/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v2_2Frame;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;

public class ID3v2_2
extends AbstractID3v2 {
    protected boolean compression = false;
    protected boolean unsynchronization = false;

    public ID3v2_2() {
        this.frameMap = new HashMap();
        this.majorVersion = (byte)2;
        this.revision = (byte)2;
    }

    public ID3v2_2(ID3v2_2 copyObject) {
        super(copyObject);
        this.compression = copyObject.compression;
        this.unsynchronization = copyObject.unsynchronization;
    }

    public ID3v2_2(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (!(mp3tag instanceof ID3v2_3) && mp3tag instanceof ID3v2_2) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v2_4 convertedTag = mp3tag instanceof ID3v2_4 ? (ID3v2_4)mp3tag : new ID3v2_4(mp3tag);
            this.compression = convertedTag.compression;
            this.unsynchronization = convertedTag.unsynchronization;
            ID3v2_4 id3tag = convertedTag;
            Iterator iterator = id3tag.frameMap.values().iterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                ID3v2_2Frame newFrame = new ID3v2_2Frame(frame);
                this.frameMap.put(newFrame.getIdentifier(), newFrame);
            }
        }
    }

    public ID3v2_2(RandomAccessFile file) throws TagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "ID3v2_2.20";
    }

    public int getSize() {
        int size = 10;
        Iterator iterator = this.frameMap.values().iterator();
        while (iterator.hasNext()) {
            ID3v2_2Frame frame = (ID3v2_2Frame)iterator.next();
            size += frame.getSize();
        }
        return size;
    }

    public void append(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_2) {
            this.unsynchronization = ((ID3v2_2)tag).unsynchronization;
            this.compression = ((ID3v2_2)tag).compression;
        }
        super.append(tag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2_2)) {
            return false;
        }
        ID3v2_2 object = (ID3v2_2)obj;
        if (this.compression != object.compression) {
            return false;
        }
        if (this.unsynchronization != object.unsynchronization) {
            return false;
        }
        return super.equals(obj);
    }

    public void overwrite(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_2) {
            this.unsynchronization = ((ID3v2_2)tag).unsynchronization;
            this.compression = ((ID3v2_2)tag).compression;
        }
        super.overwrite(tag);
    }

    public void read(RandomAccessFile file) throws TagException, IOException {
        byte[] buffer = new byte[4];
        if (!this.seek(file)) {
            throw new TagNotFoundException("ID3v2.20 tag not found");
        }
        file.read(buffer, 0, 3);
        if (buffer[0] != 2 || buffer[1] != 0) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        this.majorVersion = buffer[0];
        this.revision = buffer[1];
        this.unsynchronization = (buffer[2] & 0x80) != 0;
        this.compression = (buffer[2] & 0x80) != 0;
        file.read(buffer, 0, 4);
        int size = this.byteArrayToSize(buffer);
        this.frameMap = new HashMap();
        long filePointer = file.getFilePointer();
        this.fileReadSize = size;
        paddingCounter = 0;
        while (file.getFilePointer() - filePointer <= (long)size) {
            try {
                ID3v2_2Frame next = new ID3v2_2Frame(file);
                String id = next.getIdentifier();
                if (this.frameMap.containsKey(id)) {
                    this.duplicateFrameId = this.duplicateFrameId + id + "; ";
                    this.duplicateBytes += ((AbstractID3v2Frame)this.frameMap.get(id)).getSize();
                }
                this.frameMap.put(id, next);
            }
            catch (InvalidTagException ex) {
                if (ex.getMessage().equals("Found empty frame")) {
                    this.emptyFrameBytes += 10;
                } else {
                    ++this.invalidFrameBytes;
                }
                if (file.getFilePointer() - filePointer > (long)size) continue;
            }
        }
        this.padding = paddingCounter;
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        file.seek(0L);
        file.read(buffer, 0, 3);
        String tag = new String(buffer, 0, 3);
        if (!tag.equals("ID3")) {
            return false;
        }
        file.read(buffer, 0, 2);
        file.seek(file.getFilePointer() - 2L);
        return buffer[0] == 2 && buffer[1] == 0;
    }

    public String toString() {
        Iterator iterator = this.frameMap.values().iterator();
        String str = this.getIdentifier() + " - " + this.getSize() + " bytes\n";
        str = str + "compression        = " + this.compression + "\n";
        str = str + "unsynchronization  = " + this.unsynchronization + "\n";
        while (iterator.hasNext()) {
            ID3v2_2Frame frame = (ID3v2_2Frame)iterator.next();
            str = str + frame.toString() + "\n";
        }
        return str + "\n";
    }

    public void write(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_2) {
            this.unsynchronization = ((ID3v2_2)tag).unsynchronization;
            this.compression = ((ID3v2_2)tag).compression;
        }
        super.write(tag);
    }

    public void write(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[6];
        MP3File mp3 = new MP3File();
        mp3.seekMP3Frame(file);
        long mp3start = file.getFilePointer();
        file.seek(0L);
        String str = "ID3";
        int i = 0;
        while (i < str.length()) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        buffer[3] = 2;
        buffer[4] = 0;
        if (this.unsynchronization) {
            buffer[5] = (byte)(buffer[5] | 0x80);
        }
        if (this.compression) {
            buffer[5] = (byte)(buffer[5] | 0x80);
        }
        file.write(buffer);
        file.write(this.sizeToByteArray((int)mp3start - 10));
        Iterator iterator = this.frameMap.values().iterator();
        while (iterator.hasNext()) {
            ID3v2_2Frame frame = (ID3v2_2Frame)iterator.next();
            frame.write(file);
        }
        if ((long)this.getSize() != file.getFilePointer()) {
            // empty if block
        }
    }
}

