/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberFixedLength;
import org.farng.mp3.object.ObjectStringNullTerminated;

public class FrameBodyGRID
extends AbstractID3v2FrameBody {
    public FrameBodyGRID() {
    }

    public FrameBodyGRID(FrameBodyGRID body) {
        super(body);
    }

    public FrameBodyGRID(String owner, byte groupSymbol, byte[] data) {
        this.setObject("Owner", owner);
        this.setObject("Group Symbol", new Byte(groupSymbol));
        this.setObject("Group Dependent Data", data);
    }

    public FrameBodyGRID(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public void setGroupSymbol(byte textEncoding) {
        this.setObject("Group Symbol", new Byte(textEncoding));
    }

    public byte getGroupSymbol() {
        if (this.getObject("Group Symbol") != null) {
            return (Byte)this.getObject("Group Symbol");
        }
        return 0;
    }

    public String getIdentifier() {
        return "GRID\u0000" + this.getOwner() + '\u0000' + this.getGroupSymbol();
    }

    public void setOwner(String owner) {
        this.setObject("Owner", owner);
    }

    public String getOwner() {
        return (String)this.getObject("Owner");
    }

    protected void setupObjectList() {
        this.objectList.add(new ObjectStringNullTerminated("Owner"));
        this.objectList.add(new ObjectNumberFixedLength("Group Symbol", 1));
        this.objectList.add(new ObjectByteArraySizeTerminated("Group Dependent Data"));
    }
}

