/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ListIterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringDate;
import org.farng.mp3.object.ObjectStringNullTerminated;

public class FrameBodyCOMR
extends AbstractID3v2FrameBody {
    public FrameBodyCOMR() {
    }

    public FrameBodyCOMR(FrameBodyCOMR body) {
        super(body);
    }

    public FrameBodyCOMR(byte textEncoding, String priceString, String validUntil, String contactUrl, byte recievedAs, String nameOfSeller, String description, String mimeType, byte[] sellerLogo) {
        this.setObject("Text Encoding", new Byte(textEncoding));
        this.setObject("Price String", priceString);
        this.setObject("Valid Until", validUntil);
        this.setObject("Contact URL", contactUrl);
        this.setObject("Recieved As", new Byte(recievedAs));
        this.setObject("Name Of Seller", nameOfSeller);
        this.setObject("Description", description);
        this.setObject("Picture MIME Type", mimeType);
        this.setObject("Seller Logo", sellerLogo);
    }

    public FrameBodyCOMR(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public String getIdentifier() {
        String str = "COMR";
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            str = str + '\u0000' + this.getOwner();
        }
        return str;
    }

    public String getOwner() {
        return (String)this.getObject("Owner");
    }

    public void getOwner(String description) {
        this.setObject("Owner", description);
    }

    protected void setupObjectList() {
        this.objectList.add(new ObjectNumberHashMap("Text Encoding", 1));
        this.objectList.add(new ObjectStringNullTerminated("Price String"));
        this.objectList.add(new ObjectStringDate("Valid Until"));
        this.objectList.add(new ObjectStringNullTerminated("Contact URL"));
        this.objectList.add(new ObjectNumberHashMap("Recieved As", 1));
        this.objectList.add(new ObjectStringNullTerminated("Name Of Seller"));
        this.objectList.add(new ObjectStringNullTerminated("Description"));
        this.objectList.add(new ObjectStringNullTerminated("Picture MIME Type"));
        this.objectList.add(new ObjectByteArraySizeTerminated("Seller Logo"));
    }
}

