/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3FileItem;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;

public abstract class AbstractID3v2
extends AbstractID3 {
    public static int paddingCounter = 0;
    protected HashMap frameMap = null;
    protected String duplicateFrameId = "";
    protected byte majorVersion = 0;
    protected byte revision = 0;
    protected int duplicateBytes = 0;
    protected int emptyFrameBytes = 0;
    protected int fileReadSize = 0;
    protected int invalidFrameBytes = 0;
    protected int padding = 0;

    public AbstractID3v2() {
    }

    public AbstractID3v2(AbstractID3v2 copyObject) {
        super(copyObject);
        this.duplicateFrameId = new String(copyObject.duplicateFrameId);
        this.majorVersion = copyObject.majorVersion;
        this.revision = copyObject.revision;
        this.duplicateBytes = copyObject.duplicateBytes;
        this.emptyFrameBytes = copyObject.emptyFrameBytes;
        this.fileReadSize = copyObject.fileReadSize;
        this.invalidFrameBytes = copyObject.invalidFrameBytes;
        this.padding = copyObject.padding;
        Iterator iterator = copyObject.frameMap.keySet().iterator();
        while (iterator.hasNext()) {
            String identifier = (String)iterator.next();
            AbstractID3v2Frame newFrame = (AbstractID3v2Frame)TagUtility.copyObject(copyObject.frameMap.get(identifier));
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    public int getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getDuplicateFrameId() {
        return this.duplicateFrameId;
    }

    public int getEmptyFrameBytes() {
        return this.emptyFrameBytes;
    }

    public int getFileReadBytes() {
        return this.fileReadSize;
    }

    public void setFrame(AbstractID3v2Frame frame) {
        this.frameMap.put(frame.getIdentifier(), frame);
    }

    public AbstractID3v2Frame getFrame(String identifier) {
        return (AbstractID3v2Frame)this.frameMap.get(identifier);
    }

    public int getFrameCount() {
        if (this.frameMap == null) {
            return 0;
        }
        return this.frameMap.size();
    }

    public Iterator getFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        HashSet result = new HashSet();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(identifier)) continue;
            result.add(this.frameMap.get(key));
        }
        return result.iterator();
    }

    public int getInvalidFrameBytes() {
        return this.invalidFrameBytes;
    }

    public int getPaddingSize() {
        return this.padding;
    }

    public void append(AbstractMP3Tag tag) {
        AbstractID3v2 oldTag = this;
        AbstractID3v2 newTag = null;
        if (tag != null) {
            newTag = tag instanceof AbstractID3v2 ? (AbstractID3v2)tag : new ID3v2_4(tag);
            Iterator iterator = newTag.frameMap.values().iterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                if (oldTag.hasFrame(frame.getIdentifier())) continue;
                oldTag.setFrame(frame);
            }
        }
    }

    public void append(RandomAccessFile file) throws IOException, TagException {
        try {
            ID3v2_4 oldTag = new ID3v2_4(file);
            ((AbstractID3v2)oldTag).append(this);
            ((AbstractMP3FileItem)oldTag).write(file);
        }
        catch (TagNotFoundException ex) {
            try {
                ID3v2_3 oldTag = new ID3v2_3(file);
                ((AbstractID3v2)oldTag).append(this);
                ((AbstractMP3FileItem)oldTag).write(file);
            }
            catch (TagNotFoundException ex2) {
                try {
                    ID3v2_2 oldTag = new ID3v2_2(file);
                    ((AbstractID3v2)oldTag).append(this);
                    ((AbstractMP3FileItem)oldTag).write(file);
                }
                catch (TagNotFoundException ex3) {
                    this.write(file);
                }
            }
        }
    }

    public void delete(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        if (this.seek(file)) {
            file.seek(0L);
            file.write(buffer);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2)) {
            return false;
        }
        AbstractID3v2 object = (AbstractID3v2)obj;
        if (!this.frameMap.equals(object.frameMap)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean hasFrame(String identifier) {
        return this.frameMap.containsKey(identifier);
    }

    public boolean hasFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            String key = (String)iterator.next();
            if (!key.startsWith(identifier)) continue;
            found = true;
        }
        return found;
    }

    public Iterator iterator() {
        return this.frameMap.values().iterator();
    }

    public void overwrite(AbstractMP3Tag tag) {
        AbstractID3v2 oldTag = this;
        AbstractID3v2 newTag = null;
        if (tag != null) {
            newTag = tag instanceof AbstractID3v2 ? (AbstractID3v2)tag : new ID3v2_4(tag);
            Iterator iterator = newTag.frameMap.values().iterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                oldTag.setFrame(frame);
            }
        }
    }

    public void overwrite(RandomAccessFile file) throws IOException, TagException {
        try {
            ID3v2_4 oldTag = new ID3v2_4(file);
            ((AbstractID3v2)oldTag).overwrite(this);
            ((AbstractMP3FileItem)oldTag).write(file);
        }
        catch (TagNotFoundException ex) {
            try {
                ID3v2_3 oldTag = new ID3v2_3(file);
                ((AbstractID3v2)oldTag).overwrite(this);
                ((AbstractMP3FileItem)oldTag).write(file);
            }
            catch (TagNotFoundException ex2) {
                try {
                    ID3v2_2 oldTag = new ID3v2_2(file);
                    ((AbstractID3v2)oldTag).overwrite(this);
                    ((AbstractMP3FileItem)oldTag).write(file);
                }
                catch (TagNotFoundException ex3) {
                    this.write(file);
                }
            }
        }
    }

    public void removeFrame(String identifier) {
        this.frameMap.remove(identifier);
    }

    public void removeFrameOfType(String identifier) {
        Iterator iterator = this.getFrameOfType(identifier);
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
            this.frameMap.remove(frame.getIdentifier());
        }
    }

    public Collection values() {
        return this.frameMap.values();
    }

    public void write(AbstractMP3Tag tag) {
        AbstractID3v2 oldTag = this;
        AbstractID3v2 newTag = null;
        if (tag != null) {
            newTag = tag instanceof AbstractID3v2 ? (AbstractID3v2)tag : new ID3v2_4(tag);
            Iterator iterator = newTag.frameMap.values().iterator();
            oldTag.frameMap.clear();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                oldTag.setFrame(frame);
            }
        }
    }

    protected int byteArrayToSize(byte[] buffer) {
        return (buffer[0] << 21) + (buffer[1] << 14) + (buffer[2] << 7) + buffer[3];
    }

    protected byte[] sizeToByteArray(int size) {
        byte[] buffer = new byte[]{(byte)((size & 0xFE00000) >> 21), (byte)((size & 0x1FC000) >> 14), (byte)((size & 0x3F80) >> 7), (byte)(size & 0x7F)};
        return buffer;
    }
}

