/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameTokenIterator;
import org.farng.mp3.id3.AbstractFrameBodyTextInformation;
import org.farng.mp3.id3.AbstractFrameBodyUrlLink;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.id3.ID3v2_4Frame;

public class FilenameToken
extends AbstractFilenameComposite {
    private Class id3v2FrameBodyClass = null;
    private String token;
    static /* synthetic */ Class class$org$farng$mp3$id3$AbstractFrameBodyTextInformation;
    static /* synthetic */ Class class$org$farng$mp3$id3$AbstractFrameBodyUrlLink;
    static /* synthetic */ Class class$org$farng$mp3$id3$AbstractID3v2FrameBody;

    public FilenameToken() {
    }

    public FilenameToken(FilenameToken copyObject) {
        super(copyObject);
        try {
            this.id3v2FrameBodyClass = this.id3v2FrameBodyClass.newInstance().getClass();
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("IllegalAccessException: No access to run constructor to create copy");
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("InstantiationException: Unable to instantiate constructor to copy");
        }
        this.token = new String(copyObject.token);
    }

    public void setFrame(AbstractID3v2Frame frame) {
        if (this.id3v2FrameBodyClass != null && this.id3v2FrameBodyClass.equals(frame.getBody().getClass())) {
            if ((class$org$farng$mp3$id3$AbstractFrameBodyTextInformation == null ? (class$org$farng$mp3$id3$AbstractFrameBodyTextInformation = FilenameToken.class$("org.farng.mp3.id3.AbstractFrameBodyTextInformation")) : class$org$farng$mp3$id3$AbstractFrameBodyTextInformation).isInstance(frame.getBody())) {
                this.token = ((AbstractFrameBodyTextInformation)frame.getBody()).getText();
            } else if ((class$org$farng$mp3$id3$AbstractFrameBodyUrlLink == null ? (class$org$farng$mp3$id3$AbstractFrameBodyUrlLink = FilenameToken.class$("org.farng.mp3.id3.AbstractFrameBodyUrlLink")) : class$org$farng$mp3$id3$AbstractFrameBodyUrlLink).isInstance(frame.getBody())) {
                this.token = ((AbstractFrameBodyUrlLink)frame.getBody()).getUrlLink();
            }
        }
    }

    public void setId3v2FrameBodyClass(Class id3v2FrameBodyClass) {
        this.id3v2FrameBodyClass = id3v2FrameBodyClass;
    }

    public Class getId3v2FrameBodyClass() {
        return this.id3v2FrameBodyClass;
    }

    public void setToken(String token) {
        this.token = token.trim();
    }

    public String getToken() {
        return this.token;
    }

    public String composeFilename() {
        return this.token;
    }

    public ID3v2_4 createId3Tag() {
        ID3v2_4 tag;
        block8: {
            tag = new ID3v2_4();
            if (this.id3v2FrameBodyClass == null) break block8;
            try {
                AbstractID3v2FrameBody body = (AbstractID3v2FrameBody)this.id3v2FrameBodyClass.newInstance();
                if (body instanceof AbstractFrameBodyTextInformation) {
                    ((AbstractFrameBodyTextInformation)body).setText(this.token);
                    ((AbstractFrameBodyTextInformation)body).setTextEncoding((byte)0);
                } else if (body instanceof AbstractFrameBodyUrlLink) {
                    ((AbstractFrameBodyUrlLink)body).setUrlLink(this.token);
                } else if (body instanceof FrameBodyCOMM) {
                    ((FrameBodyCOMM)body).setText(this.token);
                    ((FrameBodyCOMM)body).setDescription("");
                    ((FrameBodyCOMM)body).setLanguage(TagOptionSingleton.getInstance().getLanguage());
                    ((FrameBodyCOMM)body).setTextEncoding(TagOptionSingleton.getInstance().getTextEncoding());
                }
                ID3v2_4Frame frame = new ID3v2_4Frame();
                frame.setBody(body);
                tag.setFrame(frame);
            }
            catch (IllegalAccessException ex) {
            }
            catch (InstantiationException ex) {}
        }
        return tag;
    }

    public Iterator iterator() {
        return new FilenameTokenIterator(this);
    }

    public void matchAgainstKeyword(Class id3v2FrameBodyClass) {
        if ((class$org$farng$mp3$id3$AbstractID3v2FrameBody == null ? (class$org$farng$mp3$id3$AbstractID3v2FrameBody = FilenameToken.class$("org.farng.mp3.id3.AbstractID3v2FrameBody")) : class$org$farng$mp3$id3$AbstractID3v2FrameBody).isAssignableFrom(id3v2FrameBodyClass) && (TagOptionSingleton.getInstance().isCompositeMatchOverwrite() || this.id3v2FrameBodyClass == null)) {
            Iterator iterator = TagOptionSingleton.getInstance().getKeywordListIterator(id3v2FrameBodyClass);
            String lowerCaseToken = this.token.toLowerCase();
            while (iterator.hasNext()) {
                String matchString = ((String)iterator.next()).toLowerCase();
                if (!matchString.equals(lowerCaseToken) && matchString.indexOf(lowerCaseToken) < 0 && lowerCaseToken.indexOf(matchString) < 0) continue;
                this.setId3v2FrameBodyClass(id3v2FrameBodyClass);
                break;
            }
        }
    }

    public void matchAgainstTag(AbstractMP3Tag matchTag) {
        if (TagOptionSingleton.getInstance().isCompositeMatchOverwrite() || this.id3v2FrameBodyClass == null) {
            ID3v2_4 tag = matchTag instanceof ID3v2_4 ? (ID3v2_4)matchTag : new ID3v2_4(matchTag);
            Iterator iterator = tag.iterator();
            String matchString = null;
            String lowerCaseToken = this.token.toLowerCase();
            while (iterator.hasNext()) {
                ID3v2_4Frame frame = (ID3v2_4Frame)iterator.next();
                AbstractID3v2FrameBody body = (AbstractID3v2FrameBody)frame.getBody();
                if (body instanceof AbstractFrameBodyTextInformation) {
                    matchString = ((AbstractFrameBodyTextInformation)body).getText().toLowerCase();
                } else if (body instanceof AbstractFrameBodyUrlLink) {
                    matchString = ((AbstractFrameBodyUrlLink)body).getUrlLink().toLowerCase();
                } else if (body instanceof FrameBodyCOMM) {
                    matchString = ((FrameBodyCOMM)body).getText();
                }
                if (!matchString.equals(lowerCaseToken) && matchString.indexOf(lowerCaseToken) < 0 && lowerCaseToken.indexOf(matchString) < 0) continue;
                this.setId3v2FrameBodyClass(body.getClass());
                break;
            }
        }
    }

    public String toString() {
        return this.id3v2FrameBodyClass + ": " + this.token;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

