/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.FilenameTag;
import org.farng.mp3.filename.FilenameTagBuilder;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v1_1;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.Lyrics3v1;
import org.farng.mp3.lyrics3.Lyrics3v2;

public class MP3File {
    private AbstractID3v2 id3v2tag = null;
    private AbstractLyrics3 lyrics3tag = null;
    private File mp3file;
    private FilenameTag filenameTag = null;
    private ID3v1 id3v1tag = null;
    private boolean copyProtected;
    private boolean home;
    private boolean padding;
    private boolean privacy;
    private boolean protection;
    private boolean variableBitRate = false;
    private byte emphasis;
    private byte layer;
    private byte mode;
    private byte modeExtension;
    private byte mpegVersion;
    private double frequency;
    private int bitRate;

    public MP3File() {
    }

    public MP3File(MP3File copyObject) {
        this.copyProtected = copyObject.copyProtected;
        this.home = copyObject.home;
        this.padding = copyObject.padding;
        this.privacy = copyObject.privacy;
        this.protection = copyObject.protection;
        this.variableBitRate = copyObject.variableBitRate;
        this.emphasis = copyObject.emphasis;
        this.layer = copyObject.layer;
        this.mode = copyObject.mode;
        this.modeExtension = copyObject.modeExtension;
        this.mpegVersion = copyObject.mpegVersion;
        this.frequency = copyObject.frequency;
        this.bitRate = copyObject.bitRate;
        this.mp3file = new File(copyObject.mp3file.getAbsolutePath());
        this.filenameTag = new FilenameTag(copyObject.filenameTag);
        this.id3v2tag = (AbstractID3v2)TagUtility.copyObject(copyObject.id3v2tag);
        this.lyrics3tag = (AbstractLyrics3)TagUtility.copyObject(copyObject.lyrics3tag);
        this.id3v1tag = (ID3v1)TagUtility.copyObject(copyObject.id3v1tag);
    }

    public MP3File(String filename) throws IOException, TagException {
        this(new File(filename));
    }

    public MP3File(File file) throws IOException, TagException {
        this.mp3file = file;
        RandomAccessFile newFile = new RandomAccessFile(file, "rw");
        try {
            this.id3v1tag = new ID3v1_1(newFile);
        }
        catch (TagNotFoundException ex) {
            // empty catch block
        }
        try {
            if (this.id3v1tag == null) {
                this.id3v1tag = new ID3v1(newFile);
            }
        }
        catch (TagNotFoundException ex) {
            // empty catch block
        }
        try {
            this.id3v2tag = new ID3v2_4(newFile);
        }
        catch (TagNotFoundException ex) {
            // empty catch block
        }
        try {
            if (this.id3v2tag == null) {
                this.id3v2tag = new ID3v2_3(newFile);
            }
        }
        catch (TagNotFoundException ex) {
            // empty catch block
        }
        try {
            if (this.id3v2tag == null) {
                this.id3v2tag = new ID3v2_2(newFile);
            }
        }
        catch (TagNotFoundException ex) {
            // empty catch block
        }
        try {
            this.lyrics3tag = new Lyrics3v2(newFile);
        }
        catch (TagNotFoundException ex) {
            // empty catch block
        }
        try {
            if (this.lyrics3tag == null) {
                this.lyrics3tag = new Lyrics3v1(newFile);
            }
        }
        catch (TagNotFoundException ex) {
            // empty catch block
        }
        newFile.close();
        try {
            this.filenameTag = FilenameTagBuilder.createFilenameTagFromMP3File(this);
        }
        catch (Exception ex) {
            throw new TagException("Unable to create FilenameTag", ex);
        }
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public boolean isCopyProtected() {
        return this.copyProtected;
    }

    public byte getEmphasis() {
        return this.emphasis;
    }

    public void setFilenameTag(FilenameTag filenameTag) {
        this.filenameTag = filenameTag;
    }

    public FilenameTag getFilenameTag() {
        return this.filenameTag;
    }

    public void setFrameAcrossTags(AbstractID3v2Frame frame) {
        ID3v2_4 id3v1 = null;
        ID3v2_4 lyrics3 = null;
        if (this.id3v1tag != null) {
            id3v1 = new ID3v2_4((AbstractMP3Tag)this.id3v1tag);
            id3v1.setFrame(frame);
            this.id3v1tag.overwrite(id3v1);
        }
        if (this.id3v2tag != null) {
            this.id3v2tag.setFrame(frame);
        }
        if (this.lyrics3tag != null) {
            lyrics3 = new ID3v2_4(this.lyrics3tag);
            lyrics3.setFrame(frame);
            this.lyrics3tag = new Lyrics3v2(lyrics3);
        }
        if (this.filenameTag != null) {
            this.filenameTag.setFrame(frame);
        }
    }

    public ArrayList getFrameAcrossTags(String identifier) {
        if (identifier != null && identifier.length() > 0) {
            Iterator iterator;
            ID3v2_4 id3v1 = null;
            ID3v2_4 lyrics3 = null;
            ArrayList list = new ArrayList();
            if (this.id3v1tag != null && (id3v1 = new ID3v2_4((AbstractMP3Tag)this.id3v1tag)).hasFrameOfType(identifier)) {
                iterator = id3v1.getFrameOfType(identifier);
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            if (this.id3v2tag != null && this.id3v2tag.hasFrameOfType(identifier)) {
                iterator = this.id3v2tag.getFrameOfType(identifier);
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            if (this.lyrics3tag != null && (lyrics3 = new ID3v2_4(this.lyrics3tag)).hasFrameOfType(identifier)) {
                iterator = lyrics3.getFrameOfType(identifier);
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            if (this.filenameTag != null && this.filenameTag.hasFrameOfType(identifier)) {
                iterator = this.filenameTag.getFrameOfType(identifier);
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            return list;
        }
        return null;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public boolean isHome() {
        return this.home;
    }

    public void setID3v1Tag(AbstractMP3Tag mp3tag) {
        this.id3v1tag = new ID3v1_1(mp3tag);
    }

    public void setID3v1Tag(ID3v1 id3v1tag) {
        this.id3v1tag = id3v1tag;
    }

    public ID3v1 getID3v1Tag() {
        return this.id3v1tag;
    }

    public void setID3v2Tag(AbstractMP3Tag mp3tag) {
        this.id3v2tag = new ID3v2_4(mp3tag);
    }

    public void setID3v2Tag(AbstractID3v2 id3v2tag) {
        this.id3v2tag = id3v2tag;
    }

    public AbstractID3v2 getID3v2Tag() {
        return this.id3v2tag;
    }

    public byte getLayer() {
        return this.layer;
    }

    public void setLyrics3Tag(AbstractMP3Tag mp3tag) {
        this.lyrics3tag = new Lyrics3v2(mp3tag);
    }

    public void setLyrics3Tag(AbstractLyrics3 lyrics3tag) {
        this.lyrics3tag = lyrics3tag;
    }

    public AbstractLyrics3 getLyrics3Tag() {
        return this.lyrics3tag;
    }

    public byte getMode() {
        return this.mode;
    }

    public byte getModeExtension() {
        return this.modeExtension;
    }

    public long getMp3StartByte() throws IOException, FileNotFoundException {
        return this.getMp3StartByte(this.mp3file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getMp3StartByte(File file) throws IOException, FileNotFoundException {
        RandomAccessFile rfile = null;
        long startByte = 0L;
        try {
            rfile = new RandomAccessFile(file, "r");
            this.seekMP3Frame(rfile);
            startByte = rfile.getFilePointer();
            Object var6_4 = null;
            if (rfile == null) return startByte;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (rfile == null) throw throwable;
            rfile.close();
            throw throwable;
        }
        rfile.close();
        return startByte;
    }

    public void setMp3file(File mp3file) {
        this.mp3file = mp3file;
    }

    public File getMp3file() {
        return this.mp3file;
    }

    public byte getMpegVersion() {
        return this.mpegVersion;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public boolean isPrivacy() {
        return this.privacy;
    }

    public boolean isProtection() {
        return this.protection;
    }

    public boolean isUnsynchronized() {
        return this.getUnsynchronizedFragments().size() > 0;
    }

    public HashSet getUnsynchronizedFragments() {
        ID3v2_4 id3v1 = null;
        ID3v2_4 lyrics3 = null;
        ID3v2_4 filename = null;
        AbstractID3v2 id3v2 = null;
        ID3v2_4 total = new ID3v2_4((AbstractMP3Tag)this.id3v2tag);
        HashSet<String> set = new HashSet<String>();
        total.append(this.id3v1tag);
        total.append(this.lyrics3tag);
        total.append(this.filenameTag);
        total.append(this.id3v2tag);
        id3v1 = new ID3v2_4((AbstractMP3Tag)this.id3v1tag);
        lyrics3 = new ID3v2_4(this.lyrics3tag);
        filename = new ID3v2_4(this.filenameTag);
        id3v2 = this.id3v2tag;
        Iterator iterator = total.iterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
            String identifier = frame.getIdentifier();
            if (id3v2 != null && id3v2.hasFrame(identifier) && !id3v2.getFrame(identifier).isSubsetOf(frame)) {
                set.add(identifier);
            }
            if (id3v1 != null && id3v1.hasFrame(identifier) && !id3v1.getFrame(identifier).isSubsetOf(frame)) {
                set.add(identifier);
            }
            if (lyrics3 != null && lyrics3.hasFrame(identifier) && !lyrics3.getFrame(identifier).isSubsetOf(frame)) {
                set.add(identifier);
            }
            if (filename == null || !filename.hasFrame(identifier) || filename.getFrame(identifier).isSubsetOf(frame)) continue;
            set.add(identifier);
        }
        return set;
    }

    public void setVariableBitRate(boolean variableBitRate) {
        this.variableBitRate = variableBitRate;
    }

    public boolean isVariableBitRate() {
        return this.variableBitRate;
    }

    public boolean adjustID3v2Padding() throws FileNotFoundException, IOException, TagException {
        return this.adjustID3v2Padding(TagOptionSingleton.getInstance().getId3v2PaddingSize(), TagOptionSingleton.getInstance().isId3v2PaddingWillShorten(), TagOptionSingleton.getInstance().isId3v2PaddingCopyTag(), this.mp3file);
    }

    public boolean adjustID3v2Padding(int paddingSize, boolean willShorten, boolean copyID3v2Tag) throws FileNotFoundException, IOException, TagException {
        return this.adjustID3v2Padding(paddingSize, willShorten, copyID3v2Tag, this.mp3file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adjustID3v2Padding(int paddingSize, boolean willShorten, boolean copyID3v2Tag, File file) throws FileNotFoundException, IOException, TagException {
        int id3v2TagSize = 0;
        int mp3start = (int)this.getMp3StartByte(file);
        FileOutputStream outStream = null;
        FileInputStream inStream = null;
        File backupFile = null;
        File paddedFile = null;
        if (paddingSize < 0) {
            throw new TagException("Invalid paddingSize: " + paddingSize);
        }
        if (this.hasID3v2Tag()) {
            id3v2TagSize = this.getID3v2Tag().getSize();
        }
        if (paddingSize != 0) {
            while (paddingSize < id3v2TagSize) {
                paddingSize = (int)((float)paddingSize * TagOptionSingleton.getInstance().getId3v2PaddingMultiplier());
            }
        }
        if (paddingSize < mp3start && !willShorten) {
            return false;
        }
        if (paddingSize == mp3start) {
            return false;
        }
        try {
            byte[] buffer;
            paddedFile = File.createTempFile("temp", ".mp3", file.getParentFile());
            outStream = new FileOutputStream(paddedFile);
            inStream = new FileInputStream(file);
            if (copyID3v2Tag) {
                if (paddingSize < mp3start && willShorten) {
                    buffer = new byte[paddingSize];
                    inStream.read(buffer, 0, buffer.length);
                    outStream.write(buffer, 0, buffer.length);
                    buffer = new byte[mp3start - paddingSize];
                    inStream.read(buffer, 0, buffer.length);
                } else {
                    buffer = new byte[mp3start];
                    inStream.read(buffer, 0, buffer.length);
                    outStream.write(buffer, 0, buffer.length);
                    if (paddingSize - mp3start > 0) {
                        buffer = new byte[paddingSize - mp3start];
                        outStream.write(buffer, 0, buffer.length);
                    }
                }
            } else {
                buffer = new byte[paddingSize];
                inStream.skip(mp3start);
                outStream.write(buffer, 0, buffer.length);
            }
            buffer = new byte[1024];
            int b = inStream.read(buffer, 0, buffer.length);
            while (b == 1024) {
                outStream.write(buffer, 0, buffer.length);
                b = inStream.read(buffer, 0, buffer.length);
            }
            if (b != -1) {
                outStream.write(buffer, 0, b);
            }
            backupFile = new File(file.getParentFile(), TagUtility.appendBeforeExtension(file.getName(), ".original"));
            TagUtility.copyFile(file, backupFile);
            if (!backupFile.exists()) {
                boolean bl = false;
                return bl;
            }
            backupFile.setLastModified(file.lastModified());
            TagUtility.copyFile(paddedFile, file);
            boolean bl = true;
            return bl;
        }
        finally {
            if (inStream != null) {
                inStream.getFD().sync();
                inStream.close();
            }
            if (outStream != null) {
                outStream.getFD().sync();
                outStream.close();
            }
            if (backupFile != null && !TagOptionSingleton.getInstance().isOriginalSavedAfterAdjustingID3v2Padding()) {
                backupFile.delete();
            }
            if (paddedFile != null) {
                paddedFile.delete();
            }
        }
    }

    public void delete(AbstractMP3Tag mp3tag) throws FileNotFoundException, IOException {
        mp3tag.delete(new RandomAccessFile(this.mp3file, "rw"));
    }

    public boolean hasFilenameTag() {
        return this.filenameTag != null;
    }

    public boolean hasID3v1Tag() {
        return this.id3v1tag != null;
    }

    public boolean hasID3v2Tag() {
        return this.id3v2tag != null;
    }

    public boolean hasLyrics3Tag() {
        return this.lyrics3tag != null;
    }

    public void save() throws IOException, TagException {
        this.save(this.mp3file, TagOptionSingleton.getInstance().getDefaultSaveMode());
    }

    public void save(int saveMode) throws IOException, TagException {
        this.save(this.mp3file, saveMode);
    }

    public void save(String filename) throws IOException, TagException {
        this.save(new File(filename), TagOptionSingleton.getInstance().getDefaultSaveMode());
    }

    public void save(String filename, int saveMode) throws IOException, TagException {
        this.save(new File(filename), saveMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(File file, int saveMode) throws IOException, TagException {
        if (saveMode < 1 || saveMode > 3) {
            throw new TagException("Invalid Save Mode");
        }
        RandomAccessFile rfile = null;
        try {
            boolean debug;
            if (this.id3v2tag != null) {
                this.adjustID3v2Padding(TagOptionSingleton.getInstance().getId3v2PaddingSize(), TagOptionSingleton.getInstance().isId3v2PaddingWillShorten(), TagOptionSingleton.getInstance().isId3v2PaddingCopyTag(), file);
            }
            rfile = new RandomAccessFile(file, "rw");
            if (TagOptionSingleton.getInstance().isId3v2Save()) {
                if (this.id3v2tag == null) {
                    if (saveMode == 2) {
                        new ID3v2_4().delete(rfile);
                    }
                } else if (saveMode == 1) {
                    this.id3v2tag.write(rfile);
                } else if (saveMode == 3) {
                    this.id3v2tag.append(rfile);
                } else if (saveMode == 2) {
                    this.id3v2tag.overwrite(rfile);
                }
            }
            if (TagOptionSingleton.getInstance().isLyrics3Save()) {
                if (this.lyrics3tag == null) {
                    if (saveMode == 2) {
                        new Lyrics3v2().delete(rfile);
                    }
                } else if (saveMode == 1) {
                    this.lyrics3tag.write(rfile);
                } else if (saveMode == 3) {
                    this.lyrics3tag.append(rfile);
                } else if (saveMode == 2) {
                    this.lyrics3tag.overwrite(rfile);
                }
            }
            if (TagOptionSingleton.getInstance().isId3v1Save()) {
                if (this.id3v1tag == null) {
                    if (saveMode == 2) {
                        new ID3v1().delete(rfile);
                    }
                } else if (saveMode == 1) {
                    this.id3v1tag.write(rfile);
                } else if (saveMode == 3) {
                    this.id3v1tag.append(rfile);
                } else if (saveMode == 2) {
                    this.id3v1tag.overwrite(rfile);
                    debug = false;
                }
            }
            if (TagOptionSingleton.getInstance().isFilenameTagSave() && this.filenameTag != null) {
                if (saveMode == 1) {
                    this.filenameTag.write(rfile);
                } else if (saveMode == 3) {
                    this.filenameTag.append(rfile);
                } else if (saveMode == 2) {
                    this.filenameTag.overwrite(rfile);
                    debug = false;
                }
            }
            Object var6_5 = null;
            if (rfile == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (rfile == null) throw throwable;
            rfile.close();
            throw throwable;
        }
        rfile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean seekMP3Frame() throws IOException {
        RandomAccessFile rfile = null;
        boolean found = false;
        try {
            rfile = new RandomAccessFile(this.mp3file, "r");
            found = this.seekMP3Frame(rfile);
            Object var4_3 = null;
            if (rfile == null) return found;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rfile == null) throw throwable;
            rfile.close();
            throw throwable;
        }
        rfile.close();
        return found;
    }

    public boolean seekMP3Frame(RandomAccessFile seekFile) throws IOException {
        boolean syncFound = false;
        long filePointer = 1L;
        this.variableBitRate = false;
        try {
            seekFile.seek(0L);
            do {
                byte first;
                if ((first = seekFile.readByte()) != -1) continue;
                filePointer = seekFile.getFilePointer();
                byte second = (byte)(seekFile.readByte() & 0xFFFFFFE0);
                if (second == -32) {
                    seekFile.seek(filePointer - 1L);
                    syncFound = this.seekNextMP3Frame(seekFile, TagOptionSingleton.getInstance().getNumberMP3SyncFrame());
                }
                seekFile.seek(filePointer);
            } while (!syncFound);
            seekFile.seek(filePointer - 1L);
        }
        catch (EOFException ex) {
            syncFound = false;
        }
        catch (IOException ex) {
            syncFound = false;
            throw ex;
        }
        return syncFound;
    }

    private int getFrameSize() {
        if (this.frequency == 0.0) {
            return 0;
        }
        int size = 0;
        boolean paddingByte = this.padding;
        size = this.layer == 3 ? (int)(((double)(12 * this.bitRate) / this.frequency + (double)paddingByte) * 4.0) : (int)((double)(144 * this.bitRate) / this.frequency + (double)paddingByte);
        return size;
    }

    private void readFrameHeader(RandomAccessFile file) throws IOException, TagNotFoundException, InvalidTagException {
        byte[] buffer = new byte[4];
        file.read(buffer);
        if (buffer[0] != -1 || (buffer[1] & 0xFFFFFFE0) != -32) {
            throw new TagNotFoundException("MP3 Frame sync bits not found");
        }
        this.mpegVersion = (byte)((buffer[1] & 0x18) >> 3);
        this.layer = (byte)((buffer[1] & 6) >> 1);
        this.protection = (buffer[1] & 1) != 1;
        int bitRateValue = buffer[2] & 0xF0 | buffer[1] & 8 | buffer[1] & 6;
        Long object = (Long)TagConstant.bitrate.get(new Long(bitRateValue));
        if (object != null) {
            if (object != (long)this.bitRate) {
                this.variableBitRate = true;
            }
        } else {
            throw new InvalidTagException("Invalid bit rate");
        }
        this.bitRate = object.intValue();
        int frequencyValue = (buffer[2] & 0xC) >>> 2;
        if (this.mpegVersion == 3) {
            switch (frequencyValue) {
                case 0: {
                    this.frequency = 44.1;
                    break;
                }
                case 1: {
                    this.frequency = 48.0;
                    break;
                }
                case 2: {
                    this.frequency = 32.0;
                }
            }
        } else if (this.mpegVersion == 2) {
            switch (frequencyValue) {
                case 0: {
                    this.frequency = 22.05;
                    break;
                }
                case 1: {
                    this.frequency = 24.0;
                    break;
                }
                case 2: {
                    this.frequency = 16.0;
                }
            }
        } else if (this.mpegVersion == 0) {
            switch (frequencyValue) {
                case 0: {
                    this.frequency = 11.025;
                    break;
                }
                case 1: {
                    this.frequency = 12.0;
                    break;
                }
                case 2: {
                    this.frequency = 8.0;
                }
            }
        } else {
            throw new InvalidTagException("Invalid MPEG version");
        }
        this.padding = (buffer[2] & 2) != 0;
        this.privacy = (buffer[2] & 1) != 0;
        this.mode = (byte)((buffer[3] & 0xC0) >> 6);
        this.modeExtension = (byte)((buffer[3] & 0x30) >> 4);
        this.copyProtected = (buffer[3] & 8) != 0;
        this.home = (buffer[3] & 4) != 0;
        this.emphasis = (byte)(buffer[3] & 3);
    }

    private boolean seekNextMP3Frame(RandomAccessFile file, int iterations) throws IOException {
        boolean syncFound = false;
        if (iterations == 0) {
            syncFound = true;
        } else {
            try {
                this.readFrameHeader(file);
            }
            catch (TagException ex) {
                return false;
            }
            int size = this.getFrameSize();
            if (size <= 0 || (long)size > file.length()) {
                return false;
            }
            byte[] buffer = new byte[size - 4];
            file.read(buffer);
            long filePointer = file.getFilePointer();
            byte first = file.readByte();
            if (first == -1) {
                byte second = (byte)(file.readByte() & 0xFFFFFFE0);
                if (second == -32) {
                    file.seek(filePointer);
                    syncFound = this.seekNextMP3Frame(file, iterations - 1);
                } else {
                    syncFound = false;
                }
            } else {
                syncFound = false;
            }
        }
        return syncFound;
    }
}

