/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.farng.mp3.AbstractMP3FileItem;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public abstract class AbstractMP3FragmentBody
extends AbstractMP3FileItem {
    protected ArrayList objectList = new ArrayList();
    static /* synthetic */ Class class$org$farng$mp3$id3$ID3v2_2;
    static /* synthetic */ Class class$org$farng$mp3$id3$ID3v2_3;
    static /* synthetic */ Class class$org$farng$mp3$id3$ID3v2_4;

    public AbstractMP3FragmentBody() {
        this.setupObjectList();
    }

    public AbstractMP3FragmentBody(AbstractMP3FragmentBody copyObject) {
        super(copyObject);
        int i = 0;
        while (i < copyObject.objectList.size()) {
            AbstractMP3Object newObject = (AbstractMP3Object)TagUtility.copyObject(copyObject.objectList.get(i));
            this.objectList.add(newObject);
            ++i;
        }
    }

    public String getBriefDescription() {
        String str = "";
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            if (object.toString() == null || object.toString().length() <= 0) continue;
            str = str + object.getIdentifier() + "=\"" + object.toString() + "\"; ";
        }
        return str;
    }

    public String getDescription() {
        String str = "";
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            str = str + object.getIdentifier() + " = " + object.toString() + "\n";
        }
        return str.trim();
    }

    public void setObject(String identifier, Object obj) {
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            if (!object.getIdentifier().equals(identifier)) continue;
            object.setValue(obj);
        }
    }

    public Object getObject(String identifier) {
        Object obj = null;
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            if (!object.getIdentifier().equals(identifier)) continue;
            obj = object.getValue();
        }
        return obj;
    }

    public int getSize() {
        int size = 0;
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            size += object.getSize();
        }
        return size;
    }

    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof AbstractMP3FragmentBody)) {
            return false;
        }
        ArrayList superset = ((AbstractMP3FragmentBody)obj).objectList;
        int i = 0;
        while (i < this.objectList.size()) {
            if (((AbstractMP3Object)this.objectList.get(i)).getValue() != null && !superset.contains(this.objectList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractMP3FragmentBody)) {
            return false;
        }
        AbstractMP3FragmentBody object = (AbstractMP3FragmentBody)obj;
        if (!this.objectList.equals(object.objectList)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        return this.objectList.iterator();
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        int size = this.readHeader(file);
        byte[] buffer = new byte[size];
        int offset = 0;
        file.read(buffer);
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            if (offset > size - 1) {
                throw new InvalidTagException("Invalid size for Frame Body");
            }
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            object.readByteArray(buffer, offset);
            offset += object.getSize();
        }
    }

    public String toString() {
        String str = this.getIdentifier() + "\n";
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            str = str + object.getIdentifier() + " = " + object.toString() + "\n";
        }
        return str;
    }

    public void write(RandomAccessFile file) throws IOException {
        this.writeHeader(file, this.getSize());
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            byte[] buffer = object.writeByteArray();
            file.write(buffer);
        }
    }

    protected abstract int readHeader(RandomAccessFile var1) throws IOException, InvalidTagException;

    protected void setupObjectList() {
    }

    protected abstract void writeHeader(RandomAccessFile var1, int var2) throws IOException;

    protected boolean use6ByteHeader() {
        Exception exception = new Exception();
        StackTraceElement[] stackArray = exception.getStackTrace();
        int i = stackArray.length - 1;
        while (i >= 0) {
            String className = stackArray[i].getClassName();
            if ((class$org$farng$mp3$id3$ID3v2_2 == null ? AbstractMP3FragmentBody.class$("org.farng.mp3.id3.ID3v2_2") : class$org$farng$mp3$id3$ID3v2_2).getName().equals(className)) {
                return true;
            }
            if ((class$org$farng$mp3$id3$ID3v2_3 == null ? AbstractMP3FragmentBody.class$("org.farng.mp3.id3.ID3v2_3") : class$org$farng$mp3$id3$ID3v2_3).getName().equals(className)) {
                return false;
            }
            if ((class$org$farng$mp3$id3$ID3v2_4 == null ? AbstractMP3FragmentBody.class$("org.farng.mp3.id3.ID3v2_4") : class$org$farng$mp3$id3$ID3v2_4).getName().equals(className)) {
                return false;
            }
            --i;
        }
        throw new UnsupportedOperationException("FragmentBody not called within ID3v2 tag.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

