/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.DecimalFormatProperties;
import org.apache.xalan.templates.ElemApplyTemplates;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.TemplateList;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StylesheetRoot
extends StylesheetComposed
implements Serializable,
Templates {
    private Hashtable m_availElems;
    private StylesheetComposed[] m_globalImportList;
    private OutputProperties m_outputProperties;
    private boolean m_outputMethodSet = false;
    private Hashtable m_attrSets;
    private Hashtable m_decimalFormatSymbols;
    private Vector m_keyDecls;
    private Hashtable m_namespaceAliasComposed;
    private TemplateList m_templateList;
    private Vector m_variables;
    private TemplateList m_whiteSpaceInfoList;
    private ElemTemplate m_defaultTextRule;
    private ElemTemplate m_defaultRule;
    private ElemTemplate m_defaultRootRule;
    XPath m_selectDefault;

    public StylesheetRoot(ErrorListener errorListener) throws TransformerConfigurationException {
        super(null);
        this.setStylesheetRoot(this);
        try {
            this.m_selectDefault = new XPath("node()", this, this, 0, errorListener);
            this.initDefaultRule(errorListener);
        }
        catch (TransformerException se) {
            throw new TransformerConfigurationException("Can't init default templates!", se);
        }
    }

    public StylesheetRoot(XSLTSchema schema, ErrorListener listener) throws TransformerConfigurationException {
        this(listener);
        this.m_availElems = schema.getElemsAvailable();
    }

    /*
     * Unable to fully structure code
     */
    private void QuickSort2(Vector v, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            midNode = (ElemTemplateElement)v.elementAt((lo0 + hi0) / 2);
            ** GOTO lbl18
            {
                ++lo;
                do {
                    if (lo < hi0 && ((ElemTemplateElement)v.elementAt(lo)).compareTo(midNode) < 0) continue block0;
                    while (hi > lo0 && ((ElemTemplateElement)v.elementAt(hi)).compareTo(midNode) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    node = (ElemTemplateElement)v.elementAt(lo);
                    v.setElementAt(v.elementAt(hi), lo);
                    v.setElementAt(node, hi);
                    ++lo;
                    --hi;
lbl18:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.QuickSort2(v, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort2(v, lo, hi0);
            }
        }
    }

    protected void addImports(Stylesheet stylesheet, boolean addToList, Vector importList) {
        int i;
        int n = stylesheet.getImportCount();
        if (n > 0) {
            i = 0;
            while (i < n) {
                StylesheetComposed imported = stylesheet.getImport(i);
                this.addImports(imported, true, importList);
                ++i;
            }
        }
        if ((n = stylesheet.getIncludeCount()) > 0) {
            i = 0;
            while (i < n) {
                Stylesheet included = stylesheet.getInclude(i);
                this.addImports(included, false, importList);
                ++i;
            }
        }
        if (addToList) {
            importList.addElement(stylesheet);
        }
    }

    public boolean canStripWhiteSpace() {
        return this.m_whiteSpaceInfoList != null;
    }

    static void composeTemplates(ElemTemplateElement templ) {
        templ.compose();
        ElemTemplateElement child = templ.getFirstChildElem();
        while (child != null) {
            StylesheetRoot.composeTemplates(child);
            child = child.getNextSiblingElem();
        }
    }

    public Vector getAttributeSetComposed(QName name) throws ArrayIndexOutOfBoundsException {
        return (Vector)this.m_attrSets.get(name);
    }

    public Hashtable getAvailableElements() {
        return this.m_availElems;
    }

    public DecimalFormatSymbols getDecimalFormatComposed(QName name) {
        return (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(name);
    }

    public Properties getDefaultOutputProps() {
        return this.m_outputProperties.getProperties();
    }

    public final ElemTemplate getDefaultRootRule() {
        return this.m_defaultRootRule;
    }

    public final ElemTemplate getDefaultRule() {
        return this.m_defaultRule;
    }

    public final ElemTemplate getDefaultTextRule() {
        return this.m_defaultTextRule;
    }

    public StylesheetComposed getGlobalImport(int i) {
        return this.m_globalImportList[i];
    }

    public int getGlobalImportCount() {
        return this.m_globalImportList != null ? this.m_globalImportList.length : 1;
    }

    public int getImportNumber(StylesheetComposed sheet) {
        if (this == sheet) {
            return 0;
        }
        int n = this.getGlobalImportCount();
        int i = 0;
        while (i < n) {
            if (sheet == this.getGlobalImport(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector getKeysComposed() {
        return this.m_keyDecls;
    }

    public NamespaceAlias getNamespaceAliasComposed(String uri) {
        return this.m_namespaceAliasComposed == null ? null : this.m_namespaceAliasComposed.get(uri);
    }

    public OutputProperties getOutputComposed() {
        return this.m_outputProperties;
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.getDefaultOutputProps()).clone();
    }

    public ElemTemplate getTemplateComposed(QName qname) {
        return this.m_templateList.getTemplate(qname);
    }

    public ElemTemplate getTemplateComposed(XPathContext xctxt, Node targetNode, QName mode, int maxImportLevel, boolean quietConflictWarnings) throws TransformerException {
        return this.m_templateList.getTemplate(xctxt, targetNode, mode, maxImportLevel, quietConflictWarnings);
    }

    public final TemplateList getTemplateListComposed() {
        return this.m_templateList;
    }

    public ElemVariable getVariableOrParamComposed(QName qname) {
        if (this.m_variables != null) {
            int n = this.m_variables.size();
            int i = 0;
            while (i < n) {
                ElemVariable var = (ElemVariable)this.m_variables.elementAt(i);
                if (var.getName().equals(qname)) {
                    return var;
                }
                ++i;
            }
        }
        return null;
    }

    public Vector getVariablesAndParamsComposed() {
        return this.m_variables;
    }

    public WhiteSpaceInfo getWhiteSpaceInfo(XPathContext support, Element targetElement) throws TransformerException {
        if (this.m_whiteSpaceInfoList != null) {
            return (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, -1, false);
        }
        return null;
    }

    private void initDefaultRule(ErrorListener errorListener) throws TransformerException {
        this.m_defaultRule = new ElemTemplate();
        this.m_defaultRule.setStylesheet(this);
        XPath defMatch = new XPath("*", this, this, 1, errorListener);
        this.m_defaultRule.setMatch(defMatch);
        ElemApplyTemplates childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        this.m_defaultRule.appendChild(childrenElement);
        this.m_defaultTextRule = new ElemTemplate();
        this.m_defaultTextRule.setStylesheet(this);
        defMatch = new XPath("text() | @*", this, this, 1, errorListener);
        this.m_defaultTextRule.setMatch(defMatch);
        ElemValueOf elemValueOf = new ElemValueOf();
        this.m_defaultTextRule.appendChild(elemValueOf);
        XPath selectPattern = new XPath(".", this, this, 0, errorListener);
        elemValueOf.setSelect(selectPattern);
        this.m_defaultRootRule = new ElemTemplate();
        this.m_defaultRootRule.setStylesheet(this);
        defMatch = new XPath("/", this, this, 1, errorListener);
        this.m_defaultRootRule.setMatch(defMatch);
        childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        this.m_defaultRootRule.appendChild(childrenElement);
    }

    public boolean isOutputMethodSet() {
        return this.m_outputMethodSet;
    }

    public boolean isRoot() {
        return true;
    }

    public Transformer newTransformer() {
        return new TransformerImpl(this);
    }

    public void recompose() throws TransformerException {
        if (this.m_globalImportList == null) {
            Vector importList = new Vector();
            this.addImports(this, true, importList);
            this.m_globalImportList = new StylesheetComposed[importList.size()];
            int i = importList.size() - 1;
            int j = 0;
            while (i >= 0) {
                this.m_globalImportList[j++] = (StylesheetComposed)importList.elementAt(i);
                --i;
            }
        }
        Vector recomposableElements = new Vector();
        int n = this.getGlobalImportCount();
        int i = 0;
        while (i < n) {
            StylesheetComposed imported = this.getGlobalImport(i);
            imported.recompose(recomposableElements);
            ++i;
        }
        this.QuickSort2(recomposableElements, 0, recomposableElements.size() - 1);
        this.m_outputProperties = new OutputProperties("xml");
        this.m_attrSets = new Hashtable();
        this.m_decimalFormatSymbols = new Hashtable();
        this.m_keyDecls = new Vector();
        this.m_namespaceAliasComposed = new Hashtable();
        this.m_templateList = new TemplateList();
        this.m_variables = new Vector();
        int i2 = recomposableElements.size() - 1;
        while (i2 >= 0) {
            ((ElemTemplateElement)recomposableElements.elementAt(i2)).recompose(this);
            --i2;
        }
        this.m_templateList.compose();
        this.m_outputProperties.compose();
        n = this.getGlobalImportCount();
        int i3 = 0;
        while (i3 < n) {
            StylesheetComposed imported = this.getGlobalImport(i3);
            int includedCount = imported.getIncludeCountComposed();
            int j = -1;
            while (j < includedCount) {
                Stylesheet included = imported.getIncludeComposed(j);
                StylesheetRoot.composeTemplates(included);
                ++j;
            }
            ++i3;
        }
    }

    void recomposeAttributeSets(ElemAttributeSet attrSet) {
        Vector<ElemAttributeSet> attrSetList = (Vector<ElemAttributeSet>)this.m_attrSets.get(attrSet.getName());
        if (attrSetList == null) {
            attrSetList = new Vector<ElemAttributeSet>();
            this.m_attrSets.put(attrSet.getName(), attrSetList);
        }
        attrSetList.addElement(attrSet);
    }

    void recomposeDecimalFormats(DecimalFormatProperties dfp) {
        DecimalFormatSymbols oldDfs = (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(dfp.getName());
        if (oldDfs == null) {
            this.m_decimalFormatSymbols.put(dfp.getName(), dfp.getDecimalFormatSymbols());
        } else if (!dfp.getDecimalFormatSymbols().equals(oldDfs)) {
            String themsg = dfp.getName().equals(new QName("")) ? XSLMessages.createWarning(19, new Object[0]) : XSLMessages.createWarning(20, new Object[]{dfp.getName()});
            throw new RuntimeException(themsg);
        }
    }

    void recomposeKeys(KeyDeclaration keyDecl) {
        this.m_keyDecls.addElement(keyDecl);
    }

    void recomposeNamespaceAliases(NamespaceAlias nsAlias) {
        this.m_namespaceAliasComposed.put(nsAlias.getStylesheetNamespace(), nsAlias);
    }

    void recomposeOutput(OutputProperties oprops) throws TransformerException {
        this.m_outputProperties.copyFrom(oprops);
    }

    void recomposeTemplates(ElemTemplate template) {
        this.m_templateList.setTemplate(template);
    }

    void recomposeVariables(ElemVariable elemVar) {
        if (this.getVariableOrParamComposed(elemVar.getName()) == null) {
            this.m_variables.addElement(elemVar);
        }
    }

    void recomposeWhiteSpaceInfo(WhiteSpaceInfo wsi) {
        if (this.m_whiteSpaceInfoList == null) {
            this.m_whiteSpaceInfoList = new TemplateList();
        }
        this.m_whiteSpaceInfoList.setTemplate(wsi);
    }

    public final void setTemplateListComposed(TemplateList templateList) {
        this.m_templateList = templateList;
    }

    public boolean shouldCheckWhitespace() {
        return this.m_whiteSpaceInfoList != null;
    }

    public boolean shouldStripWhiteSpace(XPathContext support, Element targetElement) throws TransformerException {
        if (this.m_whiteSpaceInfoList != null) {
            while (targetElement != null) {
                WhiteSpaceInfo info = (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, -1, false);
                if (info != null) {
                    return info.getShouldStripSpace();
                }
                Node parent = targetElement.getParentNode();
                targetElement = parent != null && parent.getNodeType() == 1 ? (Element)parent : null;
            }
        }
        return false;
    }
}

