/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;

public class OutputProperties
extends ElemTemplateElement
implements Cloneable {
    static final String S_XSLT_PREFIX = "xslt.output.";
    static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    static final String S_XALAN_PREFIX = "org.apache.xslt.";
    static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    private transient Hashtable m_propertiesLevels;
    private Properties m_properties = null;
    public static String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    public static String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xslt}content-handler";
    public static String S_KEY_ENTITIES = "{http://xml.apache.org/xslt}entities";
    public static String S_USE_URL_ESCAPING = "{http://xml.apache.org/xslt}use-url-escaping";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Integer m_synch_object = new Integer(1);
    static /* synthetic */ Class class$org$apache$xalan$templates$OutputProperties;

    public OutputProperties() {
        this("xml");
    }

    public OutputProperties(String method) {
        this.m_properties = new Properties(OutputProperties.getDefaultMethodProperties(method));
    }

    public OutputProperties(Properties defaults) {
        this.m_properties = new Properties(defaults);
    }

    private void checkDuplicates(OutputProperties newProps) throws TransformerException {
        if (this.m_propertiesLevels == null) {
            this.m_propertiesLevels = new Hashtable();
        }
        int newPrecedence = newProps.getStylesheetComposed().getImportCountComposed();
        Properties p = newProps.getProperties();
        Enumeration enumeration = ((Hashtable)p).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.equals("cdata-section-elements")) continue;
            Integer oldPrecedence = (Integer)this.m_propertiesLevels.get(key);
            if (oldPrecedence == null) {
                this.m_propertiesLevels.put(key, new Integer(newPrecedence));
                continue;
            }
            if (newPrecedence < oldPrecedence) continue;
            String oldValue = (String)((Hashtable)this.m_properties).get(key);
            String newValue = (String)((Hashtable)newProps.m_properties).get(key);
            if ((oldValue != null || newValue == null) && oldValue.equals(newValue)) continue;
            String msg = String.valueOf(key) + " can not be multiply defined at the same " + "import level! Old value = " + oldValue + "; New value = " + newValue;
            throw new TransformerException(msg, newProps);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object clone() {
        try {
            OutputProperties cloned = (OutputProperties)super.clone();
            cloned.m_properties = (Properties)((Hashtable)cloned.m_properties).clone();
            return cloned;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void compose() {
        super.compose();
        this.m_propertiesLevels = null;
    }

    public void copyFrom(Properties src) {
        this.copyFrom(src, true);
    }

    public void copyFrom(Properties src, boolean shouldResetDefaults) {
        Enumeration enumeration = ((Hashtable)src).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Object oldValue = ((Hashtable)this.m_properties).get(key);
            if (oldValue == null) {
                String val = (String)((Hashtable)src).get(key);
                if (shouldResetDefaults && key.equals("method")) {
                    this.setMethodDefaults(val);
                }
                ((Hashtable)this.m_properties).put(key, val);
                continue;
            }
            if (!key.equals("cdata-section-elements")) continue;
            ((Hashtable)this.m_properties).put(key, String.valueOf((String)oldValue) + " " + (String)((Hashtable)src).get(key));
        }
    }

    public void copyFrom(OutputProperties opsrc) throws TransformerException {
        this.checkDuplicates(opsrc);
        this.copyFrom(opsrc.getProperties());
    }

    private static String fixupPropertyString(String s, boolean doClipping) {
        int index;
        if (doClipping && s.startsWith(S_XSLT_PREFIX)) {
            s = s.substring(S_XSLT_PREFIX_LEN);
        }
        if (s.startsWith(S_XALAN_PREFIX)) {
            s = S_BUILTIN_EXTENSIONS_UNIVERSAL + s.substring(S_XALAN_PREFIX_LEN);
        }
        if ((index = s.indexOf("\\u003a")) > 0) {
            String temp = s.substring(index + 6);
            s = String.valueOf(s.substring(0, index)) + ":" + temp;
        }
        return s;
    }

    public boolean getBooleanProperty(String key) {
        return OutputProperties.getBooleanProperty(key, this.m_properties);
    }

    public static boolean getBooleanProperty(String key, Properties props) {
        String s = props.getProperty(key);
        return s != null && s.equals("yes");
    }

    public boolean getBooleanProperty(QName key) {
        return this.getBooleanProperty(key.toNamespacedString());
    }

    public static Properties getDefaultMethodProperties(String method) {
        Properties defaultProperties;
        block20: {
            defaultProperties = null;
            try {
                Integer n;
                if (m_xml_properties == null) {
                    n = m_synch_object;
                    synchronized (n) {
                        if (m_xml_properties == null) {
                            m_xml_properties = OutputProperties.loadPropertiesFile("output_xml.properties", null);
                        }
                    }
                }
                if (method.equals("xml")) {
                    defaultProperties = m_xml_properties;
                    break block20;
                }
                if (method.equals("html")) {
                    if (m_html_properties == null) {
                        n = m_synch_object;
                        synchronized (n) {
                            if (m_html_properties == null) {
                                m_html_properties = OutputProperties.loadPropertiesFile("output_html.properties", m_xml_properties);
                            }
                        }
                    }
                    defaultProperties = m_html_properties;
                    break block20;
                }
                if (method.equals("text")) {
                    if (m_text_properties == null) {
                        n = m_synch_object;
                        synchronized (n) {
                            if (m_text_properties == null && (m_text_properties = OutputProperties.loadPropertiesFile("output_text.properties", null)).getProperty("encoding") == null) {
                                String mimeEncoding = Encodings.getMimeEncoding(null);
                                ((Hashtable)m_text_properties).put("encoding", mimeEncoding);
                            }
                        }
                    }
                    defaultProperties = m_text_properties;
                    break block20;
                }
                defaultProperties = m_xml_properties;
            }
            catch (IOException ioe) {
                throw new WrappedRuntimeException(ioe);
            }
        }
        return defaultProperties;
    }

    public int getIntProperty(String key) {
        return OutputProperties.getIntProperty(key, this.m_properties);
    }

    public static int getIntProperty(String key, Properties props) {
        String s = props.getProperty(key);
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public int getIntProperty(QName key) {
        return this.getIntProperty(key.toNamespacedString());
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public String getProperty(QName key) {
        return this.m_properties.getProperty(key.toNamespacedString());
    }

    public Vector getQNameProperties(String key) {
        return OutputProperties.getQNameProperties(key, this.m_properties);
    }

    public static Vector getQNameProperties(String key, Properties props) {
        block6: {
            String s = props.getProperty(key);
            if (s == null) break block6;
            Vector<QName> v = new Vector<QName>();
            int l = s.length();
            boolean inCurly = false;
            FastStringBuffer buf = new FastStringBuffer();
            int i = 0;
            while (i < l) {
                block9: {
                    char c;
                    block8: {
                        block7: {
                            c = s.charAt(i);
                            if (!Character.isWhitespace(c)) break block7;
                            if (inCurly) break block8;
                            if (buf.length() > 0) {
                                QName qname = QName.getQNameFromString(buf.toString());
                                v.addElement(qname);
                                buf.reset();
                            }
                            break block9;
                        }
                        if (c == '{') {
                            inCurly = true;
                        } else if (c == '}') {
                            inCurly = false;
                        }
                    }
                    buf.append(c);
                }
                ++i;
            }
            if (buf.length() > 0) {
                QName qname = QName.getQNameFromString(buf.toString());
                v.addElement(qname);
                buf.reset();
            }
            return v;
        }
        return null;
    }

    public Vector getQNameProperties(QName key) {
        return this.getQNameProperties(key.toNamespacedString());
    }

    public QName getQNameProperty(String key) {
        return OutputProperties.getQNameProperty(key, this.m_properties);
    }

    public static QName getQNameProperty(String key, Properties props) {
        String s = props.getProperty(key);
        if (s != null) {
            return QName.getQNameFromString(s);
        }
        return null;
    }

    public QName getQNameProperty(QName key) {
        return this.getQNameProperty(key.toNamespacedString());
    }

    public boolean isLegalPropertyKey(String key) {
        return key.equals("cdata-section-elements") || key.equals("doctype-public") || key.equals("doctype-system") || key.equals("encoding") || key.equals("indent") || key.equals("media-type") || key.equals("method") || key.equals("omit-xml-declaration") || key.equals("standalone") || key.equals("version") || key.length() > 0 && key.charAt(0) == '{';
    }

    private static Properties loadPropertiesFile(String resourceName, Properties defaults) throws IOException {
        Properties props = new Properties(defaults);
        InputStream is = (class$org$apache$xalan$templates$OutputProperties != null ? class$org$apache$xalan$templates$OutputProperties : (class$org$apache$xalan$templates$OutputProperties = OutputProperties.class$("org.apache.xalan.templates.OutputProperties"))).getResourceAsStream(resourceName);
        BufferedInputStream bis = new BufferedInputStream(is);
        props.load(bis);
        Enumeration keys = ((Hashtable)props).keys();
        while (keys.hasMoreElements()) {
            String newKey;
            String newValue;
            String key = (String)keys.nextElement();
            String value = System.getProperty(key);
            if (value == null) {
                value = (String)((Hashtable)props).get(key);
            }
            newValue = (newValue = System.getProperty(newKey = OutputProperties.fixupPropertyString(key, true))) == null ? OutputProperties.fixupPropertyString(value, false) : OutputProperties.fixupPropertyString(newValue, false);
            if (key == newKey && value == newValue) continue;
            ((Hashtable)props).remove(key);
            ((Hashtable)props).put(newKey, newValue);
        }
        return props;
    }

    public void recompose(StylesheetRoot root) throws TransformerException {
        root.recomposeOutput(this);
    }

    public void setBooleanProperty(String key, boolean value) {
        ((Hashtable)this.m_properties).put(key, value ? "yes" : "no");
    }

    public void setBooleanProperty(QName key, boolean value) {
        ((Hashtable)this.m_properties).put(key.toNamespacedString(), value ? "yes" : "no");
    }

    public void setIntProperty(String key, int value) {
        ((Hashtable)this.m_properties).put(key, Integer.toString(value));
    }

    public void setIntProperty(QName key, int value) {
        this.setIntProperty(key.toNamespacedString(), value);
    }

    public void setMethodDefaults(String method) {
        String defaultMethod = this.m_properties.getProperty("method");
        if (defaultMethod == null || !defaultMethod.equals(method)) {
            Properties savedProps = this.m_properties;
            Properties newDefaults = OutputProperties.getDefaultMethodProperties(method);
            this.m_properties = new Properties(newDefaults);
            this.copyFrom(savedProps, false);
        }
    }

    public void setProperty(String key, String value) {
        if (key.equals("method")) {
            this.setMethodDefaults(value);
        }
        ((Hashtable)this.m_properties).put(key, value);
    }

    public void setProperty(QName key, String value) {
        this.setProperty(key.toNamespacedString(), value);
    }

    public void setQNameProperties(String key, Vector v) {
        int s = v.size();
        FastStringBuffer fsb = new FastStringBuffer();
        int i = 0;
        while (i < s) {
            QName qname = (QName)v.elementAt(i);
            fsb.append(qname.toNamespacedString());
            if (i < s - 1) {
                fsb.append(' ');
            }
            ++i;
        }
        ((Hashtable)this.m_properties).put(key, fsb.toString());
    }

    public void setQNameProperties(QName key, Vector v) {
        this.setQNameProperties(key.toNamespacedString(), v);
    }

    public void setQNameProperty(String key, QName value) {
        this.setProperty(key, value.toNamespacedString());
    }

    public void setQNameProperty(QName key, QName value) {
        this.setQNameProperty(key.toNamespacedString(), value);
    }
}

