/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final byte[] endstream = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    static final byte[] endobj = new byte[]{101, 110, 100, 111, 98, 106};
    protected PRTokeniser tokens;
    protected int[] xref;
    protected PdfObject[] xrefObj;
    protected PdfDictionary trailer;
    protected PdfDictionary[] pages;
    protected PdfDictionary catalog;
    protected PRIndirectReference[] pageRefs;
    protected PRAcroForm acroForm = null;
    protected ArrayList pageInh;
    protected int pagesCount;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected int objNum;
    protected int objGen;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    protected int rValue;
    protected int pValue;

    protected PdfReader() {
    }

    public PdfReader(String string) throws IOException {
        this(string, null);
    }

    public PdfReader(String string, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) throws IOException {
        this(byArray, null);
    }

    public PdfReader(byte[] byArray, byte[] byArray2) throws IOException {
        this.password = byArray2;
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    public PdfReader(URL uRL) throws IOException {
        this(uRL, null);
    }

    public PdfReader(URL uRL, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(uRL));
        this.readPdf();
    }

    public PdfReader(PdfReader pdfReader) {
        this.consolidateNamedDestinations = pdfReader.consolidateNamedDestinations;
        this.encrypted = pdfReader.encrypted;
        this.rebuilt = pdfReader.rebuilt;
        this.sharedStreams = pdfReader.sharedStreams;
        this.tampered = pdfReader.tampered;
        this.password = pdfReader.password;
        this.pdfVersion = pdfReader.pdfVersion;
        this.eofPos = pdfReader.eofPos;
        this.freeXref = pdfReader.freeXref;
        this.lastXref = pdfReader.lastXref;
        this.objGen = pdfReader.objGen;
        this.objNum = pdfReader.objNum;
        this.pagesCount = pdfReader.pagesCount;
        this.tokens = pdfReader.tokens;
        this.decrypt = pdfReader.decrypt;
        this.pValue = pdfReader.pValue;
        this.rValue = pdfReader.rValue;
        this.xrefObj = new PdfObject[pdfReader.xrefObj.length];
        int n = 0;
        while (n < pdfReader.xrefObj.length) {
            this.xrefObj[n] = PdfReader.duplicatePdfObject(pdfReader.xrefObj[n], this);
            ++n;
        }
        this.pageRefs = new PRIndirectReference[pdfReader.pageRefs.length];
        this.pages = new PdfDictionary[pdfReader.pages.length];
        int n2 = 0;
        while (n2 < pdfReader.pageRefs.length) {
            this.pageRefs[n2] = (PRIndirectReference)PdfReader.duplicatePdfObject(pdfReader.pageRefs[n2], this);
            this.pages[n2] = (PdfDictionary)PdfReader.getPdfObject(this.pageRefs[n2]);
            ++n2;
        }
        this.trailer = (PdfDictionary)PdfReader.duplicatePdfObject(pdfReader.trailer, this);
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfObject pdfObject = this.catalog.get(PdfName.ACROFORM);
        if (pdfObject != null) {
            try {
                this.acroForm = new PRAcroForm(this);
                this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(pdfObject));
            }
            catch (Exception exception) {
                this.acroForm = null;
            }
        }
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter, this.xrefObj, this.pages);
    }

    public int getNumberOfPages() {
        return this.pages.length;
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        return this.acroForm;
    }

    public int getPageRotation(int n) {
        PdfDictionary pdfDictionary = this.pages[n - 1];
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ROTATE));
        if (pdfNumber == null) {
            return 0;
        }
        int n2 = pdfNumber.intValue();
        return (n2 %= 360) < 0 ? n2 + 360 : n2;
    }

    public Rectangle getPageSizeWithRotation(int n) {
        Rectangle rectangle = this.getPageSize(n);
        int n2 = this.getPageRotation(n);
        while (n2 > 0) {
            rectangle = rectangle.rotate();
            n2 -= 90;
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n) {
        PdfDictionary pdfDictionary = this.pages[n - 1];
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getCropBox(int n) {
        PdfDictionary pdfDictionary = this.pages[n - 1];
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CROPBOX));
        if (pdfArray == null) {
            return this.getPageSize(n);
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public HashMap getInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
        if (pdfDictionary == null) {
            return hashMap;
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
            if (pdfObject == null) continue;
            String string = pdfObject.toString();
            switch (pdfObject.type()) {
                case 3: {
                    string = ((PdfString)pdfObject).toUnicodeString();
                    break;
                }
                case 4: {
                    string = PdfName.decodeName(string);
                }
            }
            hashMap.put(PdfName.decodeName(pdfName.toString()), string);
        }
        return hashMap;
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        ArrayList arrayList = pdfArray.getArrayList();
        float f = ((PdfNumber)arrayList.get(0)).floatValue();
        float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
        float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
        float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
        return new Rectangle(Math.min(f, f3), Math.min(f2, f4), Math.max(f, f3), Math.max(f2, f4));
    }

    protected void readPdf() throws IOException {
        try {
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new IOException("Rebuild failed: " + exception2.getMessage() + "; Original message: " + exception.getMessage());
                }
            }
            this.readDocObj();
            this.readDecryptedDocObj();
            this.strings.clear();
            this.readPages();
            PdfObject pdfObject = this.catalog.get(PdfName.ACROFORM);
            if (pdfObject != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(pdfObject));
                }
                catch (Exception exception) {
                    this.acroForm = null;
                }
            }
            this.eliminateSharedStreams();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.tokens.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception exception) {}
    }

    private boolean equalsArray(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void readDecryptedDocObj() throws IOException {
        String string;
        PdfObject pdfObject;
        PdfObject pdfObject2 = this.trailer.get(PdfName.ENCRYPT);
        if (pdfObject2 == null || pdfObject2.toString().equals("null")) {
            return;
        }
        this.encrypted = true;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(this.trailer.get(PdfName.ID));
        byte[] byArray = null;
        if (pdfArray != null) {
            pdfObject = (PdfObject)pdfArray.getArrayList().get(0);
            string = pdfObject.toString();
            byArray = DocWriter.getISOBytes(string);
        }
        string = pdfDictionary.get(PdfName.U).toString();
        byte[] byArray2 = DocWriter.getISOBytes(string);
        string = pdfDictionary.get(PdfName.O).toString();
        byte[] byArray3 = DocWriter.getISOBytes(string);
        pdfObject = pdfDictionary.get(PdfName.R);
        if (pdfObject.type() != 2) {
            throw new IOException("Illegal R value.");
        }
        this.rValue = ((PdfNumber)pdfObject).intValue();
        if (this.rValue != 2 && this.rValue != 3) {
            throw new IOException("Unknown encryption type (" + this.rValue + ")");
        }
        pdfObject = pdfDictionary.get(PdfName.P);
        if (pdfObject.type() != 2) {
            throw new IOException("Illegal P value.");
        }
        this.pValue = ((PdfNumber)pdfObject).intValue();
        this.decrypt = new PdfEncryption();
        this.decrypt.setupByUserPassword(byArray, this.password, byArray3, this.pValue, this.rValue == 3);
        if (!this.equalsArray(byArray2, this.decrypt.userKey, this.rValue == 3 ? 16 : 32)) {
            this.decrypt.setupByOwnerPassword(byArray, this.password, byArray2, byArray3, this.pValue, this.rValue == 3);
            if (!Arrays.equals(byArray2, this.decrypt.userKey)) {
                throw new IOException("Bad user password");
            }
        }
        int n = 0;
        while (n < this.strings.size()) {
            PdfString pdfString = (PdfString)this.strings.get(n);
            pdfString.decrypt(this);
            ++n;
        }
    }

    public static PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject.type() != 10) {
            return pdfObject;
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
        int n = pRIndirectReference.getNumber();
        if ((pdfObject = pRIndirectReference.getReader().xrefObj[n]) == null) {
            return PdfNull.PDFNULL;
        }
        return pdfObject;
    }

    protected void pushPageAttributes(PdfDictionary pdfDictionary) {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (this.pageInh.size() != 0) {
            pdfDictionary2.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
        }
        int n = 0;
        while (n < pageInhCandidates.length) {
            PdfObject pdfObject = pdfDictionary.get(pageInhCandidates[n]);
            if (pdfObject != null) {
                pdfDictionary2.put(pageInhCandidates[n], pdfObject);
            }
            ++n;
        }
        this.pageInh.add(pdfDictionary2);
    }

    protected void popPageAttributes() {
        this.pageInh.remove(this.pageInh.size() - 1);
    }

    protected void iteratePages(PdfDictionary pdfDictionary) throws IOException {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            pdfDictionary.put(PdfName.TYPE, PdfName.PAGE);
            PdfDictionary pdfDictionary2 = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
            Iterator iterator = pdfDictionary2.getKeys().iterator();
            while (iterator.hasNext()) {
                PdfName pdfName = (PdfName)iterator.next();
                if (pdfDictionary.get(pdfName) != null) continue;
                pdfDictionary.put(pdfName, pdfDictionary2.get(pdfName));
            }
            this.pages[this.pagesCount++] = pdfDictionary;
        } else {
            pdfDictionary.put(PdfName.TYPE, PdfName.PAGES);
            this.pushPageAttributes(pdfDictionary);
            ArrayList arrayList = pdfArray.getArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                this.pageRefs[this.pagesCount] = (PRIndirectReference)arrayList.get(n);
                PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(this.pageRefs[this.pagesCount]);
                this.iteratePages(pdfDictionary3);
                ++n;
            }
            this.popPageAttributes();
        }
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.COUNT));
        this.pages = new PdfDictionary[pdfNumber.intValue()];
        this.pageRefs = new PRIndirectReference[this.pages.length];
        this.pagesCount = 0;
        this.iteratePages(pdfDictionary);
        this.pageInh = null;
    }

    protected void readDocObj() throws IOException {
        Object object;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.xrefObj = new PdfObject[this.xref.length];
        int n2 = 1;
        while (n2 < this.xrefObj.length) {
            n = this.xref[n2];
            if (n > 0) {
                this.tokens.seek(n);
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid object number.");
                }
                this.objNum = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid generation number.");
                }
                this.objGen = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (!this.tokens.getStringValue().equals("obj")) {
                    this.tokens.throwError("Token 'obj' expected.");
                }
                object = this.readPRObject();
                this.xrefObj[n2] = object;
                if (((PdfObject)object).type() == 7) {
                    arrayList.add(object);
                }
            }
            ++n2;
        }
        n = this.tokens.length();
        object = new byte[16];
        int n3 = 0;
        while (n3 < arrayList.size()) {
            int n4;
            PRStream pRStream;
            block13: {
                pRStream = (PRStream)arrayList.get(n3);
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.LENGTH));
                int n5 = pRStream.getOffset();
                n4 = pdfNumber.intValue();
                boolean bl = false;
                if (n4 + n5 > n - 20) {
                    bl = true;
                } else {
                    this.tokens.seek(n5 + n4);
                    String string = this.tokens.readString(20);
                    if (!(string.startsWith("\nendstream") || string.startsWith("\r\nendstream") || string.startsWith("\rendstream") || string.startsWith("endstream"))) {
                        bl = true;
                    }
                }
                if (bl) {
                    int n6;
                    this.tokens.seek(n5);
                    do {
                        n6 = this.tokens.getFilePointer();
                        if (!this.tokens.readLineSegment((byte[])object)) break block13;
                        if (!PdfReader.equalsn((byte[])object, endstream)) continue;
                        n4 = n6 - n5;
                        break block13;
                    } while (!PdfReader.equalsn((byte[])object, endobj));
                    this.tokens.seek(n6 - 16);
                    String string = this.tokens.readString(16);
                    int n7 = string.indexOf("endstream");
                    if (n7 >= 0) {
                        n6 = n6 - 16 + n7;
                    }
                    n4 = n6 - n5;
                }
            }
            pRStream.setLength(n4);
            ++n3;
        }
        this.xref = null;
    }

    static PdfObject killIndirect(PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.type() == 8) {
            return null;
        }
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfObject);
        if (pdfObject.type() == 10) {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
            pRIndirectReference.getReader().xrefObj[pRIndirectReference.getNumber()] = null;
        }
        return pdfObject2;
    }

    protected void readXref() throws IOException {
        PdfNumber pdfNumber;
        int n;
        int n2;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        this.lastXref = n2 = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        this.tokens.seek(n2);
        while ((n = this.tokens.read()) != -1 && n != 116) {
        }
        if (n == -1) {
            throw new IOException("Unexpected end of file.");
        }
        this.tokens.backOnePosition(n);
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("trailer")) {
            throw new IOException("trailer not found.");
        }
        this.trailer = (PdfDictionary)this.readPRObject();
        PdfNumber pdfNumber2 = (PdfNumber)this.trailer.get(PdfName.SIZE);
        this.xref = new int[pdfNumber2.intValue()];
        this.tokens.seek(n2);
        this.readXrefSection();
        PdfDictionary pdfDictionary = this.trailer;
        while ((pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.PREV)) != null) {
            this.tokens.seek(pdfNumber.intValue());
            this.readXrefSection();
            pdfDictionary = (PdfDictionary)this.readPRObject();
        }
    }

    protected void readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block0: while (true) {
            int n5;
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            n = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            n2 = this.tokens.intValue() + n;
            if (n == 1) {
                n5 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                if (n3 == 0 && n4 == 65535) {
                    --n;
                    --n2;
                }
                this.tokens.seek(n5);
            }
            if (this.xref.length < n2) {
                int[] nArray = new int[n2];
                System.arraycopy(this.xref, 0, nArray, 0, this.xref.length);
                this.xref = nArray;
            }
            n5 = n;
            while (true) {
                if (n5 >= n2) continue block0;
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n5] == 0) {
                        if (n3 == 0) {
                            this.tokens.throwError("File position 0 cross-reference entry in this xref subsection");
                        }
                        this.xref[n5] = n3;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n5] == 0) {
                        this.xref[n5] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++n5;
            }
            break;
        }
    }

    protected void rebuildXref() throws IOException {
        Object object;
        int n;
        this.tokens.seek(0);
        int[][] nArrayArray = new int[1024][];
        Object object2 = 0;
        this.trailer = null;
        byte[] byArray = new byte[64];
        while (true) {
            n = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(byArray)) break;
            if (byArray[0] == 116) {
                if (!PdfEncodings.convertToString(byArray, null).startsWith("trailer")) continue;
                n = this.tokens.getFilePointer();
                try {
                    object = (PdfDictionary)this.readPRObject();
                    if (object.get(PdfName.ROOT) != null) {
                        this.trailer = object;
                        continue;
                    }
                    this.tokens.seek(n);
                }
                catch (Exception exception) {
                    this.tokens.seek(n);
                }
                continue;
            }
            if (byArray[0] < 48 || byArray[0] > 57 || (object = PRTokeniser.checkObjectStart(byArray)) == null) continue;
            Object object3 = object[0];
            Object object4 = object[1];
            if (object3 >= nArrayArray.length) {
                reference var8_9 = object3 * 2;
                int[][] nArrayArray2 = new int[var8_9][];
                System.arraycopy(nArrayArray, 0, nArrayArray2, 0, object2);
                nArrayArray = nArrayArray2;
            }
            if (object3 >= object2) {
                object2 = object3 + true;
            }
            if (nArrayArray[object3] != null && object4 < nArrayArray[object3][1]) continue;
            object[0] = n;
            nArrayArray[object3] = object;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        this.xref = new int[object2];
        n = 0;
        while (n < object2) {
            object = nArrayArray[n];
            if (object != null) {
                this.xref[n] = (int)object[0];
            }
            ++n;
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue());
            PdfObject pdfObject = this.readPRObject();
            int n = pdfObject.type();
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject pdfObject;
        int n;
        PdfArray pdfArray = new PdfArray();
        while (-(n = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n = this.tokens.getTokenType();
        switch (n) {
            case 7: {
                PdfDictionary pdfDictionary = this.readDictionary();
                int n2 = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int n3 = this.tokens.read();
                    if (n3 == 13) {
                        n3 = this.tokens.read();
                    }
                    if (n3 != 10) {
                        this.tokens.backOnePosition(n3);
                    }
                    PRStream pRStream = new PRStream(this, this.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    pRStream.setObjNum(this.objNum, this.objGen);
                    return pRStream;
                }
                this.tokens.seek(n2);
                return pdfDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString pdfString = new PdfString(this.tokens.getStringValue(), null);
                pdfString.setObjNum(this.objNum, this.objGen);
                this.strings.add(pdfString);
                return pdfString;
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue());
            }
            case 9: {
                return new PRIndirectReference(this, this.tokens.getReference(), this.tokens.getGeneration());
            }
        }
        return new PdfLiteral(-n, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n;
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 == 62) break;
            if (!PRTokeniser.isWhitespace(n3)) {
                int n4 = PRTokeniser.getHex(n3);
                if (n4 == -1) {
                    throw new RuntimeException("Illegal character in ASCIIHexDecode.");
                }
                if (bl) {
                    n = n4;
                } else {
                    byteArrayOutputStream.write((byte)((n << 4) + n4));
                }
                bl = !bl;
            }
            ++n2;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        int[] nArray = new int[5];
        int n3 = 0;
        while (n3 < byArray.length) {
            n = byArray[n3] & 0xFF;
            if (n == 126) break;
            if (!PRTokeniser.isWhitespace(n)) {
                if (n == 122 && n2 == 0) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                } else {
                    if (n < 33 || n > 117) {
                        throw new RuntimeException("Illegal character in ASCII85Decode.");
                    }
                    nArray[n2] = n - 33;
                    if (++n2 == 5) {
                        n2 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < 5) {
                            n4 = n4 * 85 + nArray[n5];
                            ++n5;
                        }
                        byteArrayOutputStream.write((byte)(n4 >> 24));
                        byteArrayOutputStream.write((byte)(n4 >> 16));
                        byteArrayOutputStream.write((byte)(n4 >> 8));
                        byteArrayOutputStream.write((byte)n4);
                    }
                }
            }
            ++n3;
        }
        n = 0;
        if (n2 == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (n2 == 2) {
            n = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85;
            byteArrayOutputStream.write((byte)(n >> 24));
        } else if (n2 == 3) {
            n = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85;
            byteArrayOutputStream.write((byte)(n >> 24));
            byteArrayOutputStream.write((byte)(n >> 16));
        } else if (n2 == 4) {
            n = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + nArray[3] * 85;
            byteArrayOutputStream.write((byte)(n >> 24));
            byteArrayOutputStream.write((byte)(n >> 16));
            byteArrayOutputStream.write((byte)(n >> 8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int n) {
        if (n > this.pages.length) {
            return null;
        }
        return this.pages[n - 1];
    }

    public PRIndirectReference getPageOrigRef(int n) {
        if (n > this.pageRefs.length) {
            return null;
        }
        return this.pageRefs[n - 1];
    }

    public byte[] getPageContent(int n, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = this.getPageN(n);
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
        if (pdfObject == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (pdfObject.type() == 7) {
            return PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        if (pdfObject.type() == 5) {
            PdfArray pdfArray = (PdfArray)pdfObject;
            ArrayList arrayList = pdfArray.getArrayList();
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                PdfObject pdfObject2 = PdfReader.getPdfObject((PdfObject)arrayList.get(n2));
                if (pdfObject2 != null && pdfObject2.type() == 7) {
                    byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject2, randomAccessFileOrArray);
                    byteArrayOutputStream.write(byArray);
                    if (n2 != arrayList.size() - 1) {
                        byteArrayOutputStream.write(10);
                    }
                }
                ++n2;
            }
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    protected void killXref(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (pdfObject instanceof PdfIndirectReference && pdfObject.type() != 10) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                int n = ((PRIndirectReference)pdfObject).getNumber();
                pdfObject = this.xrefObj[n];
                this.xrefObj[n] = null;
                this.freeXref = n;
                this.killXref(pdfObject);
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    this.killXref((PdfObject)arrayList.get(n));
                    ++n;
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    this.killXref(pdfDictionary.get((PdfName)iterator.next()));
                }
                break;
            }
        }
    }

    public void setPageContent(int n, byte[] byArray) throws IOException {
        PdfDictionary pdfDictionary = this.getPageN(n);
        if (pdfDictionary == null) {
            return;
        }
        PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
        this.freeXref = -1;
        this.killXref(pdfObject);
        if (this.freeXref == -1) {
            int n2 = this.xrefObj.length - 1;
            while (n2 > 0) {
                if (this.xrefObj[n2] == null) {
                    this.freeXref = n2;
                    break;
                }
                --n2;
            }
            if (this.freeXref == -1) {
                PdfObject[] pdfObjectArray = new PdfObject[this.xrefObj.length + 10];
                System.arraycopy(this.xrefObj, 0, pdfObjectArray, 0, this.xrefObj.length);
                this.freeXref = this.xrefObj.length;
                this.xrefObj = pdfObjectArray;
            }
        }
        pdfDictionary.put(PdfName.CONTENTS, new PRIndirectReference(this, this.freeXref));
        this.xrefObj[this.freeXref] = new PRStream(this, byArray);
    }

    public static byte[] getStreamBytes(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        Object object;
        byte[] byArray;
        PdfReader pdfReader = pRStream.getReader();
        PdfObject pdfObject = PdfReader.getPdfObject(pRStream.get(PdfName.FILTER));
        if (pRStream.getOffset() < 0) {
            byArray = pRStream.getBytes();
        } else {
            byArray = new byte[pRStream.getLength()];
            randomAccessFileOrArray.seek(pRStream.getOffset());
            randomAccessFileOrArray.readFully(byArray);
            object = pdfReader.getDecrypt();
            if (object != null) {
                ((PdfEncryption)object).setHashKey(pRStream.getObjNum(), pRStream.getObjGen());
                ((PdfEncryption)object).prepareKey();
                ((PdfEncryption)object).encryptRC4(byArray);
            }
        }
        object = new ArrayList();
        if (pdfObject != null) {
            if (pdfObject.type() == 4) {
                ((ArrayList)object).add(pdfObject);
            } else if (pdfObject.type() == 5) {
                object = ((PdfArray)pdfObject).getArrayList();
            }
        }
        int n = 0;
        while (n < ((ArrayList)object).size()) {
            String string = ((PdfName)PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(n))).toString();
            if (string.equals("/FlateDecode") || string.equals("/Fl")) {
                byArray = PdfReader.FlateDecode(byArray);
            } else if (string.equals("/ASCIIHexDecode") || string.equals("/AHx")) {
                byArray = PdfReader.ASCIIHexDecode(byArray);
            } else if (string.equals("/ASCII85Decode") || string.equals("/A85")) {
                byArray = PdfReader.ASCII85Decode(byArray);
            } else if (string.equals("/LZWDecode")) {
                byArray = PdfReader.LZWDecode(byArray);
            } else {
                throw new IOException("The filter " + string + " is not supported.");
            }
            ++n;
        }
        return byArray;
    }

    public void eliminateSharedStreams() {
        PdfObject[] pdfObjectArray;
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pages.length == 1) {
            return;
        }
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList<PRStream> arrayList2 = new ArrayList<PRStream>();
        IntHashtable intHashtable = new IntHashtable();
        int n = 0;
        while (n < this.pages.length) {
            PdfObject pdfObject;
            PdfDictionary pdfDictionary = this.pages[n];
            if (pdfDictionary != null && (pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS))) != null) {
                PdfObject pdfObject2;
                if (pdfObject.type() == 7) {
                    pdfObject2 = (PRIndirectReference)pdfDictionary.get(PdfName.CONTENTS);
                    if (intHashtable.containsKey(((PdfIndirectReference)pdfObject2).getNumber())) {
                        arrayList.add(pdfObject2);
                        arrayList2.add(new PRStream((PRStream)pdfObject, null));
                    } else {
                        intHashtable.put(((PdfIndirectReference)pdfObject2).getNumber(), 1);
                    }
                } else {
                    pdfObject2 = (PdfArray)pdfObject;
                    pdfObjectArray = ((PdfArray)pdfObject2).getArrayList();
                    int n2 = 0;
                    while (n2 < pdfObjectArray.size()) {
                        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObjectArray.get(n2);
                        if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                            arrayList.add(pRIndirectReference);
                            arrayList2.add(new PRStream((PRStream)PdfReader.getPdfObject(pRIndirectReference), null));
                        } else {
                            intHashtable.put(pRIndirectReference.getNumber(), 1);
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (arrayList2.size() == 0) {
            return;
        }
        int n3 = 1;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = n3;
            while (n5 < this.xrefObj.length) {
                if (this.xrefObj[n5] == null) {
                    int n6 = arrayList2.size() - 1;
                    this.xrefObj[n5] = (PRStream)arrayList2.get(n6);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)arrayList.get(n6);
                    pRIndirectReference.setNumber(n5, 0);
                    if (n6 == 0) {
                        return;
                    }
                    arrayList2.remove(n6);
                }
                ++n5;
            }
            n3 = this.xrefObj.length;
            pdfObjectArray = new PdfObject[this.xrefObj.length + arrayList2.size()];
            System.arraycopy(this.xrefObj, 0, pdfObjectArray, 0, this.xrefObj.length);
            this.xrefObj = pdfObjectArray;
            ++n4;
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean bl) {
        this.tampered = bl;
    }

    public byte[] getMetadata() throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(pdfObject instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        byte[] byArray = null;
        try {
            randomAccessFileOrArray.reOpen();
            byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getXrefSize() {
        return this.xrefObj.length;
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public int getPermissions() {
        return this.pValue;
    }

    public boolean is128Key() {
        return this.rValue == 3;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean existsName(PdfDictionary pdfDictionary, PdfName pdfName, PdfName pdfName2) {
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
        if (pdfObject == null || pdfObject.type() != 4) {
            return false;
        }
        PdfName pdfName3 = (PdfName)pdfObject;
        return pdfName3.equals(pdfName2);
    }

    static String getFontName(PdfDictionary pdfDictionary) {
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.BASEFONT));
        if (pdfObject == null || pdfObject.type() != 4) {
            return null;
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    static String getSubsetPrefix(PdfDictionary pdfDictionary) {
        String string = PdfReader.getFontName(pdfDictionary);
        if (string == null) {
            return null;
        }
        if (string.length() < 8 || string.charAt(6) != '+') {
            return null;
        }
        int n = 0;
        while (n < 6) {
            char c = string.charAt(n);
            if (c < 'A' || c > 'Z') {
                return null;
            }
            ++n;
        }
        return string;
    }

    public int shuffleSubsetNames() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.xrefObj.length) {
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = this.xrefObj[n2];
            if (pdfObject != null && pdfObject.type() == 6 && PdfReader.existsName(pdfDictionary = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT)) {
                PdfDictionary pdfDictionary2;
                Object object;
                Object object2;
                String string;
                if (PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TRUETYPE)) {
                    string = PdfReader.getSubsetPrefix(pdfDictionary);
                    if (string != null) {
                        object2 = BaseFont.createSubsetPrefix() + string.substring(7);
                        object = new PdfName((String)object2);
                        pdfDictionary.put(PdfName.BASEFONT, (PdfObject)object);
                        ++n;
                        pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
                        if (pdfDictionary2 != null) {
                            pdfDictionary2.put(PdfName.FONTNAME, (PdfObject)object);
                        }
                    }
                } else if (PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE0)) {
                    String string2;
                    string = PdfReader.getSubsetPrefix(pdfDictionary);
                    object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DESCENDANTFONTS));
                    if (object2 != null && ((ArrayList)(object = ((PdfArray)object2).getArrayList())).size() != 0 && (string2 = PdfReader.getSubsetPrefix(pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(0)))) != null) {
                        String string3 = BaseFont.createSubsetPrefix();
                        if (string != null) {
                            pdfDictionary.put(PdfName.BASEFONT, new PdfName(string3 + string.substring(7)));
                        }
                        PdfName pdfName = new PdfName(string3 + string2.substring(7));
                        pdfDictionary2.put(PdfName.BASEFONT, pdfName);
                        ++n;
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FONTDESCRIPTOR));
                        if (pdfDictionary3 != null) {
                            pdfDictionary3.put(PdfName.FONTNAME, pdfName);
                        }
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    public int createFakeFontSubsets() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.xrefObj.length) {
            String string;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = this.xrefObj[n2];
            if (pdfObject != null && pdfObject.type() == 6 && PdfReader.existsName(pdfDictionary = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT) && (PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TRUETYPE)) && (string = PdfReader.getSubsetPrefix(pdfDictionary)) == null && (string = PdfReader.getFontName(pdfDictionary)) != null) {
                String string2 = BaseFont.createSubsetPrefix() + string;
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
                if (pdfDictionary2 != null && (pdfDictionary2.get(PdfName.FONTFILE) != null || pdfDictionary2.get(PdfName.FONTFILE2) != null || pdfDictionary2.get(PdfName.FONTFILE3) != null)) {
                    PdfName pdfName = new PdfName(string2);
                    pdfDictionary.put(PdfName.BASEFONT, pdfName);
                    pdfDictionary2.put(PdfName.FONTNAME, pdfName);
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }

    private static void processNamedNode(PdfDictionary pdfDictionary, HashMap hashMap) {
        block6: {
            PdfArray pdfArray;
            block5: {
                pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES));
                if (pdfArray == null) break block5;
                ArrayList arrayList = pdfArray.getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    PdfObject pdfObject;
                    PdfString pdfString = (PdfString)PdfReader.getPdfObject((PdfObject)arrayList.get(n++));
                    PdfObject pdfObject2 = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                    if (pdfObject2.type() == 5) {
                        hashMap.put(pdfString.toString(), pdfObject2);
                    } else if (pdfObject2.type() == 6 && (pdfObject = PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.D))) != null && pdfObject.type() == 5) {
                        hashMap.put(pdfString.toString(), pdfObject);
                    }
                    ++n;
                }
                break block6;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block6;
            ArrayList arrayList = pdfArray.getArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                PdfReader.processNamedNode(pdfDictionary2, hashMap);
                ++n;
            }
        }
    }

    public void consolidateNamedDestinations() {
        Object object;
        PdfObject pdfObject;
        Object object2;
        Object object3;
        Object object4;
        PdfDictionary pdfDictionary;
        if (this.consolidateNamedDestinations) {
            return;
        }
        this.consolidateNamedDestinations = true;
        HashMap<Object, PdfObject> hashMap = new HashMap<Object, PdfObject>();
        if (this.catalog.get(PdfName.DESTS) != null) {
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.DESTS));
            object4 = pdfDictionary.getKeys();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                PdfName pdfName = (PdfName)object3.next();
                object2 = PdfName.decodeName(pdfName.toString());
                pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
                if (pdfObject.type() == 5) {
                    hashMap.put(object2, pdfObject);
                    continue;
                }
                if (pdfObject.type() != 6 || (object = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.D))) == null || ((PdfObject)object).type() != 5) continue;
                hashMap.put(object2, (PdfObject)object);
            }
        }
        if (this.catalog.get(PdfName.NAMES) != null) {
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.NAMES));
            if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DESTS))) != null) {
                PdfReader.processNamedNode(pdfDictionary, hashMap);
            }
        }
        if (hashMap.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.pages.length) {
            object4 = (PdfArray)PdfReader.getPdfObject(this.pages[n].get(PdfName.ANNOTS));
            if (object4 != null) {
                object3 = ((PdfArray)object4).getArrayList();
                int n2 = 0;
                while (n2 < ((ArrayList)object3).size()) {
                    object2 = PdfReader.getPdfObject((PdfObject)((ArrayList)object3).get(n2));
                    if (object2 != null && ((PdfObject)object2).type() == 6) {
                        PdfObject pdfObject2;
                        pdfObject = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.DEST));
                        object = null;
                        if (pdfObject != null) {
                            if (pdfObject.type() == 4) {
                                object = PdfName.decodeName(pdfObject.toString());
                            } else if (pdfObject.type() == 3) {
                                object = pdfObject.toString();
                            }
                            pdfObject2 = (PdfArray)hashMap.get(object);
                            if (pdfObject2 != null) {
                                ((PdfDictionary)object2).put(PdfName.DEST, pdfObject2);
                            }
                        } else {
                            PdfName pdfName;
                            pdfObject = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.A));
                            if (pdfObject != null && PdfName.GOTO.equals(pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)(pdfObject2 = (PdfDictionary)pdfObject)).get(PdfName.S)))) {
                                pdfObject = PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.D));
                                if (pdfObject.type() == 4) {
                                    object = PdfName.decodeName(pdfObject.toString());
                                } else if (pdfObject.type() == 3) {
                                    object = pdfObject.toString();
                                }
                                PdfArray pdfArray = (PdfArray)hashMap.get(object);
                                if (pdfArray != null) {
                                    ((PdfDictionary)pdfObject2).put(PdfName.D, pdfArray);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected static PdfDictionary duplicatePdfDictionary(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, PdfReader pdfReader) {
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            pdfDictionary2.put(pdfName, PdfReader.duplicatePdfObject(pdfDictionary.get(pdfName), pdfReader));
        }
        return pdfDictionary2;
    }

    protected static PdfObject duplicatePdfObject(PdfObject pdfObject, PdfReader pdfReader) {
        if (pdfObject == null) {
            return null;
        }
        switch (pdfObject.type()) {
            case 6: {
                return PdfReader.duplicatePdfDictionary((PdfDictionary)pdfObject, null, pdfReader);
            }
            case 7: {
                PRStream pRStream = (PRStream)pdfObject;
                PRStream pRStream2 = new PRStream(pRStream, null, pdfReader);
                PdfReader.duplicatePdfDictionary(pRStream, pRStream2, pdfReader);
                return pRStream2;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                PdfArray pdfArray = new PdfArray();
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    pdfArray.add(PdfReader.duplicatePdfObject((PdfObject)iterator.next(), pdfReader));
                }
                return pdfArray;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                return new PRIndirectReference(pdfReader, pRIndirectReference.getNumber(), pRIndirectReference.getGeneration());
            }
        }
        return pdfObject;
    }

    protected void removeUnusedNode(PdfObject pdfObject, boolean[] blArray) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName = (PdfName)iterator.next();
                    this.removeUnusedNode(pdfDictionary.get(pdfName), blArray);
                }
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                PdfArray pdfArray = new PdfArray();
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    this.removeUnusedNode((PdfObject)iterator.next(), blArray);
                }
                break;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                int n = pRIndirectReference.getNumber();
                if (blArray[n]) break;
                blArray[n] = true;
                this.removeUnusedNode(PdfReader.getPdfObject(pRIndirectReference), blArray);
            }
        }
    }

    public int removeUnusedObjects() {
        boolean[] blArray = new boolean[this.xrefObj.length];
        this.removeUnusedNode(this.trailer, blArray);
        int n = 0;
        int n2 = 1;
        while (n2 < blArray.length) {
            if (!blArray[n2] && this.xrefObj[n2] != null) {
                this.xrefObj[n2] = null;
                ++n;
            }
            ++n2;
        }
        return n;
    }
}

