/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import patterns.ColorMap;
import patterns.Pattern;
import patterns.Pigment3D;
import patterns.PigmentMap;

public class PatternPigment3D
implements Pigment3D {
    private Pattern pattern;
    private ColorMap colorMap;
    private PigmentMap pigmentMap;
    private Point3f point = new Point3f();
    private Matrix4f m4Transform = new Matrix4f();

    public PatternPigment3D(Matrix4f transform, Pattern pattern, ColorMap colorMap) {
        if (pattern == null || colorMap == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.colorMap = colorMap;
        this.m4Transform.set(transform);
    }

    public PatternPigment3D(Matrix4f transform, Pattern pattern, PigmentMap pigmentMap) {
        if (pattern == null || pigmentMap == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.pigmentMap = pigmentMap;
        this.m4Transform.set(transform);
    }

    public void transform(Matrix4f matrix) {
        this.m4Transform.mul(matrix);
    }

    public Color3f colorAt(float x, float y, float z) {
        this.point.set(x, y, z);
        this.m4Transform.transform(this.point);
        if (this.colorMap != null) {
            return this.colorMap.colorAt(this.pattern.valueAt(this.point.x, this.point.y, this.point.z));
        }
        return this.pigmentMap.colorAt(this.pattern.valueAt(this.point.x, this.point.y, this.point.z), x, y, z);
    }
}

