/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import patterns.AbstractPattern;
import patterns.Perturberation;
import patterns.Sine;
import patterns.Slope;

public class Marble
extends AbstractPattern {
    private final Perturberation perturberation;
    private final Slope slope;

    public Marble() {
        this.perturberation = null;
        this.slope = new Sine();
    }

    public Marble(Slope slope) {
        if (slope == null) {
            throw new NullPointerException();
        }
        this.slope = slope;
        this.perturberation = null;
    }

    public Marble(Perturberation perturberation) {
        this.perturberation = perturberation;
        this.slope = new Sine();
    }

    public Marble(Slope slope, Perturberation perturberation) {
        if (slope == null) {
            throw new NullPointerException();
        }
        this.slope = slope;
        this.perturberation = perturberation;
    }

    public float valueAt(float x, float y, float z) {
        if (this.perturberation != null) {
            x += this.perturberation.valueAt(x, y, z);
        }
        return this.slope.valueAt(x - (float)Math.floor(x));
    }
}

