/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;

public class GraphicsState {
    private List listTransforms = new ArrayList();
    private Matrix4f m4CurrentTransform = new Matrix4f();

    public GraphicsState() {
        this.m4CurrentTransform.setIdentity();
    }

    public void transformBegin() {
        this.listTransforms.add(this.m4CurrentTransform);
        this.m4CurrentTransform = new Matrix4f();
        this.m4CurrentTransform.setIdentity();
    }

    public void transformEnd() {
        this.m4CurrentTransform = (Matrix4f)this.listTransforms.get(this.listTransforms.size() - 1);
        this.listTransforms.remove(this.listTransforms.size() - 1);
    }

    public void translate(float x, float y, float z) {
        Matrix4f matrix = new Matrix4f(1.0f, 0.0f, 0.0f, x, 0.0f, 1.0f, 0.0f, y, 0.0f, 0.0f, 1.0f, z, 0.0f, 0.0f, 0.0f, 1.0f);
        this.m4CurrentTransform.mul(matrix);
    }

    public void scale(float s) {
        this.scale(s, s, s);
    }

    public void scale(float x, float y, float z) {
        Matrix4f matrix = new Matrix4f(1.0f / x, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.m4CurrentTransform.mul(matrix);
    }

    public void rotate(float x, float y, float z) {
        Matrix4f matrix = new Matrix4f();
        matrix.rotX(x / 180.0f * (float)Math.PI);
        this.m4CurrentTransform.mul(matrix);
        matrix.rotY(y / 180.0f * (float)Math.PI);
        this.m4CurrentTransform.mul(matrix);
        matrix.rotZ(z / 180.0f * (float)Math.PI);
        this.m4CurrentTransform.mul(matrix);
    }

    public void transform(Matrix4f matrix) {
        this.m4CurrentTransform.mul(matrix);
    }

    public Matrix4f getMatrix() {
        return new Matrix4f(this.m4CurrentTransform);
    }
}

