/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import javax.vecmath.Color3f;
import patterns.ObjectMap;

public class ColorMap
extends ObjectMap {
    public static ColorMap createBlackToWhiteColorMap() {
        ColorMap cm = new ColorMap();
        cm.addEntry(0.0f, new Color3f(0.0f, 0.0f, 0.0f));
        cm.addEntry(1.0f, new Color3f(1.0f, 1.0f, 1.0f));
        return cm;
    }

    public void addEntry(float position, Color3f color) {
        super.addEntry(position, color);
    }

    public Color3f colorAt(float position) {
        if (this.iState != 2) {
            throw new IllegalStateException("This colormap is not complete");
        }
        if (position <= 0.0f) {
            return (Color3f)this.map[0].object;
        }
        if (position >= 1.0f) {
            return (Color3f)this.map[this.map.length - 1].object;
        }
        int i = this.lowIndex(position);
        float a = this.map[i].position;
        float b = this.map[i + 1].position;
        float s = (position - a) / (b - a);
        Color3f ca = (Color3f)this.map[i].object;
        Color3f cb = (Color3f)this.map[i + 1].object;
        return new Color3f(ca.x + s * (cb.x - ca.x), ca.y + s * (cb.y - ca.y), ca.z + s * (cb.z - ca.z));
    }
}

