/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import javax.vecmath.Color3f;
import patterns.Pigment3D;

public class AveragePigment3D
implements Pigment3D {
    private float[] aFactor = new float[0];
    private Pigment3D[] aPigment = new Pigment3D[0];

    public void addPigment(float factor, Pigment3D pigment) {
        int l = this.aFactor.length;
        float[] newFactor = new float[l + 1];
        Pigment3D[] newPigment = new Pigment3D[l + 1];
        System.arraycopy(this.aFactor, 0, newFactor, 0, l);
        System.arraycopy(this.aPigment, 0, newPigment, 0, l);
        newFactor[l] = factor;
        newPigment[l] = pigment;
        this.aFactor = newFactor;
        this.aPigment = newPigment;
    }

    public void normalize() {
        float sum = 0.0f;
        int i = 0;
        while (i < this.aFactor.length) {
            sum += this.aFactor[i++];
        }
        i = 0;
        while (i < this.aFactor.length) {
            int n = i++;
            this.aFactor[n] = this.aFactor[n] / sum;
        }
    }

    public Color3f colorAt(float x, float y, float z) {
        Color3f color = new Color3f();
        int i = 0;
        while (i < this.aFactor.length) {
            Color3f c = this.aPigment[i].colorAt(x, y, z);
            color.x += c.x * this.aFactor[i];
            color.y += c.y * this.aFactor[i];
            color.z += c.z * this.aFactor[i];
            ++i;
        }
        return color;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.aFactor.length) {
            sb.append(String.valueOf(this.aFactor[i]) + "\t" + this.aPigment[i] + "\n");
            ++i;
        }
        return sb.toString();
    }
}

