/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import jpatch.auxilary.XMLutils;
import jpatch.boundary.JPatchTreeLeaf;
import jpatch.boundary.MainFrame;
import jpatch.entity.ControlPoint;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Morph
extends JPatchTreeLeaf {
    private ArrayList listPoints;
    private ArrayList listVectors;
    private float fValue;
    private float fMin;
    private float fMax;
    private Map mapPositions;
    private boolean bPrepared;

    public void setMin(float f) {
        this.fMin = f;
    }

    public void setMax(float f) {
        this.fMax = f;
    }

    public float getMin() {
        return this.fMin;
    }

    public float getMax() {
        return this.fMax;
    }

    public float getValue() {
        return this.fValue;
    }

    public void setValue(float f) {
        this.fValue = f;
    }

    public int getSliderValue() {
        return (int)((this.fValue - this.fMin) / (this.fMax - this.fMin) * 100.0f);
    }

    public void setSliderValue(int n) {
        this.fValue = this.fMin + (this.fMax - this.fMin) / 100.0f * (float)n;
    }

    public List getPointList() {
        return new ArrayList(this.listPoints);
    }

    public List getVectorList() {
        return new ArrayList(this.listVectors);
    }

    public void setPointList(List list) {
        this.listPoints.clear();
        this.listPoints.addAll(list);
    }

    public void setVectorList(List list) {
        this.listVectors.clear();
        this.listVectors.addAll(list);
    }

    public void apply() {
        Vector3f vector3f = new Vector3f();
        int n = 0;
        int n2 = this.listPoints.size();
        while (n < n2) {
            ControlPoint controlPoint = (ControlPoint)this.listPoints.get(n);
            vector3f.set((Vector3f)this.listVectors.get(n));
            vector3f.scale(this.fValue);
            controlPoint.getPosition().add(vector3f);
            controlPoint.invalidateTangents();
            ++n;
        }
    }

    public void unapply() {
        this.fValue = -this.fValue;
        this.apply();
        this.fValue = -this.fValue;
    }

    public void add(ControlPoint controlPoint, Vector3f vector3f) {
        this.listPoints.add(controlPoint);
        this.listVectors.add(vector3f);
    }

    public Vector3f removePoint(ControlPoint controlPoint) {
        int n = this.listPoints.indexOf(controlPoint);
        if (n != -1) {
            Vector3f vector3f = (Vector3f)this.listVectors.get(n);
            this.listPoints.remove(n);
            this.listVectors.remove(n);
            return vector3f;
        }
        return null;
    }

    public boolean replacePoint(ControlPoint controlPoint, ControlPoint controlPoint2) {
        int n = this.listPoints.indexOf(controlPoint);
        if (n != -1) {
            this.listPoints.set(n, controlPoint2);
            return true;
        }
        return false;
    }

    public void prepare() {
        Iterator iterator = MainFrame.getInstance().getModel().allHeads().iterator();
        while (iterator.hasNext()) {
            ControlPoint controlPoint = (ControlPoint)iterator.next();
            this.mapPositions.put(controlPoint, new Point3f(controlPoint.getPosition()));
        }
        this.bPrepared = true;
    }

    public void set() {
        if (!this.bPrepared) {
            throw new IllegalStateException("attempted to set unprepared morph");
        }
        Vector3f vector3f = new Vector3f();
        this.listPoints.clear();
        this.listVectors.clear();
        Iterator iterator = MainFrame.getInstance().getModel().allHeads().iterator();
        while (iterator.hasNext()) {
            ControlPoint controlPoint = (ControlPoint)iterator.next();
            vector3f.set(controlPoint.getPosition());
            vector3f.sub((Tuple3f)this.mapPositions.get(controlPoint));
            if (vector3f.x == 0.0f && vector3f.y == 0.0f && vector3f.z == 0.0f) continue;
            this.listPoints.add(controlPoint);
            this.listVectors.add(new Vector3f(vector3f));
        }
        this.fValue = 1.0f;
        this.mapPositions.clear();
        this.bPrepared = false;
    }

    public void dump() {
        System.out.println(this.strName);
        int n = 0;
        int n2 = this.listPoints.size();
        while (n < n2) {
            ControlPoint controlPoint = (ControlPoint)this.listPoints.get(n);
            Vector3f vector3f = (Vector3f)this.listVectors.get(n);
            System.out.println("\tcp " + controlPoint + '\t' + vector3f);
            ++n;
        }
    }

    public StringBuffer xml(int n) {
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.indent(n + 1);
        StringBuffer stringBuffer3 = XMLutils.indent(n + 2);
        StringBuffer stringBuffer4 = XMLutils.lineBreak();
        StringBuffer stringBuffer5 = new StringBuffer();
        stringBuffer5.append(stringBuffer).append("<morph name=\"").append(this.strName).append("\" ");
        stringBuffer5.append("min=\"").append(this.fMin).append("\" ");
        stringBuffer5.append("max=\"").append(this.fMax).append("\" ");
        stringBuffer5.append("value=\"").append(this.fValue).append("\">");
        stringBuffer5.append(stringBuffer4);
        stringBuffer5.append(stringBuffer2).append("<target value=\"1.0\">");
        stringBuffer5.append(stringBuffer4);
        int n2 = 0;
        int n3 = this.listPoints.size();
        while (n2 < n3) {
            ControlPoint controlPoint = (ControlPoint)this.listPoints.get(n2);
            Vector3f vector3f = (Vector3f)this.listVectors.get(n2);
            stringBuffer5.append(stringBuffer3);
            stringBuffer5.append("<point nr=\"").append(controlPoint.getXmlNumber()).append("\" ");
            stringBuffer5.append("x=\"").append(vector3f.x).append("\" ");
            stringBuffer5.append("y=\"").append(vector3f.y).append("\" ");
            stringBuffer5.append("z=\"").append(vector3f.z).append("\"/>");
            stringBuffer5.append(stringBuffer4);
            ++n2;
        }
        stringBuffer5.append(stringBuffer2).append("</target>").append(stringBuffer4);
        stringBuffer5.append(stringBuffer).append("</morph>").append(stringBuffer4);
        return stringBuffer5;
    }

    private final /* synthetic */ void this() {
        this.listPoints = new ArrayList();
        this.listVectors = new ArrayList();
        this.fValue = 0.0f;
        this.fMin = 0.0f;
        this.fMax = 1.0f;
        this.mapPositions = new HashMap();
        this.bPrepared = false;
    }

    public Morph(int n, String string) {
        this.this();
        this.iNodeType = n;
        this.strName = string;
    }
}

