/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import jpatch.auxilary.XMLutils;
import jpatch.boundary.JPatchTreeNode;
import jpatch.boundary.Rotoscope;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.selection.Selection;
import jpatch.control.edit.AddPatchEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.RemovePatchFromModelEdit;
import jpatch.entity.Bone;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.Morph;
import jpatch.entity.Patch;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Model
extends JPatchTreeNode {
    private Curve firstCurve;
    private Patch firstPatch;
    private Curve lastCurve;
    private Patch lastPatch;
    private Bone firstBone;
    private JPatchTreeNode treenodeSelections;
    private JPatchTreeNode treenodeMaterials;
    private JPatchTreeNode treenodeExpressions;
    private JPatchTreeNode treenodeBones;
    private ArrayList lstCandidateFivePointPatch;
    private List lstMaterials;
    private List lstSelections;
    private List lstMorphs;
    private List lstBoneShapes;
    private HashMap mapPhonemes;
    private Rotoscope[] aRotoscope;

    public void setRotoscope(int n, Rotoscope rotoscope) {
        if (n >= 1 && n <= 6) {
            this.aRotoscope[n - 1] = rotoscope;
        }
    }

    public Rotoscope getRotoscope(int n) {
        if (n >= 1 && n <= 6) {
            return this.aRotoscope[n - 1];
        }
        return null;
    }

    public StringBuffer xml(int n) {
        Object object;
        Iterator iterator;
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.indent(n + 1);
        StringBuffer stringBuffer3 = XMLutils.lineBreak();
        StringBuffer stringBuffer4 = new StringBuffer();
        stringBuffer4.append(stringBuffer).append("<model>").append(stringBuffer3);
        stringBuffer4.append(stringBuffer2).append("<name>").append(this.strName).append("</name>").append(stringBuffer3);
        String[] stringArray = new String[]{"front", "rear", "top", "bottom", "left", "right"};
        int n2 = 0;
        while (n2 < 6) {
            if (this.aRotoscope[n2] != null) {
                stringBuffer4.append(this.aRotoscope[n2].xml(n + 1, stringArray[n2]));
            }
            ++n2;
        }
        n2 = 0;
        Object object2 = this.lstMaterials.iterator();
        while (object2.hasNext()) {
            iterator = (JPatchMaterial)object2.next();
            ((JPatchMaterial)((Object)iterator)).setXmlNumber(n2++);
            stringBuffer4.append(((JPatchMaterial)((Object)iterator)).xml(n + 1));
        }
        stringBuffer4.append(stringBuffer2).append("<mesh>").append(stringBuffer3);
        this.setCpMap();
        object2 = this.getFirstCurve();
        while (object2 != null) {
            stringBuffer4.append(((Curve)object2).xml(n + 2));
            object2 = ((Curve)object2).getNext();
        }
        object2 = this.getFirstPatch();
        while (object2 != null) {
            stringBuffer4.append(((Patch)object2).xml(n + 2));
            object2 = ((Patch)object2).getNext();
        }
        object2 = this.lstMorphs.iterator();
        while (object2.hasNext()) {
            iterator = (Morph)object2.next();
            stringBuffer4.append(((Morph)((Object)iterator)).xml(n + 2));
        }
        object2 = new StringBuffer();
        iterator = this.mapPhonemes.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Morph morph = (Morph)this.mapPhonemes.get(object);
            if (morph == null) continue;
            ((StringBuffer)object2).append(stringBuffer2).append("\t\t<map phoneme=\"" + (String)object + "\" morph=\"" + this.lstMorphs.indexOf(morph) + "\"/>").append(stringBuffer3);
        }
        if (((StringBuffer)object2).length() > 0) {
            stringBuffer4.append(stringBuffer2).append("\t<lipsync>").append(stringBuffer3);
            stringBuffer4.append((StringBuffer)object2);
            stringBuffer4.append(stringBuffer2).append("\t</lipsync>").append(stringBuffer3);
        }
        stringBuffer4.append(stringBuffer2).append("</mesh>").append(stringBuffer3);
        iterator = this.lstSelections.iterator();
        while (iterator.hasNext()) {
            object = (PointSelection)iterator.next();
            stringBuffer4.append(((PointSelection)object).xml(n + 1));
        }
        stringBuffer4.append(stringBuffer).append("</model>").append(stringBuffer3);
        return stringBuffer4;
    }

    public void setMorphFor(String string, Morph morph) {
        this.mapPhonemes.put(string, morph);
    }

    public Morph getMorphFor(String string) {
        return (Morph)this.mapPhonemes.get(string);
    }

    public Set getPhonemeMorphSet() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.mapPhonemes.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(this.mapPhonemes.get(iterator.next()));
        }
        return hashSet;
    }

    public boolean addMaterial(JPatchMaterial jPatchMaterial) {
        this.treenodeMaterials.add(jPatchMaterial);
        this.lstMaterials.add(jPatchMaterial);
        return true;
    }

    public boolean checkSelection(Selection selection) {
        return this.lstSelections.contains(selection) ^ true;
    }

    public void addSelection(Selection selection) {
        this.treenodeSelections.add(selection);
        this.lstSelections.add(selection);
    }

    public void getBounds(Point3f point3f, Point3f point3f2) {
        point3f.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        point3f2.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        Patch patch = this.firstPatch;
        while (patch != null) {
            ControlPoint[] controlPointArray = patch.getControlPoints();
            int n = 0;
            while (n < controlPointArray.length) {
                Point3f point3f3 = controlPointArray[n].getPosition();
                if (point3f3.x < point3f.x) {
                    point3f.x = point3f3.x;
                }
                if (point3f3.y < point3f.y) {
                    point3f.y = point3f3.y;
                }
                if (point3f3.z < point3f.z) {
                    point3f.z = point3f3.z;
                }
                if (point3f3.x > point3f2.x) {
                    point3f2.x = point3f3.x;
                }
                if (point3f3.y > point3f2.y) {
                    point3f2.y = point3f3.y;
                }
                if (point3f3.z > point3f2.z) {
                    point3f2.z = point3f3.z;
                }
                ++n;
            }
            patch = patch.getNext();
        }
    }

    public void addExpression(Morph morph) {
        this.treenodeExpressions.add(morph);
        this.lstMorphs.add(morph);
    }

    public void setReferenceGeometry() {
        this.unapplyMorphs();
        Curve curve = this.firstCurve;
        while (curve != null) {
            ControlPoint controlPoint = curve.getStart();
            while (controlPoint != null) {
                controlPoint.setReference();
                controlPoint = controlPoint.getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        this.applyMorphs();
    }

    public void unapplyMorphs() {
        Iterator iterator = this.lstMorphs.iterator();
        while (iterator.hasNext()) {
            ((Morph)iterator.next()).unapply();
        }
    }

    public void applyMorphs() {
        Iterator iterator = this.lstMorphs.iterator();
        while (iterator.hasNext()) {
            ((Morph)iterator.next()).apply();
        }
    }

    public Iterator getSelectionIterator() {
        return this.lstSelections.iterator();
    }

    public Iterator getMorphIterator() {
        return this.lstMorphs.iterator();
    }

    public List getMorphList() {
        return this.lstMorphs;
    }

    public List getBoneShapeList() {
        return this.lstBoneShapes;
    }

    public List getSelectionsContaining(ControlPoint controlPoint) {
        ArrayList<PointSelection> arrayList = new ArrayList<PointSelection>();
        Iterator iterator = this.lstSelections.iterator();
        while (iterator.hasNext()) {
            PointSelection pointSelection = (PointSelection)iterator.next();
            if (!pointSelection.contains(controlPoint)) continue;
            arrayList.add(pointSelection);
        }
        return arrayList;
    }

    public void removeSelection(Selection selection) {
        this.treenodeSelections.remove(selection);
        this.lstSelections.remove(selection);
    }

    public void removeMaterial(JPatchMaterial jPatchMaterial) {
        this.treenodeMaterials.remove(jPatchMaterial);
        this.lstMaterials.remove(jPatchMaterial);
    }

    public void removeExpression(Morph morph) {
        this.treenodeExpressions.remove(morph);
        this.lstMorphs.remove(morph);
    }

    public void addCandidateFivePointPatchList(ArrayList arrayList) {
        this.lstCandidateFivePointPatch.addAll(arrayList);
    }

    public JPatchMaterial getMaterial(int n) {
        return (JPatchMaterial)this.lstMaterials.get(n);
    }

    public List getMaterialList() {
        return this.lstMaterials;
    }

    public void setFirstCurve(Curve curve) {
        this.firstCurve = curve;
    }

    public void setLastCurve(Curve curve) {
        this.lastCurve = curve;
    }

    public Curve getFirstCurve() {
        return this.firstCurve;
    }

    public JPatchTreeNode getRootBone() {
        return this.treenodeBones;
    }

    public Bone getFirstBone() {
        return this.firstBone;
    }

    public void setFirstBone(Bone bone) {
        this.firstBone = bone;
    }

    public void addBone(Bone bone) {
        bone.insertBefore(this.firstBone);
        this.firstBone = bone;
    }

    public Patch getFirstPatch() {
        return this.firstPatch;
    }

    public Patch getLastPatch() {
        return this.lastPatch;
    }

    public void setFirstPatch(Patch patch) {
        this.firstPatch = patch;
    }

    public void setLastPatch(Patch patch) {
        this.lastPatch = patch;
    }

    public Curve getLastCurve() {
        return this.lastCurve;
    }

    public void addCurve(Curve curve) {
        if (this.lastCurve != null) {
            this.lastCurve.setNext(curve);
        }
        curve.setPrev(this.lastCurve);
        curve.setNext(null);
        this.lastCurve = curve;
        if (this.firstCurve == null) {
            this.firstCurve = curve;
        }
        curve.setModel(this);
    }

    public void addCurve(ControlPoint controlPoint) {
        Curve curve = new Curve(controlPoint, this);
        curve.validate();
        this.addCurve(curve);
    }

    public void addPatch(ControlPoint[] controlPointArray, JPatchCompoundEdit jPatchCompoundEdit) {
        boolean bl = false;
        Patch patch = this.firstPatch;
        while (patch != null) {
            if (patch.isEqual(controlPointArray)) {
                bl = true;
                patch.setValid(true);
                break;
            }
            patch = patch.getNext();
        }
        if (!bl) {
            this.addPatch(new Patch(controlPointArray), jPatchCompoundEdit);
        }
    }

    public void addPatch(Patch patch, JPatchCompoundEdit jPatchCompoundEdit) {
        if (jPatchCompoundEdit == null) {
            if (this.lastPatch != null) {
                this.lastPatch.setNext(patch);
            }
            patch.setPrev(this.lastPatch);
            patch.setNext(null);
            this.lastPatch = patch;
            if (this.firstPatch == null) {
                this.firstPatch = patch;
            }
            patch.setModel(this);
        } else {
            jPatchCompoundEdit.addEdit(new AddPatchEdit(patch));
        }
    }

    public void removePatch(Patch patch, JPatchCompoundEdit jPatchCompoundEdit) {
        if (jPatchCompoundEdit == null) {
            patch.remove();
        } else {
            jPatchCompoundEdit.addEdit(new RemovePatchFromModelEdit(patch));
        }
    }

    public void removeMorph(Morph morph) {
        this.lstMorphs.remove(morph);
    }

    public ArrayList getPatchesContaining(ControlPoint controlPoint) {
        ArrayList<Patch> arrayList = new ArrayList<Patch>();
        Patch patch = this.firstPatch;
        while (patch != null) {
            if (patch.contains(controlPoint)) {
                arrayList.add(patch);
            }
            patch = patch.getNext();
        }
        return arrayList;
    }

    public void clearPatches() {
        Patch patch = this.firstPatch;
        while (patch != null) {
            patch.setValid(false);
            patch = patch.getNext();
        }
    }

    public ArrayList allHeads() {
        ArrayList<ControlPoint> arrayList = new ArrayList<ControlPoint>();
        boolean bl = false;
        Curve curve = this.getFirstCurve();
        while (curve != null) {
            ControlPoint controlPoint = curve.getStart();
            while (controlPoint != null) {
                if (controlPoint.isHead() && !controlPoint.isChildHook()) {
                    arrayList.add(controlPoint);
                }
                controlPoint = controlPoint.getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        return arrayList;
    }

    public int numberOfCurves() {
        int n = 0;
        Curve curve = this.getFirstCurve();
        while (curve != null) {
            if (!curve.getStart().isHook()) {
                ++n;
            }
            curve = curve.getNext();
        }
        return n;
    }

    public int numberOfPatches() {
        int n = 0;
        Patch patch = this.getFirstPatch();
        while (patch != null) {
            ++n;
            patch = patch.getNext();
        }
        return n;
    }

    public ArrayList getCandidateFivePointPatchList() {
        return this.lstCandidateFivePointPatch;
    }

    public void computePatches() {
        this.computePatches(null);
    }

    public void computePatches(JPatchCompoundEdit jPatchCompoundEdit) {
        ControlPoint[] controlPointArray;
        int n;
        ControlPoint[] controlPointArray2;
        int n2;
        Object object;
        ControlPoint[] controlPointArray3;
        this.clearPatches();
        ArrayList arrayList = this.allHeads();
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        HashMap<ControlPoint, Integer> hashMap = new HashMap<ControlPoint, Integer>();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            ControlPoint controlPoint = (ControlPoint)arrayList.get(n3);
            arrayList2.add(controlPoint.allNeighbors());
            hashMap.put(controlPoint, new Integer(n3));
            ++n3;
        }
        n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        int n6 = 0;
        while (n6 < this.lstCandidateFivePointPatch.size()) {
            ArrayList arrayList4;
            int n7;
            controlPointArray3 = new ControlPoint[10];
            object = (ControlPoint[])this.lstCandidateFivePointPatch.get(n6);
            n2 = 0;
            controlPointArray2 = (ControlPoint[])hashMap.get(this.trueHead(object[0]));
            if (controlPointArray2 != null) {
                n7 = controlPointArray2.intValue();
                arrayList4 = (ArrayList)arrayList2.get(n7);
                n = 0;
                while (n < arrayList4.size()) {
                    controlPointArray = (ControlPoint[])arrayList4.get(n);
                    if (controlPointArray[0] == this.trueHead((ControlPoint)object[1])) {
                        n2 = 1;
                        controlPointArray3[0] = controlPointArray[1];
                        controlPointArray3[1] = controlPointArray[2];
                    }
                    ++n;
                }
            }
            if (n2 != 0) {
                n2 = 0;
                n7 = (Integer)hashMap.get(this.trueHead((ControlPoint)object[1]));
                arrayList4 = (ArrayList)arrayList2.get(n7);
                n = 0;
                while (n < arrayList4.size()) {
                    controlPointArray = (ControlPoint[])arrayList4.get(n);
                    if (controlPointArray[0] == this.trueHead((ControlPoint)object[2])) {
                        n2 = 1;
                        controlPointArray3[2] = controlPointArray[1];
                        controlPointArray3[3] = controlPointArray[2];
                    }
                    ++n;
                }
            }
            if (n2 != 0) {
                n2 = 0;
                n7 = (Integer)hashMap.get(this.trueHead((ControlPoint)object[2]));
                arrayList4 = (ArrayList)arrayList2.get(n7);
                n = 0;
                while (n < arrayList4.size()) {
                    controlPointArray = (ControlPoint[])arrayList4.get(n);
                    if (controlPointArray[0] == this.trueHead((ControlPoint)object[3])) {
                        n2 = 1;
                        controlPointArray3[4] = controlPointArray[1];
                        controlPointArray3[5] = controlPointArray[2];
                    }
                    ++n;
                }
            }
            if (n2 != 0) {
                n2 = 0;
                n7 = (Integer)hashMap.get(this.trueHead((ControlPoint)object[3]));
                arrayList4 = (ArrayList)arrayList2.get(n7);
                n = 0;
                while (n < arrayList4.size()) {
                    controlPointArray = (ControlPoint[])arrayList4.get(n);
                    if (controlPointArray[0] == this.trueHead((ControlPoint)object[4])) {
                        n2 = 1;
                        controlPointArray3[6] = controlPointArray[1];
                        controlPointArray3[7] = controlPointArray[2];
                    }
                    ++n;
                }
            }
            if (n2 != 0) {
                n2 = 0;
                n7 = (Integer)hashMap.get(this.trueHead((ControlPoint)object[4]));
                arrayList4 = (ArrayList)arrayList2.get(n7);
                n = 0;
                while (n < arrayList4.size()) {
                    controlPointArray = (ControlPoint[])arrayList4.get(n);
                    if (controlPointArray[0] == this.trueHead((ControlPoint)object[0])) {
                        n2 = 1;
                        controlPointArray3[8] = controlPointArray[1];
                        controlPointArray3[9] = controlPointArray[2];
                    }
                    ++n;
                }
            }
            if (n2 != 0 && controlPointArray3[0].trueCp() != controlPointArray3[9].trueCp() && controlPointArray3[1].trueCp() != controlPointArray3[2].trueCp() && controlPointArray3[3].trueCp() != controlPointArray3[4].trueCp() && controlPointArray3[5].trueCp() != controlPointArray3[6].trueCp() && controlPointArray3[7].trueCp() != controlPointArray3[8].trueCp()) {
                this.addPatch(controlPointArray3, jPatchCompoundEdit);
                ++n5;
            } else {
                arrayList3.add(object);
            }
            ++n6;
        }
        this.lstCandidateFivePointPatch.removeAll(arrayList3);
        n6 = 0;
        while (n6 < arrayList.size()) {
            controlPointArray3 = (ControlPoint)arrayList.get(n6);
            object = (ArrayList)arrayList2.get(n6);
            n2 = 0;
            while (n2 < ((ArrayList)object).size() - 1) {
                controlPointArray2 = (ControlPoint[])((ArrayList)object).get(n2);
                ControlPoint controlPoint = controlPointArray2[0];
                int n8 = (Integer)hashMap.get(controlPoint);
                if (n8 > n6) {
                    n = n2 + 1;
                    while (n < ((ArrayList)object).size()) {
                        controlPointArray = (ControlPoint[])((ArrayList)object).get(n);
                        ControlPoint controlPoint2 = controlPointArray[0];
                        int n9 = (Integer)hashMap.get(controlPoint2);
                        if (n9 > n6) {
                            Object object2;
                            ControlPoint[] controlPointArray4;
                            ArrayList arrayList5 = (ArrayList)arrayList2.get(n8);
                            ArrayList arrayList6 = (ArrayList)arrayList2.get(n9);
                            int n10 = 0;
                            while (n10 < arrayList5.size()) {
                                ControlPoint[] controlPointArray5 = (ControlPoint[])arrayList5.get(n10);
                                controlPointArray4 = controlPointArray5[0];
                                if (controlPointArray4 == controlPoint2 && controlPointArray2[1].trueCp() != controlPointArray[1].trueCp() && controlPointArray5[1].trueCp() != controlPointArray2[2].trueCp() && controlPointArray[2].trueCp() != controlPointArray5[2].trueCp()) {
                                    object2 = new ControlPoint[]{controlPointArray2[1], controlPointArray2[2], controlPointArray5[1], controlPointArray5[2], controlPointArray[2], controlPointArray[1]};
                                    this.addPatch((ControlPoint[])object2, jPatchCompoundEdit);
                                    ++n3;
                                }
                                ++n10;
                            }
                            n10 = 1;
                            int n11 = 0;
                            while (n11 < arrayList5.size()) {
                                controlPointArray4 = (ControlPoint[])arrayList5.get(n11);
                                object2 = controlPointArray4[0];
                                if (object2 == controlPoint2) {
                                    n10 = 0;
                                }
                                ++n11;
                            }
                            n11 = 0;
                            while (n11 < arrayList6.size()) {
                                controlPointArray4 = (ControlPoint[])arrayList6.get(n11);
                                object2 = controlPointArray4[0];
                                if (object2 == controlPoint) {
                                    n10 = 0;
                                }
                                ++n11;
                            }
                            n11 = 0;
                            while (n11 < arrayList5.size()) {
                                controlPointArray4 = (ControlPoint[])arrayList5.get(n11);
                                object2 = controlPointArray4[0];
                                int n12 = (Integer)hashMap.get(object2);
                                if (n12 != n6) {
                                    int n13 = 0;
                                    while (n13 < arrayList6.size()) {
                                        ControlPoint[] controlPointArray6 = (ControlPoint[])arrayList6.get(n13);
                                        ControlPoint controlPoint3 = controlPointArray6[0];
                                        if (controlPoint3 == object2) {
                                            int n14 = 0;
                                            while (n14 < ((ArrayList)object).size()) {
                                                ControlPoint[] controlPointArray7 = (ControlPoint[])((ArrayList)object).get(n14);
                                                ControlPoint controlPoint4 = controlPointArray7[0];
                                                if (object2 == controlPoint4) {
                                                    n10 = 0;
                                                }
                                                ++n14;
                                            }
                                            if (n10 != 0 && controlPointArray2[1].trueCp() != controlPointArray[1].trueCp() && controlPointArray4[1].trueCp() != controlPointArray2[2].trueCp() && controlPointArray6[2].trueCp() != controlPointArray4[2].trueCp() && controlPointArray6[1].trueCp() != controlPointArray[2].trueCp()) {
                                                ControlPoint[] controlPointArray8 = new ControlPoint[]{controlPointArray2[1], controlPointArray2[2], controlPointArray4[1], controlPointArray4[2], controlPointArray6[2], controlPointArray6[1], controlPointArray[2], controlPointArray[1]};
                                                this.addPatch(controlPointArray8, jPatchCompoundEdit);
                                                ++n4;
                                            }
                                        }
                                        ++n13;
                                    }
                                }
                                ++n11;
                            }
                        }
                        ++n;
                    }
                }
                ++n2;
            }
            ++n6;
        }
        Patch patch = this.firstPatch;
        while (patch != null) {
            if (!patch.isValid()) {
                this.removePatch(patch, jPatchCompoundEdit);
            }
            patch = patch.getNext();
        }
    }

    public void dump() {
        Object object;
        System.out.println("------------- curves -------------");
        System.out.println("\tcp\tnext\tprev\tloop\tna\tpa\tphook\tchook\thpos\n");
        Curve curve = this.getFirstCurve();
        while (curve != null) {
            System.out.println("Curve: " + curve.hashCode() + " closed: " + curve.isClosed());
            object = curve.getStart();
            while (object != null) {
                System.out.println("\t" + object + '\t' + ((ControlPoint)object).getNext() + '\t' + ((ControlPoint)object).getPrev() + '\t' + ((ControlPoint)object).getLoop() + '\t' + ((ControlPoint)object).getNextAttached() + '\t' + ((ControlPoint)object).getPrevAttached() + '\t' + ((ControlPoint)object).getParentHook() + '\t' + ((ControlPoint)object).getChildHook() + '\t' + ((ControlPoint)object).getHookPos());
                object = ((ControlPoint)object).getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        System.out.println("\n\n------------- patches -------------");
        object = this.firstPatch;
        while (object != null) {
            System.out.println(object);
            object = ((Patch)object).getNext();
        }
        System.out.println("\n\n----------- morphs -------------");
        object = this.lstMorphs.iterator();
        while (object.hasNext()) {
            ((Morph)object.next()).dump();
        }
        System.out.println("\n\n----------- end -------------");
    }

    private final void setCpMap() {
        HashMap<ControlPoint, Integer> hashMap = new HashMap<ControlPoint, Integer>();
        int n = 0;
        Curve curve = this.getFirstCurve();
        while (curve != null) {
            ControlPoint controlPoint = curve.getStart();
            while (controlPoint != null) {
                hashMap.put(controlPoint, new Integer(n++));
                controlPoint = controlPoint.getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        ControlPoint.setMap(hashMap);
    }

    private final ControlPoint trueHead(ControlPoint controlPoint) {
        return controlPoint.getParentHook() == null ? controlPoint.getHead() : controlPoint.getParentHook().getHead();
    }

    private final /* synthetic */ void this() {
        this.lstCandidateFivePointPatch = new ArrayList();
        this.lstMaterials = new ArrayList();
        this.lstSelections = new ArrayList();
        this.lstMorphs = new ArrayList();
        this.lstBoneShapes = new ArrayList();
        this.mapPhonemes = new HashMap();
        this.aRotoscope = new Rotoscope[6];
    }

    public Model() {
        this.this();
        this.iNodeType = 1;
        this.strName = "New Model";
        this.treenodeSelections = new JPatchTreeNode(12, this, "Selections");
        this.treenodeMaterials = new JPatchTreeNode(2, this, "Materials");
        this.treenodeExpressions = new JPatchTreeNode(3, this, "Expressions");
        this.treenodeBones = new JPatchTreeNode(4, this, "Bones");
        JPatchMaterial jPatchMaterial = new JPatchMaterial(new Color3f(1.0f, 1.0f, 1.0f));
        jPatchMaterial.setName("Default Material");
        this.addMaterial(jPatchMaterial);
    }
}

