/*
 * Decompiled with CFR 0.152.
 */
package jpatch.control.edit;

import jpatch.control.edit.ChangeCPChildHookEdit;
import jpatch.control.edit.ChangeCPCurveEdit;
import jpatch.control.edit.DeleteControlPointEdit;
import jpatch.control.edit.DetachControlPointEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.RemoveControlPointFromCurveEdit;
import jpatch.control.edit.RemoveControlPointFromSelectionsEdit;
import jpatch.control.edit.RemoveCurveFromModelEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;

public class RemoveCurveEdit
extends JPatchCompoundEdit {
    public RemoveCurveEdit(Curve curve) {
        super("REMOVE CURVE");
        this.addEdit(new RemoveCurveFromModelEdit(curve));
        ControlPoint[] controlPointArray = curve.getControlPointArray();
        if (controlPointArray != null) {
            int n = 0;
            while (n < controlPointArray.length) {
                if (controlPointArray[n].getNextAttached() != null && controlPointArray[n].getNextAttached().isHook()) {
                    Curve curve2 = controlPointArray[n].getNextAttached().getCurve();
                    this.addEdit(new RemoveControlPointFromSelectionsEdit(controlPointArray[n].getNextAttached()));
                    this.addEdit(new RemoveControlPointFromCurveEdit(controlPointArray[n].getNextAttached()));
                    if (curve2.getLength() == 2) {
                        this.addEdit(new ChangeCPChildHookEdit(curve2.getStart().getParentHook(), null));
                        this.addEdit(new RemoveControlPointFromSelectionsEdit(curve2.getStart()));
                        this.addEdit(new RemoveControlPointFromSelectionsEdit(curve2.getStart().getEnd()));
                        this.addEdit(new RemoveCurveFromModelEdit(curve2));
                    }
                }
                this.addEdit(new DetachControlPointEdit(controlPointArray[n]));
                this.addEdit(new ChangeCPCurveEdit(controlPointArray[n], null));
                if (controlPointArray[n].getHookPos() > 0.0f && controlPointArray[n].getHookPos() < 1.0f && controlPointArray[n].getPrevAttached() != null) {
                    this.addEdit(new DeleteControlPointEdit(controlPointArray[n].getPrevAttached()));
                }
                this.addEdit(new RemoveControlPointFromSelectionsEdit(controlPointArray[n]));
                ++n;
            }
        }
    }
}

