/*
 * Decompiled with CFR 0.152.
 */
package jpatch.control.edit;

import jpatch.control.edit.JPatchAbstractUndoableEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;

public class RemoveControlPointFromCurveEdit
extends JPatchAbstractUndoableEdit {
    private ControlPoint cp;
    private ControlPoint cpNext;
    private ControlPoint cpPrev;
    private Curve curve;
    private boolean bStart;

    public void redo() {
        this.remove();
    }

    public void undo() {
        this.readdEdit();
    }

    private final void readdEdit() {
        this.cp.setCurve(this.curve);
        if (this.cpNext != null) {
            this.cpNext.setPrev(this.cp);
            if (this.cp.getLoop()) {
                this.cpNext.setLoop(false);
            }
        }
        if (this.cpPrev != null) {
            this.cpPrev.setNext(this.cp);
        }
        if (this.bStart) {
            this.curve.setStart(this.cp);
        }
        this.cp.setNext(this.cpNext);
        this.cp.setPrev(this.cpPrev);
    }

    private final void remove() {
        this.cp.setCurve(null);
        if (this.cpNext != null) {
            this.cpNext.setPrev(this.cpPrev);
            if (this.cp.getLoop()) {
                this.cpNext.setLoop(true);
            }
        }
        if (this.cpPrev != null) {
            this.cpPrev.setNext(this.cpNext);
        }
        if (this.bStart) {
            this.curve.setStart(this.cpNext);
        }
    }

    public RemoveControlPointFromCurveEdit(ControlPoint controlPoint) {
        this.cp = controlPoint;
        this.curve = controlPoint.getCurve();
        this.cpNext = controlPoint.getNext();
        this.cpPrev = controlPoint.getPrev();
        boolean bl = false;
        if (this.curve.getStart() == controlPoint) {
            bl = true;
        }
        this.bStart = bl;
        this.remove();
    }
}

