/*
 * Decompiled with CFR 0.152.
 */
package jpatch.control;

import java.io.File;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4f;
import jpatch.boundary.Animator;
import jpatch.boundary.JPatchSettings;
import jpatch.control.importer.JPatchImport;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.AnimObject;
import jpatch.entity.Camera;
import jpatch.entity.Model;
import jpatch.entity.Morph;
import jpatch.entity.MotionCurve2;
import jpatch.entity.MotionCurveSet;
import jpatch.entity.MotionKey2;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AnimationImporter
extends DefaultHandler {
    private static final int IDLE = 0;
    private static final int SEQUENCE = 1;
    private static final int MODEL = 2;
    private static final int FLOAT_CURVE = 3;
    private static final int POINT3D_CURVE = 4;
    private static final int COLOR3F_CURVE = 5;
    private static final int QUAT4F_CURVE = 6;
    private static final int CAMERA = 7;
    private static final int LIGHT = 8;
    private int iState;
    private int iPrevState;
    private StringBuffer sbChars;
    private AnimObject animObject;
    private String animModelFilename;
    private MotionCurve2 motionCurve;
    private MotionCurveSet motionCurveSet;
    private String strRendererFormat;
    private Animator animation;

    public void loadAnimation(String string) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.parse(new InputSource(string));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        switch (this.iState) {
            case 0: {
                if (!string2.equals("sequence")) break;
                this.iState = 1;
                break;
            }
            case 1: {
                if (string2.equals("name") || string2.equals("start") || string2.equals("end") || string2.equals("framerate") || string2.equals("prefix")) {
                    this.sbChars = new StringBuffer();
                    break;
                }
                if (string2.equals("model")) {
                    this.iState = 2;
                    this.animObject = new AnimModel();
                    break;
                }
                if (string2.equals("camera")) {
                    this.iState = 7;
                    this.animObject = this.animation.getActiveCamera();
                    this.motionCurveSet = new MotionCurveSet.Camera((Camera)this.animObject);
                    break;
                }
                if (string2.equals("lightsource")) {
                    this.iState = 8;
                    this.animObject = new AnimLight();
                    this.motionCurveSet = new MotionCurveSet.Light((AnimLight)this.animObject);
                    break;
                }
                if (!string2.equals("renderer")) break;
                this.parseRenderer(attributes);
                break;
            }
            case 2: {
                if (string2.equals("name") || string2.equals("filename") || string2.equals("subdivisionoffset")) {
                    this.sbChars = new StringBuffer();
                    break;
                }
                if (string2.equals("motioncurve")) {
                    this.iPrevState = 2;
                    this.prepareMotioncurve(attributes);
                    break;
                }
                if (!string2.equals("renderer")) break;
                this.parseRenderer(attributes);
                break;
            }
            case 7: {
                if (string2.equals("name")) {
                    this.sbChars = new StringBuffer();
                    break;
                }
                if (!string2.equals("motioncurve")) break;
                this.iPrevState = 7;
                this.prepareMotioncurve(attributes);
                break;
            }
            case 8: {
                if (string2.equals("name")) {
                    this.sbChars = new StringBuffer();
                    break;
                }
                if (string2.equals("motioncurve")) {
                    this.iPrevState = 8;
                    this.prepareMotioncurve(attributes);
                    break;
                }
                if (string2.equals("renderer")) {
                    this.parseRenderer(attributes);
                    break;
                }
                if (!string2.equals("inactive")) break;
                ((AnimLight)this.animObject).setActive(false);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (!string2.equals("key")) break;
                this.parseKey(attributes);
                break;
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        switch (this.iState) {
            case 1: {
                if (string2.equals("name")) {
                    this.animation.setName(this.sbChars.toString());
                    break;
                }
                if (string2.equals("start")) {
                    this.animation.setStart(Float.parseFloat(this.sbChars.toString()));
                    break;
                }
                if (string2.equals("end")) {
                    this.animation.setEnd(Float.parseFloat(this.sbChars.toString()));
                    break;
                }
                if (string2.equals("framerate")) {
                    this.animation.setFramerate(Float.parseFloat(this.sbChars.toString()));
                    break;
                }
                if (string2.equals("prefix")) {
                    this.animation.setPrefix(this.sbChars.toString());
                    break;
                }
                if (string2.equals("sequence")) {
                    this.iState = 0;
                    break;
                }
                if (!string2.equals("renderer")) break;
                this.animation.setRenderString(this.strRendererFormat, "", this.sbChars.toString());
                break;
            }
            case 2: {
                if (string2.equals("name")) {
                    this.animObject.setName(this.sbChars.toString());
                    break;
                }
                if (string2.equals("subdivisionoffset")) {
                    ((AnimModel)this.animObject).setSubdivisionOffset(Integer.parseInt(this.sbChars.toString()));
                    break;
                }
                if (string2.equals("filename")) {
                    this.animModelFilename = this.sbChars.toString();
                    Model model = new Model();
                    new JPatchImport().importModel(model, JPatchSettings.getInstance().strModelDir + File.separatorChar + this.animModelFilename);
                    ((AnimModel)this.animObject).setModel(model);
                    this.motionCurveSet = new MotionCurveSet.Model((AnimModel)this.animObject);
                    break;
                }
                if (string2.equals("model")) {
                    this.iState = 1;
                    this.motionCurveSet.populateList();
                    this.animation.addObject(this.animObject, this.animModelFilename, this.motionCurveSet);
                    this.animObject = null;
                    break;
                }
                if (!string2.equals("renderer")) break;
                ((AnimModel)this.animObject).setRenderString(this.strRendererFormat, "", this.sbChars.toString());
                break;
            }
            case 7: {
                if (string2.equals("name")) {
                    this.animObject.setName(this.sbChars.toString());
                    break;
                }
                if (!string2.equals("camera")) break;
                this.iState = 1;
                this.motionCurveSet.populateList();
                this.animation.setMotionCurveSetFor(this.animObject, this.motionCurveSet);
                this.animObject = null;
                break;
            }
            case 8: {
                if (string2.equals("name")) {
                    this.animObject.setName(this.sbChars.toString());
                    break;
                }
                if (string2.equals("lightsource")) {
                    this.iState = 1;
                    this.motionCurveSet.populateList();
                    this.animation.addObject(this.animObject, null, this.motionCurveSet);
                    this.animObject = null;
                    break;
                }
                if (!string2.equals("renderer")) break;
                ((AnimLight)this.animObject).setRenderString(this.strRendererFormat, "", this.sbChars.toString());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (!string2.equals("motioncurve")) break;
                this.iState = this.iPrevState;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.sbChars != null) {
            this.sbChars.append(cArray, n, n2);
        }
    }

    private final void prepareMotioncurve(Attributes attributes) {
        int n = 0;
        int n2 = 0;
        while (n2 < attributes.getLength()) {
            String string = attributes.getLocalName(n2);
            String string2 = attributes.getValue(n2);
            if (string.equals("type")) {
                if (string2.equals("morph")) {
                    n = 1;
                } else if (string2.equals("position")) {
                    this.motionCurve = MotionCurve2.createPositionCurve();
                    this.motionCurveSet.position = (MotionCurve2.Point3d)this.motionCurve;
                    this.iState = 4;
                } else if (string2.equals("orientation")) {
                    n = 2;
                } else if (string2.equals("scale")) {
                    n = 3;
                } else if (string2.equals("focallength")) {
                    this.motionCurve = MotionCurve2.createFocalLengthCurve();
                    ((MotionCurveSet.Camera)this.motionCurveSet).focalLength = (MotionCurve2.Float)this.motionCurve;
                    this.iState = 3;
                } else if (string2.equals("size")) {
                    this.motionCurve = MotionCurve2.createSizeCurve();
                    ((MotionCurveSet.Light)this.motionCurveSet).size = (MotionCurve2.Float)this.motionCurve;
                    this.iState = 3;
                } else if (string2.equals("intensity")) {
                    this.motionCurve = MotionCurve2.createIntensityCurve();
                    ((MotionCurveSet.Light)this.motionCurveSet).intensity = (MotionCurve2.Float)this.motionCurve;
                    this.iState = 3;
                } else if (string2.equals("color")) {
                    this.motionCurve = MotionCurve2.createColorCurve();
                    ((MotionCurveSet.Light)this.motionCurveSet).color = (MotionCurve2.Color3f)this.motionCurve;
                    this.iState = 5;
                }
            } else if (string.equals("subtype")) {
                if (n == 2) {
                    if (string2.equals("quaternion")) {
                        this.motionCurve = MotionCurve2.createOrientationCurve();
                        this.motionCurveSet.orientation = (MotionCurve2.Quat4f)this.motionCurve;
                        this.iState = 6;
                    }
                } else if (n == 3 && string2.equals("uniform")) {
                    this.motionCurve = MotionCurve2.createScaleCurve();
                    ((MotionCurveSet.Model)this.motionCurveSet).scale = (MotionCurve2.Float)this.motionCurve;
                    this.iState = 3;
                }
            } else if (n == 1 && string.equals("morph")) {
                Morph morph = (Morph)((AnimModel)this.animObject).getModel().getMorphList().get(Integer.parseInt(string2));
                this.motionCurve = MotionCurve2.createMorphCurve(morph);
                ((MotionCurveSet.Model)this.motionCurveSet).setMorphCurve(morph, (MotionCurve2.Float)this.motionCurve);
                this.iState = 3;
            } else if (string.equals("interpolation")) {
                if (string2.equals("linear")) {
                    this.motionCurve.setInterpolationMethod(MotionCurve2.LINEAR);
                } else if (string2.equals("cubic")) {
                    this.motionCurve.setInterpolationMethod(MotionCurve2.CUBIC);
                }
            }
            ++n2;
        }
    }

    private final void parseRenderer(Attributes attributes) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("format")) {
                this.strRendererFormat = string2;
            }
            ++n;
        }
        this.sbChars = new StringBuffer();
    }

    private final void parseKey(Attributes attributes) {
        float f = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("frame")) {
                f = Float.parseFloat(string2);
            } else if (string.equals("value") || string.equals("x") || string.equals("r")) {
                d = Double.parseDouble(string2);
            } else if (string.equals("y") || string.equals("g")) {
                d2 = Double.parseDouble(string2);
            } else if (string.equals("z") || string.equals("b")) {
                d3 = Double.parseDouble(string2);
            } else if (string.equals("w")) {
                d4 = Double.parseDouble(string2);
            }
            ++n;
        }
        switch (this.iState) {
            case 3: {
                this.motionCurve.addKey(new MotionKey2.Float(f, (float)d));
                break;
            }
            case 4: {
                this.motionCurve.addKey(new MotionKey2.Point3d(f, new Point3d(d, d2, d3)));
                break;
            }
            case 6: {
                this.motionCurve.addKey(new MotionKey2.Quat4f(f, new Quat4f((float)d, (float)d2, (float)d3, (float)d4)));
                break;
            }
            case 5: {
                this.motionCurve.addKey(new MotionKey2.Color3f(f, new Color3f((float)d, (float)d2, (float)d3)));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private final /* synthetic */ void this() {
        this.iState = 0;
        this.iPrevState = 0;
        this.animation = Animator.getInstance();
    }

    public AnimationImporter() {
        this.this();
    }
}

