/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.Rotoscope;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.Viewport;
import jpatch.boundary.tools.JPatchTool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RotoscopeTool
extends JPatchTool {
    private static final int IDLE = 0;
    private static final int SLIDER = 1;
    private static final int MOVE = 2;
    private static final int SCALE_TOP_LEFT = 3;
    private static final int SCALE_TOP_RIGHT = 4;
    private static final int SCALE_BOTTOM_LEFT = 5;
    private static final int SCALE_BOTTOM_RIGHT = 6;
    private int iState;
    private Rotoscope rotoscope;
    private int iWidth;
    private int iHeight;
    private int iLeftX;
    private int iRightX;
    private int iTopY;
    private int iBottomY;
    private int iCenterX;
    private int iCenterY;
    private int iMouseX;
    private int iMouseY;
    private float fFactor;

    public final int getButton() {
        return 4;
    }

    private final void init(ViewDefinition viewDefinition) {
        this.rotoscope = MainFrame.getInstance().getModel().getRotoscope(viewDefinition.getView());
        if (this.rotoscope == null) {
            return;
        }
        float f = viewDefinition.getTranslateX();
        float f2 = viewDefinition.getTranslateY();
        float f3 = viewDefinition.getWidth();
        float f4 = viewDefinition.getHeight();
        float f5 = viewDefinition.getScale() * f3 * 0.5f;
        float f6 = this.rotoscope.getScale() * f5;
        float f7 = this.rotoscope.getXPosition() - this.rotoscope.getScale() * 0.5f * (float)this.rotoscope.getPixelWidth();
        float f8 = this.rotoscope.getYPosition() - this.rotoscope.getScale() * 0.5f * (float)this.rotoscope.getPixelHeight();
        this.iWidth = (int)(f6 * (float)this.rotoscope.getPixelWidth());
        this.iHeight = (int)(f6 * (float)this.rotoscope.getPixelHeight());
        this.iLeftX = (int)(f3 * 0.5f + (f + f7) * f5);
        this.iRightX = this.iLeftX + this.iWidth;
        this.iTopY = (int)(f4 * 0.5f + (f2 + f8) * f5);
        this.iBottomY = this.iTopY + this.iHeight;
        this.iCenterX = (this.iLeftX + this.iRightX) / 2;
        this.iCenterY = (this.iTopY + this.iBottomY) / 2;
    }

    public final void paint(Viewport viewport, JPatchDrawable jPatchDrawable) {
        JPatchSettings jPatchSettings = JPatchSettings.getInstance();
        Graphics2D graphics2D = (Graphics2D)jPatchDrawable.getGraphics();
        ViewDefinition viewDefinition = viewport.getViewDefinition();
        this.init(viewDefinition);
        if (this.rotoscope == null) {
            graphics2D.setColor(jPatchSettings.cSelection);
            graphics2D.drawString("No rotoscope set!", viewDefinition.getWidth() / 2.0f - 50.0f, viewDefinition.getHeight() / 2.0f - 20.0f);
            return;
        }
        Color color = new Color(255, 255, 255);
        if (this.iState == 2) {
            graphics2D.setColor(color);
            graphics2D.drawRect(this.iLeftX, this.iTopY, this.iWidth, this.iHeight);
        } else {
            graphics2D.setColor(jPatchSettings.cSelection);
            graphics2D.drawRect(this.iLeftX, this.iTopY, this.iWidth, this.iHeight);
            if (this.iState == 3) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(jPatchSettings.cSelection);
            }
            graphics2D.fillRect(this.iLeftX - 3, this.iTopY - 3, 7, 7);
            if (this.iState == 4) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(jPatchSettings.cSelection);
            }
            graphics2D.fillRect(this.iRightX - 3, this.iTopY - 3, 7, 7);
            if (this.iState == 5) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(jPatchSettings.cSelection);
            }
            graphics2D.fillRect(this.iLeftX - 3, this.iBottomY - 3, 7, 7);
            if (this.iState == 6) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(jPatchSettings.cSelection);
            }
            graphics2D.fillRect(this.iRightX - 3, this.iBottomY - 3, 7, 7);
        }
        graphics2D.setColor(jPatchSettings.cSelection);
        graphics2D.drawString("Opacity:", this.iCenterX - 90, this.iBottomY + 17);
        graphics2D.drawRect(this.iCenterX - 40, this.iBottomY + 9, 127, 7);
        if (this.iState == 1) {
            graphics2D.setColor(new Color(255, 255, 255));
        }
        graphics2D.fillRect(this.iCenterX - 40, this.iBottomY + 10, this.rotoscope.getOpacity() / 2, 6);
        graphics2D.drawLine(this.iCenterX - 41 + this.rotoscope.getOpacity() / 2, this.iBottomY + 5, this.iCenterX - 41 + this.rotoscope.getOpacity() / 2, this.iBottomY + 20);
        graphics2D.drawLine(this.iCenterX - 40 + this.rotoscope.getOpacity() / 2, this.iBottomY + 5, this.iCenterX - 40 + this.rotoscope.getOpacity() / 2, this.iBottomY + 20);
        graphics2D.drawLine(this.iCenterX - 39 + this.rotoscope.getOpacity() / 2, this.iBottomY + 5, this.iCenterX - 39 + this.rotoscope.getOpacity() / 2, this.iBottomY + 20);
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        this.init(((Viewport)mouseEvent.getSource()).getViewDefinition());
        if (this.rotoscope == null) {
            return;
        }
        if (mouseEvent.getButton() == 1) {
            this.iMouseX = mouseEvent.getX();
            this.iMouseY = mouseEvent.getY();
            float f = this.iMouseX - this.iCenterX;
            float f2 = this.iMouseY - this.iCenterY;
            float f3 = (float)Math.sqrt(f * f + f2 * f2);
            this.fFactor = this.rotoscope.getScale() / f3;
            int n = this.iCenterX - 40 + this.rotoscope.getOpacity() / 2;
            if (this.iMouseY > this.iBottomY + 3 && this.iMouseY < this.iBottomY + 22 && this.iMouseX > n - 4 && this.iMouseX < n + 4) {
                this.iState = 1;
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            } else if (this.iMouseX > this.iLeftX - 5 && this.iMouseX < this.iLeftX + 5 && this.iMouseY > this.iTopY - 5 && this.iMouseY < this.iTopY + 5) {
                this.iState = 3;
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            } else if (this.iMouseX > this.iRightX - 5 && this.iMouseX < this.iRightX + 5 && this.iMouseY > this.iTopY - 5 && this.iMouseY < this.iTopY + 5) {
                this.iState = 4;
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            } else if (this.iMouseX > this.iLeftX - 5 && this.iMouseX < this.iLeftX + 5 && this.iMouseY > this.iBottomY - 5 && this.iMouseY < this.iBottomY + 5) {
                this.iState = 5;
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            } else if (this.iMouseX > this.iRightX - 5 && this.iMouseX < this.iRightX + 5 && this.iMouseY > this.iBottomY - 5 && this.iMouseY < this.iBottomY + 5) {
                this.iState = 6;
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            } else if (this.iMouseX >= this.iLeftX && this.iMouseX <= this.iRightX && this.iMouseY >= this.iTopY && this.iMouseY <= this.iBottomY) {
                this.iState = 2;
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            }
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            ((Component)mouseEvent.getSource()).removeMouseMotionListener(this);
            this.iState = 0;
            MainFrame.getInstance().getJPatchScreen().update_all();
        }
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        this.init(((Viewport)mouseEvent.getSource()).getViewDefinition());
        if (this.rotoscope == null) {
            return;
        }
        int n = mouseEvent.getX() - this.iMouseX;
        int n2 = mouseEvent.getY() - this.iMouseY;
        this.iMouseX = mouseEvent.getX();
        this.iMouseY = mouseEvent.getY();
        switch (this.iState) {
            case 1: {
                int n3 = (this.iMouseX - this.iCenterX + 40) * 2;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 > 255) {
                    n3 = 255;
                }
                this.rotoscope.setOpacity(n3);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
                break;
            }
            case 2: {
                ViewDefinition viewDefinition = ((Viewport)mouseEvent.getSource()).getViewDefinition();
                float f = viewDefinition.getScale() * viewDefinition.getWidth() * 0.5f;
                float f2 = this.rotoscope.getXPosition() + 1.0f / f * (float)n;
                float f3 = this.rotoscope.getYPosition() + 1.0f / f * (float)n2;
                this.rotoscope.setPosition(f2, f3);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                float f = this.iMouseX - this.iCenterX;
                float f4 = this.iMouseY - this.iCenterY;
                float f5 = (float)Math.sqrt(f * f + f4 * f4);
                this.rotoscope.setScale(f5 * this.fFactor);
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
                break;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.iState = 0;
    }

    public RotoscopeTool() {
        this.this();
        MainFrame.getInstance().setHelpText("Drag rotoscope to move. Drag handles to scale. Move slider to change opacity.");
    }
}

