/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.MainFrame;
import jpatch.boundary.SimpleShape;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.Viewport;
import jpatch.boundary.tools.Handle;
import jpatch.boundary.tools.RotateTool;

public class PivotHandle
extends Handle {
    private RotateTool rotateTool;

    public Point3f getPosition() {
        return this.rotateTool.getPivot();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.iMouseX;
        int n2 = mouseEvent.getY() - this.iMouseY;
        ViewDefinition viewDefinition = ((Viewport)mouseEvent.getSource()).getViewDefinition();
        viewDefinition.setZ(this.getPosition());
        MainFrame.getInstance().getConstraints().setPointPosition(this.getPosition(), viewDefinition.get3DPosition(mouseEvent.getX(), mouseEvent.getY()));
        this.rotateTool.setRadius();
        MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
    }

    public void paint(Viewport viewport, JPatchDrawable jPatchDrawable) {
        Point3f point3f = this.getTransformedPosition(viewport.getViewDefinition().getMatrix());
        float f = (float)this.cPassive.getRed() / 255.0f;
        float f2 = (float)this.cPassive.getGreen() / 255.0f;
        float f3 = (float)this.cPassive.getBlue() / 255.0f;
        int n = (int)point3f.x;
        int n2 = (int)point3f.y;
        Matrix4f matrix4f = viewport.getViewDefinition().getMatrix();
        SimpleShape simpleShape = !this.bActive ? SimpleShape.createCube((float)this.iSize / matrix4f.getScale(), f, f2, f3) : SimpleShape.createCube((float)this.iSize / matrix4f.getScale(), 1.0f, 1.0f, 1.0f);
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.set(this.rotateTool.getRotA());
        simpleShape.transform(matrix4f2);
        Vector3f vector3f = new Vector3f(this.getPosition());
        matrix4f2.set(vector3f);
        simpleShape.transform(matrix4f2);
        jPatchDrawable.drawSimpleShape(simpleShape, matrix4f);
    }

    public PivotHandle(RotateTool rotateTool, Color color) {
        super(null, color);
        this.rotateTool = rotateTool;
    }
}

