/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.sidebar;

import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import jpatch.boundary.JPatchButton;
import jpatch.boundary.JPatchInput;
import jpatch.boundary.JPatchToggleButton;
import jpatch.boundary.MainFrame;
import jpatch.boundary.action.DeleteMorphAction;
import jpatch.boundary.action.EditMorphAction;
import jpatch.boundary.sidebar.SidePanel;
import jpatch.entity.Morph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MorphPanel
extends SidePanel
implements ChangeListener {
    JPatchInput inputName;
    JPanel panelMinMax;
    JPatchInput inputMin;
    JPatchInput inputMax;
    JSlider slider;
    Morph morph;
    AbstractButton editButton;
    AbstractButton deleteButton;

    public void edit() {
        this.editButton.doClick();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.inputName) {
            this.morph.setName(this.inputName.getStringValue());
            ((DefaultTreeModel)MainFrame.getInstance().getTree().getModel()).nodeChanged(this.morph);
        } else if (changeEvent.getSource() == this.inputMin) {
            this.morph.setMin(this.inputMin.getFloatValue());
            if (this.inputMin.getFloatValue() > this.morph.getValue()) {
                this.morph.unapply();
                this.morph.setValue(this.inputMin.getFloatValue());
                this.morph.apply();
                MainFrame.getInstance().getJPatchScreen().update_all();
            }
            this.slider.setValue(this.morph.getSliderValue());
        } else if (changeEvent.getSource() == this.inputMax) {
            this.morph.setMax(this.inputMax.getFloatValue());
            if (this.inputMax.getFloatValue() < this.morph.getValue()) {
                this.morph.unapply();
                this.morph.setValue(this.inputMax.getFloatValue());
                this.morph.apply();
                MainFrame.getInstance().getJPatchScreen().update_all();
            }
            this.slider.setValue(this.morph.getSliderValue());
        } else if (changeEvent.getSource() == this.slider && this.slider.getValueIsAdjusting()) {
            this.morph.unapply();
            this.morph.setSliderValue(this.slider.getValue());
            this.morph.apply();
            MainFrame.getInstance().getJPatchScreen().update_all();
        }
    }

    public void editMorph() {
        this.slider.setValue(this.morph.getSliderValue());
        this.slider.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    public void editMorphDone() {
        this.slider.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }

    private final /* synthetic */ void this() {
        this.panelMinMax = new JPanel();
    }

    public MorphPanel(Morph morph) {
        this.this();
        this.morph = morph;
        Morph morph2 = MainFrame.getInstance().getEditedMorph();
        this.deleteButton = new JPatchButton(new DeleteMorphAction(morph));
        this.editButton = new JPatchToggleButton(new EditMorphAction(morph, this));
        this.add(this.editButton);
        this.add(this.deleteButton);
        JPanel jPanel = MainFrame.getInstance().getSideBar().getDetailPanel();
        JPatchInput.setDimensions(50, 150, 20);
        this.inputName = new JPatchInput("Name:", morph.getName());
        this.panelMinMax.setLayout(new BoxLayout(this.panelMinMax, 0));
        JPatchInput.setDimensions(50, 50, 20);
        this.inputMin = new JPatchInput("Min:", morph.getMin());
        this.inputMax = new JPatchInput("Max:", morph.getMax());
        this.panelMinMax.add(this.inputMin);
        this.panelMinMax.add(this.inputMax);
        jPanel.removeAll();
        jPanel.add(this.inputName);
        jPanel.add(this.panelMinMax);
        this.slider = new JSlider(0, 0, 100, morph.getSliderValue());
        this.slider.setFocusable(false);
        jPanel.add(this.slider);
        jPanel.repaint();
        this.inputName.addChangeListener(this);
        this.inputMin.addChangeListener(this);
        this.inputMax.addChangeListener(this);
        this.slider.addChangeListener(this);
        if (morph == morph2) {
            this.editButton.setSelected(true);
            this.deleteButton.setEnabled(false);
            this.slider.setEnabled(false);
        } else if (morph2 != null) {
            this.editButton.setEnabled(false);
        }
    }
}

