/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.selection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import jpatch.auxilary.XMLutils;
import jpatch.boundary.MainFrame;
import jpatch.boundary.selection.Selection;
import jpatch.entity.ControlPoint;
import jpatch.entity.JPatchException;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.Patch;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PointSelection
extends Selection {
    private static PointSelection ps = new PointSelection(false);
    private static ControlPoint[] acp = new ControlPoint[0];
    protected Collection colCp;
    protected Point3f p3Pivot;
    protected Matrix3f m3Rotation;
    protected Point3f p3CornerA;
    protected Point3f p3CornerB;
    protected ControlPoint cpHot;
    protected boolean bDirection;
    protected boolean bCurve;

    public static Class getPointSelectionClass() {
        return ps.getClass();
    }

    public void addPointSelection(PointSelection pointSelection) {
        this.colCp.addAll(pointSelection.colCp);
    }

    public Collection getSelectedControlPoints() {
        return this.colCp;
    }

    public void xorPointSelection(PointSelection pointSelection) {
        Iterator iterator = pointSelection.colCp.iterator();
        while (iterator.hasNext()) {
            ControlPoint controlPoint = (ControlPoint)iterator.next();
            if (this.colCp.contains(controlPoint)) {
                this.colCp.remove(controlPoint);
                continue;
            }
            this.colCp.add(controlPoint);
        }
        if (this.colCp.size() == 0) {
            MainFrame.getInstance().setSelection(null);
        }
    }

    public void setControlPoint(ControlPoint controlPoint) {
        this.colCp.clear();
        this.colCp.add(controlPoint);
        this.cpHot = controlPoint;
    }

    public boolean isSingle() {
        boolean bl = false;
        if (this.colCp.size() == 1) {
            bl = true;
        }
        return bl;
    }

    public ControlPoint[] getControlPointArray() {
        return this.colCp.toArray(acp);
    }

    public void setHotCp(ControlPoint controlPoint) {
        this.cpHot = controlPoint;
    }

    public ControlPoint getHotCp() {
        return this.cpHot;
    }

    public Point3f[] getPointArray() {
        Point3f[] point3fArray = new Point3f[this.colCp.size()];
        int n = 0;
        Iterator iterator = this.colCp.iterator();
        while (iterator.hasNext()) {
            point3fArray[n++] = new Point3f(((ControlPoint)iterator.next()).getPosition());
        }
        return point3fArray;
    }

    public ControlPoint getControlPoint() {
        if (this.isSingle()) {
            return (ControlPoint)this.colCp.iterator().next();
        }
        throw new JPatchException("attempted to get singe ControlPoint but size != 1");
    }

    public int getSize() {
        return this.colCp.size();
    }

    public void addControlPoint(ControlPoint controlPoint) {
        this.colCp.add(controlPoint);
    }

    public void removeControlPoint(ControlPoint controlPoint) {
        this.colCp.remove(controlPoint);
        if (this.colCp.size() == 0) {
            MainFrame.getInstance().setSelection(null);
        }
    }

    public boolean contains(ControlPoint controlPoint) {
        return this.colCp.contains(controlPoint);
    }

    public void applyMaterial(JPatchMaterial jPatchMaterial) {
        Patch patch = MainFrame.getInstance().getModel().getFirstPatch();
        while (patch != null) {
            if (patch.isSelected(this)) {
                patch.setMaterial(jPatchMaterial);
            }
            patch = patch.getNext();
        }
    }

    public Point3f getPivot() {
        if (this.p3Pivot == null) {
            this.p3Pivot = this.getCenter();
        }
        return this.p3Pivot;
    }

    public Point3f getCornerA() {
        this.computeBounds();
        return this.p3CornerA;
    }

    public Point3f getCornerB() {
        this.computeBounds();
        return this.p3CornerB;
    }

    public Matrix3f getRotation() {
        if (this.m3Rotation == null) {
            this.m3Rotation = new Matrix3f();
            this.m3Rotation.setIdentity();
        }
        return this.m3Rotation;
    }

    public void resetPivotToCenter() {
        if (this.p3Pivot == null) {
            this.p3Pivot = new Point3f();
        }
        this.p3Pivot.set(this.getCenter());
    }

    protected void computeBounds() {
        float f = -3.4028235E38f;
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        float f6 = Float.MAX_VALUE;
        Point3f[] point3fArray = this.getPointArray();
        Point3f point3f = new Point3f();
        Matrix3f matrix3f = new Matrix3f(this.m3Rotation);
        matrix3f.invert();
        int n = 0;
        while (n < point3fArray.length) {
            point3f.set(point3fArray[n]);
            matrix3f.transform(point3f);
            if (point3f.x > f) {
                f = point3f.x;
            }
            if (point3f.x < f2) {
                f2 = point3f.x;
            }
            if (point3f.y > f3) {
                f3 = point3f.y;
            }
            if (point3f.y < f4) {
                f4 = point3f.y;
            }
            if (point3f.z > f5) {
                f5 = point3f.z;
            }
            if (point3f.z < f6) {
                f6 = point3f.z;
            }
            ++n;
        }
        this.p3CornerA.set(f2, f4, f6);
        this.p3CornerB.set(f, f3, f5);
    }

    public Point3f getCenter() {
        Point3f point3f = new Point3f();
        this.computeBounds();
        point3f.interpolate(this.p3CornerA, this.p3CornerB, 0.5f);
        this.m3Rotation.transform(point3f);
        return point3f;
    }

    public StringBuffer xml(int n) {
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.lineBreak();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(stringBuffer).append("<selection name=\"" + this.getName() + "\">");
        Iterator iterator = this.colCp.iterator();
        while (iterator.hasNext()) {
            int n2 = ((ControlPoint)iterator.next()).getXmlNumber();
            if (n2 == -1) continue;
            stringBuffer3.append(n2);
            if (!iterator.hasNext()) continue;
            stringBuffer3.append(",");
        }
        stringBuffer3.append("</selection>").append(stringBuffer2);
        return stringBuffer3;
    }

    public boolean getDirection() {
        return this.bDirection;
    }

    public boolean isCurve() {
        boolean bl = false;
        if (this.bCurve && this.isSingle()) {
            bl = true;
        }
        return bl;
    }

    public void nextPoint() {
        if (!this.bCurve) {
            this.bCurve = true;
        } else if (this.isSingle()) {
            if (this.bDirection) {
                ControlPoint controlPoint = this.getControlPoint();
                if (controlPoint.getPrevAttached() != null) {
                    this.setControlPoint(controlPoint.getPrevAttached());
                } else {
                    this.setControlPoint(controlPoint.getHead());
                    this.bCurve = false;
                }
            }
            this.bDirection ^= true;
        }
    }

    private final /* synthetic */ void this() {
        this.m3Rotation = new Matrix3f();
        this.p3CornerA = new Point3f();
        this.p3CornerB = new Point3f();
        this.bDirection = false;
        this.bCurve = false;
    }

    private PointSelection(boolean bl) {
        this.this();
    }

    public PointSelection() {
        this.this();
        this.colCp = new HashSet();
        this.m3Rotation.setIdentity();
    }

    public PointSelection(ControlPoint controlPoint) {
        this();
        this.setControlPoint(controlPoint);
    }
}

