/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jpatch.boundary.KeyMapping;
import jpatch.boundary.MainFrame;
import jpatch.boundary.selection.PointSelection;
import jpatch.control.edit.CloneCommonEdit;
import jpatch.control.edit.NewExtrudeEdit;

public final class ExtrudeAction
extends AbstractAction {
    public final void actionPerformed(ActionEvent actionEvent) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        if (pointSelection != null && !pointSelection.isSingle()) {
            if (CloneCommonEdit.checkForHooks(pointSelection.getControlPointArray())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Extrude operation can not be performed bacause the selection contains hooks", "Can't extrude", 0);
            } else {
                NewExtrudeEdit newExtrudeEdit = new NewExtrudeEdit(pointSelection.getControlPointArray());
                if (newExtrudeEdit.size() > 0) {
                    MainFrame.getInstance().getUndoManager().addEdit(newExtrudeEdit);
                }
                MainFrame.getInstance().getJPatchScreen().update_all();
            }
        }
    }

    public ExtrudeAction() {
        super("", new ImageIcon(ClassLoader.getSystemResource("jpatch/images/extrude.png")));
        this.putValue("ShortDescription", KeyMapping.getDescription("extrude"));
    }
}

