/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import jpatch.boundary.MainFrame;
import jpatch.boundary.selection.PointSelection;
import jpatch.control.edit.CorrectSelectionsEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.entity.ControlPoint;

public final class DetachControlPointsAction
extends AbstractAction {
    public final void actionPerformed(ActionEvent actionEvent) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        if (pointSelection != null && pointSelection.isSingle()) {
            if (pointSelection.isCurve()) {
                MainFrame.getInstance().getUndoManager().addEdit(CorrectSelectionsEdit.detachPoint(pointSelection.getControlPoint()));
                MainFrame.getInstance().getJPatchScreen().update_all();
            } else {
                ControlPoint[] controlPointArray = pointSelection.getControlPoint().getStack();
                JPatchCompoundEdit jPatchCompoundEdit = new JPatchCompoundEdit("detach");
                int n = 0;
                while (n < controlPointArray.length) {
                    jPatchCompoundEdit.addEdit(CorrectSelectionsEdit.detachPoint(pointSelection.getControlPoint()));
                    ++n;
                }
                MainFrame.getInstance().getUndoManager().addEdit(jPatchCompoundEdit);
                MainFrame.getInstance().getJPatchScreen().update_all();
            }
        }
    }

    public DetachControlPointsAction() {
        super("", new ImageIcon(ClassLoader.getSystemResource("jpatch/images/detach.png")));
        this.putValue("ShortDescription", "Detach points");
    }
}

