/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.Lighting;
import jpatch.entity.MaterialProperties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ZBufferRenderer {
    private static int iCurveSubdivisions;
    private static int iPatchSubdivisions;
    private static float[] B0;
    private static float[] B1;
    private static float[] B2;
    private static float[] B3;
    private static float[] dB0;
    private static float[] dB1;
    private static float[] dB2;
    private static float[] dB3;
    private static float[] cB0;
    private static float[] cB1;
    private static float[] cB2;
    private static float[] cB3;
    private static JPatchSettings settings;
    private static final byte SUB_PIXEL_BITS = 16;
    private static final int SUB_PIXEL_MULTIPLIER = 65536;
    private static final int SUB_PIXEL_MASK_1 = 65535;
    private static final int SUB_PIXEL_MASK_2 = -65536;
    private static Point3f[] ap3;
    private static Vector3f[] av3N;
    private static int[] aiColor;
    protected int iWidth;
    protected int iHeight;
    private int[] aiActiveFrameBuffer;
    private int[] aiActiveZBuffer;
    private int[] aiImageZBuffer;
    private BufferedImage bufferedImage;
    private int iMaxZ;
    private float fPolygonOffset;
    private int color;
    private Vector3f v3dt;
    private Vector3f v3ds;
    protected Lighting lighting;
    private boolean bDirectRendering;
    protected boolean bBackfaceNormalFlip;
    private boolean bCulling;
    private boolean bMark;

    public static void init() {
        float f;
        iPatchSubdivisions = ZBufferRenderer.settings.iPatchSubdivisions;
        iCurveSubdivisions = ZBufferRenderer.settings.iCurveSubdivisions;
        ap3 = new Point3f[iPatchSubdivisions * iPatchSubdivisions];
        av3N = new Vector3f[iPatchSubdivisions * iPatchSubdivisions];
        aiColor = new int[iPatchSubdivisions * iPatchSubdivisions];
        B0 = new float[iPatchSubdivisions];
        B1 = new float[iPatchSubdivisions];
        B2 = new float[iPatchSubdivisions];
        B3 = new float[iPatchSubdivisions];
        dB0 = new float[iPatchSubdivisions];
        dB1 = new float[iPatchSubdivisions];
        dB2 = new float[iPatchSubdivisions];
        dB3 = new float[iPatchSubdivisions];
        cB0 = new float[iCurveSubdivisions];
        cB1 = new float[iCurveSubdivisions];
        cB2 = new float[iCurveSubdivisions];
        cB3 = new float[iCurveSubdivisions];
        int n = 0;
        while (n < iPatchSubdivisions * iPatchSubdivisions) {
            ZBufferRenderer.ap3[n] = new Point3f();
            ZBufferRenderer.av3N[n] = new Vector3f();
            ++n;
        }
        n = 0;
        while (n < iPatchSubdivisions) {
            f = (float)n / (float)(iPatchSubdivisions - 1);
            ZBufferRenderer.B0[n] = (1.0f - f) * (1.0f - f) * (1.0f - f);
            ZBufferRenderer.B1[n] = (float)3 * f * (1.0f - f) * (1.0f - f);
            ZBufferRenderer.B2[n] = (float)3 * f * f * (1.0f - f);
            ZBufferRenderer.B3[n] = f * f * f;
            ZBufferRenderer.dB0[n] = -3.0f * (1.0f - f) * (1.0f - f);
            ZBufferRenderer.dB1[n] = -6.0f * f * (1.0f - f) + (float)3 * (1.0f - f) * (1.0f - f);
            ZBufferRenderer.dB2[n] = -3.0f * f * f + 6.0f * f * (1.0f - f);
            ZBufferRenderer.dB3[n] = (float)3 * f * f;
            ++n;
        }
        n = 0;
        while (n < iCurveSubdivisions) {
            f = (float)n / (float)(iCurveSubdivisions - 1);
            ZBufferRenderer.cB0[n] = (1.0f - f) * (1.0f - f) * (1.0f - f);
            ZBufferRenderer.cB1[n] = (float)3 * f * (1.0f - f) * (1.0f - f);
            ZBufferRenderer.cB2[n] = (float)3 * f * f * (1.0f - f);
            ZBufferRenderer.cB3[n] = f * f * f;
            ++n;
        }
    }

    public void setCulling(int n) {
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        this.bCulling = bl;
        boolean bl2 = false;
        if (n == 2) {
            bl2 = true;
        }
        this.bMark = bl2;
    }

    public void setLighting(Lighting lighting) {
        this.lighting = lighting;
    }

    public Lighting getLighting() {
        return this.lighting;
    }

    public Graphics getGraphics() {
        return this.bufferedImage.getGraphics();
    }

    public Image getImage() {
        return this.bufferedImage;
    }

    public void setColor(Color color) {
        this.color = color.getRGB();
    }

    public void setColor(int n) {
        this.color = n;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        this.iWidth = bufferedImage.getWidth();
        this.iHeight = bufferedImage.getHeight();
        this.aiImageZBuffer = new int[this.iWidth * this.iHeight];
    }

    public void renderToImage() {
        try {
            this.aiActiveFrameBuffer = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        }
        catch (ClassCastException classCastException) {
            this.bufferedImage = new BufferedImage(this.iWidth, this.iHeight, 1);
            this.aiActiveFrameBuffer = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        }
        this.aiActiveZBuffer = this.aiImageZBuffer;
    }

    public void setActiveBuffers(int[] nArray, int[] nArray2) {
        this.aiActiveFrameBuffer = nArray;
        this.aiActiveZBuffer = nArray2;
    }

    public int getSubdivisions() {
        return iPatchSubdivisions - 1;
    }

    public void setSubdivisions(int n) {
        iPatchSubdivisions = ++n;
        ZBufferRenderer.init();
    }

    public void clear() {
        Arrays.fill(this.aiActiveFrameBuffer, ZBufferRenderer.settings.iBackground);
        Arrays.fill(this.aiActiveZBuffer, this.iMaxZ);
    }

    public void clearZBuffer() {
        Arrays.fill(this.aiActiveZBuffer, this.iMaxZ);
    }

    public void reset(int[] nArray, int[] nArray2) {
        int n = this.aiActiveFrameBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            this.aiActiveFrameBuffer[n2] = nArray[n2];
            this.aiActiveZBuffer[n2] = nArray2[n2];
            ++n2;
        }
    }

    protected final void drawCurveSegment3D(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        int n;
        int n2;
        int n3;
        int n4 = (int)point3f.x;
        int n5 = (int)point3f.y;
        int n6 = (int)(point3f.z * 65536.0f);
        int n7 = 1;
        while (n7 < iCurveSubdivisions - 1) {
            n3 = (int)(cB0[n7] * point3f.x + cB1[n7] * point3f2.x + cB2[n7] * point3f3.x + cB3[n7] * point3f4.x);
            n2 = (int)(cB0[n7] * point3f.y + cB1[n7] * point3f2.y + cB2[n7] * point3f3.y + cB3[n7] * point3f4.y);
            n = (int)(cB0[n7] * point3f.z + cB1[n7] * point3f2.z + cB2[n7] * point3f3.z + cB3[n7] * point3f4.z) * 65536;
            this.drawLine3D(n4, n5, n6, n3, n2, n);
            n4 = n3;
            n5 = n2;
            n6 = n;
            ++n7;
        }
        n3 = (int)point3f4.x;
        n2 = (int)point3f4.y;
        n = (int)(point3f4.z * 65536.0f);
        this.drawLine3D(n4, n5, n6, n3, n2, n);
    }

    public final void drawCurveSegment(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        int n;
        int n2;
        int n3;
        int n4 = (int)point3f.x;
        int n5 = (int)point3f.y;
        int n6 = (int)(point3f.z * 65536.0f);
        int n7 = 1;
        while (n7 < iCurveSubdivisions - 1) {
            n3 = (int)(cB0[n7] * point3f.x + cB1[n7] * point3f2.x + cB2[n7] * point3f3.x + cB3[n7] * point3f4.x);
            n2 = (int)(cB0[n7] * point3f.y + cB1[n7] * point3f2.y + cB2[n7] * point3f3.y + cB3[n7] * point3f4.y);
            n = (int)(cB0[n7] * point3f.z + cB1[n7] * point3f2.z + cB2[n7] * point3f3.z + cB3[n7] * point3f4.z) * 65536;
            this.drawLine(n4, n5, n3, n2);
            n4 = n3;
            n5 = n2;
            n6 = n;
            ++n7;
        }
        n3 = (int)point3f4.x;
        n2 = (int)point3f4.y;
        n = (int)(point3f4.z * 65536.0f);
        this.drawLine(n4, n5, n3, n2);
    }

    public final void drawBicubicPatchGourad(Point3f[] point3fArray, MaterialProperties materialProperties) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        while (n < 16) {
            boolean bl5 = false;
            if (point3fArray[n].x > 0.0f) {
                bl5 = true;
            }
            bl4 |= bl5;
            boolean bl6 = false;
            if (point3fArray[n].x < (float)this.iWidth) {
                bl6 = true;
            }
            bl3 |= bl6;
            boolean bl7 = false;
            if (point3fArray[n].y > 0.0f) {
                bl7 = true;
            }
            bl2 |= bl7;
            boolean bl8 = false;
            if (point3fArray[n].y < (float)this.iHeight) {
                bl8 = true;
            }
            bl |= bl8;
            ++n;
        }
        if (bl4 && bl3 && bl2 && bl) {
            switch (iPatchSubdivisions) {
                case 2: {
                    ap3[0].set(point3fArray[0]);
                    ap3[1].set(point3fArray[3]);
                    ap3[2].set(point3fArray[12]);
                    ap3[3].set(point3fArray[15]);
                    this.v3ds.sub(point3fArray[1], point3fArray[0]);
                    this.v3dt.sub(point3fArray[4], point3fArray[0]);
                    av3N[0].cross(this.v3ds, this.v3dt);
                    av3N[0].normalize();
                    this.v3ds.sub(point3fArray[2], point3fArray[3]);
                    this.v3dt.sub(point3fArray[7], point3fArray[3]);
                    av3N[1].cross(this.v3ds, this.v3dt);
                    av3N[1].normalize();
                    this.v3ds.sub(point3fArray[13], point3fArray[12]);
                    this.v3dt.sub(point3fArray[8], point3fArray[12]);
                    av3N[2].cross(this.v3ds, this.v3dt);
                    av3N[2].normalize();
                    this.v3ds.sub(point3fArray[14], point3fArray[15]);
                    this.v3dt.sub(point3fArray[11], point3fArray[15]);
                    av3N[3].cross(this.v3ds, this.v3dt);
                    av3N[3].normalize();
                    break;
                }
                default: {
                    int n2 = 0;
                    while (n2 < iPatchSubdivisions) {
                        int n3 = iPatchSubdivisions * n2;
                        int n4 = 0;
                        while (n4 < iPatchSubdivisions) {
                            float f = point3fArray[0].x * B0[n4] + point3fArray[1].x * B1[n4] + point3fArray[2].x * B2[n4] + point3fArray[3].x * B3[n4];
                            float f2 = point3fArray[4].x * B0[n4] + point3fArray[5].x * B1[n4] + point3fArray[6].x * B2[n4] + point3fArray[7].x * B3[n4];
                            float f3 = point3fArray[8].x * B0[n4] + point3fArray[9].x * B1[n4] + point3fArray[10].x * B2[n4] + point3fArray[11].x * B3[n4];
                            float f4 = point3fArray[12].x * B0[n4] + point3fArray[13].x * B1[n4] + point3fArray[14].x * B2[n4] + point3fArray[15].x * B3[n4];
                            float f5 = point3fArray[0].y * B0[n4] + point3fArray[1].y * B1[n4] + point3fArray[2].y * B2[n4] + point3fArray[3].y * B3[n4];
                            float f6 = point3fArray[4].y * B0[n4] + point3fArray[5].y * B1[n4] + point3fArray[6].y * B2[n4] + point3fArray[7].y * B3[n4];
                            float f7 = point3fArray[8].y * B0[n4] + point3fArray[9].y * B1[n4] + point3fArray[10].y * B2[n4] + point3fArray[11].y * B3[n4];
                            float f8 = point3fArray[12].y * B0[n4] + point3fArray[13].y * B1[n4] + point3fArray[14].y * B2[n4] + point3fArray[15].y * B3[n4];
                            float f9 = point3fArray[0].z * B0[n4] + point3fArray[1].z * B1[n4] + point3fArray[2].z * B2[n4] + point3fArray[3].z * B3[n4];
                            float f10 = point3fArray[4].z * B0[n4] + point3fArray[5].z * B1[n4] + point3fArray[6].z * B2[n4] + point3fArray[7].z * B3[n4];
                            float f11 = point3fArray[8].z * B0[n4] + point3fArray[9].z * B1[n4] + point3fArray[10].z * B2[n4] + point3fArray[11].z * B3[n4];
                            float f12 = point3fArray[12].z * B0[n4] + point3fArray[13].z * B1[n4] + point3fArray[14].z * B2[n4] + point3fArray[15].z * B3[n4];
                            ap3[n3].set(f * B0[n2] + f2 * B1[n2] + f3 * B2[n2] + f4 * B3[n2], f5 * B0[n2] + f6 * B1[n2] + f7 * B2[n2] + f8 * B3[n2], f9 * B0[n2] + f10 * B1[n2] + f11 * B2[n2] + f12 * B3[n2]);
                            this.v3ds.set(f * dB0[n2] + f2 * dB1[n2] + f3 * dB2[n2] + f4 * dB3[n2], f5 * dB0[n2] + f6 * dB1[n2] + f7 * dB2[n2] + f8 * dB3[n2], f9 * dB0[n2] + f10 * dB1[n2] + f11 * dB2[n2] + f12 * dB3[n2]);
                            this.v3dt.set(B0[n2] * (point3fArray[0].x * dB0[n4] + point3fArray[1].x * dB1[n4] + point3fArray[2].x * dB2[n4] + point3fArray[3].x * dB3[n4]) + B1[n2] * (point3fArray[4].x * dB0[n4] + point3fArray[5].x * dB1[n4] + point3fArray[6].x * dB2[n4] + point3fArray[7].x * dB3[n4]) + B2[n2] * (point3fArray[8].x * dB0[n4] + point3fArray[9].x * dB1[n4] + point3fArray[10].x * dB2[n4] + point3fArray[11].x * dB3[n4]) + B3[n2] * (point3fArray[12].x * dB0[n4] + point3fArray[13].x * dB1[n4] + point3fArray[14].x * dB2[n4] + point3fArray[15].x * dB3[n4]), B0[n2] * (point3fArray[0].y * dB0[n4] + point3fArray[1].y * dB1[n4] + point3fArray[2].y * dB2[n4] + point3fArray[3].y * dB3[n4]) + B1[n2] * (point3fArray[4].y * dB0[n4] + point3fArray[5].y * dB1[n4] + point3fArray[6].y * dB2[n4] + point3fArray[7].y * dB3[n4]) + B2[n2] * (point3fArray[8].y * dB0[n4] + point3fArray[9].y * dB1[n4] + point3fArray[10].y * dB2[n4] + point3fArray[11].y * dB3[n4]) + B3[n2] * (point3fArray[12].y * dB0[n4] + point3fArray[13].y * dB1[n4] + point3fArray[14].y * dB2[n4] + point3fArray[15].y * dB3[n4]), B0[n2] * (point3fArray[0].z * dB0[n4] + point3fArray[1].z * dB1[n4] + point3fArray[2].z * dB2[n4] + point3fArray[3].z * dB3[n4]) + B1[n2] * (point3fArray[4].z * dB0[n4] + point3fArray[5].z * dB1[n4] + point3fArray[6].z * dB2[n4] + point3fArray[7].z * dB3[n4]) + B2[n2] * (point3fArray[8].z * dB0[n4] + point3fArray[9].z * dB1[n4] + point3fArray[10].z * dB2[n4] + point3fArray[11].z * dB3[n4]) + B3[n2] * (point3fArray[12].z * dB0[n4] + point3fArray[13].z * dB1[n4] + point3fArray[14].z * dB2[n4] + point3fArray[15].z * dB3[n4]));
                            av3N[n3].cross(this.v3ds, this.v3dt);
                            av3N[n3].normalize();
                            ++n3;
                            ++n4;
                        }
                        ++n2;
                    }
                    break block0;
                }
            }
            if (this.bBackfaceNormalFlip) {
                this.flipBackfaceNormals(av3N);
            }
            this.shade(ap3, av3N, materialProperties, aiColor);
            if (materialProperties.isOpaque()) {
                this.draw3DTriangleGridGourad(ap3, aiColor, iPatchSubdivisions, iPatchSubdivisions);
            } else {
                n = (int)(Math.min(1.0f, materialProperties.transmit + materialProperties.filter) * 255.0f);
                this.draw3DTriangleGridGouradTransparent(ap3, aiColor, iPatchSubdivisions, iPatchSubdivisions, n);
            }
        }
    }

    public final void drawBicubicPatchFlat(Point3f[] point3fArray, MaterialProperties materialProperties) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        while (n < 16) {
            boolean bl5 = false;
            if (point3fArray[n].x > 0.0f) {
                bl5 = true;
            }
            bl4 |= bl5;
            boolean bl6 = false;
            if (point3fArray[n].x < (float)this.iWidth) {
                bl6 = true;
            }
            bl3 |= bl6;
            boolean bl7 = false;
            if (point3fArray[n].y > 0.0f) {
                bl7 = true;
            }
            bl2 |= bl7;
            boolean bl8 = false;
            if (point3fArray[n].y < (float)this.iHeight) {
                bl8 = true;
            }
            bl |= bl8;
            ++n;
        }
        if (bl4 && bl3 && bl2 && bl) {
            switch (iPatchSubdivisions) {
                case 2: {
                    ap3[0].set(point3fArray[0]);
                    ap3[1].set(point3fArray[3]);
                    ap3[2].set(point3fArray[12]);
                    ap3[3].set(point3fArray[15]);
                    break;
                }
                case 3: {
                    float f = point3fArray[0].x * 0.125f;
                    float f2 = point3fArray[0].y * 0.125f;
                    float f3 = point3fArray[0].z * 0.125f;
                    float f4 = point3fArray[3].x * 0.125f;
                    float f5 = point3fArray[3].y * 0.125f;
                    float f6 = point3fArray[3].z * 0.125f;
                    float f7 = point3fArray[12].x * 0.125f;
                    float f8 = point3fArray[12].y * 0.125f;
                    float f9 = point3fArray[12].z * 0.125f;
                    float f10 = point3fArray[15].x * 0.125f;
                    float f11 = point3fArray[15].y * 0.125f;
                    float f12 = point3fArray[15].z * 0.125f;
                    float f13 = f + point3fArray[1].x * 0.375f + point3fArray[2].x * 0.375f + f4;
                    float f14 = f2 + point3fArray[1].y * 0.375f + point3fArray[2].y * 0.375f + f5;
                    float f15 = f3 + point3fArray[1].z * 0.375f + point3fArray[2].z * 0.375f + f6;
                    float f16 = f7 + point3fArray[13].x * 0.375f + point3fArray[14].x * 0.375f + f10;
                    float f17 = f8 + point3fArray[13].y * 0.375f + point3fArray[14].y * 0.375f + f11;
                    float f18 = f9 + point3fArray[13].z * 0.375f + point3fArray[14].z * 0.375f + f12;
                    ap3[0].set(point3fArray[0]);
                    ap3[1].set(f13, f14, f15);
                    ap3[2].set(point3fArray[3]);
                    ZBufferRenderer.ap3[3].x = f + point3fArray[4].x * 0.375f + point3fArray[8].x * 0.375f + f7;
                    ZBufferRenderer.ap3[3].y = f2 + point3fArray[4].y * 0.375f + point3fArray[8].y * 0.375f + f8;
                    ZBufferRenderer.ap3[3].z = f3 + point3fArray[4].z * 0.375f + point3fArray[8].z * 0.375f + f9;
                    ZBufferRenderer.ap3[5].x = f4 + point3fArray[7].x * 0.375f + point3fArray[11].x * 0.375f + f10;
                    ZBufferRenderer.ap3[5].y = f5 + point3fArray[7].y * 0.375f + point3fArray[11].y * 0.375f + f11;
                    ZBufferRenderer.ap3[5].z = f6 + point3fArray[7].z * 0.375f + point3fArray[11].z * 0.375f + f12;
                    ap3[6].set(point3fArray[12]);
                    ap3[7].set(f16, f17, f18);
                    ap3[8].set(point3fArray[15]);
                    float f19 = point3fArray[4].x * 0.125f + point3fArray[5].x * 0.375f + point3fArray[6].x * 0.375f + point3fArray[7].x * 0.125f;
                    float f20 = point3fArray[8].x * 0.125f + point3fArray[9].x * 0.375f + point3fArray[10].x * 0.375f + point3fArray[11].x * 0.125f;
                    float f21 = point3fArray[4].y * 0.125f + point3fArray[5].y * 0.375f + point3fArray[6].y * 0.375f + point3fArray[7].y * 0.125f;
                    float f22 = point3fArray[8].y * 0.125f + point3fArray[9].y * 0.375f + point3fArray[10].y * 0.375f + point3fArray[11].y * 0.125f;
                    float f23 = point3fArray[4].z * 0.125f + point3fArray[5].z * 0.375f + point3fArray[6].z * 0.375f + point3fArray[7].z * 0.125f;
                    float f24 = point3fArray[8].z * 0.125f + point3fArray[9].z * 0.375f + point3fArray[10].z * 0.375f + point3fArray[11].z * 0.125f;
                    ZBufferRenderer.ap3[4].x = f13 * 0.125f + f19 * 0.375f + f20 * 0.375f + f16 * 0.125f;
                    ZBufferRenderer.ap3[4].y = f14 * 0.125f + f21 * 0.375f + f22 * 0.375f + f17 * 0.125f;
                    ZBufferRenderer.ap3[4].z = f15 * 0.125f + f23 * 0.375f + f24 * 0.375f + f18 * 0.125f;
                    break;
                }
                default: {
                    int n2 = 0;
                    while (n2 < iPatchSubdivisions) {
                        int n3 = iPatchSubdivisions * n2;
                        int n4 = 0;
                        while (n4 < iPatchSubdivisions) {
                            float f = point3fArray[0].x * B0[n4] + point3fArray[1].x * B1[n4] + point3fArray[2].x * B2[n4] + point3fArray[3].x * B3[n4];
                            float f25 = point3fArray[4].x * B0[n4] + point3fArray[5].x * B1[n4] + point3fArray[6].x * B2[n4] + point3fArray[7].x * B3[n4];
                            float f26 = point3fArray[8].x * B0[n4] + point3fArray[9].x * B1[n4] + point3fArray[10].x * B2[n4] + point3fArray[11].x * B3[n4];
                            float f27 = point3fArray[12].x * B0[n4] + point3fArray[13].x * B1[n4] + point3fArray[14].x * B2[n4] + point3fArray[15].x * B3[n4];
                            float f28 = point3fArray[0].y * B0[n4] + point3fArray[1].y * B1[n4] + point3fArray[2].y * B2[n4] + point3fArray[3].y * B3[n4];
                            float f29 = point3fArray[4].y * B0[n4] + point3fArray[5].y * B1[n4] + point3fArray[6].y * B2[n4] + point3fArray[7].y * B3[n4];
                            float f30 = point3fArray[8].y * B0[n4] + point3fArray[9].y * B1[n4] + point3fArray[10].y * B2[n4] + point3fArray[11].y * B3[n4];
                            float f31 = point3fArray[12].y * B0[n4] + point3fArray[13].y * B1[n4] + point3fArray[14].y * B2[n4] + point3fArray[15].y * B3[n4];
                            float f32 = point3fArray[0].z * B0[n4] + point3fArray[1].z * B1[n4] + point3fArray[2].z * B2[n4] + point3fArray[3].z * B3[n4];
                            float f33 = point3fArray[4].z * B0[n4] + point3fArray[5].z * B1[n4] + point3fArray[6].z * B2[n4] + point3fArray[7].z * B3[n4];
                            float f34 = point3fArray[8].z * B0[n4] + point3fArray[9].z * B1[n4] + point3fArray[10].z * B2[n4] + point3fArray[11].z * B3[n4];
                            float f35 = point3fArray[12].z * B0[n4] + point3fArray[13].z * B1[n4] + point3fArray[14].z * B2[n4] + point3fArray[15].z * B3[n4];
                            ZBufferRenderer.ap3[n3].x = f * B0[n2] + f25 * B1[n2] + f26 * B2[n2] + f27 * B3[n2];
                            ZBufferRenderer.ap3[n3].y = f28 * B0[n2] + f29 * B1[n2] + f30 * B2[n2] + f31 * B3[n2];
                            ZBufferRenderer.ap3[n3].z = f32 * B0[n2] + f33 * B1[n2] + f34 * B2[n2] + f35 * B3[n2];
                            ++n3;
                            ++n4;
                        }
                        ++n2;
                    }
                    break block0;
                }
            }
            if (materialProperties.isOpaque()) {
                this.draw3DTriangleGridFlat(ap3, materialProperties.getRGB(), iPatchSubdivisions, iPatchSubdivisions);
            } else {
                int n5 = (int)(Math.min(1.0f, materialProperties.transmit + materialProperties.filter) * 255.0f);
                this.draw3DTriangleGridFlatTransparent(ap3, materialProperties.getRGB(), iPatchSubdivisions, iPatchSubdivisions, n5);
            }
        }
    }

    protected final void draw3DTriangleGridGourad(Point3f[] point3fArray, int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2 - 1) {
            int n4 = 0;
            while (n4 < n - 1) {
                int n5 = n3 * n + n4;
                int n6 = (n3 + 1) * n + n4;
                int n7 = (n3 + 1) * n + n4 + 1;
                int n8 = n3 * n + n4 + 1;
                this.draw3DTriangleGourad(point3fArray[n5], point3fArray[n6], point3fArray[n7], nArray[n5], nArray[n6], nArray[n7]);
                this.draw3DTriangleGourad(point3fArray[n7], point3fArray[n8], point3fArray[n5], nArray[n7], nArray[n8], nArray[n5]);
                ++n4;
            }
            ++n3;
        }
    }

    protected final void draw3DTriangleGridGouradTransparent(Point3f[] point3fArray, int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n2 - 1) {
            int n5 = 0;
            while (n5 < n - 1) {
                int n6 = n4 * n + n5;
                int n7 = (n4 + 1) * n + n5;
                int n8 = (n4 + 1) * n + n5 + 1;
                int n9 = n4 * n + n5 + 1;
                this.draw3DTriangleGouradTransparent(point3fArray[n6], point3fArray[n7], point3fArray[n8], nArray[n6], nArray[n7], nArray[n8], n3);
                this.draw3DTriangleGouradTransparent(point3fArray[n8], point3fArray[n9], point3fArray[n6], nArray[n8], nArray[n9], nArray[n6], n3);
                ++n5;
            }
            ++n4;
        }
    }

    protected final void draw3DTriangleGridFlat(Point3f[] point3fArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3 - 1) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                int n6 = n4 * n2 + n5;
                int n7 = (n4 + 1) * n2 + n5;
                int n8 = (n4 + 1) * n2 + n5 + 1;
                int n9 = n4 * n2 + n5 + 1;
                this.draw3DTriangleFlat(point3fArray[n6], point3fArray[n7], point3fArray[n8], n);
                this.draw3DTriangleFlat(point3fArray[n8], point3fArray[n9], point3fArray[n6], n);
                ++n5;
            }
            ++n4;
        }
    }

    protected final void draw3DTriangleGridFlatTransparent(Point3f[] point3fArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n3 - 1) {
            int n6 = 0;
            while (n6 < n2 - 1) {
                int n7 = n5 * n2 + n6;
                int n8 = (n5 + 1) * n2 + n6;
                int n9 = (n5 + 1) * n2 + n6 + 1;
                int n10 = n5 * n2 + n6 + 1;
                this.draw3DTriangleFlatTransparent(point3fArray[n7], point3fArray[n8], point3fArray[n9], n, n4);
                this.draw3DTriangleFlatTransparent(point3fArray[n9], point3fArray[n10], point3fArray[n7], n, n4);
                ++n6;
            }
            ++n5;
        }
    }

    protected final void flipBackfaceNormals(Vector3f[] vector3fArray) {
        int n = 0;
        while (n < vector3fArray.length) {
            if (vector3fArray[n].z > 0.0f) {
                vector3fArray[n].x = -vector3fArray[n].x;
                vector3fArray[n].y = -vector3fArray[n].y;
                vector3fArray[n].z = -vector3fArray[n].z;
            }
            ++n;
        }
    }

    protected final void shade(Point3f[] point3fArray, Vector3f[] vector3fArray, MaterialProperties materialProperties, int[] nArray) {
        int n = point3fArray.length;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.shade(point3fArray[n2], vector3fArray[n2], materialProperties);
            ++n2;
        }
    }

    public final int shade(Point3f point3f, Vector3f vector3f, MaterialProperties materialProperties) {
        return this.lighting.shade(point3f, vector3f, materialProperties);
    }

    public final void drawPoint3D(Point3f point3f, int n) {
        int n2 = (int)point3f.x;
        int n3 = (int)point3f.y;
        int n4 = (int)(point3f.z * 65536.0f);
        int n5 = n2 - n;
        int n6 = n3 - n;
        int n7 = n2 + n;
        int n8 = n3 + n;
        if (n5 < 0 && n7 < 0 || n6 < 0 && n8 < 0 || n5 >= this.iWidth && n7 >= this.iWidth || n6 >= this.iHeight && n8 >= this.iHeight) {
            return;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 >= this.iWidth) {
            n7 = this.iWidth - 1;
        }
        if (n8 >= this.iHeight) {
            n8 = this.iHeight - 1;
        }
        n3 = n6;
        while (n3 <= n8) {
            n2 = n5;
            while (n2 <= n7) {
                int n9 = this.iWidth * n3 + n2;
                if (n4 < this.aiActiveZBuffer[n9]) {
                    this.aiActiveFrameBuffer[n9] = this.color;
                    this.aiActiveZBuffer[n9] = n4;
                }
                ++n2;
            }
            ++n3;
        }
    }

    public void drawXPoint3D(Point3f point3f) {
        int n = (int)point3f.x;
        int n2 = (int)point3f.y;
        int n3 = (int)(point3f.z * 65536.0f);
        this.setPixel3D(n, n2 - 2, n3);
        this.setPixel3D(n - 1, n2 - 1, n3);
        this.setPixel3D(n, n2 - 1, n3);
        this.setPixel3D(n + 1, n2 - 1, n3);
        this.setPixel3D(n - 2, n2, n3);
        this.setPixel3D(n - 1, n2, n3);
        this.setPixel3D(n, n2, n3);
        this.setPixel3D(n + 1, n2, n3);
        this.setPixel3D(n + 2, n2, n3);
        this.setPixel3D(n - 1, n2 + 1, n3);
        this.setPixel3D(n, n2 + 1, n3);
        this.setPixel3D(n + 1, n2 + 1, n3);
        this.setPixel3D(n, n2 + 2, n3);
    }

    public void setPixel3D(int n, int n2, int n3) {
        if (n < 0 || n >= this.iWidth || n2 < 0 || n2 >= this.iHeight) {
            return;
        }
        int n4 = this.iWidth * n2 + n;
        if (n3 < this.aiActiveZBuffer[n4]) {
            this.aiActiveFrameBuffer[n4] = this.color;
            this.aiActiveZBuffer[n4] = n3;
        }
    }

    protected final void drawLineStrip3D(Point3f[] point3fArray) {
        int n = 0;
        while (n < point3fArray.length - 1) {
            this.drawLine3D(point3fArray[n], point3fArray[++n]);
        }
    }

    public final void drawLine3D(Point3f point3f, Point3f point3f2) {
        int n = (int)point3f.x;
        int n2 = (int)point3f.y;
        int n3 = (int)point3f2.x;
        int n4 = (int)point3f2.y;
        int n5 = (int)(point3f.z * 65536.0f);
        int n6 = (int)(point3f2.z * 65536.0f);
        this.drawLine3D(n, n2, n5, n3, n4, n6);
    }

    public final void drawGhostLine3D(Point3f point3f, Point3f point3f2, int n) {
        int n2 = (int)point3f.x;
        int n3 = (int)point3f.y;
        int n4 = (int)point3f2.x;
        int n5 = (int)point3f2.y;
        int n6 = (int)(point3f.z * 65536.0f);
        int n7 = (int)(point3f2.z * 65536.0f);
        this.drawGhostLine3D(n2, n3, n6, n4, n5, n7, n);
    }

    public final void drawLine3D(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 0 && n4 < 0 || n2 < 0 && n5 < 0 || n >= this.iWidth && n4 >= this.iWidth || n2 >= this.iHeight && n5 >= this.iHeight) {
            return;
        }
        int n7 = n4 - n;
        int n8 = n5 - n2;
        int n9 = n6 - n3;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (Math.abs(n7) > Math.abs(n8)) {
            int n10;
            int n11;
            int n12;
            int n13;
            if (n7 > 0) {
                n13 = n;
                n12 = n2 << 32784;
                n11 = n3;
                n8 = (n8 << 16) / n7;
                n9 /= n7;
                n10 = n4 < this.iWidth ? n4 : this.iWidth;
            } else {
                n13 = n4;
                n12 = n5 << 32784;
                n11 = n6;
                n8 = (n8 << 16) / n7;
                n9 /= n7;
                int n14 = n10 = n < this.iWidth ? n : this.iWidth;
            }
            if (n13 < 0) {
                n12 -= n8 * n13;
                n11 -= n9 * n13;
                n13 = 0;
            }
            int n15 = this.iHeight << 16;
            while (n13 < n10) {
                int n16;
                if (n12 >= 0 && n12 < n15 && n11 <= this.aiActiveZBuffer[n16 = this.iWidth * (n12 >> 16) + n13]) {
                    this.aiActiveFrameBuffer[n16] = this.color;
                    this.aiActiveZBuffer[n16] = n11;
                }
                ++n13;
                n12 += n8;
                n11 += n9;
            }
        } else {
            int n17;
            int n18;
            int n19;
            int n20;
            if (n8 > 0) {
                n20 = n2;
                n19 = n << 32784;
                n18 = n3;
                n7 = (n7 << 16) / n8;
                n9 /= n8;
                n17 = n5 < this.iHeight ? n5 : this.iHeight;
            } else {
                n20 = n5;
                n19 = n4 << 32784;
                n18 = n6;
                n7 = (n7 << 16) / n8;
                n9 /= n8;
                int n21 = n17 = n2 < this.iHeight ? n2 : this.iHeight;
            }
            if (n20 < 0) {
                n19 -= n7 * n20;
                n18 -= n9 * n20;
                n20 = 0;
            }
            int n22 = this.iWidth << 16;
            while (n20 < n17) {
                int n23;
                if (n19 >= 0 && n19 < n22 && n18 < this.aiActiveZBuffer[n23 = this.iWidth * n20 + (n19 >> 16)]) {
                    this.aiActiveFrameBuffer[n23] = this.color;
                    this.aiActiveZBuffer[n23] = n18;
                }
                ++n20;
                n19 += n7;
                n18 += n9;
            }
        }
    }

    public final void drawGhostLine3D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = (this.color & 0xFF0000) * (255 - n7) >> 8 & 0xFF0000 | (this.color & 0xFF00) * (255 - n7) >> 8 & 0xFF00 | (this.color & 0xFF) * (255 - n7) >> 8 & 0xFF;
        if (n < 0 && n4 < 0 || n2 < 0 && n5 < 0 || n >= this.iWidth && n4 >= this.iWidth || n2 >= this.iHeight && n5 >= this.iHeight) {
            return;
        }
        int n9 = n4 - n;
        int n10 = n5 - n2;
        int n11 = n6 - n3;
        if (n9 == 0 && n10 == 0) {
            return;
        }
        if (Math.abs(n9) > Math.abs(n10)) {
            int n12;
            int n13;
            int n14;
            int n15;
            if (n9 > 0) {
                n15 = n;
                n14 = n2 << 32784;
                n13 = n3;
                n10 = (n10 << 16) / n9;
                n11 /= n9;
                n12 = n4 < this.iWidth ? n4 : this.iWidth;
            } else {
                n15 = n4;
                n14 = n5 << 32784;
                n13 = n6;
                n10 = (n10 << 16) / n9;
                n11 /= n9;
                int n16 = n12 = n < this.iWidth ? n : this.iWidth;
            }
            if (n15 < 0) {
                n14 -= n10 * n15;
                n13 -= n11 * n15;
                n15 = 0;
            }
            int n17 = this.iHeight << 16;
            while (n15 < n12) {
                if (n14 >= 0 && n14 < n17) {
                    int n18 = this.iWidth * (n14 >> 16) + n15;
                    if (n13 <= this.aiActiveZBuffer[n18]) {
                        this.aiActiveFrameBuffer[n18] = this.color;
                        this.aiActiveZBuffer[n18] = n13;
                    } else {
                        int n19 = this.aiActiveFrameBuffer[n18];
                        this.aiActiveFrameBuffer[n18] = ((n19 & 0xFF0000) * n7 >> 8 & 0xFF0000 | (n19 & 0xFF00) * n7 >> 8 & 0xFF00 | (n19 & 0xFF) * n7 >> 8 & 0xFF) + n8;
                    }
                }
                ++n15;
                n14 += n10;
                n13 += n11;
            }
        } else {
            int n20;
            int n21;
            int n22;
            int n23;
            if (n10 > 0) {
                n23 = n2;
                n22 = n << 32784;
                n21 = n3;
                n9 = (n9 << 16) / n10;
                n11 /= n10;
                n20 = n5 < this.iHeight ? n5 : this.iHeight;
            } else {
                n23 = n5;
                n22 = n4 << 32784;
                n21 = n6;
                n9 = (n9 << 16) / n10;
                n11 /= n10;
                int n24 = n20 = n2 < this.iHeight ? n2 : this.iHeight;
            }
            if (n23 < 0) {
                n22 -= n9 * n23;
                n21 -= n11 * n23;
                n23 = 0;
            }
            int n25 = this.iWidth << 16;
            while (n23 < n20) {
                if (n22 >= 0 && n22 < n25) {
                    int n26 = this.iWidth * n23 + (n22 >> 16);
                    if (n21 < this.aiActiveZBuffer[n26]) {
                        this.aiActiveFrameBuffer[n26] = this.color;
                        this.aiActiveZBuffer[n26] = n21;
                    } else {
                        int n27 = this.aiActiveFrameBuffer[n26];
                        this.aiActiveFrameBuffer[n26] = ((n27 & 0xFF0000) * n7 >> 8 & 0xFF0000 | (n27 & 0xFF00) * n7 >> 8 & 0xFF00 | (n27 & 0xFF) * n7 >> 8 & 0xFF) + n8;
                    }
                }
                ++n23;
                n22 += n9;
                n21 += n11;
            }
        }
    }

    public final void drawRect(int n, int n2, int n3, int n4) {
        this.drawLine(n, n2, n3, n2);
        this.drawLine(n3, n2, n3, n4);
        this.drawLine(n3, n4, n, n4);
        this.drawLine(n, n4, n, n2);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        if (n < 0 && n3 < 0 || n2 < 0 && n4 < 0 || n >= this.iWidth && n3 >= this.iWidth || n2 >= this.iHeight && n4 >= this.iHeight) {
            return;
        }
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 == 0 && n6 == 0) {
            return;
        }
        if (Math.abs(n5) > Math.abs(n6)) {
            int n7;
            int n8;
            int n9;
            if (n5 > 0) {
                n9 = n;
                n8 = n2 << 32784;
                n6 = (n6 << 16) / n5;
                n7 = n3 < this.iWidth ? n3 : this.iWidth;
            } else {
                n9 = n3;
                n8 = n4 << 32784;
                n6 = (n6 << 16) / n5;
                int n10 = n7 = n < this.iWidth ? n : this.iWidth;
            }
            if (n9 < 0) {
                n8 -= n6 * n9;
                n9 = 0;
            }
            int n11 = this.iHeight << 16;
            while (n9 < n7) {
                if (n8 >= 0 && n8 < n11) {
                    int n12 = this.iWidth * (n8 >> 16) + n9;
                    this.aiActiveFrameBuffer[n12] = this.color;
                }
                ++n9;
                n8 += n6;
            }
        } else {
            int n13;
            int n14;
            int n15;
            if (n6 > 0) {
                n15 = n2;
                n14 = n << 32784;
                n5 = (n5 << 16) / n6;
                n13 = n4 < this.iHeight ? n4 : this.iHeight;
            } else {
                n15 = n4;
                n14 = n3 << 32784;
                n5 = (n5 << 16) / n6;
                int n16 = n13 = n2 < this.iHeight ? n2 : this.iHeight;
            }
            if (n15 < 0) {
                n14 -= n5 * n15;
                n15 = 0;
            }
            int n17 = this.iWidth << 16;
            while (n15 < n13) {
                if (n14 >= 0 && n14 < n17) {
                    int n18 = this.iWidth * n15 + (n14 >> 16);
                    this.aiActiveFrameBuffer[n18] = this.color;
                }
                ++n15;
                n14 += n5;
            }
        }
    }

    protected final void xorLine(int n, int n2, int n3, int n4, int n5) {
        if (n < 0 && n3 < 0 || n2 < 0 && n4 < 0 || n >= this.iWidth && n3 >= this.iWidth || n2 >= this.iHeight && n4 >= this.iHeight) {
            return;
        }
        int n6 = n3 - n;
        int n7 = n4 - n2;
        if (n6 == 0 && n7 == 0) {
            return;
        }
        if (Math.abs(n6) > Math.abs(n7)) {
            int n8;
            int n9;
            int n10;
            if (n6 > 0) {
                n10 = n;
                n9 = n2 << 32784;
                n7 = (n7 << 16) / n6;
                n8 = n3 < this.iWidth ? n3 : this.iWidth;
            } else {
                n10 = n3;
                n9 = n4 << 32784;
                n7 = (n7 << 16) / n6;
                int n11 = n8 = n < this.iWidth ? n : this.iWidth;
            }
            if (n10 < 0) {
                n9 -= n7 * n10;
                n10 = 0;
            }
            int n12 = this.iHeight << 16;
            while (n10 < n8) {
                if (n9 >= 0 && n9 < n12) {
                    int n13;
                    int n14 = n13 = this.iWidth * (n9 >> 16) + n10;
                    this.aiActiveFrameBuffer[n14] = this.aiActiveFrameBuffer[n14] ^ n5;
                }
                ++n10;
                n9 += n7;
            }
        } else {
            int n15;
            int n16;
            int n17;
            if (n7 > 0) {
                n17 = n2;
                n16 = n << 32784;
                n6 = (n6 << 16) / n7;
                n15 = n4 < this.iHeight ? n4 : this.iHeight;
            } else {
                n17 = n4;
                n16 = n3 << 32784;
                n6 = (n6 << 16) / n7;
                int n18 = n15 = n2 < this.iHeight ? n2 : this.iHeight;
            }
            if (n17 < 0) {
                n16 -= n6 * n17;
                n17 = 0;
            }
            int n19 = this.iWidth << 16;
            while (n17 < n15) {
                if (n16 >= 0 && n16 < n19) {
                    int n20;
                    int n21 = n20 = this.iWidth * n17 + (n16 >> 16);
                    this.aiActiveFrameBuffer[n21] = this.aiActiveFrameBuffer[n21] ^ n5;
                }
                ++n17;
                n16 += n6;
            }
        }
    }

    protected final void drawHLine(int n, int n2) {
        if (n < 0 || n >= this.iHeight) {
            return;
        }
        int n3 = n * this.iHeight;
        int n4 = 0;
        while (n4 < this.iHeight) {
            this.aiActiveFrameBuffer[n3] = n2;
            ++n4;
            ++n3;
        }
    }

    protected final void drawVLine(int n, int n2) {
        if (n < 0 || n >= this.iWidth) {
            return;
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < this.iWidth) {
            this.aiActiveFrameBuffer[n3] = n2;
            ++n4;
            n3 += this.iWidth;
        }
    }

    protected final void setPixel(int n, int n2, int n3) {
        this.aiActiveFrameBuffer[n + n2 * this.iWidth] = n3;
    }

    private final void draw3DTriangleGourad(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        int n33;
        int n34;
        int n35;
        int n36;
        int n37;
        int n38;
        int n39;
        int n40;
        int n41;
        int n42;
        int n43;
        int n44;
        int n45;
        int n46;
        int n47;
        int n48;
        int[] nArray = this.aiActiveFrameBuffer;
        int[] nArray2 = this.aiActiveZBuffer;
        int n49 = n10 & 0xFF0000;
        int n50 = (n10 & 0xFF00) << 8;
        int n51 = (n10 & 0xFF) << 16;
        int n52 = n11 & 0xFF0000;
        int n53 = (n11 & 0xFF00) << 8;
        int n54 = (n11 & 0xFF) << 16;
        int n55 = n12 & 0xFF0000;
        int n56 = (n12 & 0xFF00) << 8;
        int n57 = (n12 & 0xFF) << 16;
        int n58 = n4 - n;
        int n59 = n5 - n2;
        int n60 = n6 - n3;
        int n61 = n52 - n49;
        int n62 = n53 - n50;
        int n63 = n54 - n51;
        int n64 = n7 - n;
        int n65 = n8 - n2;
        int n66 = n9 - n3;
        int n67 = n55 - n49;
        int n68 = n56 - n50;
        int n69 = n57 - n51;
        int n70 = n7 - n4;
        int n71 = n8 - n5;
        int n72 = n9 - n6;
        int n73 = n55 - n52;
        int n74 = n56 - n53;
        int n75 = n57 - n54;
        int n76 = 0;
        int n77 = 0;
        int n78 = 0;
        int n79 = 0;
        int n80 = 0;
        int n81 = 0;
        int n82 = 0;
        int n83 = 0;
        int n84 = 0;
        int n85 = 0;
        int n86 = 0;
        int n87 = 0;
        int n88 = 0;
        int n89 = 0;
        int n90 = 0;
        if (n65 <= 0) {
            return;
        }
        if (n59 > 0) {
            n76 = (int)(((long)n58 << 16) / (long)n59);
            n77 = (int)(((long)n60 << 16) / (long)n59);
            n78 = (int)(((long)n61 << 16) / (long)n59);
            n79 = (int)(((long)n62 << 16) / (long)n59);
            n80 = (int)(((long)n63 << 16) / (long)n59);
        }
        n81 = (int)(((long)n64 << 16) / (long)n65);
        n82 = (int)(((long)n66 << 16) / (long)n65);
        n83 = (int)(((long)n67 << 16) / (long)n65);
        n84 = (int)(((long)n68 << 16) / (long)n65);
        n85 = (int)(((long)n69 << 16) / (long)n65);
        if (n71 > 0) {
            n86 = (int)(((long)n70 << 16) / (long)n71);
            n87 = (int)(((long)n72 << 16) / (long)n71);
            n88 = (int)(((long)n73 << 16) / (long)n71);
            n89 = (int)(((long)n74 << 16) / (long)n71);
            n90 = (int)(((long)n75 << 16) / (long)n71);
        }
        int n91 = 65536 - (n2 & (char)-1);
        int n92 = 65536 - (n8 & (char)-1);
        int n93 = n2 >> 16;
        int n94 = n5 >> 16;
        int n95 = n8 >> 16;
        int n96 = n93;
        int n97 = 0;
        if (n94 >= 0) {
            n97 = n94 >= this.iHeight ? this.iHeight - 1 : n94;
        }
        int n98 = n97;
        int n99 = n95;
        if (n96 < n98) {
            if (n76 < n81) {
                n48 = n76;
                n47 = n77;
                n46 = n78;
                n45 = n79;
                n44 = n80;
                n43 = n81;
                n42 = n82;
                n41 = n83;
                n40 = n84;
                n39 = n85;
            } else {
                n48 = n81;
                n47 = n82;
                n46 = n83;
                n45 = n84;
                n44 = n85;
                n43 = n76;
                n42 = n77;
                n41 = n78;
                n40 = n79;
                n39 = n80;
            }
            n38 = n + (int)((long)n48 * (long)n91 >> 16);
            n37 = n3 + (int)((long)n47 * (long)n91 >> 16);
            n36 = n49 + (int)((long)n46 * (long)n91 >> 16);
            n35 = n50 + (int)((long)n45 * (long)n91 >> 16);
            n34 = n51 + (int)((long)n44 * (long)n91 >> 16);
            n33 = n + (int)((long)n43 * (long)n91 >> 16);
            n32 = n3 + (int)((long)n42 * (long)n91 >> 16);
            n31 = n49 + (int)((long)n41 * (long)n91 >> 16);
            n30 = n50 + (int)((long)n40 * (long)n91 >> 16);
            n29 = n51 + (int)((long)n39 * (long)n91 >> 16);
            if (n96 < 0) {
                n38 -= n48 * n96;
                n37 -= n47 * n96;
                n36 -= n46 * n96;
                n35 -= n45 * n96;
                n34 -= n44 * n96;
                n33 -= n43 * n96;
                n32 -= n42 * n96;
                n31 -= n41 * n96;
                n30 -= n40 * n96;
                n29 -= n39 * n96;
                n96 = 0;
            }
            n28 = n96;
            while (n28 < n98) {
                n27 = n38 >> 16;
                n26 = n33 >> 16;
                if (n27 < n26) {
                    n25 = (int)(((long)(n32 - n37) << 16) / (long)(n33 - n38));
                    n24 = (int)(((long)(n31 - n36) << 16) / (long)(n33 - n38));
                    n23 = (int)(((long)(n30 - n35) << 16) / (long)(n33 - n38));
                    n22 = (int)(((long)(n29 - n34) << 16) / (long)(n33 - n38));
                    n21 = 65536 - (n38 & (char)-1);
                    n20 = n37 + (int)((long)n25 * (long)n21 >> 16);
                    n19 = n36 + (int)((long)n24 * (long)n21 >> 24);
                    n18 = n35 + (int)((long)n23 * (long)n21 >> 24);
                    n17 = n34 + (int)((long)n22 * (long)n21 >> 24);
                    int n100 = 0;
                    if (n27 >= 0) {
                        n100 = n27;
                    }
                    n16 = n100;
                    int n101 = n15 = n26 > this.iWidth ? this.iWidth : n26;
                    if (n27 < 0) {
                        n20 -= n25 * n27;
                        n19 -= n24 * n27;
                        n18 -= n23 * n27;
                        n17 -= n22 * n27;
                    }
                    n14 = n28 * this.iWidth + n16;
                    n13 = n16;
                    while (n13 < n15) {
                        if (n20 < nArray2[n14]) {
                            nArray[n14] = 0xFF000000 | n19 & 0xFF0000 | (n18 & 0xFF0000) >> 8 | (n17 & 0xFF0000) >> 16;
                            nArray2[n14] = n20;
                        }
                        n20 += n25;
                        n19 += n24;
                        n18 += n23;
                        n17 += n22;
                        ++n14;
                        ++n13;
                    }
                }
                n38 += n48;
                n37 += n47;
                n36 += n46;
                n35 += n45;
                n34 += n44;
                n33 += n43;
                n32 += n42;
                n31 += n41;
                n30 += n40;
                n29 += n39;
                ++n28;
            }
        }
        if (n99 > n98) {
            if (n81 > n86) {
                n48 = n81;
                n47 = n82;
                n46 = n83;
                n45 = n84;
                n44 = n85;
                n43 = n86;
                n42 = n87;
                n41 = n88;
                n40 = n89;
                n39 = n90;
            } else {
                n48 = n86;
                n47 = n87;
                n46 = n88;
                n45 = n89;
                n44 = n90;
                n43 = n81;
                n42 = n82;
                n41 = n83;
                n40 = n84;
                n39 = n85;
            }
            n38 = n7 + (int)((long)n48 * (long)n92 >> 16);
            n37 = n9 + (int)((long)n47 * (long)n92 >> 16);
            n36 = n55 + (int)((long)n46 * (long)n92 >> 16);
            n35 = n56 + (int)((long)n45 * (long)n92 >> 16);
            n34 = n57 + (int)((long)n44 * (long)n92 >> 16);
            n33 = n7 + (int)((long)n43 * (long)n92 >> 16);
            n32 = n9 + (int)((long)n42 * (long)n92 >> 16);
            n31 = n55 + (int)((long)n41 * (long)n92 >> 16);
            n30 = n56 + (int)((long)n40 * (long)n92 >> 16);
            n29 = n57 + (int)((long)n39 * (long)n92 >> 16);
            if (n99 >= this.iHeight) {
                n28 = n99 - this.iHeight + 1;
                n38 -= n48 * n28;
                n37 -= n47 * n28;
                n36 -= n46 * n28;
                n35 -= n45 * n28;
                n34 -= n44 * n28;
                n33 -= n43 * n28;
                n32 -= n43 * n28;
                n31 -= n41 * n28;
                n30 -= n40 * n28;
                n29 -= n39 * n28;
                n99 = this.iHeight - 1;
            }
            n28 = n99;
            while (n28 >= n98) {
                n27 = n38 >> 16;
                n26 = n33 >> 16;
                if (n27 < n26) {
                    n25 = (int)(((long)(n32 - n37) << 16) / (long)(n33 - n38));
                    n24 = (int)(((long)(n31 - n36) << 16) / (long)(n33 - n38));
                    n23 = (int)(((long)(n30 - n35) << 16) / (long)(n33 - n38));
                    n22 = (int)(((long)(n29 - n34) << 16) / (long)(n33 - n38));
                    n21 = 65536 - (n38 & (char)-1);
                    n20 = n37 + (int)((long)n25 * (long)n21 >> 16);
                    n19 = n36 + (int)((long)n24 * (long)n21 >> 24);
                    n18 = n35 + (int)((long)n23 * (long)n21 >> 24);
                    n17 = n34 + (int)((long)n22 * (long)n21 >> 24);
                    int n102 = 0;
                    if (n27 >= 0) {
                        n102 = n27;
                    }
                    n16 = n102;
                    int n103 = n15 = n26 > this.iWidth ? this.iWidth : n26;
                    if (n27 < 0) {
                        n20 -= n25 * n27;
                        n19 -= n24 * n27;
                        n18 -= n23 * n27;
                        n17 -= n22 * n27;
                    }
                    n14 = n28 * this.iWidth + n16;
                    n13 = n16;
                    while (n13 < n15) {
                        if (n20 < nArray2[n14]) {
                            nArray[n14] = 0xFF000000 | n19 & 0xFF0000 | (n18 & 0xFF0000) >> 8 | (n17 & 0xFF0000) >> 16;
                            nArray2[n14] = n20;
                        }
                        n20 += n25;
                        n19 += n24;
                        n18 += n23;
                        n17 += n22;
                        ++n14;
                        ++n13;
                    }
                }
                n38 -= n48;
                n37 -= n47;
                n36 -= n46;
                n35 -= n45;
                n34 -= n44;
                n33 -= n43;
                n32 -= n42;
                n31 -= n41;
                n30 -= n40;
                n29 -= n39;
                --n28;
            }
        }
    }

    public final void draw3DTriangleFlat(Point3f point3f, Point3f point3f2, Point3f point3f3, int n) {
        if ((point3f2.x - point3f.x) * (point3f3.y - point3f.y) - (point3f2.y - point3f.y) * (point3f3.x - point3f.x) > 0.0f) {
            if (this.bCulling) {
                return;
            }
            if (this.bMark) {
                n ^= 0xFFFFFF;
            }
        }
        int n2 = (int)(point3f.x * 65536.0f);
        int n3 = (int)(point3f.y * 65536.0f);
        int n4 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
        int n5 = (int)(point3f2.x * 65536.0f);
        int n6 = (int)(point3f2.y * 65536.0f);
        int n7 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
        int n8 = (int)(point3f3.x * 65536.0f);
        int n9 = (int)(point3f3.y * 65536.0f);
        int n10 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
        if (n3 < n6) {
            if (n6 < n9) {
                this.draw3DTriangleFlat(n2, n3, n4, n5, n6, n7, n8, n9, n10, n);
            } else if (n3 < n9) {
                this.draw3DTriangleFlat(n2, n3, n4, n8, n9, n10, n5, n6, n7, n);
            } else {
                this.draw3DTriangleFlat(n8, n9, n10, n2, n3, n4, n5, n6, n7, n);
            }
        } else if (n3 < n9) {
            this.draw3DTriangleFlat(n5, n6, n7, n2, n3, n4, n8, n9, n10, n);
        } else if (n6 < n9) {
            this.draw3DTriangleFlat(n5, n6, n7, n8, n9, n10, n2, n3, n4, n);
        } else {
            this.draw3DTriangleFlat(n8, n9, n10, n5, n6, n7, n2, n3, n4, n);
        }
    }

    public final void draw3DTriangleGourad(Point3f point3f, Point3f point3f2, Point3f point3f3, int n, int n2, int n3) {
        if ((point3f2.x - point3f.x) * (point3f3.y - point3f.y) - (point3f2.y - point3f.y) * (point3f3.x - point3f.x) > 0.0f) {
            if (ZBufferRenderer.settings.iBackfaceMode == 1) {
                return;
            }
            if (ZBufferRenderer.settings.iBackfaceMode == 2) {
                this.draw3DTriangleFlat(point3f, point3f2, point3f3, ZBufferRenderer.settings.iBackfaceColor);
                return;
            }
        }
        int n4 = (int)(point3f.x * 65536.0f);
        int n5 = (int)(point3f.y * 65536.0f);
        int n6 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
        int n7 = (int)(point3f2.x * 65536.0f);
        int n8 = (int)(point3f2.y * 65536.0f);
        int n9 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
        int n10 = (int)(point3f3.x * 65536.0f);
        int n11 = (int)(point3f3.y * 65536.0f);
        int n12 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
        if (n5 < n8) {
            if (n8 < n11) {
                this.draw3DTriangleGourad(n4, n5, n6, n7, n8, n9, n10, n11, n12, n, n2, n3);
            } else if (n5 < n11) {
                this.draw3DTriangleGourad(n4, n5, n6, n10, n11, n12, n7, n8, n9, n, n3, n2);
            } else {
                this.draw3DTriangleGourad(n10, n11, n12, n4, n5, n6, n7, n8, n9, n3, n, n2);
            }
        } else if (n5 < n11) {
            this.draw3DTriangleGourad(n7, n8, n9, n4, n5, n6, n10, n11, n12, n2, n, n3);
        } else if (n8 < n11) {
            this.draw3DTriangleGourad(n7, n8, n9, n10, n11, n12, n4, n5, n6, n2, n3, n);
        } else {
            this.draw3DTriangleGourad(n10, n11, n12, n7, n8, n9, n4, n5, n6, n3, n2, n);
        }
    }

    private final void draw3DTriangleFlat(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int[] nArray = this.aiActiveFrameBuffer;
        int[] nArray2 = this.aiActiveZBuffer;
        int n29 = n4 - n;
        int n30 = n5 - n2;
        int n31 = n6 - n3;
        int n32 = n7 - n;
        int n33 = n8 - n2;
        int n34 = n9 - n3;
        int n35 = n7 - n4;
        int n36 = n8 - n5;
        int n37 = n9 - n6;
        int n38 = 0;
        int n39 = 0;
        int n40 = 0;
        int n41 = 0;
        int n42 = 0;
        int n43 = 0;
        if (n33 <= 0) {
            return;
        }
        if (n30 > 0) {
            n38 = (int)(((long)n29 << 16) / (long)n30);
            n39 = (int)(((long)n31 << 16) / (long)n30);
        }
        n40 = (int)(((long)n32 << 16) / (long)n33);
        n41 = (int)(((long)n34 << 16) / (long)n33);
        if (n36 > 0) {
            n42 = (int)(((long)n35 << 16) / (long)n36);
            n43 = (int)(((long)n37 << 16) / (long)n36);
        }
        int n44 = 65536 - (n2 & (char)-1);
        int n45 = 65536 - (n8 & (char)-1);
        int n46 = n2 >> 16;
        int n47 = n5 >> 16;
        int n48 = n8 >> 16;
        int n49 = n46;
        int n50 = 0;
        if (n47 >= 0) {
            n50 = n47 >= this.iHeight ? this.iHeight - 1 : n47;
        }
        int n51 = n50;
        int n52 = n48;
        if (n49 < n51) {
            if (n38 < n40) {
                n28 = n38;
                n27 = n39;
                n26 = n40;
                n25 = n41;
            } else {
                n28 = n40;
                n27 = n41;
                n26 = n38;
                n25 = n39;
            }
            n24 = n + (int)((long)n28 * (long)n44 >> 16);
            n23 = n3 + (int)((long)n27 * (long)n44 >> 16);
            n22 = n + (int)((long)n26 * (long)n44 >> 16);
            n21 = n3 + (int)((long)n25 * (long)n44 >> 16);
            if (n49 < 0) {
                n24 -= n28 * n49;
                n23 -= n27 * n49;
                n22 -= n26 * n49;
                n21 -= n25 * n49;
                n49 = 0;
            }
            n20 = n49;
            while (n20 < n51) {
                n19 = n24 >> 16;
                n18 = n22 >> 16;
                if (n19 < n18) {
                    n17 = (int)(((long)(n21 - n23) << 16) / (long)(n22 - n24));
                    n16 = 65536 - (n24 & (char)-1);
                    n15 = n23 + (int)((long)n17 * (long)n16 >> 16);
                    int n53 = 0;
                    if (n19 >= 0) {
                        n53 = n19;
                    }
                    n14 = n53;
                    int n54 = n13 = n18 > this.iWidth ? this.iWidth : n18;
                    if (n19 < 0) {
                        n15 -= n17 * n19;
                    }
                    n12 = n20 * this.iWidth + n14;
                    n11 = n14;
                    while (n11 < n13) {
                        if (n15 < nArray2[n12]) {
                            nArray[n12] = n10;
                            nArray2[n12] = n15;
                        }
                        n15 += n17;
                        ++n12;
                        ++n11;
                    }
                }
                n24 += n28;
                n23 += n27;
                n22 += n26;
                n21 += n25;
                ++n20;
            }
        }
        if (n52 > n51) {
            if (n40 > n42) {
                n28 = n40;
                n27 = n41;
                n26 = n42;
                n25 = n43;
            } else {
                n28 = n42;
                n27 = n43;
                n26 = n40;
                n25 = n41;
            }
            n24 = n7 + (int)((long)n28 * (long)n45 >> 16);
            n23 = n9 + (int)((long)n27 * (long)n45 >> 16);
            n22 = n7 + (int)((long)n26 * (long)n45 >> 16);
            n21 = n9 + (int)((long)n25 * (long)n45 >> 16);
            if (n52 >= this.iHeight) {
                n20 = n52 - this.iHeight + 1;
                n24 -= n28 * n20;
                n23 -= n27 * n20;
                n22 -= n26 * n20;
                n21 -= n25 * n20;
                n52 = this.iHeight - 1;
            }
            n20 = n52;
            while (n20 >= n51) {
                n19 = n24 >> 16;
                n18 = n22 >> 16;
                if (n19 < n18) {
                    n17 = (int)(((long)(n21 - n23) << 16) / (long)(n22 - n24));
                    n16 = 65536 - (n24 & (char)-1);
                    n15 = n23 + (int)((long)n17 * (long)n16 >> 16);
                    int n55 = 0;
                    if (n19 >= 0) {
                        n55 = n19;
                    }
                    n14 = n55;
                    int n56 = n13 = n18 > this.iWidth ? this.iWidth : n18;
                    if (n19 < 0) {
                        n15 -= n17 * n19;
                    }
                    n12 = n20 * this.iWidth + n14;
                    n11 = n14;
                    while (n11 < n13) {
                        if (n15 < nArray2[n12]) {
                            nArray[n12] = n10;
                            nArray2[n12] = n15;
                        }
                        n15 += n17;
                        ++n12;
                        ++n11;
                    }
                }
                n24 -= n28;
                n23 -= n27;
                n22 -= n26;
                n21 -= n25;
                --n20;
            }
        }
    }

    public final void draw3DTriangleFlatOld(Point3f point3f, Point3f point3f2, Point3f point3f3, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        if (point3f.y <= point3f2.y && point3f.y <= point3f3.y) {
            n21 = (int)point3f.x << 16;
            n20 = (int)point3f.y;
            n19 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            if (point3f2.y < point3f3.y) {
                n18 = (int)point3f2.x << 16;
                n17 = (int)point3f2.y;
                n16 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n15 = (int)point3f3.x << 16;
                n14 = (int)point3f3.y;
                n13 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n18 = (int)point3f3.x << 16;
                n17 = (int)point3f3.y;
                n16 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n15 = (int)point3f2.x << 16;
                n14 = (int)point3f2.y;
                n13 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            }
        } else if (point3f2.y <= point3f.y && point3f2.y <= point3f3.y) {
            n21 = (int)point3f2.x << 16;
            n20 = (int)point3f2.y;
            n19 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            if (point3f.y < point3f3.y) {
                n18 = (int)point3f.x << 16;
                n17 = (int)point3f.y;
                n16 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n15 = (int)point3f3.x << 16;
                n14 = (int)point3f3.y;
                n13 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n18 = (int)point3f3.x << 16;
                n17 = (int)point3f3.y;
                n16 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n15 = (int)point3f.x << 16;
                n14 = (int)point3f.y;
                n13 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            }
        } else {
            n21 = (int)point3f3.x << 16;
            n20 = (int)point3f3.y;
            n19 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            if (point3f.y < point3f2.y) {
                n18 = (int)point3f.x << 16;
                n17 = (int)point3f.y;
                n16 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n15 = (int)point3f2.x << 16;
                n14 = (int)point3f2.y;
                n13 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n18 = (int)point3f2.x << 16;
                n17 = (int)point3f2.y;
                n16 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n15 = (int)point3f.x << 16;
                n14 = (int)point3f.y;
                n13 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            }
        }
        int n22 = n15 - n21;
        int n23 = n14 - n20;
        int n24 = n13 - n19;
        if (n23 == 0) {
            return;
        }
        int n25 = n18 - n21;
        int n26 = n17 - n20;
        int n27 = n16 - n19;
        int n28 = n22 / n23;
        int n29 = n24 / n23;
        int n30 = n12 = n21;
        int n31 = n11 = n19;
        int n32 = n20;
        if (n26 != 0) {
            n10 = n25 / n26;
            n9 = n27 / n26;
            if (n17 < 0) {
                n30 += n28 * n26;
                n12 += n10 * n26;
                n31 += n29 * n26;
                n11 += n9 * n26;
                n32 = n17;
            } else if (n32 < 0) {
                n30 -= n28 * n32;
                n12 -= n10 * n32;
                n31 -= n29 * n32;
                n11 -= n9 * n32;
                n32 = 0;
            }
            n8 = n17 < this.iHeight ? n17 : this.iHeight;
            n7 = n32 * this.iWidth;
            while (n32 < n8) {
                if (n30 < n12) {
                    n6 = n30 >> 16;
                    n5 = n12 >> 16;
                    n4 = n31;
                    n3 = n11 - n31;
                } else {
                    n6 = n12 >> 16;
                    n5 = n30 >> 16;
                    n4 = n11;
                    n3 = n31 - n11;
                }
                if (n6 != n5) {
                    n3 /= n5 - n6;
                    if (n6 < 0) {
                        n4 -= n6 * n3;
                        n6 = 0;
                    }
                    if (n5 > this.iWidth) {
                        n5 = this.iWidth;
                    }
                    n2 = n6;
                    while (n2 < n5) {
                        if (n4 < this.aiActiveZBuffer[n7 + n2]) {
                            this.aiActiveZBuffer[n7 + n2] = n4;
                            this.aiActiveFrameBuffer[n7 + n2] = n;
                        }
                        n4 += n3;
                        ++n2;
                    }
                }
                n30 += n28;
                n31 += n29;
                n12 += n10;
                n11 += n9;
                n7 += this.iWidth;
                ++n32;
            }
        }
        n25 = n15 - n18;
        n26 = n14 - n17;
        n27 = n13 - n16;
        if (n26 != 0) {
            n10 = n25 / n26;
            n9 = n27 / n26;
            n12 = n18;
            n11 = n16;
            if (n32 < 0) {
                n30 -= n28 * n32;
                n12 -= n10 * n32;
                n31 -= n29 * n32;
                n11 -= n9 * n32;
                n32 = 0;
            }
            n8 = n14 < this.iHeight ? n14 : this.iHeight;
            n7 = n32 * this.iWidth;
            while (n32 < n8) {
                if (n30 < n12) {
                    n6 = n30 >> 16;
                    n5 = n12 >> 16;
                    n4 = n31;
                    n3 = n11 - n31;
                } else {
                    n6 = n12 >> 16;
                    n5 = n30 >> 16;
                    n4 = n11;
                    n3 = n31 - n11;
                }
                if (n6 != n5) {
                    n3 /= n5 - n6;
                    if (n6 < 0) {
                        n4 -= n6 * n3;
                        n6 = 0;
                    }
                    if (n5 > this.iWidth) {
                        n5 = this.iWidth;
                    }
                    n2 = n6;
                    while (n2 < n5) {
                        if (n4 < this.aiActiveZBuffer[n7 + n2]) {
                            this.aiActiveZBuffer[n7 + n2] = n4;
                            this.aiActiveFrameBuffer[n7 + n2] = n;
                        }
                        n4 += n3;
                        ++n2;
                    }
                }
                n30 += n28;
                n31 += n29;
                n12 += n10;
                n11 += n9;
                n7 += this.iWidth;
                ++n32;
            }
        }
    }

    protected final void draw3DTriangleFlatGhost(Point3f point3f, Point3f point3f2, Point3f point3f3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24 = (n & 0xFF0000) * (255 - n2) >> 8 & 0xFF0000 | (n & 0xFF00) * (255 - n2) >> 8 & 0xFF00 | (n & 0xFF) * (255 - n2) >> 8 & 0xFF;
        if (point3f.y <= point3f2.y && point3f.y <= point3f3.y) {
            n23 = (int)point3f.x << 16;
            n22 = (int)point3f.y;
            n21 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            if (point3f2.y < point3f3.y) {
                n20 = (int)point3f2.x << 16;
                n19 = (int)point3f2.y;
                n18 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n17 = (int)point3f3.x << 16;
                n16 = (int)point3f3.y;
                n15 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n20 = (int)point3f3.x << 16;
                n19 = (int)point3f3.y;
                n18 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n17 = (int)point3f2.x << 16;
                n16 = (int)point3f2.y;
                n15 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            }
        } else if (point3f2.y <= point3f.y && point3f2.y <= point3f3.y) {
            n23 = (int)point3f2.x << 16;
            n22 = (int)point3f2.y;
            n21 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            if (point3f.y < point3f3.y) {
                n20 = (int)point3f.x << 16;
                n19 = (int)point3f.y;
                n18 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n17 = (int)point3f3.x << 16;
                n16 = (int)point3f3.y;
                n15 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n20 = (int)point3f3.x << 16;
                n19 = (int)point3f3.y;
                n18 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n17 = (int)point3f.x << 16;
                n16 = (int)point3f.y;
                n15 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            }
        } else {
            n23 = (int)point3f3.x << 16;
            n22 = (int)point3f3.y;
            n21 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            if (point3f.y < point3f2.y) {
                n20 = (int)point3f.x << 16;
                n19 = (int)point3f.y;
                n18 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n17 = (int)point3f2.x << 16;
                n16 = (int)point3f2.y;
                n15 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n20 = (int)point3f2.x << 16;
                n19 = (int)point3f2.y;
                n18 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n17 = (int)point3f.x << 16;
                n16 = (int)point3f.y;
                n15 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            }
        }
        int n25 = n17 - n23;
        int n26 = n16 - n22;
        int n27 = n15 - n21;
        if (n26 == 0) {
            return;
        }
        int n28 = n20 - n23;
        int n29 = n19 - n22;
        int n30 = n18 - n21;
        int n31 = n25 / n26;
        int n32 = n27 / n26;
        int n33 = n14 = n23;
        int n34 = n13 = n21;
        int n35 = n22;
        if (n29 != 0) {
            n12 = n28 / n29;
            n11 = n30 / n29;
            if (n19 < 0) {
                n33 += n31 * n29;
                n14 += n12 * n29;
                n34 += n32 * n29;
                n13 += n11 * n29;
                n35 = n19;
            } else if (n35 < 0) {
                n33 -= n31 * n35;
                n14 -= n12 * n35;
                n34 -= n32 * n35;
                n13 -= n11 * n35;
                n35 = 0;
            }
            n10 = n19 < this.iHeight ? n19 : this.iHeight;
            n9 = n35 * this.iWidth;
            while (n35 < n10) {
                if (n33 < n14) {
                    n8 = n33 >> 16;
                    n7 = n14 >> 16;
                    n6 = n34;
                    n5 = n13 - n34;
                } else {
                    n8 = n14 >> 16;
                    n7 = n33 >> 16;
                    n6 = n13;
                    n5 = n34 - n13;
                }
                if (n8 != n7) {
                    n5 /= n7 - n8;
                    if (n8 < 0) {
                        n6 -= n8 * n5;
                        n8 = 0;
                    }
                    if (n7 > this.iWidth) {
                        n7 = this.iWidth;
                    }
                    n4 = n8;
                    while (n4 < n7) {
                        if (n6 < this.aiActiveZBuffer[n9 + n4]) {
                            this.aiActiveZBuffer[n9 + n4] = n6;
                            this.aiActiveFrameBuffer[n9 + n4] = n;
                        } else {
                            n3 = this.aiActiveFrameBuffer[n9 + n4];
                            this.aiActiveFrameBuffer[n9 + n4] = ((n3 & 0xFF0000) * n2 >> 8 & 0xFF0000 | (n3 & 0xFF00) * n2 >> 8 & 0xFF00 | (n3 & 0xFF) * n2 >> 8 & 0xFF) + n24;
                        }
                        n6 += n5;
                        ++n4;
                    }
                }
                n33 += n31;
                n34 += n32;
                n14 += n12;
                n13 += n11;
                n9 += this.iWidth;
                ++n35;
            }
        }
        n28 = n17 - n20;
        n29 = n16 - n19;
        n30 = n15 - n18;
        if (n29 != 0) {
            n12 = n28 / n29;
            n11 = n30 / n29;
            n14 = n20;
            n13 = n18;
            if (n35 < 0) {
                n33 -= n31 * n35;
                n14 -= n12 * n35;
                n34 -= n32 * n35;
                n13 -= n11 * n35;
                n35 = 0;
            }
            n10 = n16 < this.iHeight ? n16 : this.iHeight;
            n9 = n35 * this.iWidth;
            while (n35 < n10) {
                if (n33 < n14) {
                    n8 = n33 >> 16;
                    n7 = n14 >> 16;
                    n6 = n34;
                    n5 = n13 - n34;
                } else {
                    n8 = n14 >> 16;
                    n7 = n33 >> 16;
                    n6 = n13;
                    n5 = n34 - n13;
                }
                if (n8 != n7) {
                    n5 /= n7 - n8;
                    if (n8 < 0) {
                        n6 -= n8 * n5;
                        n8 = 0;
                    }
                    if (n7 > this.iWidth) {
                        n7 = this.iWidth;
                    }
                    n4 = n8;
                    while (n4 < n7) {
                        if (n6 < this.aiActiveZBuffer[n9 + n4]) {
                            this.aiActiveZBuffer[n9 + n4] = n6;
                            this.aiActiveFrameBuffer[n9 + n4] = n;
                        } else {
                            n3 = this.aiActiveFrameBuffer[n9 + n4];
                            this.aiActiveFrameBuffer[n9 + n4] = ((n3 & 0xFF0000) * n2 >> 8 & 0xFF0000 | (n3 & 0xFF00) * n2 >> 8 & 0xFF00 | (n3 & 0xFF) * n2 >> 8 & 0xFF) + n24;
                        }
                        n6 += n5;
                        ++n4;
                    }
                }
                n33 += n31;
                n34 += n32;
                n14 += n12;
                n13 += n11;
                n9 += this.iWidth;
                ++n35;
            }
        }
    }

    protected final void draw3DTriangleFlatTransparent(Point3f point3f, Point3f point3f2, Point3f point3f3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27 = 255 - n2;
        int n28 = ((n & 0xFF0000) * n27 & 0xFF000000) >> 8;
        int n29 = ((n & 0xFF00) * n27 & 0xFF0000) >> 8;
        int n30 = ((n & 0xFF) * n27 & 0xFF00) >> 8;
        if (point3f.y <= point3f2.y && point3f.y <= point3f3.y) {
            n26 = (int)point3f.x << 16;
            n25 = (int)point3f.y;
            n24 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            if (point3f2.y < point3f3.y) {
                n23 = (int)point3f2.x << 16;
                n22 = (int)point3f2.y;
                n21 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n20 = (int)point3f3.x << 16;
                n19 = (int)point3f3.y;
                n18 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n23 = (int)point3f3.x << 16;
                n22 = (int)point3f3.y;
                n21 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n20 = (int)point3f2.x << 16;
                n19 = (int)point3f2.y;
                n18 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            }
        } else if (point3f2.y <= point3f.y && point3f2.y <= point3f3.y) {
            n26 = (int)point3f2.x << 16;
            n25 = (int)point3f2.y;
            n24 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            if (point3f.y < point3f3.y) {
                n23 = (int)point3f.x << 16;
                n22 = (int)point3f.y;
                n21 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n20 = (int)point3f3.x << 16;
                n19 = (int)point3f3.y;
                n18 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n23 = (int)point3f3.x << 16;
                n22 = (int)point3f3.y;
                n21 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n20 = (int)point3f.x << 16;
                n19 = (int)point3f.y;
                n18 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            }
        } else {
            n26 = (int)point3f3.x << 16;
            n25 = (int)point3f3.y;
            n24 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            if (point3f.y < point3f2.y) {
                n23 = (int)point3f.x << 16;
                n22 = (int)point3f.y;
                n21 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n20 = (int)point3f2.x << 16;
                n19 = (int)point3f2.y;
                n18 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            } else {
                n23 = (int)point3f2.x << 16;
                n22 = (int)point3f2.y;
                n21 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n20 = (int)point3f.x << 16;
                n19 = (int)point3f.y;
                n18 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            }
        }
        int n31 = n20 - n26;
        int n32 = n19 - n25;
        int n33 = n18 - n24;
        if (n32 == 0) {
            return;
        }
        int n34 = n23 - n26;
        int n35 = n22 - n25;
        int n36 = n21 - n24;
        int n37 = n31 / n32;
        int n38 = n33 / n32;
        int n39 = n17 = n26;
        int n40 = n16 = n24;
        int n41 = n25;
        if (n35 != 0) {
            n15 = n34 / n35;
            n14 = n36 / n35;
            if (n22 < 0) {
                n39 += n37 * n35;
                n17 += n15 * n35;
                n40 += n38 * n35;
                n16 += n14 * n35;
                n41 = n22;
            } else if (n41 < 0) {
                n39 -= n37 * n41;
                n17 -= n15 * n41;
                n40 -= n38 * n41;
                n16 -= n14 * n41;
                n41 = 0;
            }
            n13 = n22 < this.iHeight ? n22 : this.iHeight;
            n12 = n41 * this.iWidth;
            while (n41 < n13) {
                if (n39 < n17) {
                    n11 = n39 >> 16;
                    n10 = n17 >> 16;
                    n9 = n40;
                    n8 = n16 - n40;
                } else {
                    n11 = n17 >> 16;
                    n10 = n39 >> 16;
                    n9 = n16;
                    n8 = n40 - n16;
                }
                if (n11 != n10) {
                    n8 /= n10 - n11;
                    if (n11 < 0) {
                        n9 -= n11 * n8;
                        n11 = 0;
                    }
                    if (n10 > this.iWidth) {
                        n10 = this.iWidth;
                    }
                    n7 = n11;
                    while (n7 < n10) {
                        if (n9 < this.aiActiveZBuffer[n12 + n7]) {
                            n6 = this.aiActiveFrameBuffer[n12 + n7];
                            n5 = ((n6 & 0xFF0000) * n2 >> 8) + n28 & 0xFF0000;
                            n4 = ((n6 & 0xFF00) * n2 >> 8) + n29 & 0xFF00;
                            n3 = ((n6 & 0xFF) * n2 >> 8) + n30 & 0xFF;
                            this.aiActiveFrameBuffer[n12 + n7] = 0xFF000000 | n5 | n4 | n3;
                        }
                        n9 += n8;
                        ++n7;
                    }
                }
                n39 += n37;
                n40 += n38;
                n17 += n15;
                n16 += n14;
                n12 += this.iWidth;
                ++n41;
            }
        }
        n34 = n20 - n23;
        n35 = n19 - n22;
        n36 = n18 - n21;
        if (n35 != 0) {
            n15 = n34 / n35;
            n14 = n36 / n35;
            n17 = n23;
            n16 = n21;
            if (n41 < 0) {
                n39 -= n37 * n41;
                n17 -= n15 * n41;
                n40 -= n38 * n41;
                n16 -= n14 * n41;
                n41 = 0;
            }
            n13 = n19 < this.iHeight ? n19 : this.iHeight;
            n12 = n41 * this.iWidth;
            while (n41 < n13) {
                if (n39 < n17) {
                    n11 = n39 >> 16;
                    n10 = n17 >> 16;
                    n9 = n40;
                    n8 = n16 - n40;
                } else {
                    n11 = n17 >> 16;
                    n10 = n39 >> 16;
                    n9 = n16;
                    n8 = n40 - n16;
                }
                if (n11 != n10) {
                    n8 /= n10 - n11;
                    if (n11 < 0) {
                        n9 -= n11 * n8;
                        n11 = 0;
                    }
                    if (n10 > this.iWidth) {
                        n10 = this.iWidth;
                    }
                    n7 = n11;
                    while (n7 < n10) {
                        if (n9 < this.aiActiveZBuffer[n12 + n7]) {
                            n6 = this.aiActiveFrameBuffer[n12 + n7];
                            n5 = ((n6 & 0xFF0000) * n2 >> 8) + n28 & 0xFF0000;
                            n4 = ((n6 & 0xFF00) * n2 >> 8) + n29 & 0xFF00;
                            n3 = ((n6 & 0xFF) * n2 >> 8) + n30 & 0xFF;
                            this.aiActiveFrameBuffer[n12 + n7] = 0xFF000000 | n5 | n4 | n3;
                        }
                        n9 += n8;
                        ++n7;
                    }
                }
                n39 += n37;
                n40 += n38;
                n17 += n15;
                n16 += n14;
                n12 += this.iWidth;
                ++n41;
            }
        }
    }

    protected final void draw3DTriangleGouradTransparent(Point3f point3f, Point3f point3f2, Point3f point3f3, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        int n33;
        int n34;
        int n35;
        int n36;
        int n37;
        int n38;
        int n39;
        int n40;
        int n41;
        int n42;
        int n43;
        int n44;
        int n45;
        int n46;
        int n47;
        int n48;
        int n49;
        if (this.bCulling && (point3f2.x - point3f.x) * (point3f3.y - point3f.y) - (point3f2.y - point3f.y) * (point3f3.x - point3f.x) > 0.0f) {
            return;
        }
        int n50 = 255 - n4;
        if (point3f.y <= point3f2.y && point3f.y <= point3f3.y) {
            n49 = (int)(point3f.x * 65536.0f);
            n48 = (int)point3f.y;
            n47 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
            n46 = (n & 0xFF0000) >> 8;
            n45 = n & 0xFF00;
            n44 = (n & 0xFF) << 8;
            if (point3f2.y < point3f3.y) {
                n43 = (int)(point3f2.x * 65536.0f);
                n42 = (int)point3f2.y;
                n41 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n40 = (n2 & 0xFF0000) >> 8;
                n39 = n2 & 0xFF00;
                n38 = (n2 & 0xFF) << 8;
                n37 = (int)(point3f3.x * 65536.0f);
                n36 = (int)point3f3.y;
                n35 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n34 = (n3 & 0xFF0000) >> 8;
                n33 = n3 & 0xFF00;
                n32 = (n3 & 0xFF) << 8;
            } else {
                n43 = (int)(point3f3.x * 65536.0f);
                n42 = (int)point3f3.y;
                n41 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n40 = (n3 & 0xFF0000) >> 8;
                n39 = n3 & 0xFF00;
                n38 = (n3 & 0xFF) << 8;
                n37 = (int)(point3f2.x * 65536.0f);
                n36 = (int)point3f2.y;
                n35 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n34 = (n2 & 0xFF0000) >> 8;
                n33 = n2 & 0xFF00;
                n32 = (n2 & 0xFF) << 8;
            }
        } else if (point3f2.y <= point3f.y && point3f2.y <= point3f3.y) {
            n49 = (int)(point3f2.x * 65536.0f);
            n48 = (int)point3f2.y;
            n47 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
            n46 = (n2 & 0xFF0000) >> 8;
            n45 = n2 & 0xFF00;
            n44 = (n2 & 0xFF) << 8;
            if (point3f.y < point3f3.y) {
                n43 = (int)(point3f.x * 65536.0f);
                n42 = (int)point3f.y;
                n41 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n40 = (n & 0xFF0000) >> 8;
                n39 = n & 0xFF00;
                n38 = (n & 0xFF) << 8;
                n37 = (int)(point3f3.x * 65536.0f);
                n36 = (int)point3f3.y;
                n35 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n34 = (n3 & 0xFF0000) >> 8;
                n33 = n3 & 0xFF00;
                n32 = (n3 & 0xFF) << 8;
            } else {
                n43 = (int)(point3f3.x * 65536.0f);
                n42 = (int)point3f3.y;
                n41 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
                n40 = (n3 & 0xFF0000) >> 8;
                n39 = n3 & 0xFF00;
                n38 = (n3 & 0xFF) << 8;
                n37 = (int)(point3f.x * 65536.0f);
                n36 = (int)point3f.y;
                n35 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n34 = (n & 0xFF0000) >> 8;
                n33 = n & 0xFF00;
                n32 = (n & 0xFF) << 8;
            }
        } else {
            n49 = (int)(point3f3.x * 65536.0f);
            n48 = (int)point3f3.y;
            n47 = (int)((point3f3.z + this.fPolygonOffset) * 65536.0f);
            n46 = (n3 & 0xFF0000) >> 8;
            n45 = n3 & 0xFF00;
            n44 = (n3 & 0xFF) << 8;
            if (point3f.y < point3f2.y) {
                n43 = (int)(point3f.x * 65536.0f);
                n42 = (int)point3f.y;
                n41 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n40 = (n & 0xFF0000) >> 8;
                n39 = n & 0xFF00;
                n38 = (n & 0xFF) << 8;
                n37 = (int)(point3f2.x * 65536.0f);
                n36 = (int)point3f2.y;
                n35 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n34 = (n2 & 0xFF0000) >> 8;
                n33 = n2 & 0xFF00;
                n32 = (n2 & 0xFF) << 8;
            } else {
                n43 = (int)(point3f2.x * 65536.0f);
                n42 = (int)point3f2.y;
                n41 = (int)((point3f2.z + this.fPolygonOffset) * 65536.0f);
                n40 = (n2 & 0xFF0000) >> 8;
                n39 = n2 & 0xFF00;
                n38 = (n2 & 0xFF) << 8;
                n37 = (int)(point3f.x * 65536.0f);
                n36 = (int)point3f.y;
                n35 = (int)((point3f.z + this.fPolygonOffset) * 65536.0f);
                n34 = (n & 0xFF0000) >> 8;
                n33 = n & 0xFF00;
                n32 = (n & 0xFF) << 8;
            }
        }
        int n51 = n37 - n49;
        int n52 = n36 - n48;
        int n53 = n35 - n47;
        int n54 = n34 - n46;
        int n55 = n33 - n45;
        int n56 = n32 - n44;
        if (n52 == 0) {
            return;
        }
        int n57 = n43 - n49;
        int n58 = n42 - n48;
        int n59 = n41 - n47;
        int n60 = n40 - n46;
        int n61 = n39 - n45;
        int n62 = n38 - n44;
        int n63 = n51 / n52;
        int n64 = n53 / n52;
        int n65 = n54 / n52;
        int n66 = n55 / n52;
        int n67 = n56 / n52;
        int n68 = n31 = n49;
        int n69 = n30 = n47;
        int n70 = n29 = n46;
        int n71 = n28 = n45;
        int n72 = n27 = n44;
        int n73 = n48;
        if (n58 != 0) {
            n26 = n57 / n58;
            n25 = n59 / n58;
            n24 = n60 / n58;
            n23 = n61 / n58;
            n22 = n62 / n58;
            if (n42 < 0) {
                n68 += n63 * n58;
                n31 += n26 * n58;
                n69 += n64 * n58;
                n30 += n25 * n58;
                n70 += n65 * n58;
                n29 += n24 * n58;
                n71 += n66 * n58;
                n28 += n23 * n58;
                n72 += n67 * n58;
                n27 += n22 * n58;
                n73 = n42;
            } else if (n73 < 0) {
                n68 -= n63 * n73;
                n31 -= n26 * n73;
                n69 -= n64 * n73;
                n30 -= n25 * n73;
                n70 -= n65 * n73;
                n29 -= n24 * n73;
                n71 -= n66 * n73;
                n28 -= n23 * n73;
                n72 -= n67 * n73;
                n27 -= n22 * n73;
                n73 = 0;
            }
            n21 = n42 < this.iHeight ? n42 : this.iHeight;
            n20 = n73 * this.iWidth;
            while (n73 < n21) {
                if (n68 < n31) {
                    n19 = n68 >> 16;
                    n18 = n31 >> 16;
                    n17 = n69;
                    n16 = n30 - n69;
                    n15 = n70;
                    n14 = n29 - n70;
                    n13 = n71;
                    n12 = n28 - n71;
                    n11 = n72;
                    n10 = n27 - n72;
                } else {
                    n19 = n31 >> 16;
                    n18 = n68 >> 16;
                    n17 = n30;
                    n16 = n69 - n30;
                    n15 = n29;
                    n14 = n70 - n29;
                    n13 = n28;
                    n12 = n71 - n28;
                    n11 = n27;
                    n10 = n72 - n27;
                }
                if (n19 != n18) {
                    n16 /= n18 - n19;
                    n14 /= n18 - n19;
                    n12 /= n18 - n19;
                    n10 /= n18 - n19;
                    if (n19 < 0) {
                        n17 -= n19 * n16;
                        n15 -= n19 * n14;
                        n13 -= n19 * n12;
                        n11 -= n19 * n10;
                        n19 = 0;
                    }
                    if (n18 > this.iWidth) {
                        n18 = this.iWidth;
                    }
                    n9 = n19;
                    while (n9 < n18) {
                        if (n17 < this.aiActiveZBuffer[n20 + n9]) {
                            n8 = this.aiActiveFrameBuffer[n20 + n9];
                            n7 = (n8 & 0xFF0000) * n4 >> 8 & 0xFF0000;
                            n6 = (n8 & 0xFF00) * n4 >> 8 & 0xFF00;
                            n5 = (n8 & 0xFF) * n4 >> 8 & 0xFF;
                            this.aiActiveFrameBuffer[n20 + n9] = 0xFF000000 | (n7 += n15 * n50 & 0xFF0000) | (n6 += (n13 * n50 & 0xFF0000) >> 8) | (n5 += (n11 * n50 & 0xFF0000) >> 16);
                        }
                        n17 += n16;
                        n15 += n14;
                        n13 += n12;
                        n11 += n10;
                        ++n9;
                    }
                }
                n68 += n63;
                n69 += n64;
                n70 += n65;
                n71 += n66;
                n72 += n67;
                n31 += n26;
                n30 += n25;
                n29 += n24;
                n28 += n23;
                n27 += n22;
                n20 += this.iWidth;
                ++n73;
            }
        }
        n57 = n37 - n43;
        n58 = n36 - n42;
        n59 = n35 - n41;
        n60 = n34 - n40;
        n61 = n33 - n39;
        n62 = n32 - n38;
        if (n58 != 0) {
            n26 = n57 / n58;
            n25 = n59 / n58;
            n24 = n60 / n58;
            n23 = n61 / n58;
            n22 = n62 / n58;
            n31 = n43;
            n30 = n41;
            n29 = n40;
            n28 = n39;
            n27 = n38;
            if (n73 < 0) {
                n68 -= n63 * n73;
                n31 -= n26 * n73;
                n69 -= n64 * n73;
                n30 -= n25 * n73;
                n70 -= n65 * n73;
                n29 -= n24 * n73;
                n71 -= n66 * n73;
                n28 -= n23 * n73;
                n72 -= n67 * n73;
                n27 -= n22 * n73;
                n73 = 0;
            }
            n21 = n36 < this.iHeight ? n36 : this.iHeight;
            n20 = n73 * this.iWidth;
            while (n73 < n21) {
                if (n68 < n31) {
                    n19 = n68 >> 16;
                    n18 = n31 >> 16;
                    n17 = n69;
                    n16 = n30 - n69;
                    n15 = n70;
                    n14 = n29 - n70;
                    n13 = n71;
                    n12 = n28 - n71;
                    n11 = n72;
                    n10 = n27 - n72;
                } else {
                    n19 = n31 >> 16;
                    n18 = n68 >> 16;
                    n17 = n30;
                    n16 = n69 - n30;
                    n15 = n29;
                    n14 = n70 - n29;
                    n13 = n28;
                    n12 = n71 - n28;
                    n11 = n27;
                    n10 = n72 - n27;
                }
                if (n19 != n18) {
                    n16 /= n18 - n19;
                    n14 /= n18 - n19;
                    n12 /= n18 - n19;
                    n10 /= n18 - n19;
                    if (n19 < 0) {
                        n17 -= n19 * n16;
                        n15 -= n19 * n14;
                        n13 -= n19 * n12;
                        n11 -= n19 * n10;
                        n19 = 0;
                    }
                    if (n18 > this.iWidth) {
                        n18 = this.iWidth;
                    }
                    n9 = n19;
                    while (n9 < n18) {
                        if (n17 < this.aiActiveZBuffer[n20 + n9]) {
                            n8 = this.aiActiveFrameBuffer[n20 + n9];
                            n7 = (n8 & 0xFF0000) * n4 >> 8 & 0xFF0000;
                            n6 = (n8 & 0xFF00) * n4 >> 8 & 0xFF00;
                            n5 = (n8 & 0xFF) * n4 >> 8 & 0xFF;
                            this.aiActiveFrameBuffer[n20 + n9] = 0xFF000000 | (n7 += n15 * n50 & 0xFF0000) | (n6 += (n13 * n50 & 0xFF0000) >> 8) | (n5 += (n11 * n50 & 0xFF0000) >> 16);
                        }
                        n17 += n16;
                        n15 += n14;
                        n13 += n12;
                        n11 += n10;
                        ++n9;
                    }
                }
                n68 += n63;
                n69 += n64;
                n70 += n65;
                n71 += n66;
                n72 += n67;
                n31 += n26;
                n30 += n25;
                n29 += n24;
                n28 += n23;
                n27 += n22;
                n20 += this.iWidth;
                ++n73;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.iMaxZ = Integer.MAX_VALUE;
        this.fPolygonOffset = 2.0f;
        this.v3dt = new Vector3f();
        this.v3ds = new Vector3f();
        this.bDirectRendering = false;
        this.bBackfaceNormalFlip = false;
        this.bCulling = false;
        this.bMark = false;
    }

    public ZBufferRenderer(Lighting lighting) {
        this.this();
        ZBufferRenderer.init();
        this.lighting = lighting;
    }

    static {
        settings = JPatchSettings.getInstance();
    }
}

