/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import jpatch.boundary.JPatchCanvas;
import jpatch.boundary.MainFrame;
import jpatch.boundary.Viewport;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.Model;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ViewDefinition
implements ComponentListener {
    public static final int FRONT = 1;
    public static final int REAR = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int LEFT = 5;
    public static final int RIGHT = 6;
    public static final int BIRDS_EYE = 7;
    public static final String[] aViewName = new String[]{"", "front view", "rear view", "top view", "bottom view", "left view", "right view", "bird's eye view"};
    public static final int[] aiGridPlane;
    private Viewport viewport;
    private int iView;
    private float fRotateX;
    private float fRotateY;
    private float fTranslateX;
    private float fTranslateY;
    private float fScale;
    private float fZ;
    private boolean bRenderPoints;
    private boolean bRenderCurves;
    private boolean bRenderPatches;
    private boolean bRenderBezierCPs;
    private boolean bShowRotoscope;
    private boolean bAlwaysUseZBuffer;
    private ControlPoint cpTangentHandles;
    private Vector4f v4Screen;
    private Vector4f v4ScreenOffset;
    private Matrix4f m4View;
    private float fWidth;
    private float fHeight;
    private boolean bVisible;
    private Point3f p3Lock;

    private final void setGridPlane() {
        this.viewport.getGrid().setPlane(aiGridPlane[this.iView]);
    }

    public final void componentHidden(ComponentEvent componentEvent) {
        this.bVisible = false;
    }

    public final void componentMoved(ComponentEvent componentEvent) {
    }

    public final void componentResized(ComponentEvent componentEvent) {
        this.computeMatrix();
    }

    public final void componentShown(ComponentEvent componentEvent) {
        this.bVisible = true;
    }

    public final void setViewport(Viewport viewport) {
        this.viewport = viewport;
        viewport.addComponentListener(this);
        this.setView(this.iView);
        this.setGridPlane();
    }

    public final Matrix4f getMatrix() {
        return this.m4View;
    }

    public final Matrix4f getScreenMatrix() {
        return this.m4View;
    }

    public final float getRotateX() {
        return this.fRotateX;
    }

    public final float getRotateY() {
        return this.fRotateY;
    }

    public final float getTranslateX() {
        return this.fTranslateX;
    }

    public final float getTranslateY() {
        return this.fTranslateY;
    }

    public final void setTranslation(float f, float f2) {
        this.fTranslateX = f;
        this.fTranslateY = f2;
    }

    public final float getScale() {
        return this.fScale;
    }

    public final void setScale(float f) {
        this.fScale = f;
    }

    public final void setLock(Point3f point3f) {
        this.p3Lock = point3f;
        if (this.p3Lock != null) {
            Point3f point3f2 = new Point3f(this.p3Lock);
            this.m4View.transform(point3f2);
            float f = this.getWidth() / 2.0f;
            float f2 = this.getHeight() / 2.0f;
            this.moveView(-point3f2.x / f + 1.0f, (f2 - point3f2.y) / f, false);
        }
        this.viewport.render();
    }

    public final float getWidth() {
        return this.viewport.getWidth();
    }

    public final float getHeight() {
        return this.viewport.getHeight();
    }

    public final int getView() {
        return this.iView;
    }

    public final String getViewName() {
        return aViewName[this.iView];
    }

    public final boolean alwaysUseZBuffer() {
        return this.bAlwaysUseZBuffer;
    }

    public final void alwaysUseZBuffer(boolean bl) {
        this.bAlwaysUseZBuffer = bl;
    }

    public final boolean renderPoints() {
        return this.bRenderPoints;
    }

    public final boolean renderCurves() {
        return this.bRenderCurves;
    }

    public final boolean renderPatches() {
        return this.bRenderPatches;
    }

    public final boolean renderBezierCPs() {
        return this.bRenderBezierCPs;
    }

    public final boolean showRotoscope() {
        return this.bShowRotoscope;
    }

    public final boolean isLocked() {
        boolean bl = false;
        if (this.p3Lock != null) {
            bl = true;
        }
        return bl;
    }

    public final void renderPoints(boolean bl) {
        this.bRenderPoints = bl;
    }

    public final void renderCurves(boolean bl) {
        this.bRenderCurves = bl;
    }

    public final void renderPatches(boolean bl) {
        this.bRenderPatches = bl;
    }

    public final void renderBezierCPs(boolean bl) {
        this.bRenderBezierCPs = bl;
    }

    public final void showRotoscope(boolean bl) {
        this.bShowRotoscope = bl;
    }

    public final void setTangentHandles(ControlPoint controlPoint) {
        this.cpTangentHandles = controlPoint;
    }

    public final ControlPoint getTangentHandles() {
        return this.cpTangentHandles;
    }

    public final void computeMatrix() {
        switch (this.iView) {
            case 1: {
                this.m4View.set(new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case 2: {
                this.m4View.set(new Matrix4f(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case 6: {
                this.m4View.set(new Matrix4f(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case 5: {
                this.m4View.set(new Matrix4f(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case 4: {
                this.m4View.set(new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case 3: {
                this.m4View.set(new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case 7: {
                this.m4View.set(new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.rotX(this.fRotateX);
                this.m4View.mul(matrix4f);
                matrix4f.rotY(this.fRotateY);
                this.m4View.mul(matrix4f);
                break;
            }
        }
        this.m4View.setScale(this.fScale);
        this.m4View.setTranslation(new Vector3f(this.fTranslateX * this.fScale, this.fTranslateY * this.fScale, 0.0f));
        float f = this.viewport.getWidth();
        float f2 = this.viewport.getHeight();
        float f3 = f;
        Matrix4f matrix4f = new Matrix4f();
        this.m4View.mul(f3 / 2.0f);
        this.m4View.setRow(3, 0.0f, 0.0f, 0.0f, 1.0f);
        this.m4View.getColumn(3, this.v4Screen);
        this.v4ScreenOffset = new Vector4f(f / 2.0f, f2 / 2.0f, 0.0f, 0.0f);
        this.v4Screen.add(this.v4ScreenOffset);
        this.m4View.setColumn(3, this.v4Screen);
    }

    public final void setView(int n) {
        this.iView = n;
        switch (this.iView) {
            case 1: {
                this.fRotateX = 0.0f;
                this.fRotateY = 0.0f;
                break;
            }
            case 2: {
                this.fRotateX = 0.0f;
                this.fRotateY = (float)Math.PI;
                break;
            }
            case 5: {
                this.fRotateX = 0.0f;
                this.fRotateY = -1.5707964f;
                break;
            }
            case 6: {
                this.fRotateX = 0.0f;
                this.fRotateY = 1.5707964f;
                break;
            }
            case 3: {
                this.fRotateX = -1.5707964f;
                this.fRotateY = 0.0f;
                break;
            }
            case 4: {
                this.fRotateX = 1.5707964f;
                this.fRotateY = 0.0f;
                break;
            }
            case 7: {
                this.fRotateX = -0.7853982f;
                this.fRotateY = 0.7853982f;
                break;
            }
        }
        this.p3Lock = null;
        this.computeMatrix();
        this.setGridPlane();
    }

    public final void moveView(float f, float f2) {
        this.moveView(f, f2, true);
    }

    public final void moveView(float f, float f2, boolean bl) {
        this.fTranslateX += f / this.fScale;
        this.fTranslateY += f2 / this.fScale;
        this.computeMatrix();
        ((JPatchCanvas)this.viewport).clearBackground();
        if (bl) {
            this.viewport.render();
        }
    }

    public final void rotateView(float f, float f2) {
        this.iView = 7;
        this.fRotateX -= f2;
        this.fRotateY -= f;
        if ((double)this.fRotateX < -1.5707963267948966) {
            this.fRotateX = -1.5707964f;
        }
        if ((double)this.fRotateX > 1.5707963267948966) {
            this.fRotateX = 1.5707964f;
        }
        this.viewport.getGrid().setPlane(0);
        if (this.p3Lock != null) {
            this.computeMatrix();
            Point3f point3f = new Point3f(this.p3Lock);
            this.m4View.transform(point3f);
            float f3 = this.getWidth() / 2.0f;
            float f4 = this.getHeight() / 2.0f;
            this.moveView(-point3f.x / f3 + 1.0f, (f4 - point3f.y) / f3, false);
        }
        this.computeMatrix();
        ((JPatchCanvas)this.viewport).clearBackground();
        this.viewport.render();
    }

    public final void scaleView(float f) {
        this.fScale *= f;
        this.computeMatrix();
        ((JPatchCanvas)this.viewport).clearBackground();
        this.viewport.render();
    }

    public final void repaint() {
        this.viewport.render();
    }

    public final void reset() {
        ((JPatchCanvas)this.viewport).updateImage();
    }

    public final Point get2DPosition(Point3f point3f) {
        Point3f point3f2 = new Point3f(point3f);
        this.getScreenMatrix().transform(point3f2);
        return new Point((int)point3f2.x, (int)point3f2.y);
    }

    public final void setZ(Point3f point3f) {
        Point3f point3f2 = new Point3f(point3f);
        this.getScreenMatrix().transform(point3f2);
        this.fZ = point3f2.z;
    }

    public final void setZ(float f) {
        this.fZ = f;
    }

    public final Point3f get3DPosition(float f, float f2) {
        Point3f point3f = new Point3f(f, f2, this.fZ);
        Matrix4f matrix4f = this.getScreenMatrix();
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.invert(matrix4f);
        matrix4f2.transform(point3f);
        return point3f;
    }

    public final ControlPoint getClosestControlPoint(Point2D.Float float_, ControlPoint controlPoint) {
        return this.getClosestControlPoint(float_, controlPoint, null);
    }

    public final ControlPoint getClosestControlPoint(Point2D.Float float_, ControlPoint controlPoint, float[] fArray) {
        return this.getClosestControlPoint(float_, controlPoint, fArray, false);
    }

    public final ControlPoint getClosestControlPoint(Point2D.Float float_, ControlPoint controlPoint, float[] fArray, boolean bl) {
        return this.getClosestControlPoint(float_, controlPoint, fArray, bl, false);
    }

    public final ControlPoint getClosestControlPoint(Point2D.Float float_, ControlPoint controlPoint, float[] fArray, boolean bl, boolean bl2) {
        return this.getClosestControlPoint(float_, controlPoint, fArray, bl, bl2, null);
    }

    public final ControlPoint getClosestControlPoint(Point2D.Float float_, ControlPoint controlPoint, float[] fArray, boolean bl, boolean bl2, ControlPoint controlPoint2) {
        float f;
        Point2D.Float float_2;
        Object object;
        if (bl2 && this.viewport.getGrid().snap()) {
            object = new Point3f(float_.x, float_.y, 0.0f);
            Matrix4f matrix4f = new Matrix4f(this.getScreenMatrix());
            matrix4f.invert();
            matrix4f.transform((Point3f)object);
            this.viewport.getGrid().correctVector((Tuple3f)object);
            this.getScreenMatrix().transform((Point3f)object);
            float_2 = new Point2D.Float(((Point3f)object).x, ((Point3f)object).y);
        } else {
            float_2 = float_;
        }
        float f2 = -1.0f;
        ControlPoint controlPoint3 = controlPoint != null ? controlPoint.getHead() : null;
        Model model = MainFrame.getInstance().getModel();
        Matrix4f matrix4f = this.getScreenMatrix();
        Point3f point3f = new Point3f();
        Point2D.Float float_3 = new Point2D.Float();
        float f3 = 64.0f;
        float f4 = 256.0f;
        float f5 = 16.0f;
        if (controlPoint2 != null) {
            point3f.set(controlPoint2.getPosition());
            matrix4f.transform(point3f);
            float_3.setLocation(point3f.x, point3f.y);
            f = (float)float_3.distanceSq(float_2);
            if (f <= f5) {
                return controlPoint2;
            }
        }
        Object object2 = null;
        Curve curve = model.getFirstCurve();
        while (curve != null) {
            object = curve.getStart();
            if (bl && ((ControlPoint)object).getHookPos() != 0.0f && ((ControlPoint)object).getHookPos() != 1.0f || ((ControlPoint)object).getHookPos() == -1.0f) {
                while (object != null) {
                    if (!((ControlPoint)object).isHidden()) {
                        if (((ControlPoint)object).isHead()) {
                            point3f.set(((ControlPoint)object).getPosition());
                            matrix4f.transform(point3f);
                            float_3.setLocation(point3f.x, point3f.y);
                            f = (float)float_3.distanceSq(float_2);
                            if (f <= f3 && object != controlPoint3) {
                                f3 = f;
                                object2 = object;
                                f2 = -1.0f;
                            }
                        }
                        if (fArray != null && f3 == 64.0f && ((ControlPoint)object).getNext() != null) {
                            int n = 0;
                            while (n < 3) {
                                point3f.set(((ControlPoint)object).getHookPosition(n));
                                matrix4f.transform(point3f);
                                float_3.setLocation(point3f.x, point3f.y);
                                f = (float)float_3.distanceSq(float_2);
                                if (f <= f4 && object != controlPoint3) {
                                    f4 = f;
                                    object2 = object;
                                    f2 = ControlPoint.HOOKPOS[n];
                                }
                                ++n;
                            }
                        }
                    }
                    object = ((ControlPoint)object).getNextCheckNextLoop();
                }
            }
            curve = curve.getNext();
        }
        if (fArray != null) {
            fArray[0] = f2;
        }
        return object2;
    }

    private final /* synthetic */ void this() {
        this.fRotateX = 0.0f;
        this.fRotateY = 0.0f;
        this.fTranslateX = 0.0f;
        this.fTranslateY = 0.0f;
        this.fScale = 0.03f;
        this.fZ = 0.0f;
        this.bRenderPoints = true;
        this.bRenderCurves = true;
        this.bRenderPatches = false;
        this.bRenderBezierCPs = false;
        this.bShowRotoscope = true;
        this.bAlwaysUseZBuffer = false;
        this.cpTangentHandles = null;
        this.v4Screen = new Vector4f();
        this.v4ScreenOffset = new Vector4f();
        this.m4View = new Matrix4f();
    }

    public ViewDefinition(int n) {
        this.this();
        this.iView = n;
    }

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 3;
        aiGridPlane = nArray;
    }
}

