/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import jpatch.auxilary.XMLutils;
import jpatch.boundary.JPatchCanvas;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.ViewDefinition;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Rotoscope {
    private BufferedImage originalRGBImage;
    private BufferedImage filteredRGBImage;
    private int iOpacity;
    private float fXPosition;
    private float fYPosition;
    private float fScale;
    private AffineTransform affineTransform;
    private String strFilename;
    private boolean bValid;

    public final boolean isValid() {
        return this.bValid;
    }

    public final int getPixelWidth() {
        return this.originalRGBImage.getWidth();
    }

    public final int getPixelHeight() {
        return this.originalRGBImage.getHeight();
    }

    public final float getScale() {
        return this.fScale;
    }

    public final float getXPosition() {
        return this.fXPosition;
    }

    public final float getYPosition() {
        return this.fYPosition;
    }

    public final void setPosition(float f, float f2) {
        this.fXPosition = f;
        this.fYPosition = f2;
    }

    public final void setScale(float f) {
        this.fScale = f;
    }

    public final void loadImageFromFile(String string) {
        BufferedImage bufferedImage;
        this.strFilename = string;
        try {
            bufferedImage = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Unable to load rotoscope image \"" + string + "\"\n" + iOException, "Error", 0);
            return;
        }
        if (bufferedImage == null) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Unable to load rotoscope image \"" + string + "\"\nInvalid file format", "Error", 0);
            return;
        }
        this.originalRGBImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        int[] nArray = ((DataBufferInt)this.originalRGBImage.getRaster().getDataBuffer()).getData();
        int n = 0;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                nArray[n++] = bufferedImage.getRGB(n5, n4);
                ++n5;
            }
            ++n4;
        }
        this.fScale = 0.05f;
        this.fXPosition = 0.0f;
        this.fYPosition = 0.0f;
        this.filteredRGBImage = new BufferedImage(this.originalRGBImage.getWidth(null), this.originalRGBImage.getHeight(null), 1);
        this.bValid = true;
        this.setOpacity(128);
    }

    public final void setOpacity(int n) {
        this.iOpacity = n;
        if (this.bValid) {
            int n2 = (JPatchSettings.getInstance().cBackground.getRed() * (255 - this.iOpacity) & 0xFF00) << 8;
            int n3 = JPatchSettings.getInstance().cBackground.getGreen() * (255 - this.iOpacity) & 0xFF00;
            int n4 = (JPatchSettings.getInstance().cBackground.getBlue() * (255 - this.iOpacity) & 0xFF00) >> 8;
            int n5 = n2 | n3 | n4;
            int[] nArray = ((DataBufferInt)this.originalRGBImage.getRaster().getDataBuffer()).getData();
            int[] nArray2 = ((DataBufferInt)this.filteredRGBImage.getRaster().getDataBuffer()).getData();
            int n6 = nArray.length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = ((nArray[n7] & 0xFF0000) * this.iOpacity & 0xFF000000) >> 8;
                int n9 = ((nArray[n7] & 0xFF00) * this.iOpacity & 0xFF0000) >> 8;
                int n10 = ((nArray[n7] & 0xFF) * this.iOpacity & 0xFF00) >> 8;
                nArray2[n7] = (n8 | n9 | n10) + n5;
                ++n7;
            }
        }
    }

    public final int getOpacity() {
        return this.iOpacity;
    }

    public final void paint(JPatchCanvas jPatchCanvas) {
        Graphics2D graphics2D = (Graphics2D)jPatchCanvas.getDrawable().getGraphics();
        ViewDefinition viewDefinition = jPatchCanvas.getViewDefinition();
        float f = viewDefinition.getTranslateX();
        float f2 = viewDefinition.getTranslateY();
        float f3 = viewDefinition.getWidth();
        float f4 = viewDefinition.getHeight();
        float f5 = viewDefinition.getScale() * f3 * 0.5f;
        float f6 = this.fScale * f5;
        float f7 = this.fXPosition - this.fScale * 0.5f * (float)this.filteredRGBImage.getWidth();
        float f8 = this.fYPosition - this.fScale * 0.5f * (float)this.filteredRGBImage.getHeight();
        this.affineTransform = new AffineTransform(f6, 0.0f, 0.0f, f6, f3 * 0.5f + (f + f7) * f5, f4 * 0.5f + (f2 + f8) * f5);
        graphics2D.drawImage(this.filteredRGBImage, this.affineTransform, null);
        int n = (int)(f3 * 0.5f + (f + f7) * f5);
        int n2 = (int)((float)n + f6 * (float)this.getPixelWidth());
        int n3 = (int)(f4 * 0.5f + (f2 + f8) * f5);
        int n4 = (int)((float)n3 + f6 * (float)this.getPixelHeight());
        graphics2D.setColor(JPatchSettings.getInstance().cGrey);
        graphics2D.drawRect(n, n3, n2 - n, n4 - n3);
    }

    public final StringBuffer xml(int n, String string) {
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.lineBreak();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(stringBuffer).append("<rotoscope view=\"" + string + "\">").append(stringBuffer2);
        stringBuffer3.append(stringBuffer).append("\t<image>").append(this.strFilename).append("</image>").append(stringBuffer2);
        stringBuffer3.append(stringBuffer).append("\t<display x=\"" + this.fXPosition + "\" y=\"" + this.fYPosition + "\" scale=\"" + this.fScale + "\" opacity=\"" + this.iOpacity + "\"/>").append(stringBuffer2);
        stringBuffer3.append(stringBuffer).append("</rotoscope>").append(stringBuffer2);
        return stringBuffer3;
    }

    private final /* synthetic */ void this() {
        this.affineTransform = new AffineTransform();
    }

    public Rotoscope() {
        this.this();
        this.bValid = false;
    }

    public Rotoscope(String string) {
        this.this();
        this.loadImageFromFile(string);
    }
}

