/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpatch.boundary.JPatchSlider;
import jpatch.boundary.MainFrame;
import jpatch.boundary.RealtimeRaytracer;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.MaterialProperties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MaterialEditor
extends JDialog
implements ChangeListener,
ActionListener {
    private MaterialProperties materialProperties;
    private MaterialProperties oldMaterialProperties;
    private String strPovRay;
    private String strRenderMan;
    private String strInyo;
    private JPatchMaterial material;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JButton buttonApply;
    private JButton buttonColor;
    private JPatchSlider sliderRed;
    private JPatchSlider sliderGreen;
    private JPatchSlider sliderBlue;
    private JPatchSlider sliderTransmit;
    private JPatchSlider sliderFilter;
    private JPatchSlider sliderAmbient;
    private JPatchSlider sliderDiffuse;
    private JPatchSlider sliderBrilliance;
    private JPatchSlider sliderSpecular;
    private JPatchSlider sliderRoughness;
    private JPatchSlider sliderMetallic;
    private JPatchSlider sliderReflectionMin;
    private JPatchSlider sliderReflectionMax;
    private JPatchSlider sliderReflectionFalloff;
    private JPatchSlider sliderRefraction;
    private RealtimeRaytracer trace;
    private JCheckBox checkboxLoRes;
    private JCheckBox checkboxConserveEnergy;
    JTextArea[] atextArea;

    private final void addComponentBounds(Component component, int n, int n2, int n3, int n4) {
        this.add(component);
        component.setBounds(n, n2, n3, n4);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.sliderRed) {
            this.materialProperties.red = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderGreen) {
            this.materialProperties.green = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderBlue) {
            this.materialProperties.blue = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderTransmit) {
            this.materialProperties.transmit = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderFilter) {
            this.materialProperties.filter = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderAmbient) {
            this.materialProperties.ambient = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderDiffuse) {
            this.materialProperties.diffuse = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderBrilliance) {
            this.materialProperties.brilliance = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderSpecular) {
            this.materialProperties.specular = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderRoughness) {
            this.materialProperties.roughness = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderMetallic) {
            this.materialProperties.metallic = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderReflectionMin) {
            this.materialProperties.reflectionMin = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderReflectionMax) {
            this.materialProperties.reflectionMax = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderReflectionFalloff) {
            this.materialProperties.reflectionFalloff = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.sliderRefraction) {
            this.materialProperties.refraction = ((JPatchSlider)changeEvent.getSource()).getValue();
        } else if (changeEvent.getSource() == this.checkboxLoRes) {
            this.trace.setLoRes(((JCheckBox)changeEvent.getSource()).isSelected());
        } else if (changeEvent.getSource() == this.checkboxConserveEnergy) {
            this.materialProperties.conserveEnergy = ((AbstractButton)changeEvent.getSource()).isSelected();
        }
        this.trace.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.buttonOk) {
            this.commit();
            this.dispose();
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.revert();
            this.dispose();
        } else if (actionEvent.getSource() == this.buttonApply) {
            this.commit();
        } else if (actionEvent.getSource() == this.buttonColor && (color = JColorChooser.showDialog(this, "", this.materialProperties.getColor())) != null) {
            this.sliderRed.setValue((float)color.getRed() / 255.0f);
            this.sliderGreen.setValue((float)color.getGreen() / 255.0f);
            this.sliderBlue.setValue((float)color.getBlue() / 255.0f);
            this.materialProperties.red = this.sliderRed.getValue();
            this.materialProperties.green = this.sliderGreen.getValue();
            this.materialProperties.blue = this.sliderBlue.getValue();
            this.trace.repaint();
        }
    }

    private final void commit() {
        this.material.getMaterialProperties().set(this.materialProperties);
        this.material.setRenderString("povray", "3.5", this.atextArea[0].getText());
        this.material.setRenderString("renderman", "3.1", this.atextArea[1].getText());
        this.material.setRenderString("inyo", "0.0", this.atextArea[2].getText());
        MainFrame.getInstance().getJPatchScreen().update_all();
    }

    private final void revert() {
        this.material.getMaterialProperties().set(this.oldMaterialProperties);
        this.material.setRenderString("povray", "3.5", this.strPovRay);
        this.material.setRenderString("renderman", "3.1", this.strRenderMan);
        this.material.setRenderString("inyo", "0.0", this.strRenderMan);
        MainFrame.getInstance().getJPatchScreen().update_all();
    }

    private final /* synthetic */ void this() {
        this.checkboxLoRes = new JCheckBox("Lo-Res", true);
        this.checkboxConserveEnergy = new JCheckBox("conserve energy", true);
        this.atextArea = new JTextArea[3];
    }

    public MaterialEditor(Frame frame, JPatchMaterial jPatchMaterial) {
        super(MainFrame.getInstance(), "JPatch material editor - " + jPatchMaterial.getName(), true);
        this.this();
        this.getContentPane().setLayout(new BorderLayout());
        this.material = jPatchMaterial;
        this.materialProperties = new MaterialProperties(jPatchMaterial.getMaterialProperties());
        this.oldMaterialProperties = new MaterialProperties(this.materialProperties);
        this.buttonOk = new JButton("OK");
        this.buttonCancel = new JButton("Cancel");
        this.buttonApply = new JButton("Apply");
        this.buttonColor = new JButton("Pick a color...");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.strPovRay = jPatchMaterial.getRenderString("povray", "3.5");
        this.strRenderMan = jPatchMaterial.getRenderString("renderman", "3.1");
        this.strInyo = jPatchMaterial.getRenderString("iyno", "0.0");
        this.atextArea[0] = new JTextArea(jPatchMaterial.getRenderString("povray", "3.5"));
        this.atextArea[1] = new JTextArea(jPatchMaterial.getRenderString("renderman", "3.1"));
        this.atextArea[2] = new JTextArea(jPatchMaterial.getRenderString("inyo", "0.0"));
        int n = 0;
        while (n < this.atextArea.length) {
            this.atextArea[n].setRows(15);
            ++n;
        }
        jPanel.setLayout(new GridLayout(8, 2, 20, 0));
        JPatchSlider.setDimensions(90, 100, 50, 20);
        JPatchSlider.setNumberFormat(new DecimalFormat("##0.00###"));
        this.sliderRed = new JPatchSlider("red", 0.0f, 1.0f, this.materialProperties.red);
        this.sliderGreen = new JPatchSlider("green", 0.0f, 1.0f, this.materialProperties.green);
        this.sliderBlue = new JPatchSlider("blue", 0.0f, 1.0f, this.materialProperties.blue);
        this.sliderTransmit = new JPatchSlider("transmit", 0.0f, 1.0f, this.materialProperties.transmit);
        this.sliderFilter = new JPatchSlider("filter", 0.0f, 1.0f, this.materialProperties.filter);
        this.sliderAmbient = new JPatchSlider("ambient", 0.0f, 1.0f, this.materialProperties.ambient);
        this.sliderDiffuse = new JPatchSlider("diffuse", 0.0f, 1.0f, this.materialProperties.diffuse);
        this.sliderBrilliance = new JPatchSlider("brilliance", 0.1f, 10.0f, this.materialProperties.brilliance, 2);
        this.sliderSpecular = new JPatchSlider("specular", 0.0f, 5, this.materialProperties.specular);
        this.sliderRoughness = new JPatchSlider("roughness", 1.0E-4f, 0.1f, this.materialProperties.roughness, 2);
        this.sliderMetallic = new JPatchSlider("metallic", 0.0f, 1.0f, this.materialProperties.metallic);
        this.sliderReflectionMin = new JPatchSlider("reflection min", 0.0f, 1.0f, this.materialProperties.reflectionMin);
        this.sliderReflectionMax = new JPatchSlider("reflection max", 0.0f, 1.0f, this.materialProperties.reflectionMax);
        this.sliderReflectionFalloff = new JPatchSlider("refl. falloff", 0.1f, 10.0f, this.materialProperties.reflectionFalloff, 2);
        this.sliderRefraction = new JPatchSlider("refraction idx.", 1.0f, 2.5f, this.materialProperties.refraction);
        this.trace = new RealtimeRaytracer(this.materialProperties);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(this.sliderRed);
        jPanel.add(this.sliderSpecular);
        jPanel.add(this.sliderGreen);
        jPanel.add(this.sliderRoughness);
        jPanel.add(this.sliderBlue);
        jPanel.add(this.sliderMetallic);
        jPanel.add(this.sliderFilter);
        jPanel.add(this.sliderReflectionMin);
        jPanel.add(this.sliderTransmit);
        jPanel.add(this.sliderReflectionMax);
        jPanel.add(this.sliderAmbient);
        jPanel.add(this.sliderReflectionFalloff);
        jPanel.add(this.sliderDiffuse);
        jPanel.add(this.sliderRefraction);
        jPanel.add(this.sliderBrilliance);
        jPanel.add(this.checkboxConserveEnergy);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.sliderRed.addChangeListener(this);
        this.sliderGreen.addChangeListener(this);
        this.sliderBlue.addChangeListener(this);
        this.sliderTransmit.addChangeListener(this);
        this.sliderFilter.addChangeListener(this);
        this.sliderAmbient.addChangeListener(this);
        this.sliderDiffuse.addChangeListener(this);
        this.sliderBrilliance.addChangeListener(this);
        this.sliderSpecular.addChangeListener(this);
        this.sliderRoughness.addChangeListener(this);
        this.sliderMetallic.addChangeListener(this);
        this.sliderReflectionMin.addChangeListener(this);
        this.sliderReflectionMax.addChangeListener(this);
        this.sliderReflectionFalloff.addChangeListener(this);
        this.sliderRefraction.addChangeListener(this);
        this.checkboxLoRes.addChangeListener(this);
        this.checkboxConserveEnergy.setSelected(this.materialProperties.conserveEnergy);
        this.checkboxConserveEnergy.addChangeListener(this);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.trace, "Center");
        jPanel3.add((Component)this.checkboxLoRes, "South");
        jPanel2.add((Component)jPanel3, "East");
        this.getContentPane().add((Component)jPanel2, "North");
        jTabbedPane.addTab("POV-Ray", new JScrollPane(this.atextArea[0]));
        jTabbedPane.addTab("RenderMan", new JScrollPane(this.atextArea[1]));
        jTabbedPane.addTab("Inyo", new JScrollPane(this.atextArea[2]));
        this.getContentPane().add((Component)jTabbedPane, "Center");
        jPanel4.add(this.buttonOk);
        jPanel4.add(this.buttonApply);
        jPanel4.add(this.buttonColor);
        jPanel4.add(this.buttonCancel);
        this.getContentPane().add((Component)jPanel4, "South");
        this.setDefaultCloseOperation(2);
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.buttonApply.addActionListener(this);
        this.buttonColor.addActionListener(this);
        this.setSize(700, 500);
        this.setLocationRelativeTo(frame);
    }
}

