/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JPatchSettings {
    public static final int OUTPUT_TRIANGULIZED_HASHPATCHES = 0;
    public static final int OUTPUT_BEZIERPATCHES = 1;
    public static final int OUTPUT_QUADS = 1;
    public static final int SUBDIV_LOW = 2;
    public static final int SUBDIV_MEDIUM = 3;
    public static final int SUBDIV_HIGH = 4;
    public static final int RENDERER_INYO = 0;
    public static final int RENDERER_POVRAY = 1;
    public static final int RENDERER_RIB = 2;
    public static final int POVRAY_UNIX = 0;
    public static final int POVRAY_WINDOWS = 1;
    private static JPatchSettings INSTANCE;
    public int iRenderer;
    public boolean bFirstStart;
    public Color cBackground;
    public Color cCurve;
    public Color cPoint;
    public Color cHeadPoint;
    public Color cMultiPoint;
    public Color cSelection;
    public Color cText;
    public Color cTangent;
    public Color cOrigin;
    public Color cGrid;
    public Color cGridMin;
    public Color cX;
    public Color cY;
    public Color cZ;
    public Color cSelected;
    public Color cHot;
    public Color cGrey;
    public Color cBackface;
    public int iGhost;
    public int iBackground;
    public int iCurve;
    public int iPoint;
    public int iPointSelected;
    public int iGrid;
    public int iGridMin;
    public int iSelection;
    public int iX;
    public int iY;
    public int iZ;
    public int iScreenMode;
    public boolean bSyncWindows;
    public int iPatchSubdivisions;
    public int iCurveSubdivisions;
    public int iTesselationQuality;
    public int iScreenX;
    public int iScreenY;
    public int iScreenWidth;
    public int iScreenHeight;
    public int iLightingMode;
    public boolean bStickyLight;
    public boolean bGridSnap;
    public float fGridSpacing;
    public String strModelDir;
    public int iBackfaceMode;
    public int iBackfaceColor;
    public String strJPatchPath;
    public String strAMPath;
    public String strSPatchPath;
    public String strPovrayPath;
    public String strRendermanPath;
    public String strRotoscopePath;
    public String strPlafClassName;
    public String strJPatchFile;
    public String strWorkingDir;
    public boolean bDeleteSources;
    public Color cBackgroundColor;
    public final PovraySettings povraySettings;
    public final InyoSettings inyoSettings;
    public final RibSettings ribSettings;
    public final WavefrontSettings wavefrontSettings;
    public int iRenderWidth;
    public int iRenderHeight;
    public float fRenderAspectWidth;
    public float fRenderAspectHeight;
    public String[] astrKeyMap;
    private Preferences userPrefs;
    private Map mapDefaults;

    public static JPatchSettings getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JPatchSettings();
        }
        return INSTANCE;
    }

    public void setColors(Color[] colorArray) {
        this.cBackground = colorArray[0];
        this.cPoint = colorArray[1];
        this.cCurve = colorArray[2];
        this.cHeadPoint = colorArray[3];
        this.cMultiPoint = colorArray[4];
        this.cSelected = colorArray[5];
        this.cHot = colorArray[6];
        this.cSelection = colorArray[7];
        this.cText = colorArray[8];
        this.cGrid = colorArray[9];
        this.cGridMin = colorArray[10];
        this.cX = colorArray[11];
        this.cY = colorArray[12];
        this.cZ = colorArray[13];
        this.cTangent = colorArray[14];
        this.cBackface = colorArray[15];
        this.iBackground = this.cBackground.getRGB();
        this.iCurve = this.cCurve.getRGB();
        this.iPoint = this.cPoint.getRGB();
        this.iGrid = this.cGrid.getRGB();
        this.iGridMin = this.cGridMin.getRGB();
        this.iSelection = this.cSelection.getRGB();
        this.iX = this.cX.getRGB();
        this.iY = this.cY.getRGB();
        this.iZ = this.cZ.getRGB();
        this.iBackfaceColor = this.cBackface.getRGB();
    }

    public Color[] getColors() {
        return new Color[]{this.cBackground, this.cPoint, this.cCurve, this.cHeadPoint, this.cMultiPoint, this.cSelected, this.cHot, this.cSelection, this.cText, this.cGrid, this.cGridMin, this.cX, this.cY, this.cZ, this.cTangent, this.cBackface};
    }

    public Color[] getDefaultColors() {
        return new Color[]{this.getColorDefault("backgroundColor"), this.getColorDefault("pointColor"), this.getColorDefault("curveColor"), this.getColorDefault("headPointColor"), this.getColorDefault("multiPointColor"), this.getColorDefault("selectedColor"), this.getColorDefault("hotColor"), this.getColorDefault("selectionColor"), this.getColorDefault("textColor"), this.getColorDefault("gridColor"), this.getColorDefault("minorGridColor"), this.getColorDefault("xColor"), this.getColorDefault("yColor"), this.getColorDefault("zColor"), this.getColorDefault("tangentColor"), this.getColorDefault("backfaceColor")};
    }

    public void loadSettings() {
        this.bFirstStart = this.getBoolean("firstStart");
        this.cBackground = this.getColor("backgroundColor");
        this.cCurve = this.getColor("curveColor");
        this.cPoint = this.getColor("pointColor");
        this.cTangent = this.getColor("tangentColor");
        this.cHeadPoint = this.getColor("headPointColor");
        this.cMultiPoint = this.getColor("multiPointColor");
        this.cSelection = this.getColor("selectionColor");
        this.cText = this.getColor("textColor");
        this.cOrigin = this.getColor("originColor");
        this.cGrid = this.getColor("gridColor");
        this.cGridMin = this.getColor("minorGridColor");
        this.cX = this.getColor("xColor");
        this.cY = this.getColor("yColor");
        this.cZ = this.getColor("zColor");
        this.cSelected = this.getColor("selectedColor");
        this.cHot = this.getColor("hotColor");
        this.cGrey = this.getColor("greyColor");
        this.cBackface = this.getColor("backfaceColor");
        this.iBackground = this.cBackground.getRGB();
        this.iCurve = this.cCurve.getRGB();
        this.iPoint = this.cPoint.getRGB();
        this.iGrid = this.cGrid.getRGB();
        this.iGridMin = this.cGridMin.getRGB();
        this.iSelection = this.cSelection.getRGB();
        this.iX = this.cX.getRGB();
        this.iY = this.cY.getRGB();
        this.iZ = this.cZ.getRGB();
        this.iBackfaceColor = this.cBackface.getRGB();
        this.iScreenMode = this.getInt("screenMode");
        this.bSyncWindows = this.getBoolean("syncWindows");
        this.iPatchSubdivisions = this.getInt("patchSubdivisions");
        this.iCurveSubdivisions = this.getInt("curveSubdivisions");
        this.iTesselationQuality = this.getInt("tesselationQuality");
        this.iScreenX = this.getInt("screenX");
        this.iScreenY = this.getInt("screenY");
        this.iScreenWidth = this.getInt("screenWidth");
        this.iScreenHeight = this.getInt("screenHeight");
        this.iLightingMode = this.getInt("lightingMode");
        this.bStickyLight = this.getBoolean("stickyLight");
        this.iBackfaceMode = this.getInt("backfaceMode");
        this.bGridSnap = this.getBoolean("gridSnap");
        this.fGridSpacing = this.getFloat("gridSpacing");
        this.strJPatchPath = this.getString("jpatchPath");
        this.strSPatchPath = this.getString("spatchPath");
        this.strAMPath = this.getString("amPath");
        this.strPovrayPath = this.getString("povrayPath");
        this.strRendermanPath = this.getString("rendermanPath");
        this.strRotoscopePath = this.getString("rotoscopePath");
        this.strPlafClassName = this.getString("lookAndFeel");
        this.strWorkingDir = this.getString("workingDir");
        this.cBackgroundColor = this.getColor("rendererBackgroundColor");
        this.iRenderer = this.getInt("renderer");
        this.povraySettings.strExecutable = this.getString("povrayExecutable");
        this.povraySettings.strEnv = this.getString("povrayEnv");
        this.povraySettings.iVersion = this.getInt("povrayVersion");
        this.povraySettings.iOutputMode = this.getInt("povrayOutputMode");
        this.povraySettings.iSubdivMode = this.getInt("povraySubdivMode");
        this.povraySettings.fAaJitter = this.getFloat("povrayAaJitter");
        this.povraySettings.iAaMethod = this.getInt("povrayAaMethod");
        this.povraySettings.iAaLevel = this.getInt("povrayAaLevel");
        this.povraySettings.fAaThreshold = this.getFloat("povrayAaThreshold");
        this.povraySettings.strInclude = this.getString("povrayInclude");
        this.povraySettings.strPath = this.getString("povrayPath");
        this.inyoSettings.strTexturePath = this.getString("inyoTexturePath");
        this.inyoSettings.iSupersample = this.getInt("inyoSupersample");
        this.inyoSettings.iSamplingMode = this.getInt("inyoSamplingMode");
        this.inyoSettings.iSubdivMode = this.getInt("inyoSubdivMode");
        this.inyoSettings.iRecursion = this.getInt("inyoRecursionDepth");
        this.inyoSettings.iShadowSamples = this.getInt("inyoShadowSamples");
        this.inyoSettings.bTransparentShadows = this.getBoolean("inyoTransparentShadows");
        this.inyoSettings.bEnableCaustics = this.getBoolean("inyoCaustics");
        this.inyoSettings.bOversampleCaustics = this.getBoolean("inyoOversampleCaustics");
        this.inyoSettings.bEnableAmbientOcclusion = this.getBoolean("inyoAmbientOcclusion");
        this.inyoSettings.fAmbientOcclusionDistance = this.getFloat("inyoAmbientOcclusionDistance");
        this.inyoSettings.iAmbientOcclusionSamples = this.getInt("inyoAmbientOcclusionSamples");
        this.inyoSettings.fAmbientOcclusionColorbleed = this.getFloat("inyoAmbientOcclusionColorbleed");
        this.ribSettings.strExecutable = this.getString("ribExecutable");
        this.ribSettings.strEnv = this.getString("ribEnv");
        this.ribSettings.iOutputMode = this.getInt("ribOutputMode");
        this.ribSettings.iSubdivMode = this.getInt("ribSubdivMode");
        this.ribSettings.iPixelSamplesX = this.getInt("ribPixelSamplesX");
        this.ribSettings.iPixelSamplesY = this.getInt("ribPixelSamplesY");
        this.ribSettings.iPixelFilterX = this.getInt("ribPixelFilterX");
        this.ribSettings.iPixelFilterY = this.getInt("ribPixelFilterY");
        this.ribSettings.iPixelFilter = this.getInt("ribPixelFilter");
        this.ribSettings.fShadingRate = this.getFloat("ribShadingRate");
        this.ribSettings.iShadingInterpolation = this.getInt("ribShadingInterpolation");
        this.ribSettings.fExposure = this.getFloat("ribExposure");
        this.ribSettings.strPath = this.getString("ribPath");
        this.wavefrontSettings.strPath = this.getString("wavefrontPath");
        this.wavefrontSettings.iOutputMode = this.getInt("wavefrontOutputMode");
        this.wavefrontSettings.iSubdivMode = this.getInt("wavefrontSubdivMode");
        this.wavefrontSettings.bExportNormals = this.getBoolean("wavefrontExportNormals");
        this.wavefrontSettings.bAverageNormals = this.getBoolean("wavefrontAverageNormals");
        this.iRenderWidth = this.getInt("renderWidth");
        this.iRenderHeight = this.getInt("renderHeight");
        this.fRenderAspectWidth = this.getFloat("renderAspectWidth");
        this.fRenderAspectHeight = this.getFloat("renderAspectHeight");
        this.strModelDir = this.getString("modelDir");
        this.bDeleteSources = this.getBoolean("deleteSources");
    }

    public void loadDefaults() {
        this.bFirstStart = this.getBooleanDefault("firstStart");
        this.cBackground = this.getColorDefault("backgroundColor");
        this.cCurve = this.getColorDefault("curveColor");
        this.cPoint = this.getColorDefault("pointColor");
        this.cTangent = this.getColorDefault("tangentColor");
        this.cHeadPoint = this.getColorDefault("headPointColor");
        this.cMultiPoint = this.getColorDefault("multiPointColor");
        this.cSelection = this.getColorDefault("selectionColor");
        this.cText = this.getColorDefault("textColor");
        this.cOrigin = this.getColorDefault("originColor");
        this.cGrid = this.getColorDefault("gridColor");
        this.cGridMin = this.getColorDefault("minorGridColor");
        this.cX = this.getColorDefault("xColor");
        this.cY = this.getColorDefault("yColor");
        this.cZ = this.getColorDefault("zColor");
        this.cSelected = this.getColorDefault("selectedColor");
        this.cHot = this.getColorDefault("hotColor");
        this.cGrey = this.getColorDefault("greyColor");
        this.cBackface = this.getColorDefault("backfaceColor");
        this.iBackground = this.cBackground.getRGB();
        this.iCurve = this.cCurve.getRGB();
        this.iPoint = this.cPoint.getRGB();
        this.iGrid = this.cGrid.getRGB();
        this.iGridMin = this.cGridMin.getRGB();
        this.iSelection = this.cSelection.getRGB();
        this.iX = this.cX.getRGB();
        this.iY = this.cY.getRGB();
        this.iZ = this.cZ.getRGB();
        this.iBackfaceColor = this.cBackface.getRGB();
        this.iScreenMode = this.getIntDefault("screenMode");
        this.bSyncWindows = this.getBooleanDefault("syncWindows");
        this.iPatchSubdivisions = this.getIntDefault("patchSubdivisions");
        this.iCurveSubdivisions = this.getIntDefault("curveSubdivisions");
        this.iTesselationQuality = this.getIntDefault("tesselationQuality");
        this.iScreenX = this.getIntDefault("screenX");
        this.iScreenY = this.getIntDefault("screenY");
        this.iScreenWidth = this.getIntDefault("screenWidth");
        this.iScreenHeight = this.getIntDefault("screenHeight");
        this.iLightingMode = this.getIntDefault("lightingMode");
        this.bStickyLight = this.getBooleanDefault("stickyLight");
        this.iBackfaceMode = this.getIntDefault("backfaceMode");
        this.bGridSnap = this.getBooleanDefault("gridSnap");
        this.fGridSpacing = this.getFloatDefault("gridSpacing");
        this.strJPatchPath = this.getStringDefault("jpatchPath");
        this.strSPatchPath = this.getStringDefault("spatchPath");
        this.strAMPath = this.getStringDefault("amPath");
        this.strPovrayPath = this.getStringDefault("povrayPath");
        this.strRendermanPath = this.getStringDefault("rendermanPath");
        this.strRotoscopePath = this.getStringDefault("rotoscopePath");
        this.strPlafClassName = this.getStringDefault("lookAndFeel");
        this.strWorkingDir = this.getStringDefault("workingDir");
        this.cBackgroundColor = this.getColorDefault("rendererBackgroundColor");
        this.iRenderer = this.getIntDefault("renderer");
        this.povraySettings.strExecutable = this.getStringDefault("povrayExecutable");
        this.povraySettings.strEnv = this.getStringDefault("povrayEnv");
        this.povraySettings.iVersion = this.getIntDefault("povrayVersion");
        this.povraySettings.fAaJitter = this.getFloatDefault("povrayAaJitter");
        this.povraySettings.iOutputMode = this.getIntDefault("povrayOutputMode");
        this.povraySettings.iSubdivMode = this.getIntDefault("povraySubdivMode");
        this.povraySettings.iAaMethod = this.getIntDefault("povrayAaMethod");
        this.povraySettings.iAaLevel = this.getIntDefault("povrayAaLevel");
        this.povraySettings.fAaThreshold = this.getFloatDefault("povrayAaThreshold");
        this.povraySettings.strInclude = this.getStringDefault("povrayInclude");
        this.povraySettings.strPath = this.getStringDefault("povrayPath");
        this.inyoSettings.strTexturePath = this.getStringDefault("inyoTexturePath");
        this.inyoSettings.iSupersample = this.getIntDefault("inyoSupersample");
        this.inyoSettings.iSamplingMode = this.getIntDefault("inyoSamplingMode");
        this.inyoSettings.iSubdivMode = this.getIntDefault("inyoSubdivMode");
        this.inyoSettings.iRecursion = this.getIntDefault("inyoRecursionDepth");
        this.inyoSettings.iShadowSamples = this.getIntDefault("inyoShadowSamples");
        this.inyoSettings.bTransparentShadows = this.getBooleanDefault("inyoTransparentShadows");
        this.inyoSettings.bEnableCaustics = this.getBooleanDefault("inyoCaustics");
        this.inyoSettings.bOversampleCaustics = this.getBooleanDefault("inyoOversampleCaustics");
        this.inyoSettings.bEnableAmbientOcclusion = this.getBooleanDefault("inyoAmbientOcclusion");
        this.inyoSettings.fAmbientOcclusionDistance = this.getFloatDefault("inyoAmbientOcclusionDistance");
        this.inyoSettings.iAmbientOcclusionSamples = this.getIntDefault("inyoAmbientOcclusionSamples");
        this.inyoSettings.fAmbientOcclusionColorbleed = this.getFloatDefault("inyoAmbientOcclusionColorbleed");
        this.ribSettings.strExecutable = this.getStringDefault("ribExecutable");
        this.ribSettings.strEnv = this.getStringDefault("ribEnv");
        this.ribSettings.iOutputMode = this.getIntDefault("ribOutputMode");
        this.ribSettings.iSubdivMode = this.getIntDefault("ribSubdivMode");
        this.ribSettings.iPixelSamplesX = this.getIntDefault("ribPixelSamplesX");
        this.ribSettings.iPixelSamplesY = this.getIntDefault("ribPixelSamplesY");
        this.ribSettings.iPixelFilterX = this.getIntDefault("ribPixelFilterX");
        this.ribSettings.iPixelFilterY = this.getIntDefault("ribPixelFilterY");
        this.ribSettings.iPixelFilter = this.getIntDefault("ribPixelFilter");
        this.ribSettings.fShadingRate = this.getFloatDefault("ribShadingRate");
        this.ribSettings.iShadingInterpolation = this.getIntDefault("ribShadingInterpolation");
        this.ribSettings.fExposure = this.getFloatDefault("ribExposure");
        this.ribSettings.strPath = this.getStringDefault("ribPath");
        this.wavefrontSettings.strPath = this.getStringDefault("wavefrontPath");
        this.wavefrontSettings.iOutputMode = this.getIntDefault("wavefrontOutputMode");
        this.wavefrontSettings.iSubdivMode = this.getIntDefault("wavefrontSubdivMode");
        this.wavefrontSettings.bAverageNormals = this.getBooleanDefault("wavefrontAverageNormals");
        this.iRenderWidth = this.getIntDefault("renderWidth");
        this.iRenderHeight = this.getIntDefault("renderHeight");
        this.fRenderAspectWidth = this.getFloatDefault("renderAspectWidth");
        this.fRenderAspectHeight = this.getFloatDefault("renderAspectHeight");
        this.strModelDir = this.getStringDefault("modelDir");
        this.bDeleteSources = this.getBooleanDefault("deleteSources");
    }

    public void saveSettings() {
        this.putBoolean("firstStart", this.bFirstStart);
        this.putColor("backgroundColor", this.cBackground);
        this.putColor("curveColor", this.cCurve);
        this.putColor("pointColor", this.cPoint);
        this.putColor("headPointColor", this.cHeadPoint);
        this.putColor("multiPointColor", this.cMultiPoint);
        this.putColor("selectionColor", this.cSelection);
        this.putColor("textColor", this.cText);
        this.putColor("originColor", this.cOrigin);
        this.putColor("gridColor", this.cGrid);
        this.putColor("minorGridColor", this.cGridMin);
        this.putColor("xColor", this.cX);
        this.putColor("yColor", this.cY);
        this.putColor("zColor", this.cZ);
        this.putColor("selectedColor", this.cSelected);
        this.putColor("hotColor", this.cHot);
        this.putColor("tangentColor", this.cTangent);
        this.putColor("backfaceColor", this.cBackface);
        this.putInt("screenMode", this.iScreenMode);
        this.putBoolean("syncWindows", this.bSyncWindows);
        this.putInt("curveSubdivisions", this.iCurveSubdivisions);
        this.putInt("patchSubdivisions", this.iPatchSubdivisions);
        this.putInt("tesselationQuality", this.iTesselationQuality);
        this.putInt("screenX", this.iScreenX);
        this.putInt("screenY", this.iScreenY);
        this.putInt("screenWidth", this.iScreenWidth);
        this.putInt("screenHeight", this.iScreenHeight);
        this.putInt("lightingMode", this.iLightingMode);
        this.putBoolean("stickyLight", this.bStickyLight);
        this.putBoolean("gridSnap", this.bGridSnap);
        this.putFloat("gridSpacing", this.fGridSpacing);
        this.putInt("backfaceMode", this.iBackfaceMode);
        this.putString("jpatchPath", this.strJPatchPath);
        this.putString("spatchPath", this.strSPatchPath);
        this.putString("amPath", this.strAMPath);
        this.putString("povrayPath", this.strPovrayPath);
        this.putString("rendermanPath", this.strRendermanPath);
        this.putString("rotoscopePath", this.strRotoscopePath);
        this.putString("lookAndFeel", this.strPlafClassName);
        this.putInt("renderer", this.iRenderer);
        this.putString("workingDir", this.strWorkingDir);
        this.putColor("rendererBackgroundColor", this.cBackgroundColor);
        this.putString("povrayExecutable", this.povraySettings.strExecutable);
        this.putString("povrayEnv", this.povraySettings.strEnv);
        this.putFloat("povrayAaJitter", this.povraySettings.fAaJitter);
        this.putInt("povrayVersion", this.povraySettings.iVersion);
        this.putInt("povrayOutputMode", this.povraySettings.iOutputMode);
        this.putInt("povraySubdivMode", this.povraySettings.iSubdivMode);
        this.putInt("povrayAaMethod", this.povraySettings.iAaMethod);
        this.putInt("povrayAaLevel", this.povraySettings.iAaLevel);
        this.putFloat("povrayAaThreshold", this.povraySettings.fAaThreshold);
        this.putString("povrayInclude", this.povraySettings.strInclude);
        this.putString("povrayPath", this.povraySettings.strPath);
        this.putString("inyoTexturePath", this.inyoSettings.strTexturePath);
        this.putInt("inyoSupersample", this.inyoSettings.iSupersample);
        this.putInt("inyoSamplingMode", this.inyoSettings.iSamplingMode);
        this.putInt("inyoSubdivMode", this.inyoSettings.iSubdivMode);
        this.putInt("inyoRecursionDepth", this.inyoSettings.iRecursion);
        this.putInt("inyoShadowSamples", this.inyoSettings.iShadowSamples);
        this.putBoolean("inyoTransparentShadows", this.inyoSettings.bTransparentShadows);
        this.putBoolean("inyoCaustics", this.inyoSettings.bEnableCaustics);
        this.putBoolean("inyoOversampleCaustics", this.inyoSettings.bOversampleCaustics);
        this.putBoolean("inyoAmbientOcclusion", this.inyoSettings.bEnableAmbientOcclusion);
        this.putFloat("inyoAmbientOcclusionDistance", this.inyoSettings.fAmbientOcclusionDistance);
        this.putInt("inyoAmbientOcclusionSamples", this.inyoSettings.iAmbientOcclusionSamples);
        this.putFloat("inyoAmbientOcclusionColorbleed", this.inyoSettings.fAmbientOcclusionColorbleed);
        this.putInt("ribOutputMode", this.ribSettings.iOutputMode);
        this.putInt("ribSubdivMode", this.ribSettings.iSubdivMode);
        this.putString("ribExecutable", this.ribSettings.strExecutable);
        this.putString("ribEnv", this.ribSettings.strEnv);
        this.putInt("ribPixelSamplesX", this.ribSettings.iPixelSamplesX);
        this.putInt("ribPixelSamplesY", this.ribSettings.iPixelSamplesY);
        this.putInt("ribPixelFilterX", this.ribSettings.iPixelFilterX);
        this.putInt("ribPixelFilterY", this.ribSettings.iPixelFilterY);
        this.putInt("ribPixelFilter", this.ribSettings.iPixelFilter);
        this.putFloat("ribShadingRate", this.ribSettings.fShadingRate);
        this.putInt("ribShadingInterpolation", this.ribSettings.iShadingInterpolation);
        this.putFloat("ribExposure", this.ribSettings.fExposure);
        this.putString("ribPath", this.ribSettings.strPath);
        this.putString("wavefrontPath", this.wavefrontSettings.strPath);
        this.putInt("wavefrontOutputMode", this.wavefrontSettings.iOutputMode);
        this.putInt("wavefrontSubdivMode", this.wavefrontSettings.iSubdivMode);
        this.putBoolean("wavefrontExportNormals", this.wavefrontSettings.bExportNormals);
        this.putBoolean("wavefrontAverageNormals", this.wavefrontSettings.bAverageNormals);
        this.putInt("renderWidth", this.iRenderWidth);
        this.putInt("renderHeight", this.iRenderHeight);
        this.putFloat("renderAspectWidth", this.fRenderAspectWidth);
        this.putFloat("renderAspectHeight", this.fRenderAspectHeight);
        this.putString("modelDir", this.strModelDir);
        this.putBoolean("deleteSources", this.bDeleteSources);
        try {
            this.userPrefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private final void putInt(String string, int n) {
        this.userPrefs.putInt(string, n);
    }

    private final int getInt(String string) {
        return this.userPrefs.getInt(string, (Integer)this.mapDefaults.get(string));
    }

    private final int getIntDefault(String string) {
        return (Integer)this.mapDefaults.get(string);
    }

    private final void putFloat(String string, float f) {
        this.userPrefs.putFloat(string, f);
    }

    private final float getFloat(String string) {
        return this.userPrefs.getFloat(string, ((Float)this.mapDefaults.get(string)).floatValue());
    }

    private final float getFloatDefault(String string) {
        return ((Float)this.mapDefaults.get(string)).floatValue();
    }

    private final void putBoolean(String string, boolean bl) {
        this.userPrefs.putBoolean(string, bl);
    }

    private final boolean getBoolean(String string) {
        return this.userPrefs.getBoolean(string, (Boolean)this.mapDefaults.get(string));
    }

    private final boolean getBooleanDefault(String string) {
        return (Boolean)this.mapDefaults.get(string);
    }

    private final void putString(String string, String string2) {
        this.userPrefs.put(string, string2);
    }

    private final String getString(String string) {
        return this.userPrefs.get(string, (String)this.mapDefaults.get(string));
    }

    private final String getStringDefault(String string) {
        return (String)this.mapDefaults.get(string);
    }

    private final void putColor(String string, Color color) {
        this.userPrefs.putInt(string, color.getRGB());
    }

    private final Color getColor(String string) {
        return new Color(this.userPrefs.getInt(string, ((Color)this.mapDefaults.get(string)).getRGB()));
    }

    private final Color getColorDefault(String string) {
        return (Color)this.mapDefaults.get(string);
    }

    public void resetToDefaults() {
        this.loadDefaults();
        this.saveSettings();
    }

    public static void main(String[] stringArray) {
        JPatchSettings.getInstance().resetToDefaults();
        System.out.println("All settings have been reset to their default values");
    }

    public static String[] getEnv(String string) {
        if (string.replaceAll("\\s", "").equals("")) {
            return null;
        }
        return string.replaceAll("\\s*;\\s*", ";").split(";");
    }

    private final /* synthetic */ void this() {
        this.iGhost = 160;
        this.strJPatchFile = "";
        this.strWorkingDir = "";
        this.povraySettings = new PovraySettings();
        this.inyoSettings = new InyoSettings();
        this.ribSettings = new RibSettings();
        this.wavefrontSettings = new WavefrontSettings();
        this.astrKeyMap = new String[]{"Single View\t\t\tSingle view\t\t\t1", "Horizontal Split View\t\tHorizontal split view\t\t2", "Vertical Split View\t\tVertical split view\t\t3", "Quad View\t\t\tQuad view\t\t\t4", "Rotate View\t\t\tRotate view\t\t\tSHIFT-R", "Move View\t\t\tMove view\t\t\tSHIFT-M", "Zoom View\t\t\tZoom view\t\t\tSHIFT-Z", "Undo\t\t\t\tUndo\t\t\t\tCTRL-Z", "Redo\t\t\t\tRedo\t\t\t\tCTRL-Y", "Lock X\t\t\t\tLock/unlock X\t\t\tX", "Lock Y\t\t\t\tLock/unlock Y\t\t\tY", "Lock Z\t\t\t\tLock/unlock Z\t\t\tZ", "Default Tool\t\t\tDefault tool\t\t\tESC", "Add Point\t\t\tAdd point\t\t\tA", "Add Multiple Points\t\tAdd multiple points\t\tSHIFT-A", "Magnet Tool\t\t\tMagnet tool\t\t\tM", "Rotate Tool\t\t\tRotate tool\t\t\tR", "Remove Points\t\t\tRemove points\t\t\tDEL", "Delete Points\t\t\tDelete points\t\t\tBACKSPACE", "Compute Patches\t\tCompute patches\t\t\tF5", "Clone\t\t\t\tCopy\t\t\t\tCTRL-C", "Extrude\t\t\tExtrude\t\t\t\tE", "Lathe\t\t\t\tLathe\t\t\t\tL", "Extend Selection\t\tExtend selection\t\tENTER", "Next Curve\t\t\tNext curve\t\t\tTAB", "Insert Point\t\t\tInsert point\t\t\tINS", "Bottom View\t\t\tBottom view\t\t\tNUM0", "Front View\t\t\tFront view\t\t\tNUM2", "Right View\t\t\tRight view\t\t\tNUM4", "Top View\t\t\tTop view\t\t\tNUM5", "Left View\t\t\tLeft view\t\t\tNUM6", "Bird's Eye View\t\tBird's eye view\t\t\tNUM7", "Rear View\t\t\tRear view\t\t\tNUM8", "Grid\t\t\t\tSnap to grid\t\t\tG", "Hide\t\t\t\tHide/show unselected points\tH"};
        this.userPrefs = Preferences.userRoot().node("/net/sf/jpatch/Preferences");
        this.mapDefaults = new HashMap();
    }

    public JPatchSettings() {
        this.this();
        this.mapDefaults.put("firstStart", new Boolean(true));
        this.mapDefaults.put("backgroundColor", new Color(40, 56, 72));
        this.mapDefaults.put("curveColor", new Color(255, 255, 255));
        this.mapDefaults.put("pointColor", new Color(255, 255, 0));
        this.mapDefaults.put("headPointColor", new Color(255, 0, 0));
        this.mapDefaults.put("multiPointColor", new Color(255, 128, 0));
        this.mapDefaults.put("tangentColor", new Color(255, 255, 0));
        this.mapDefaults.put("selectionColor", new Color(255, 255, 0));
        this.mapDefaults.put("textColor", new Color(128, 144, 160));
        this.mapDefaults.put("originColor", new Color(255, 255, 255));
        this.mapDefaults.put("gridColor", new Color(8, 24, 40));
        this.mapDefaults.put("minorGridColor", new Color(24, 40, 56));
        this.mapDefaults.put("xColor", new Color(255, 64, 0));
        this.mapDefaults.put("yColor", new Color(0, 255, 0));
        this.mapDefaults.put("zColor", new Color(128, 128, 255));
        this.mapDefaults.put("selectedColor", new Color(0, 255, 0));
        this.mapDefaults.put("hotColor", new Color(0, 255, 255));
        this.mapDefaults.put("greyColor", new Color(80, 96, 112));
        this.mapDefaults.put("screenMode", new Integer(1));
        this.mapDefaults.put("syncWindows", new Boolean(false));
        this.mapDefaults.put("patchSubdivisions", new Integer(3));
        this.mapDefaults.put("curveSubdivisions", new Integer(5));
        this.mapDefaults.put("tesselationQuality", new Integer(2));
        this.mapDefaults.put("screenX", new Integer(0));
        this.mapDefaults.put("screenY", new Integer(0));
        this.mapDefaults.put("screenWidth", new Integer(1000));
        this.mapDefaults.put("screenHeight", new Integer(700));
        this.mapDefaults.put("lightingMode", new Integer(3));
        this.mapDefaults.put("stickyLight", new Boolean(true));
        this.mapDefaults.put("gridSnap", new Boolean(false));
        this.mapDefaults.put("gridSpacing", new Float(1.0f));
        this.mapDefaults.put("backfaceMode", new Integer(2));
        this.mapDefaults.put("backfaceColor", new Color(255, 0, 0));
        this.mapDefaults.put("jpatchPath", "");
        this.mapDefaults.put("spatchPath", "");
        this.mapDefaults.put("amPath", "");
        this.mapDefaults.put("povrayPath", "");
        this.mapDefaults.put("rendermanPath", "");
        this.mapDefaults.put("rotoscopePath", "");
        this.mapDefaults.put("lookAndFeel", UIManager.getCrossPlatformLookAndFeelClassName());
        this.mapDefaults.put("renderer", new Integer(1));
        this.mapDefaults.put("rendererBackgroundColor", new Color(127, 127, 127));
        this.mapDefaults.put("povrayVersion", new Integer(0));
        this.mapDefaults.put("povrayOutputMode", new Integer(0));
        this.mapDefaults.put("povraySubdivMode", new Integer(3));
        this.mapDefaults.put("povrayExecutable", "");
        this.mapDefaults.put("povrayAaJitter", new Float(1.0f));
        this.mapDefaults.put("povrayAaMethod", new Integer(1));
        this.mapDefaults.put("povrayAaLevel", new Integer(2));
        this.mapDefaults.put("povrayAaThreshold", new Float(0.3f));
        this.mapDefaults.put("povrayInclude", "");
        this.mapDefaults.put("povrayEnv", "");
        this.mapDefaults.put("povrayPath", "");
        this.mapDefaults.put("inyoTexturePath", "");
        this.mapDefaults.put("inyoSupersample", new Integer(3));
        this.mapDefaults.put("inyoSamplingMode", new Integer(0));
        this.mapDefaults.put("inyoSubdivMode", new Integer(3));
        this.mapDefaults.put("inyoRecursionDepth", new Integer(12));
        this.mapDefaults.put("inyoShadowSamples", new Integer(8));
        this.mapDefaults.put("inyoTransparentShadows", new Boolean(false));
        this.mapDefaults.put("inyoCaustics", new Boolean(false));
        this.mapDefaults.put("inyoOversampleCaustics", new Boolean(false));
        this.mapDefaults.put("inyoAmbientOcclusion", new Boolean(false));
        this.mapDefaults.put("inyoAmbientOcclusionDistance", new Float(1000.0f));
        this.mapDefaults.put("inyoAmbientOcclusionSamples", new Integer(3));
        this.mapDefaults.put("inyoAmbientOcclusionColorbleed", new Float(0.25f));
        this.mapDefaults.put("ribExecutable", "");
        this.mapDefaults.put("ribOutputMode", new Integer(1));
        this.mapDefaults.put("ribSubdivMode", new Integer(2));
        this.mapDefaults.put("ribPixelSamplesX", new Integer(2));
        this.mapDefaults.put("ribPixelSamplesY", new Integer(2));
        this.mapDefaults.put("ribPixelFilterX", new Integer(2));
        this.mapDefaults.put("ribPixelFilterY", new Integer(2));
        this.mapDefaults.put("ribPixelFilter", new Integer(3));
        this.mapDefaults.put("ribShadingRate", new Float(1.0f));
        this.mapDefaults.put("ribShadingInterpolation", new Integer(1));
        this.mapDefaults.put("ribExposure", new Float(1.0f));
        this.mapDefaults.put("ribEnv", "");
        this.mapDefaults.put("ribPath", "");
        this.mapDefaults.put("wavefrontPath", "");
        this.mapDefaults.put("wavefrontOutputMode", new Integer(1));
        this.mapDefaults.put("wavefrontSubdivMode", new Integer(2));
        this.mapDefaults.put("wavefrontExportNormals", new Boolean(true));
        this.mapDefaults.put("wavefrontAverageNormals", new Boolean(false));
        this.mapDefaults.put("workingDir", "");
        this.mapDefaults.put("renderWidth", new Integer(640));
        this.mapDefaults.put("renderHeight", new Integer(360));
        this.mapDefaults.put("renderAspectWidth", new Float(16.0f));
        this.mapDefaults.put("renderAspectHeight", new Float(9.0f));
        this.mapDefaults.put("modelDir", "");
        this.mapDefaults.put("deleteSources", new Boolean(true));
        this.loadSettings();
        this.saveSettings();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PovraySettings {
        public String strPath;
        public String strExecutable;
        public String strEnv;
        public int iVersion;
        public int iOutputMode;
        public int iSubdivMode;
        public int iAaMethod;
        public int iAaLevel;
        public float fAaThreshold;
        public float fAaJitter;
        public String strInclude;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class InyoSettings {
        public String strTexturePath;
        public int iSupersample;
        public int iSamplingMode;
        public int iSubdivMode;
        public int iRecursion;
        public int iShadowSamples;
        public boolean bTransparentShadows;
        public boolean bEnableCaustics;
        public boolean bOversampleCaustics;
        public boolean bEnableAmbientOcclusion;
        public float fAmbientOcclusionDistance;
        public int iAmbientOcclusionSamples;
        public float fAmbientOcclusionColorbleed;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RibSettings {
        public String strPath;
        public String strExecutable;
        public String strEnv;
        public int iOutputMode;
        public int iSubdivMode;
        public int iPixelSamplesX;
        public int iPixelSamplesY;
        public int iPixelFilterX;
        public int iPixelFilterY;
        public int iPixelFilter;
        public float fShadingRate;
        public int iShadingInterpolation;
        public float fExposure;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class WavefrontSettings {
        public String strPath;
        public int iOutputMode;
        public int iSubdivMode;
        public boolean bExportNormals;
        public boolean bAverageNormals;
    }
}

