/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.image.BufferedImage;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.auxilary.Bezier;
import jpatch.auxilary.Functions;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.Lighting;
import jpatch.boundary.SimpleShape;
import jpatch.boundary.ZBufferRenderer;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.MaterialProperties;
import jpatch.renderer.HashPatchSubdivision;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JPatchDrawableZBuffer
extends ZBufferRenderer
implements JPatchDrawable,
HashPatchSubdivision.QuadDrain {
    private static final int GHOST = JPatchSettings.getInstance().iGhost;
    private static float fFlatness = 3;
    private static int iMaxSubdiv = 10;
    private static Vector3f v3a = new Vector3f();
    private static Vector3f v3b = new Vector3f();
    private static Vector3f v3c = new Vector3f();
    ControlPoint cp;
    Point3f p3A;
    Point3f p3B;
    Point3f p3C;
    Point3f p3D;
    private Vector3f[] av3New;
    private HashPatchSubdivision hashPatchSubdivision;
    private MaterialProperties materialProperties;

    public static final void setQuality(int n) {
        if (n == 0) {
            fFlatness = 16.0f;
        }
        if (n == 1) {
            fFlatness = 8.0f;
        }
        if (n == 2) {
            fFlatness = 4;
        }
        if (n == 3) {
            fFlatness = 2.0f;
        }
        if (n == 4) {
            fFlatness = 1.0f;
        }
    }

    public final void drawSimpleShape(SimpleShape simpleShape, Matrix4f matrix4f) {
        int n;
        Point3f[] point3fArray = simpleShape.getPoints();
        Vector3f[] vector3fArray = simpleShape.getNormals();
        int[] nArray = simpleShape.getTriangles();
        int[] nArray2 = simpleShape.getNormalIndices();
        int n2 = nArray.length / 3;
        MaterialProperties materialProperties = simpleShape.getMaterialProperties();
        if (matrix4f != null) {
            n = 0;
            while (n < point3fArray.length) {
                matrix4f.transform(point3fArray[n]);
                ++n;
            }
            n = 0;
            while (n < vector3fArray.length) {
                matrix4f.transform(vector3fArray[n]);
                vector3fArray[n].normalize();
                ++n;
            }
        }
        n = 0;
        int n3 = 0;
        while (n3 < n2) {
            Vector3f vector3f = vector3fArray[nArray2[n3]];
            if (vector3f.z < 0.0f) {
                int n4 = this.shade(null, vector3f, materialProperties);
                this.draw3DTriangleFlatGhost(point3fArray[nArray[n++]], point3fArray[nArray[n++]], point3fArray[nArray[n++]], n4, GHOST);
            } else {
                n += 3;
            }
            ++n3;
        }
    }

    public final void drawJPatchCurve3D(Curve curve, Matrix4f matrix4f) {
        this.cp = curve.getStart();
        while (this.cp != null && this.cp.isHidden()) {
            this.cp = this.cp.getNextCheckNextLoop();
        }
        if (this.cp != null && this.cp.getNext() != null) {
            this.p3A.set(this.cp.getPosition());
            this.p3B.set(this.cp.getOutTangent());
            matrix4f.transform(this.p3A);
            matrix4f.transform(this.p3B);
            this.cp = this.cp.getNext();
            while (this.cp != null) {
                if (this.cp.isHidden()) {
                    while (this.cp != null && this.cp.isHidden()) {
                        this.cp = this.cp.getNextCheckLoop();
                    }
                    if (this.cp == null) break;
                    this.p3D.set(this.cp.getPosition());
                    matrix4f.transform(this.p3D);
                } else {
                    this.p3C.set(this.cp.getInTangent());
                    this.p3D.set(this.cp.getPosition());
                    matrix4f.transform(this.p3C);
                    matrix4f.transform(this.p3D);
                    this.drawCurveSegment3D(this.p3A, this.p3B, this.p3C, this.p3D, false);
                }
                ControlPoint controlPoint = this.cp.getNextCheckLoop();
                if (controlPoint != null) {
                    this.p3B.set(this.cp.getOutTangent());
                    matrix4f.transform(this.p3B);
                    this.p3A.set(this.p3D);
                }
                this.cp = controlPoint;
            }
        }
    }

    private final Vector3f biquadraticInterpolate(Vector3f[] vector3fArray, float f, float f2) {
        float f3 = 1.0f - f;
        float f4 = 1.0f - f2;
        float f5 = f3 * f3;
        float f6 = 2.0f * f * f3;
        float f7 = f * f;
        float f8 = f4 * f4;
        float f9 = 2.0f * f2 * f4;
        float f10 = f2 * f2;
        Vector3f vector3f = new Vector3f(f8 * (vector3fArray[0].x * f5 + vector3fArray[1].x * f6 + vector3fArray[2].x * f7) + f9 * (vector3fArray[3].x * f5 + vector3fArray[4].x * f6 + vector3fArray[5].x * f7) + f10 * (vector3fArray[6].x * f5 + vector3fArray[7].x * f6 + vector3fArray[8].x * f7), f8 * (vector3fArray[0].y * f5 + vector3fArray[1].y * f6 + vector3fArray[2].y * f7) + f9 * (vector3fArray[3].y * f5 + vector3fArray[4].y * f6 + vector3fArray[5].y * f7) + f10 * (vector3fArray[6].y * f5 + vector3fArray[7].y * f6 + vector3fArray[8].y * f7), f8 * (vector3fArray[0].z * f5 + vector3fArray[1].z * f6 + vector3fArray[2].z * f7) + f9 * (vector3fArray[3].z * f5 + vector3fArray[4].z * f6 + vector3fArray[5].z * f7) + f10 * (vector3fArray[6].z * f5 + vector3fArray[7].z * f6 + vector3fArray[8].z * f7));
        vector3f.normalize();
        return vector3f;
    }

    private final boolean makeFlat(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        v3a.sub(point3f2, point3f);
        v3b.sub(point3f3, point3f4);
        v3c.sub(point3f4, point3f);
        if (JPatchDrawableZBuffer.v3c.x != 0.0f || JPatchDrawableZBuffer.v3c.y != 0.0f || JPatchDrawableZBuffer.v3c.z != 0.0f) {
            v3c.normalize();
        }
        point3f2.set(v3c);
        point3f2.scale(v3a.length());
        point3f2.add(point3f);
        point3f3.set(v3c);
        point3f3.scale(-v3b.length());
        point3f3.add(point3f4);
        return true;
    }

    private final float subdiv(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, boolean bl) {
        if (!bl) {
            v3a.set((float)4 * point3f.x - 6.0f * point3f2.x + 2.0f * point3f4.x, (float)4 * point3f.y - 6.0f * point3f2.y + 2.0f * point3f4.y, (float)4 * point3f.z - 6.0f * point3f2.z + 2.0f * point3f4.z);
            v3b.set(2.0f * point3f.x - 6.0f * point3f2.x + (float)4 * point3f4.x, 2.0f * point3f.y - 6.0f * point3f2.y + (float)4 * point3f4.y, 2.0f * point3f.z - 6.0f * point3f2.z + (float)4 * point3f4.z);
            return v3a.length() + v3b.length();
        }
        v3a.set(point3f.x - point3f2.x - point3f3.x + point3f4.x, point3f.y - point3f2.y - point3f3.y + point3f4.y, point3f.z - point3f2.z - point3f3.z + point3f4.z);
        return v3a.length();
    }

    private final int interpolateColor(int n, int n2) {
        int n3 = (n & 0xFE0000) >> 1;
        int n4 = (n & 0xFE00) >> 1;
        int n5 = (n & 0xFE) >> 1;
        int n6 = (n2 & 0xFE0000) >> 1;
        int n7 = (n2 & 0xFE00) >> 1;
        int n8 = (n2 & 0xFE) >> 1;
        return n3 + n6 | n4 + n7 | n5 + n8;
    }

    public static final Vector3f interpolateNormal(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f(vector3f.x + vector3f2.x, vector3f.y + vector3f2.y, vector3f.z + vector3f2.z);
        vector3f3.normalize();
        return vector3f3;
    }

    public static final Vector3f interpolateNormal(Vector3f vector3f, Vector3f vector3f2, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        v3a.set(point3f.x + point3f2.x - point3f3.x - point3f4.x, point3f.y + point3f2.y - point3f3.y - point3f4.y, point3f.z + point3f2.z - point3f3.z - point3f4.z);
        Vector3f vector3f3 = new Vector3f(vector3f.x + vector3f2.x, vector3f.y + vector3f2.y, vector3f.z + vector3f2.z);
        if (JPatchDrawableZBuffer.v3a.x != 0.0f || JPatchDrawableZBuffer.v3a.y != 0.0f || JPatchDrawableZBuffer.v3a.z != 0.0f) {
            v3a.normalize();
            vector3f3.cross(vector3f3, v3a);
            vector3f3.cross(vector3f3, v3a);
            vector3f3.scale(-1.0f / vector3f3.length());
        } else {
            vector3f3.normalize();
        }
        return vector3f3;
    }

    private final void drawCurveSegment3D(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, boolean bl) {
        if (this.subdiv(point3f, point3f2, point3f3, point3f4, bl) >= fFlatness) {
            Point3f point3f5 = new Point3f(point3f);
            Point3f point3f6 = new Point3f(point3f2);
            Point3f point3f7 = new Point3f(point3f3);
            Point3f point3f8 = new Point3f(point3f4);
            Point3f point3f9 = new Point3f();
            Point3f point3f10 = new Point3f();
            Point3f point3f11 = new Point3f();
            Point3f point3f12 = new Point3f();
            this.deCasteljauSplit(point3f5, point3f6, point3f7, point3f8, point3f9, point3f10, point3f11, point3f12);
            this.drawCurveSegment3D(point3f5, point3f6, point3f7, point3f8, true);
            this.drawCurveSegment3D(point3f9, point3f10, point3f11, point3f12, true);
        } else {
            this.drawLine3D(point3f, point3f4);
        }
    }

    private final void drawHashPatch4Gaurad(Point3f[] point3fArray, Vector3f[] vector3fArray, int[] nArray, boolean[] blArray, int[] nArray2, MaterialProperties materialProperties) {
        float f;
        boolean bl = false;
        int n = 0;
        while (n < 12) {
            if (point3fArray[n].x > 0.0f && point3fArray[n].x < (float)this.iWidth && point3fArray[n].y > 0.0f && point3fArray[n].y < (float)this.iHeight) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        Point3f point3f = point3fArray[0];
        Point3f point3f2 = point3fArray[1];
        Point3f point3f3 = point3fArray[2];
        Point3f point3f4 = point3fArray[3];
        boolean bl2 = false;
        if (nArray2[0] > 0) {
            bl2 = true;
        }
        float f2 = this.subdiv(point3f, point3f2, point3f3, point3f4, bl2);
        Point3f point3f5 = point3fArray[9];
        Point3f point3f6 = point3fArray[8];
        Point3f point3f7 = point3fArray[7];
        Point3f point3f8 = point3fArray[6];
        boolean bl3 = false;
        if (nArray2[2] > 0) {
            bl3 = true;
        }
        float f3 = this.subdiv(point3f5, point3f6, point3f7, point3f8, bl3);
        Point3f point3f9 = point3fArray[0];
        Point3f point3f10 = point3fArray[11];
        Point3f point3f11 = point3fArray[10];
        Point3f point3f12 = point3fArray[9];
        boolean bl4 = false;
        if (nArray2[3] > 0) {
            bl4 = true;
        }
        float f4 = this.subdiv(point3f9, point3f10, point3f11, point3f12, bl4);
        Point3f point3f13 = point3fArray[3];
        Point3f point3f14 = point3fArray[4];
        Point3f point3f15 = point3fArray[5];
        Point3f point3f16 = point3fArray[6];
        boolean bl5 = false;
        if (nArray2[1] > 0) {
            bl5 = true;
        }
        float f5 = this.subdiv(point3f13, point3f14, point3f15, point3f16, bl5);
        float f6 = nArray2[0] >= iMaxSubdiv || nArray2[2] >= iMaxSubdiv ? -1.0f : Math.max(f2, f3);
        float f7 = f = nArray2[1] >= iMaxSubdiv || nArray2[3] >= iMaxSubdiv ? -1.0f : Math.max(f5, f4);
        if (f6 >= fFlatness && f6 > f * 1.1f) {
            if (!blArray[0] && f2 <= fFlatness) {
                blArray[0] = this.makeFlat(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3]);
            }
            if (!blArray[1] && f5 <= fFlatness) {
                blArray[1] = this.makeFlat(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6]);
            }
            if (!blArray[2] && f3 <= fFlatness) {
                blArray[2] = this.makeFlat(point3fArray[9], point3fArray[8], point3fArray[7], point3fArray[6]);
            }
            if (!blArray[3] && f4 <= fFlatness) {
                blArray[3] = this.makeFlat(point3fArray[0], point3fArray[11], point3fArray[10], point3fArray[9]);
            }
            Vector3f[] vector3fArray2 = this.newNormals(4);
            vector3fArray2[1].set(vector3fArray[1]);
            vector3fArray[1] = nArray2[0] > 0 ? JPatchDrawableZBuffer.interpolateNormal(vector3fArray[0], vector3fArray[1]) : JPatchDrawableZBuffer.interpolateNormal(vector3fArray[0], vector3fArray[1], point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3]);
            vector3fArray2[0] = vector3fArray[1];
            vector3fArray2[2].set(vector3fArray[2]);
            vector3fArray[2] = nArray2[2] > 0 ? JPatchDrawableZBuffer.interpolateNormal(vector3fArray[3], vector3fArray[2]) : JPatchDrawableZBuffer.interpolateNormal(vector3fArray[3], vector3fArray[2], point3fArray[9], point3fArray[8], point3fArray[7], point3fArray[6]);
            vector3fArray2[3] = vector3fArray[2];
            Point3f[] point3fArray2 = this.newPatch(12);
            v3a.sub(point3fArray[11], point3fArray[0]);
            v3b.sub(point3fArray[4], point3fArray[3]);
            v3c.add(v3a, v3b);
            v3c.scale(0.5f);
            v3a.sub(point3fArray[10], point3fArray[9]);
            v3b.sub(point3fArray[5], point3fArray[6]);
            v3a.add(v3b);
            v3a.scale(0.5f);
            this.deCasteljauSplit(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], point3fArray2[0], point3fArray2[1], point3fArray2[2], point3fArray2[3]);
            this.deCasteljauSplit(point3fArray[9], point3fArray[8], point3fArray[7], point3fArray[6], point3fArray2[9], point3fArray2[8], point3fArray2[7], point3fArray2[6]);
            point3fArray2[4].set(point3fArray[4]);
            point3fArray2[5].set(point3fArray[5]);
            point3fArray[4].add(point3fArray[3], v3c);
            point3fArray[5].add(point3fArray[6], v3a);
            point3fArray2[11].set(point3fArray[4]);
            point3fArray2[10].set(point3fArray[5]);
            int[] nArray3 = new int[4];
            nArray3[1] = nArray[1];
            nArray[1] = !blArray[0] ? this.lighting.shade(point3fArray[3], vector3fArray[1], materialProperties) : this.interpolateColor(nArray[0], nArray[1]);
            nArray3[0] = nArray[1];
            nArray3[2] = nArray[2];
            nArray[2] = !blArray[2] ? this.lighting.shade(point3fArray[6], vector3fArray[2], materialProperties) : this.interpolateColor(nArray[2], nArray[3]);
            nArray3[3] = nArray[2];
            boolean[] blArray2 = new boolean[4];
            blArray2[0] = blArray[0];
            blArray2[1] = blArray[1];
            blArray2[2] = blArray[2];
            blArray[1] = false;
            blArray2[3] = false;
            int n2 = nArray2[1] < nArray2[3] ? nArray2[1] : nArray2[3];
            nArray2[0] = nArray2[0] + 1;
            nArray2[2] = nArray2[2] + 1;
            int[] nArray4 = new int[nArray2.length];
            int n3 = 0;
            while (n3 < nArray2.length) {
                nArray4[n3] = nArray2[n3++];
            }
            nArray2[1] = nArray4[3] = n2;
            this.drawHashPatch4Gaurad(point3fArray, vector3fArray, nArray, blArray, nArray2, materialProperties);
            this.drawHashPatch4Gaurad(point3fArray2, vector3fArray2, nArray3, blArray2, nArray4, materialProperties);
            return;
        }
        if (f >= fFlatness) {
            if (!blArray[0] && f2 <= fFlatness) {
                blArray[0] = this.makeFlat(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3]);
            }
            if (!blArray[1] && f5 <= fFlatness) {
                blArray[1] = this.makeFlat(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6]);
            }
            if (!blArray[2] && f3 <= fFlatness) {
                blArray[2] = this.makeFlat(point3fArray[9], point3fArray[8], point3fArray[7], point3fArray[6]);
            }
            if (!blArray[3] && f4 <= fFlatness) {
                blArray[3] = this.makeFlat(point3fArray[0], point3fArray[11], point3fArray[10], point3fArray[9]);
            }
            Vector3f[] vector3fArray3 = this.newNormals(4);
            vector3fArray3[3].set(vector3fArray[3]);
            vector3fArray[3] = nArray2[3] > 0 ? JPatchDrawableZBuffer.interpolateNormal(vector3fArray[0], vector3fArray[3]) : JPatchDrawableZBuffer.interpolateNormal(vector3fArray[0], vector3fArray[3], point3fArray[0], point3fArray[11], point3fArray[10], point3fArray[9]);
            vector3fArray3[0] = vector3fArray[3];
            vector3fArray3[2].set(vector3fArray[2]);
            vector3fArray[2] = nArray2[1] > 0 ? JPatchDrawableZBuffer.interpolateNormal(vector3fArray[1], vector3fArray[2]) : JPatchDrawableZBuffer.interpolateNormal(vector3fArray[1], vector3fArray[2], point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6]);
            vector3fArray3[1] = vector3fArray[2];
            Point3f[] point3fArray3 = this.newPatch(12);
            v3a.sub(point3fArray[1], point3fArray[0]);
            v3b.sub(point3fArray[8], point3fArray[9]);
            v3c.add(v3a, v3b);
            v3c.scale(0.5f);
            v3a.sub(point3fArray[2], point3fArray[3]);
            v3b.sub(point3fArray[7], point3fArray[6]);
            v3a.add(v3b);
            v3a.scale(0.5f);
            this.deCasteljauSplit(point3fArray[0], point3fArray[11], point3fArray[10], point3fArray[9], point3fArray3[0], point3fArray3[11], point3fArray3[10], point3fArray3[9]);
            this.deCasteljauSplit(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], point3fArray3[3], point3fArray3[4], point3fArray3[5], point3fArray3[6]);
            point3fArray3[8].set(point3fArray[8]);
            point3fArray3[7].set(point3fArray[7]);
            point3fArray[8].add(point3fArray[9], v3c);
            point3fArray[7].add(point3fArray[6], v3a);
            point3fArray3[1].set(point3fArray[8]);
            point3fArray3[2].set(point3fArray[7]);
            int[] nArray5 = new int[4];
            nArray5[3] = nArray[3];
            nArray[3] = !blArray[3] ? this.lighting.shade(point3fArray[9], vector3fArray[3], materialProperties) : this.interpolateColor(nArray[0], nArray[3]);
            nArray5[0] = nArray[3];
            nArray5[2] = nArray[2];
            nArray[2] = !blArray[1] ? this.lighting.shade(point3fArray[6], vector3fArray[2], materialProperties) : this.interpolateColor(nArray[1], nArray[2]);
            nArray5[1] = nArray[2];
            boolean[] blArray3 = new boolean[4];
            blArray3[1] = blArray[1];
            blArray3[3] = blArray[3];
            blArray3[2] = blArray[2];
            blArray[2] = false;
            blArray3[0] = false;
            int n4 = nArray2[0] < nArray2[2] ? nArray2[0] : nArray2[2];
            nArray2[1] = nArray2[1] + 1;
            nArray2[3] = nArray2[3] + 1;
            int[] nArray6 = new int[nArray2.length];
            int n5 = 0;
            while (n5 < nArray2.length) {
                nArray6[n5] = nArray2[n5++];
            }
            nArray2[2] = nArray6[0] = n4;
            this.drawHashPatch4Gaurad(point3fArray, vector3fArray, nArray, blArray, nArray2, materialProperties);
            this.drawHashPatch4Gaurad(point3fArray3, vector3fArray3, nArray5, blArray3, nArray6, materialProperties);
            return;
        }
        if (materialProperties.isOpaque()) {
            this.draw3DTriangleGourad(point3fArray[9], point3fArray[3], point3fArray[0], nArray[3], nArray[1], nArray[0]);
            this.draw3DTriangleGourad(point3fArray[3], point3fArray[9], point3fArray[6], nArray[1], nArray[3], nArray[2]);
        } else {
            int n6 = (int)(Math.min(1.0f, materialProperties.transmit + materialProperties.filter) * 255.0f);
            this.draw3DTriangleGouradTransparent(point3fArray[9], point3fArray[3], point3fArray[0], nArray[3], nArray[1], nArray[0], n6);
            this.draw3DTriangleGouradTransparent(point3fArray[3], point3fArray[9], point3fArray[6], nArray[1], nArray[3], nArray[2], n6);
        }
    }

    private final void drawHashPatch4Flat(Point3f[] point3fArray, boolean[] blArray, int[] nArray, int n, int n2) {
        float f;
        boolean bl = false;
        int n3 = 0;
        while (n3 < 12) {
            if (point3fArray[n3].x > 0.0f && point3fArray[n3].x < (float)this.iWidth && point3fArray[n3].y > 0.0f && point3fArray[n3].y < (float)this.iHeight) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl) {
            return;
        }
        Point3f point3f = point3fArray[0];
        Point3f point3f2 = point3fArray[1];
        Point3f point3f3 = point3fArray[2];
        Point3f point3f4 = point3fArray[3];
        boolean bl2 = false;
        if (nArray[0] > 0) {
            bl2 = true;
        }
        float f2 = this.subdiv(point3f, point3f2, point3f3, point3f4, bl2);
        Point3f point3f5 = point3fArray[9];
        Point3f point3f6 = point3fArray[8];
        Point3f point3f7 = point3fArray[7];
        Point3f point3f8 = point3fArray[6];
        boolean bl3 = false;
        if (nArray[2] > 0) {
            bl3 = true;
        }
        float f3 = this.subdiv(point3f5, point3f6, point3f7, point3f8, bl3);
        Point3f point3f9 = point3fArray[0];
        Point3f point3f10 = point3fArray[11];
        Point3f point3f11 = point3fArray[10];
        Point3f point3f12 = point3fArray[9];
        boolean bl4 = false;
        if (nArray[3] > 0) {
            bl4 = true;
        }
        float f4 = this.subdiv(point3f9, point3f10, point3f11, point3f12, bl4);
        Point3f point3f13 = point3fArray[3];
        Point3f point3f14 = point3fArray[4];
        Point3f point3f15 = point3fArray[5];
        Point3f point3f16 = point3fArray[6];
        boolean bl5 = false;
        if (nArray[1] > 0) {
            bl5 = true;
        }
        float f5 = this.subdiv(point3f13, point3f14, point3f15, point3f16, bl5);
        float f6 = nArray[0] >= iMaxSubdiv || nArray[2] >= iMaxSubdiv ? -1.0f : Math.max(f2, f3);
        float f7 = f = nArray[1] >= iMaxSubdiv || nArray[3] >= iMaxSubdiv ? -1.0f : Math.max(f5, f4);
        if (f6 >= fFlatness && f6 > f * 1.1f) {
            if (!blArray[0] && f2 <= fFlatness) {
                blArray[0] = this.makeFlat(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3]);
            }
            if (!blArray[1] && f5 <= fFlatness) {
                blArray[1] = this.makeFlat(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6]);
            }
            if (!blArray[2] && f3 <= fFlatness) {
                blArray[2] = this.makeFlat(point3fArray[9], point3fArray[8], point3fArray[7], point3fArray[6]);
            }
            if (!blArray[3] && f4 <= fFlatness) {
                blArray[3] = this.makeFlat(point3fArray[0], point3fArray[11], point3fArray[10], point3fArray[9]);
            }
            Point3f[] point3fArray2 = this.newPatch(12);
            v3a.sub(point3fArray[11], point3fArray[0]);
            v3b.sub(point3fArray[4], point3fArray[3]);
            v3c.add(v3a, v3b);
            v3c.scale(0.5f);
            v3a.sub(point3fArray[10], point3fArray[9]);
            v3b.sub(point3fArray[5], point3fArray[6]);
            v3a.add(v3b);
            v3a.scale(0.5f);
            this.deCasteljauSplit(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], point3fArray2[0], point3fArray2[1], point3fArray2[2], point3fArray2[3]);
            this.deCasteljauSplit(point3fArray[9], point3fArray[8], point3fArray[7], point3fArray[6], point3fArray2[9], point3fArray2[8], point3fArray2[7], point3fArray2[6]);
            point3fArray2[4].set(point3fArray[4]);
            point3fArray2[5].set(point3fArray[5]);
            point3fArray[4].add(point3fArray[3], v3c);
            point3fArray[5].add(point3fArray[6], v3a);
            point3fArray2[11].set(point3fArray[4]);
            point3fArray2[10].set(point3fArray[5]);
            boolean[] blArray2 = new boolean[4];
            blArray2[0] = blArray[0];
            blArray2[1] = blArray[1];
            blArray2[2] = blArray[2];
            blArray[1] = false;
            blArray2[3] = false;
            int n4 = nArray[1] < nArray[3] ? nArray[1] : nArray[3];
            nArray[0] = nArray[0] + 1;
            nArray[2] = nArray[2] + 1;
            int[] nArray2 = new int[nArray.length];
            int n5 = 0;
            while (n5 < nArray.length) {
                nArray2[n5] = nArray[n5++];
            }
            nArray[1] = nArray2[3] = n4;
            this.drawHashPatch4Flat(point3fArray, blArray, nArray, n, n2);
            this.drawHashPatch4Flat(point3fArray2, blArray2, nArray2, n, n2);
            return;
        }
        if (f >= fFlatness) {
            if (!blArray[0] && f2 <= fFlatness) {
                blArray[0] = this.makeFlat(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3]);
            }
            if (!blArray[1] && f5 <= fFlatness) {
                blArray[1] = this.makeFlat(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6]);
            }
            if (!blArray[2] && f3 <= fFlatness) {
                blArray[2] = this.makeFlat(point3fArray[9], point3fArray[8], point3fArray[7], point3fArray[6]);
            }
            if (!blArray[3] && f4 <= fFlatness) {
                blArray[3] = this.makeFlat(point3fArray[0], point3fArray[11], point3fArray[10], point3fArray[9]);
            }
            Point3f[] point3fArray3 = this.newPatch(12);
            v3a.sub(point3fArray[1], point3fArray[0]);
            v3b.sub(point3fArray[8], point3fArray[9]);
            v3c.add(v3a, v3b);
            v3c.scale(0.5f);
            v3a.sub(point3fArray[2], point3fArray[3]);
            v3b.sub(point3fArray[7], point3fArray[6]);
            v3a.add(v3b);
            v3a.scale(0.5f);
            this.deCasteljauSplit(point3fArray[0], point3fArray[11], point3fArray[10], point3fArray[9], point3fArray3[0], point3fArray3[11], point3fArray3[10], point3fArray3[9]);
            this.deCasteljauSplit(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], point3fArray3[3], point3fArray3[4], point3fArray3[5], point3fArray3[6]);
            point3fArray3[8].set(point3fArray[8]);
            point3fArray3[7].set(point3fArray[7]);
            point3fArray[8].add(point3fArray[9], v3c);
            point3fArray[7].add(point3fArray[6], v3a);
            point3fArray3[1].set(point3fArray[8]);
            point3fArray3[2].set(point3fArray[7]);
            boolean[] blArray3 = new boolean[4];
            blArray3[1] = blArray[1];
            blArray3[3] = blArray[3];
            blArray3[2] = blArray[2];
            blArray[2] = false;
            blArray3[0] = false;
            int n6 = nArray[0] < nArray[2] ? nArray[0] : nArray[2];
            nArray[1] = nArray[1] + 1;
            nArray[3] = nArray[3] + 1;
            int[] nArray3 = new int[nArray.length];
            int n7 = 0;
            while (n7 < nArray.length) {
                nArray3[n7] = nArray[n7++];
            }
            nArray[2] = nArray3[0] = n6;
            this.drawHashPatch4Flat(point3fArray, blArray, nArray, n, n2);
            this.drawHashPatch4Flat(point3fArray3, blArray3, nArray3, n, n2);
            return;
        }
        if (n2 == 0) {
            this.draw3DTriangleFlat(point3fArray[9], point3fArray[3], point3fArray[0], n);
            this.draw3DTriangleFlat(point3fArray[3], point3fArray[9], point3fArray[6], n);
        } else {
            this.draw3DTriangleFlatTransparent(point3fArray[9], point3fArray[3], point3fArray[0], n, n2);
            this.draw3DTriangleFlatTransparent(point3fArray[3], point3fArray[9], point3fArray[6], n, n2);
        }
    }

    private final Point3f[] newPatch(int n) {
        Point3f[] point3fArray = new Point3f[n];
        int n2 = 0;
        while (n2 < n) {
            point3fArray[n2++] = new Point3f();
        }
        return point3fArray;
    }

    private final Vector3f[] newNormals(int n) {
        Vector3f[] vector3fArray = new Vector3f[n];
        int n2 = 0;
        while (n2 < n) {
            vector3fArray[n2++] = new Vector3f();
        }
        return vector3fArray;
    }

    private final void deCasteljauSplit(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Point3f point3f5, Point3f point3f6, Point3f point3f7, Point3f point3f8) {
        point3f5.set((point3f2.x + point3f3.x) * 0.5f, (point3f2.y + point3f3.y) * 0.5f, (point3f2.z + point3f3.z) * 0.5f);
        point3f8.set(point3f4);
        point3f7.set((point3f3.x + point3f4.x) * 0.5f, (point3f3.y + point3f4.y) * 0.5f, (point3f3.z + point3f4.z) * 0.5f);
        point3f6.set((point3f7.x + point3f5.x) * 0.5f, (point3f7.y + point3f5.y) * 0.5f, (point3f7.z + point3f5.z) * 0.5f);
        point3f2.set((point3f.x + point3f2.x) * 0.5f, (point3f.y + point3f2.y) * 0.5f, (point3f.z + point3f2.z) * 0.5f);
        point3f3.set((point3f2.x + point3f5.x) * 0.5f, (point3f2.y + point3f5.y) * 0.5f, (point3f2.z + point3f5.z) * 0.5f);
        point3f4.set((point3f3.x + point3f6.x) * 0.5f, (point3f3.y + point3f6.y) * 0.5f, (point3f3.z + point3f6.z) * 0.5f);
        point3f5.set(point3f4);
    }

    public final void drawHashPatchGourad(Point3f[] point3fArray, Vector3f[] vector3fArray, int[] nArray, MaterialProperties materialProperties) {
        boolean[] blArray = new boolean[4];
        int[] nArray2 = new int[4];
        switch (point3fArray.length) {
            case 9: {
                nArray2[0] = this.lighting.shade(point3fArray[0], vector3fArray[0], materialProperties);
                nArray2[1] = this.lighting.shade(point3fArray[3], vector3fArray[1], materialProperties);
                nArray2[2] = this.lighting.shade(point3fArray[6], vector3fArray[2], materialProperties);
                nArray2[3] = nArray2[0];
                Vector3f[] vector3fArray2 = new Vector3f[]{vector3fArray[0], vector3fArray[1], vector3fArray[2], new Vector3f(vector3fArray[0])};
                Point3f[] point3fArray2 = new Point3f[]{point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], point3fArray[7], point3fArray[8], new Point3f(point3fArray[0]), new Point3f(point3fArray[0]), new Point3f(point3fArray[0])};
                int[] nArray3 = new int[4];
                nArray3[0] = nArray[0];
                nArray3[1] = nArray[1];
                nArray3[2] = nArray[2];
                int[] nArray4 = nArray3;
                this.drawHashPatch4Gaurad(point3fArray2, vector3fArray2, nArray2, blArray, nArray4, materialProperties);
                break;
            }
            case 12: {
                nArray2[0] = this.lighting.shade(point3fArray[0], vector3fArray[0], materialProperties);
                nArray2[1] = this.lighting.shade(point3fArray[3], vector3fArray[1], materialProperties);
                nArray2[2] = this.lighting.shade(point3fArray[6], vector3fArray[2], materialProperties);
                nArray2[3] = this.lighting.shade(point3fArray[9], vector3fArray[3], materialProperties);
                this.drawHashPatch4Gaurad(point3fArray, vector3fArray, nArray2, blArray, nArray, materialProperties);
                break;
            }
            case 15: {
                Vector3f[] vector3fArray3 = new Vector3f[]{JPatchDrawableZBuffer.interpolateNormal(vector3fArray[0], vector3fArray[1], point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3]), JPatchDrawableZBuffer.interpolateNormal(vector3fArray[1], vector3fArray[2], point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6]), JPatchDrawableZBuffer.interpolateNormal(vector3fArray[2], vector3fArray[3], point3fArray[6], point3fArray[7], point3fArray[8], point3fArray[9]), JPatchDrawableZBuffer.interpolateNormal(vector3fArray[3], vector3fArray[4], point3fArray[9], point3fArray[10], point3fArray[11], point3fArray[12]), JPatchDrawableZBuffer.interpolateNormal(vector3fArray[4], vector3fArray[0], point3fArray[12], point3fArray[13], point3fArray[14], point3fArray[0])};
                int[] nArray5 = new int[]{this.lighting.shade(point3fArray[0], vector3fArray[0], materialProperties), this.lighting.shade(point3fArray[3], vector3fArray[1], materialProperties), this.lighting.shade(point3fArray[6], vector3fArray[2], materialProperties), this.lighting.shade(point3fArray[9], vector3fArray[3], materialProperties), this.lighting.shade(point3fArray[12], vector3fArray[4], materialProperties)};
                Point3f point3f = Functions.parallelogram(point3fArray[0], point3fArray[1], point3fArray[14]);
                Point3f point3f2 = Functions.parallelogram(point3fArray[3], point3fArray[4], point3fArray[2]);
                Point3f point3f3 = Functions.parallelogram(point3fArray[6], point3fArray[7], point3fArray[5]);
                Point3f point3f4 = Functions.parallelogram(point3fArray[9], point3fArray[10], point3fArray[8]);
                Point3f point3f5 = Functions.parallelogram(point3fArray[12], point3fArray[13], point3fArray[11]);
                Point3f point3f6 = Functions.average(point3f, point3fArray[0], point3fArray[1], point3fArray[14]);
                Point3f point3f7 = Functions.average(point3f2, point3fArray[3], point3fArray[4], point3fArray[2]);
                Point3f point3f8 = Functions.average(point3f3, point3fArray[6], point3fArray[7], point3fArray[5]);
                Point3f point3f9 = Functions.average(point3f4, point3fArray[9], point3fArray[10], point3fArray[8]);
                Point3f point3f10 = Functions.average(point3f5, point3fArray[12], point3fArray[13], point3fArray[11]);
                Point3f point3f11 = Functions.average(point3f, point3f2, point3fArray[1], point3fArray[2]);
                Point3f point3f12 = Functions.average(point3f2, point3f3, point3fArray[4], point3fArray[5]);
                Point3f point3f13 = Functions.average(point3f3, point3f4, point3fArray[7], point3fArray[8]);
                Point3f point3f14 = Functions.average(point3f4, point3f5, point3fArray[10], point3fArray[11]);
                Point3f point3f15 = Functions.average(point3f5, point3f, point3fArray[13], point3fArray[14]);
                Point3f point3f16 = Functions.average(point3f, point3f2, point3f3, point3f4, point3f5);
                Point3f point3f17 = Functions.average(point3f16, point3f15, point3f6, point3f11);
                Point3f point3f18 = Functions.average(point3f16, point3f11, point3f7, point3f12);
                Point3f point3f19 = Functions.average(point3f16, point3f12, point3f8, point3f13);
                Point3f point3f20 = Functions.average(point3f16, point3f13, point3f9, point3f14);
                Point3f point3f21 = Functions.average(point3f16, point3f14, point3f10, point3f15);
                Point3f point3f22 = Functions.average(point3f21, point3f17);
                Point3f point3f23 = Functions.average(point3f17, point3f18);
                Point3f point3f24 = Functions.average(point3f18, point3f19);
                Point3f point3f25 = Functions.average(point3f19, point3f20);
                Point3f point3f26 = Functions.average(point3f20, point3f21);
                Point3f point3f27 = Functions.average(point3f17, point3f18, point3f19, point3f20, point3f21);
                Vector3f vector3f = Functions.vector(point3f22, point3f27);
                Vector3f vector3f2 = Functions.vector(point3f23, point3f27);
                Vector3f vector3f3 = Functions.vector(point3f24, point3f27);
                Vector3f vector3f4 = Functions.vector(point3f25, point3f27);
                Vector3f vector3f5 = Functions.vector(point3f26, point3f27);
                Vector3f[] vector3fArray4 = this.newNormals(5);
                vector3fArray4[0].cross(vector3f2, vector3f);
                vector3fArray4[1].cross(vector3f3, vector3f2);
                vector3fArray4[2].cross(vector3f4, vector3f3);
                vector3fArray4[3].cross(vector3f5, vector3f4);
                vector3fArray4[4].cross(vector3f, vector3f5);
                vector3fArray4[0].normalize();
                vector3fArray4[1].normalize();
                vector3fArray4[2].normalize();
                vector3fArray4[3].normalize();
                vector3fArray4[4].normalize();
                Vector3f vector3f6 = Functions.vaverage(vector3fArray4[0], vector3fArray4[1], vector3fArray4[2], vector3fArray4[3], vector3fArray4[4]);
                vector3f6.normalize();
                Vector3f[] vector3fArray5 = this.newNormals(4);
                Point3f[][] point3fArray3 = new Point3f[5][7];
                point3fArray3[0] = Bezier.deCasteljau(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], 0.5f);
                point3fArray3[1] = Bezier.deCasteljau(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], 0.5f);
                point3fArray3[2] = Bezier.deCasteljau(point3fArray[6], point3fArray[7], point3fArray[8], point3fArray[9], 0.5f);
                point3fArray3[3] = Bezier.deCasteljau(point3fArray[9], point3fArray[10], point3fArray[11], point3fArray[12], 0.5f);
                point3fArray3[4] = Bezier.deCasteljau(point3fArray[12], point3fArray[13], point3fArray[14], point3fArray[0], 0.5f);
                int[] nArray6 = new int[]{this.lighting.shade(point3fArray3[0][3], vector3fArray3[0], materialProperties), this.lighting.shade(point3fArray3[1][3], vector3fArray3[1], materialProperties), this.lighting.shade(point3fArray3[2][3], vector3fArray3[2], materialProperties), this.lighting.shade(point3fArray3[3][3], vector3fArray3[3], materialProperties), this.lighting.shade(point3fArray3[4][3], vector3fArray3[4], materialProperties)};
                int n = this.lighting.shade(point3f27, vector3f6, materialProperties);
                Point3f[] point3fArray4 = new Point3f[12];
                int[] nArray7 = new int[4];
                point3fArray4[0] = new Point3f(point3fArray3[0][0]);
                point3fArray4[1] = new Point3f(point3fArray3[0][1]);
                point3fArray4[2] = new Point3f(point3fArray3[0][2]);
                point3fArray4[3] = new Point3f(point3fArray3[0][3]);
                point3fArray4[11] = new Point3f(point3fArray3[4][5]);
                point3fArray4[4] = new Point3f(point3fArray3[0][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[3], point3fArray[4]), Functions.vector(point3fArray[0], point3fArray[14])));
                point3fArray4[10] = new Point3f(point3fArray3[4][4]);
                point3fArray4[5] = new Point3f(point3f23);
                point3fArray4[9] = new Point3f(point3fArray3[4][3]);
                point3fArray4[8] = new Point3f(point3fArray3[4][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[0], point3fArray[1]), Functions.vector(point3fArray[12], point3fArray[11])));
                point3fArray4[7] = new Point3f(point3f22);
                point3fArray4[6] = new Point3f(point3f27);
                vector3fArray5[0].set(vector3fArray[0]);
                vector3fArray5[1].set(vector3fArray3[0]);
                vector3fArray5[2].set(vector3f6);
                vector3fArray5[3].set(vector3fArray3[4]);
                nArray2[0] = nArray5[0];
                nArray2[1] = nArray6[0];
                nArray2[2] = n;
                nArray2[3] = nArray6[4];
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray7[0] = nArray[0] + 1;
                nArray7[1] = 1;
                nArray7[2] = 1;
                nArray7[3] = nArray[4] + 1;
                this.drawHashPatch4Gaurad(point3fArray4, vector3fArray5, nArray2, blArray, nArray7, materialProperties);
                point3fArray4[0].set(point3fArray3[1][0]);
                point3fArray4[1].set(point3fArray3[1][1]);
                point3fArray4[2].set(point3fArray3[1][2]);
                point3fArray4[3].set(point3fArray3[1][3]);
                point3fArray4[11].set(point3fArray3[0][5]);
                point3fArray4[4].set(point3fArray3[1][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[6], point3fArray[7]), Functions.vector(point3fArray[3], point3fArray[2])));
                point3fArray4[10].set(point3fArray3[0][4]);
                point3fArray4[5].set(point3f24);
                point3fArray4[9].set(point3fArray3[0][3]);
                point3fArray4[8].set(point3fArray3[0][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[3], point3fArray[4]), Functions.vector(point3fArray[0], point3fArray[14])));
                point3fArray4[7].set(point3f23);
                point3fArray4[6].set(point3f27);
                vector3fArray5[0].set(vector3fArray[1]);
                vector3fArray5[1].set(vector3fArray3[1]);
                vector3fArray5[2].set(vector3f6);
                vector3fArray5[3].set(vector3fArray3[0]);
                nArray2[0] = nArray5[1];
                nArray2[1] = nArray6[1];
                nArray2[2] = n;
                nArray2[3] = nArray6[0];
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray7[0] = nArray[1] + 1;
                nArray7[1] = 1;
                nArray7[2] = 1;
                nArray7[3] = nArray[0] + 1;
                this.drawHashPatch4Gaurad(point3fArray4, vector3fArray5, nArray2, blArray, nArray7, materialProperties);
                point3fArray4[0].set(point3fArray3[2][0]);
                point3fArray4[1].set(point3fArray3[2][1]);
                point3fArray4[2].set(point3fArray3[2][2]);
                point3fArray4[3].set(point3fArray3[2][3]);
                point3fArray4[11].set(point3fArray3[1][5]);
                point3fArray4[4].set(point3fArray3[2][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[10]), Functions.vector(point3fArray[6], point3fArray[5])));
                point3fArray4[10] = new Point3f(point3fArray3[1][4]);
                point3fArray4[5].set(point3f25);
                point3fArray4[9].set(point3fArray3[1][3]);
                point3fArray4[8].set(point3fArray3[1][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[6], point3fArray[7]), Functions.vector(point3fArray[3], point3fArray[2])));
                point3fArray4[7].set(point3f24);
                point3fArray4[6].set(point3f27);
                vector3fArray5[0].set(vector3fArray[2]);
                vector3fArray5[1].set(vector3fArray3[2]);
                vector3fArray5[2].set(vector3f6);
                vector3fArray5[3].set(vector3fArray3[1]);
                nArray2[0] = nArray5[2];
                nArray2[1] = nArray6[2];
                nArray2[2] = n;
                nArray2[3] = nArray6[1];
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray7[0] = nArray[2] + 1;
                nArray7[1] = 1;
                nArray7[2] = 1;
                nArray7[3] = nArray[1] + 1;
                this.drawHashPatch4Gaurad(point3fArray4, vector3fArray5, nArray2, blArray, nArray7, materialProperties);
                point3fArray4[0].set(point3fArray3[3][0]);
                point3fArray4[1].set(point3fArray3[3][1]);
                point3fArray4[2].set(point3fArray3[3][2]);
                point3fArray4[3].set(point3fArray3[3][3]);
                point3fArray4[11].set(point3fArray3[2][5]);
                point3fArray4[4].set(point3fArray3[3][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[8]), Functions.vector(point3fArray[12], point3fArray[13])));
                point3fArray4[10].set(point3fArray3[2][4]);
                point3fArray4[5].set(point3f26);
                point3fArray4[9].set(point3fArray3[2][3]);
                point3fArray4[8].set(point3fArray3[2][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[10]), Functions.vector(point3fArray[6], point3fArray[5])));
                point3fArray4[7].set(point3f25);
                point3fArray4[6].set(point3f27);
                vector3fArray5[0].set(vector3fArray[3]);
                vector3fArray5[1].set(vector3fArray3[3]);
                vector3fArray5[2].set(vector3f6);
                vector3fArray5[3].set(vector3fArray3[2]);
                nArray2[0] = nArray5[3];
                nArray2[1] = nArray6[3];
                nArray2[2] = n;
                nArray2[3] = nArray6[2];
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray7[0] = nArray[3] + 1;
                nArray7[1] = 1;
                nArray7[2] = 1;
                nArray7[3] = nArray[2] + 1;
                this.drawHashPatch4Gaurad(point3fArray4, vector3fArray5, nArray2, blArray, nArray7, materialProperties);
                point3fArray4[0].set(point3fArray3[4][0]);
                point3fArray4[1].set(point3fArray3[4][1]);
                point3fArray4[2].set(point3fArray3[4][2]);
                point3fArray4[3].set(point3fArray3[4][3]);
                point3fArray4[11].set(point3fArray3[3][5]);
                point3fArray4[4].set(point3fArray3[4][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[12], point3fArray[11]), Functions.vector(point3fArray[0], point3fArray[1])));
                point3fArray4[10].set(point3fArray3[3][4]);
                point3fArray4[5].set(point3f22);
                point3fArray4[9].set(point3fArray3[3][3]);
                point3fArray4[8].set(point3fArray3[3][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[8]), Functions.vector(point3fArray[12], point3fArray[13])));
                point3fArray4[7].set(point3f26);
                point3fArray4[6].set(point3f27);
                vector3fArray5[0].set(vector3fArray[4]);
                vector3fArray5[1].set(vector3fArray3[4]);
                vector3fArray5[2].set(vector3f6);
                vector3fArray5[3].set(vector3fArray3[3]);
                nArray2[0] = nArray5[4];
                nArray2[1] = nArray6[4];
                nArray2[2] = n;
                nArray2[3] = nArray6[3];
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray7[0] = nArray[4] + 1;
                nArray7[1] = 1;
                nArray7[2] = 1;
                nArray7[3] = nArray[3] + 1;
                this.drawHashPatch4Gaurad(point3fArray4, vector3fArray5, nArray2, blArray, nArray7, materialProperties);
                break;
            }
        }
    }

    public final void drawHashPatchFlat(Point3f[] point3fArray, int[] nArray, MaterialProperties materialProperties) {
        boolean[] blArray = new boolean[4];
        int n = materialProperties.getRGB();
        int n2 = (int)(Math.min(1.0f, materialProperties.transmit + materialProperties.filter) * 255.0f);
        switch (point3fArray.length) {
            case 9: {
                Point3f[] point3fArray2 = new Point3f[]{point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], point3fArray[7], point3fArray[8], new Point3f(point3fArray[0]), new Point3f(point3fArray[0]), new Point3f(point3fArray[0])};
                int[] nArray2 = new int[4];
                nArray2[0] = nArray[0];
                nArray2[1] = nArray[1];
                nArray2[2] = nArray[2];
                int[] nArray3 = nArray2;
                this.drawHashPatch4Flat(point3fArray2, blArray, nArray3, n, n2);
                break;
            }
            case 12: {
                this.drawHashPatch4Flat(point3fArray, blArray, nArray, n, n2);
                break;
            }
            case 15: {
                Point3f point3f = Functions.parallelogram(point3fArray[0], point3fArray[1], point3fArray[14]);
                Point3f point3f2 = Functions.parallelogram(point3fArray[3], point3fArray[4], point3fArray[2]);
                Point3f point3f3 = Functions.parallelogram(point3fArray[6], point3fArray[7], point3fArray[5]);
                Point3f point3f4 = Functions.parallelogram(point3fArray[9], point3fArray[10], point3fArray[8]);
                Point3f point3f5 = Functions.parallelogram(point3fArray[12], point3fArray[13], point3fArray[11]);
                Point3f point3f6 = Functions.average(point3f, point3fArray[0], point3fArray[1], point3fArray[14]);
                Point3f point3f7 = Functions.average(point3f2, point3fArray[3], point3fArray[4], point3fArray[2]);
                Point3f point3f8 = Functions.average(point3f3, point3fArray[6], point3fArray[7], point3fArray[5]);
                Point3f point3f9 = Functions.average(point3f4, point3fArray[9], point3fArray[10], point3fArray[8]);
                Point3f point3f10 = Functions.average(point3f5, point3fArray[12], point3fArray[13], point3fArray[11]);
                Point3f point3f11 = Functions.average(point3f, point3f2, point3fArray[1], point3fArray[2]);
                Point3f point3f12 = Functions.average(point3f2, point3f3, point3fArray[4], point3fArray[5]);
                Point3f point3f13 = Functions.average(point3f3, point3f4, point3fArray[7], point3fArray[8]);
                Point3f point3f14 = Functions.average(point3f4, point3f5, point3fArray[10], point3fArray[11]);
                Point3f point3f15 = Functions.average(point3f5, point3f, point3fArray[13], point3fArray[14]);
                Point3f point3f16 = Functions.average(point3f, point3f2, point3f3, point3f4, point3f5);
                Point3f point3f17 = Functions.average(point3f16, point3f15, point3f6, point3f11);
                Point3f point3f18 = Functions.average(point3f16, point3f11, point3f7, point3f12);
                Point3f point3f19 = Functions.average(point3f16, point3f12, point3f8, point3f13);
                Point3f point3f20 = Functions.average(point3f16, point3f13, point3f9, point3f14);
                Point3f point3f21 = Functions.average(point3f16, point3f14, point3f10, point3f15);
                Point3f point3f22 = Functions.average(point3f21, point3f17);
                Point3f point3f23 = Functions.average(point3f17, point3f18);
                Point3f point3f24 = Functions.average(point3f18, point3f19);
                Point3f point3f25 = Functions.average(point3f19, point3f20);
                Point3f point3f26 = Functions.average(point3f20, point3f21);
                Point3f point3f27 = Functions.average(point3f17, point3f18, point3f19, point3f20, point3f21);
                Vector3f vector3f = Functions.vector(point3f22, point3f27);
                Vector3f vector3f2 = Functions.vector(point3f23, point3f27);
                Vector3f vector3f3 = Functions.vector(point3f24, point3f27);
                Vector3f vector3f4 = Functions.vector(point3f25, point3f27);
                Vector3f vector3f5 = Functions.vector(point3f26, point3f27);
                Point3f[][] point3fArray3 = new Point3f[5][7];
                point3fArray3[0] = Bezier.deCasteljau(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], 0.5f);
                point3fArray3[1] = Bezier.deCasteljau(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], 0.5f);
                point3fArray3[2] = Bezier.deCasteljau(point3fArray[6], point3fArray[7], point3fArray[8], point3fArray[9], 0.5f);
                point3fArray3[3] = Bezier.deCasteljau(point3fArray[9], point3fArray[10], point3fArray[11], point3fArray[12], 0.5f);
                point3fArray3[4] = Bezier.deCasteljau(point3fArray[12], point3fArray[13], point3fArray[14], point3fArray[0], 0.5f);
                Point3f[] point3fArray4 = new Point3f[12];
                int[] nArray4 = new int[4];
                point3fArray4[0] = new Point3f(point3fArray3[0][0]);
                point3fArray4[1] = new Point3f(point3fArray3[0][1]);
                point3fArray4[2] = new Point3f(point3fArray3[0][2]);
                point3fArray4[3] = new Point3f(point3fArray3[0][3]);
                point3fArray4[11] = new Point3f(point3fArray3[4][5]);
                point3fArray4[4] = new Point3f(point3fArray3[0][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[3], point3fArray[4]), Functions.vector(point3fArray[0], point3fArray[14])));
                point3fArray4[10] = new Point3f(point3fArray3[4][4]);
                point3fArray4[5] = new Point3f(point3f23);
                point3fArray4[9] = new Point3f(point3fArray3[4][3]);
                point3fArray4[8] = new Point3f(point3fArray3[4][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[0], point3fArray[1]), Functions.vector(point3fArray[12], point3fArray[11])));
                point3fArray4[7] = new Point3f(point3f22);
                point3fArray4[6] = new Point3f(point3f27);
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray4[0] = nArray[0] + 1;
                nArray4[1] = 1;
                nArray4[2] = 1;
                nArray4[3] = nArray[4] + 1;
                this.drawHashPatch4Flat(point3fArray4, blArray, nArray4, n, n2);
                point3fArray4[0].set(point3fArray3[1][0]);
                point3fArray4[1].set(point3fArray3[1][1]);
                point3fArray4[2].set(point3fArray3[1][2]);
                point3fArray4[3].set(point3fArray3[1][3]);
                point3fArray4[11].set(point3fArray3[0][5]);
                point3fArray4[4].set(point3fArray3[1][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[6], point3fArray[7]), Functions.vector(point3fArray[3], point3fArray[2])));
                point3fArray4[10].set(point3fArray3[0][4]);
                point3fArray4[5].set(point3f24);
                point3fArray4[9].set(point3fArray3[0][3]);
                point3fArray4[8].set(point3fArray3[0][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[3], point3fArray[4]), Functions.vector(point3fArray[0], point3fArray[14])));
                point3fArray4[7].set(point3f23);
                point3fArray4[6].set(point3f27);
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray4[0] = nArray[1] + 1;
                nArray4[1] = 1;
                nArray4[2] = 1;
                nArray4[3] = nArray[0] + 1;
                this.drawHashPatch4Flat(point3fArray4, blArray, nArray4, n, n2);
                point3fArray4[0].set(point3fArray3[2][0]);
                point3fArray4[1].set(point3fArray3[2][1]);
                point3fArray4[2].set(point3fArray3[2][2]);
                point3fArray4[3].set(point3fArray3[2][3]);
                point3fArray4[11].set(point3fArray3[1][5]);
                point3fArray4[4].set(point3fArray3[2][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[10]), Functions.vector(point3fArray[6], point3fArray[5])));
                point3fArray4[10] = new Point3f(point3fArray3[1][4]);
                point3fArray4[5].set(point3f25);
                point3fArray4[9].set(point3fArray3[1][3]);
                point3fArray4[8].set(point3fArray3[1][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[6], point3fArray[7]), Functions.vector(point3fArray[3], point3fArray[2])));
                point3fArray4[7].set(point3f24);
                point3fArray4[6].set(point3f27);
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray4[0] = nArray[2] + 1;
                nArray4[1] = 1;
                nArray4[2] = 1;
                nArray4[3] = nArray[1] + 1;
                this.drawHashPatch4Flat(point3fArray4, blArray, nArray4, n, n2);
                point3fArray4[0].set(point3fArray3[3][0]);
                point3fArray4[1].set(point3fArray3[3][1]);
                point3fArray4[2].set(point3fArray3[3][2]);
                point3fArray4[3].set(point3fArray3[3][3]);
                point3fArray4[11].set(point3fArray3[2][5]);
                point3fArray4[4].set(point3fArray3[3][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[8]), Functions.vector(point3fArray[12], point3fArray[13])));
                point3fArray4[10].set(point3fArray3[2][4]);
                point3fArray4[5].set(point3f26);
                point3fArray4[9].set(point3fArray3[2][3]);
                point3fArray4[8].set(point3fArray3[2][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[10]), Functions.vector(point3fArray[6], point3fArray[5])));
                point3fArray4[7].set(point3f25);
                point3fArray4[6].set(point3f27);
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray4[0] = nArray[3] + 1;
                nArray4[1] = 1;
                nArray4[2] = 1;
                nArray4[3] = nArray[2] + 1;
                this.drawHashPatch4Flat(point3fArray4, blArray, nArray4, n, n2);
                point3fArray4[0].set(point3fArray3[4][0]);
                point3fArray4[1].set(point3fArray3[4][1]);
                point3fArray4[2].set(point3fArray3[4][2]);
                point3fArray4[3].set(point3fArray3[4][3]);
                point3fArray4[11].set(point3fArray3[3][5]);
                point3fArray4[4].set(point3fArray3[4][3]);
                point3fArray4[4].add(Functions.average(Functions.vector(point3fArray[12], point3fArray[11]), Functions.vector(point3fArray[0], point3fArray[1])));
                point3fArray4[10].set(point3fArray3[3][4]);
                point3fArray4[5].set(point3f22);
                point3fArray4[9].set(point3fArray3[3][3]);
                point3fArray4[8].set(point3fArray3[3][3]);
                point3fArray4[8].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[8]), Functions.vector(point3fArray[12], point3fArray[13])));
                point3fArray4[7].set(point3f26);
                point3fArray4[6].set(point3f27);
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
                blArray[0] = false;
                nArray4[0] = nArray[4] + 1;
                nArray4[1] = 1;
                nArray4[2] = 1;
                nArray4[3] = nArray[3] + 1;
                this.drawHashPatch4Flat(point3fArray4, blArray, nArray4, n, n2);
                break;
            }
        }
    }

    public final void addQuad(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6, Point3d point3d7, Point3d point3d8, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        Point3f point3f = new Point3f(point3d);
        Point3f point3f2 = new Point3f(point3d2);
        Point3f point3f3 = new Point3f(point3d3);
        Point3f point3f4 = new Point3f(point3d4);
        int n = this.lighting.shade(point3f, vector3f, this.materialProperties);
        int n2 = this.lighting.shade(point3f2, vector3f2, this.materialProperties);
        int n3 = this.lighting.shade(point3f3, vector3f3, this.materialProperties);
        int n4 = this.lighting.shade(point3f4, vector3f4, this.materialProperties);
        this.draw3DTriangleGourad(point3f, point3f2, point3f3, n, n2, n3);
        this.draw3DTriangleGourad(point3f3, point3f4, point3f, n3, n4, n);
    }

    private final /* synthetic */ void this() {
        this.p3A = new Point3f();
        this.p3B = new Point3f();
        this.p3C = new Point3f();
        this.p3D = new Point3f();
        this.av3New = new Vector3f[4];
        this.hashPatchSubdivision = new HashPatchSubdivision(0.0f, 1, this);
    }

    public JPatchDrawableZBuffer(BufferedImage bufferedImage, Lighting lighting) {
        super(lighting);
        this.this();
        this.setImage(bufferedImage);
        this.renderToImage();
        int n = 0;
        while (n < 4) {
            this.av3New[n++] = new Vector3f();
        }
        JPatchDrawableZBuffer.setQuality(JPatchSettings.getInstance().iTesselationQuality);
    }
}

