/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.BoneShape;
import jpatch.boundary.Grid;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchDrawableJava2D;
import jpatch.boundary.JPatchDrawableZBuffer;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.Lighting;
import jpatch.boundary.MainFrame;
import jpatch.boundary.Rotoscope;
import jpatch.boundary.SimpleShape;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.Viewport;
import jpatch.boundary.ZBufferRenderer;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.tools.JPatchTool;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.MaterialProperties;
import jpatch.entity.Model;
import jpatch.entity.Patch;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JPatchCanvas
extends JPanel
implements Viewport {
    private static final BoneShape[] ABONESHAPES = new BoneShape[0];
    private static final int GHOST = JPatchSettings.getInstance().iGhost;
    private static int COUNT = 0;
    private static int NUM = 0;
    private static final int EVERYTHING = 0;
    private static final int BACKGROUND = 1;
    private static final int FOREGROUND = 2;
    private static int count = 0;
    private int num;
    private int iMode;
    private ViewDefinition viewDefinition;
    private JPatchDrawable drawable;
    private Image image;
    private Matrix4f m4View;
    private boolean bZBuffer;
    private int[] aiStaticFrameBuffer;
    private int[] aiStaticZBuffer;
    private JPatchTool tool;
    private Grid grid;
    private boolean bFlat;
    private Lighting lighting;
    private JPatchSettings settings;
    private Font font;
    private ArrayList listTransparentPatches;
    private Image imageLock;

    public void updateImage() {
        if (this.viewDefinition.renderPatches() || this.viewDefinition.alwaysUseZBuffer()) {
            this.drawable = new JPatchDrawableZBuffer(this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight()), this.lighting);
            this.aiStaticFrameBuffer = new int[this.getWidth() * this.getHeight()];
            this.aiStaticZBuffer = new int[this.getWidth() * this.getHeight()];
            this.bZBuffer = true;
        } else {
            this.drawable = new JPatchDrawableJava2D(this.createVolatileImage(this.getWidth(), this.getHeight()), this.lighting);
            this.bZBuffer = false;
        }
        this.image = this.drawable.getImage();
        this.render();
    }

    public ViewDefinition getViewDefinition() {
        return this.viewDefinition;
    }

    public JPatchDrawable getDrawable() {
        return this.drawable;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void flatShade(boolean bl) {
        this.bFlat = bl;
    }

    public void setLighting(Lighting lighting) {
        this.lighting = lighting;
        if (this.drawable != null) {
            this.drawable.setLighting(lighting);
        }
    }

    public Lighting getLighting() {
        return this.lighting;
    }

    public void prepareBackground() {
        if (this.viewDefinition.renderPatches()) {
            PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
            if (pointSelection != null) {
                Patch patch = MainFrame.getInstance().getModel().getFirstPatch();
                while (patch != null) {
                    patch.check(pointSelection);
                    patch = patch.getNext();
                }
            }
            ((ZBufferRenderer)((Object)this.drawable)).setActiveBuffers(this.aiStaticFrameBuffer, this.aiStaticZBuffer);
            this.drawable.clear();
            this.renderPatches(1);
            this.iMode = 2;
            ((ZBufferRenderer)((Object)this.drawable)).renderToImage();
        }
    }

    public void clearBackground() {
        this.iMode = 0;
    }

    public void setTool(JPatchTool jPatchTool) {
        this.tool = jPatchTool;
        if (jPatchTool != null) {
            this.addMouseListener(jPatchTool);
        }
        this.repaint();
    }

    public void clearImage() {
        this.image = null;
        this.viewDefinition.computeMatrix();
    }

    public void paintComponent(Graphics graphics) {
        if (this.image == null || this.image.getWidth(this) != this.getWidth() || this.image.getHeight(this) != this.getHeight()) {
            this.updateImage();
        }
        graphics.drawImage(this.image, 0, 0, this);
    }

    private final void drawRotoscope() {
        Rotoscope rotoscope = MainFrame.getInstance().getModel().getRotoscope(this.viewDefinition.getView());
        if (rotoscope != null) {
            rotoscope.paint(this);
        }
    }

    private final void drawGrid() {
        this.grid.paint(this);
        Graphics2D graphics2D = (Graphics2D)this.drawable.getGraphics();
        graphics2D.setColor(this.settings.cBackground);
        graphics2D.fillOval(-5, this.getHeight() - 85, 90, 90);
        graphics2D.setColor(this.settings.cGridMin);
        graphics2D.drawOval(-5, this.getHeight() - 85, 90, 90);
    }

    public void drawActiveViewportMarker(boolean bl) {
        Graphics2D graphics2D = (Graphics2D)this.drawable.getGraphics();
        if (bl) {
            graphics2D.setColor(this.settings.cSelection);
        } else {
            graphics2D.setColor(this.settings.cBackground);
        }
        graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private final void drawDisplayName() {
        Graphics2D graphics2D = (Graphics2D)this.drawable.getGraphics();
        graphics2D.setColor(this.settings.cText);
        graphics2D.setFont(this.font);
        graphics2D.drawString(this.viewDefinition.getViewName(), 7, 15);
        if (this.bZBuffer) {
            graphics2D.drawLine(this.getWidth() - 13, 7, this.getWidth() - 6, 7);
            graphics2D.drawLine(this.getWidth() - 13, 14, this.getWidth() - 6, 14);
            graphics2D.drawLine(this.getWidth() - 13, 14, this.getWidth() - 6, 7);
        }
        if (this.grid.isSnapping()) {
            graphics2D.drawLine(this.getWidth() - 8, 20, this.getWidth() - 8, 29);
            graphics2D.drawLine(this.getWidth() - 11, 20, this.getWidth() - 11, 29);
            graphics2D.drawLine(this.getWidth() - 5, 23, this.getWidth() - 14, 23);
            graphics2D.drawLine(this.getWidth() - 5, 26, this.getWidth() - 14, 26);
        }
        if (this.viewDefinition.isLocked()) {
            graphics2D.drawImage(this.imageLock, this.getWidth() - 12, 34, null);
        }
    }

    private final void drawOrigin() {
        float f = 16.0f / this.m4View.getScale();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        point3f.set(f, 0.0f, 0.0f);
        point3f2.set(-f, 0.0f, 0.0f);
        this.m4View.transform(point3f);
        this.m4View.transform(point3f2);
        this.drawable.setColor(this.settings.cX);
        this.drawable.drawGhostLine3D(point3f, point3f2, GHOST);
        point3f.set(0.0f, f, 0.0f);
        point3f2.set(0.0f, -f, 0.0f);
        this.m4View.transform(point3f);
        this.m4View.transform(point3f2);
        this.drawable.setColor(this.settings.cY);
        this.drawable.drawGhostLine3D(point3f, point3f2, GHOST);
        point3f.set(0.0f, 0.0f, f);
        point3f2.set(0.0f, 0.0f, -f);
        this.m4View.transform(point3f);
        this.m4View.transform(point3f2);
        this.drawable.setColor(this.settings.cZ);
        this.drawable.drawGhostLine3D(point3f, point3f2, GHOST);
    }

    private final void renderHashPatches() {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f()};
        int n = 0;
        while (n < 2) {
            Patch patch = MainFrame.getInstance().getModel().getFirstPatch();
            while (patch != null) {
                if (!patch.isHidden() && patch.getMaterial() != null) {
                    MaterialProperties materialProperties = patch.getMaterial().getMaterialProperties();
                    if (!(n == 0 && !materialProperties.isOpaque() || n == 1 && materialProperties.isOpaque())) {
                        int n2;
                        boolean bl;
                        ControlPoint controlPoint;
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        int[] nArray;
                        Point3f[] point3fArray = patch.coonsPatch();
                        ControlPoint[] controlPointArray = patch.getControlPoints();
                        int n7 = 0;
                        while (n7 < point3fArray.length) {
                            this.m4View.transform(point3fArray[n7]);
                            ++n7;
                        }
                        if (!this.bFlat) {
                            this.lighting.setRotation(this.viewDefinition.getRotateX(), this.viewDefinition.getRotateY());
                            this.lighting.transform();
                            nArray = new int[patch.getType()];
                            n6 = 0;
                            while (n6 < patch.getType()) {
                                nArray[n6++] = 0;
                            }
                            n6 = 0;
                            n5 = patch.getType();
                            n4 = point3fArray.length;
                            n3 = n5 * 2;
                            while (n6 < n5) {
                                controlPoint = null;
                                bl = false;
                                n2 = n6 * 2;
                                if (controlPointArray[n2].isTargetHook()) {
                                    controlPoint = controlPointArray[n2];
                                    nArray[(n6 + n5 - 1) % n5] = 1;
                                }
                                if (controlPointArray[(n2 + n3 - 1) % n3].isTargetHook()) {
                                    controlPoint = controlPointArray[(n2 + n3 - 1) % n3];
                                    nArray[n6] = 1;
                                }
                                if (controlPoint == null) {
                                    int n8 = n6 * 3;
                                    if (point3fArray[n8].equals(point3fArray[(n8 + 3) % n4])) {
                                        vector3f.sub(point3fArray[(n8 + 4) % n4], point3fArray[n8]);
                                    } else {
                                        vector3f.sub(point3fArray[(n8 + 1) % n4], point3fArray[n8]);
                                    }
                                    if (point3fArray[n8].equals(point3fArray[(n8 + n4 - 3) % n4])) {
                                        vector3f2.sub(point3fArray[(n8 + n4 - 4) % n4], point3fArray[n8]);
                                    } else {
                                        vector3f2.sub(point3fArray[(n8 + n4 - 1) % n4], point3fArray[n8]);
                                    }
                                    vector3fArray[n6].cross(vector3f2, vector3f);
                                    vector3fArray[n6].normalize();
                                } else {
                                    ControlPoint controlPoint2 = controlPoint.getHead();
                                    int n9 = 0;
                                    while (n9 < controlPointArray.length) {
                                        if (controlPointArray[n9] == controlPoint2) {
                                            int n10 = (n9 + 1) % controlPointArray.length;
                                            int n11 = (n9 + controlPointArray.length - 1) % controlPointArray.length;
                                            boolean bl2 = false;
                                            if (controlPointArray[n9].getNext() == controlPointArray[n10] || controlPointArray[n9].getPrev() == controlPointArray[n11]) {
                                                bl2 = true;
                                            }
                                            bl = bl2;
                                            break;
                                        }
                                        ++n9;
                                    }
                                    Vector3f vector3f3 = new Vector3f();
                                    Point3f point3f = controlPoint.getPosition();
                                    if (controlPoint.getNext() != null) {
                                        vector3f3.sub(controlPoint.getNext().getPosition(), point3f);
                                    } else {
                                        vector3f3.sub(controlPoint.getPrev().getPosition(), point3f);
                                    }
                                    Vector3f vector3f4 = new Vector3f(vector3f3);
                                    Vector3f vector3f5 = new Vector3f(vector3f3);
                                    controlPoint.computeTargetHookBorderTangents(vector3f3, vector3f4, vector3f5);
                                    ControlPoint controlPoint3 = controlPoint.getHead().getStart().getParentHook();
                                    ControlPoint controlPoint4 = controlPoint3.getNext();
                                    Point3f point3f2 = controlPoint3.getPosition();
                                    Point3f point3f3 = controlPoint3.getOutTangent();
                                    Point3f point3f4 = controlPoint4.getInTangent();
                                    Point3f point3f5 = controlPoint4.getPosition();
                                    Vector3f vector3f6 = new Vector3f();
                                    Vector3f vector3f7 = new Vector3f();
                                    Vector3f vector3f8 = new Vector3f();
                                    vector3f6.sub(point3f3, point3f2);
                                    vector3f7.cross(vector3f4, vector3f6);
                                    vector3f7.normalize();
                                    vector3f6.sub(point3f5, point3f4);
                                    vector3f8.cross(vector3f5, vector3f6);
                                    vector3f8.normalize();
                                    Vector3f vector3f9 = JPatchDrawableZBuffer.interpolateNormal(vector3f7, vector3f8, point3f2, point3f3, point3f4, point3f5);
                                    float f = controlPoint.getHead().getHookPos();
                                    if (f == 0.5f) {
                                        vector3f6.set(vector3f9);
                                    } else {
                                        vector3f6 = f == 0.25f ? JPatchDrawableZBuffer.interpolateNormal(vector3f7, vector3f9) : JPatchDrawableZBuffer.interpolateNormal(vector3f9, vector3f8);
                                    }
                                    this.m4View.transform(vector3f6);
                                    vector3f6.normalize();
                                    if (bl) {
                                        vector3f6.scale(-1.0f);
                                    }
                                    vector3fArray[n6].set(vector3f6);
                                }
                                ++n6;
                            }
                            this.drawable.drawHashPatchGourad(point3fArray, vector3fArray, nArray, materialProperties);
                        } else {
                            nArray = new int[patch.getType()];
                            n6 = 0;
                            while (n6 < patch.getType()) {
                                nArray[n6++] = 0;
                            }
                            n6 = 0;
                            n5 = patch.getType();
                            n4 = point3fArray.length;
                            n3 = n5 * 2;
                            while (n6 < n5) {
                                controlPoint = null;
                                bl = false;
                                n2 = n6 * 2;
                                if (controlPointArray[n2].isTargetHook()) {
                                    controlPoint = controlPointArray[n2];
                                    nArray[(n6 + n5 - 1) % n5] = 1;
                                }
                                if (controlPointArray[(n2 + n3 - 1) % n3].isTargetHook()) {
                                    controlPoint = controlPointArray[(n2 + n3 - 1) % n3];
                                    nArray[n6] = 1;
                                }
                                ++n6;
                            }
                            this.drawable.drawHashPatchFlat(point3fArray, nArray, materialProperties);
                        }
                    }
                }
                patch = patch.getNext();
            }
            ++n;
        }
    }

    private final void renderPatches(int n) {
        Object object;
        Object object2;
        if (!this.bFlat) {
            this.lighting.setRotation(this.viewDefinition.getRotateX(), this.viewDefinition.getRotateY());
            this.lighting.transform();
        }
        this.listTransparentPatches.clear();
        Object object3 = MainFrame.getInstance().getModel().getFirstPatch();
        while (object3 != null) {
            if (!((Patch)object3).isHidden()) {
                object2 = ((Patch)object3).getMaterial().getMaterialProperties();
                if (((MaterialProperties)object2).isOpaque()) {
                    object = ((Patch)object3).bicubicPatches();
                    int n2 = 0;
                    while (n2 < ((Point3f[][])object).length) {
                        Point3f[] point3fArray = object[n2];
                        int n3 = 0;
                        while (n3 < point3fArray.length) {
                            this.m4View.transform(point3fArray[n3]);
                            ++n3;
                        }
                        if (this.bFlat) {
                            this.drawable.drawBicubicPatchFlat(point3fArray, (MaterialProperties)object2);
                        } else {
                            this.drawable.drawBicubicPatchGourad(point3fArray, (MaterialProperties)object2);
                        }
                        ++n2;
                    }
                } else {
                    this.listTransparentPatches.add(object3);
                }
            }
            object3 = ((Patch)object3).getNext();
        }
        object3 = this.listTransparentPatches.iterator();
        while (object3.hasNext()) {
            object2 = (Patch)object3.next();
            object = ((Patch)object2).getMaterial().getMaterialProperties();
            Point3f[][] point3fArray = ((Patch)object2).bicubicPatches();
            int n4 = 0;
            while (n4 < point3fArray.length) {
                Point3f[] point3fArray2 = point3fArray[n4];
                int n5 = 0;
                while (n5 < point3fArray2.length) {
                    this.m4View.transform(point3fArray2[n5]);
                    ++n5;
                }
                if (this.bFlat) {
                    this.drawable.drawBicubicPatchFlat(point3fArray2, (MaterialProperties)object);
                } else {
                    this.drawable.drawBicubicPatchGourad(point3fArray2, (MaterialProperties)object);
                }
                ++n4;
            }
        }
    }

    private final void paintTest() {
    }

    private final void renderBones() {
        Object[] objectArray = MainFrame.getInstance().getModel().getBoneShapeList().toArray(ABONESHAPES);
        int n = 0;
        while (n < objectArray.length) {
            ((BoneShape)objectArray[n]).set();
            ((SimpleShape)objectArray[n]).transform(this.m4View);
            ++n;
        }
        Arrays.sort(objectArray);
        n = 0;
        while (n < objectArray.length) {
            this.drawable.drawSimpleShape((SimpleShape)objectArray[n], null);
            ++n;
        }
    }

    private final void paintAxis() {
        int n;
        int n2;
        int n3;
        Matrix3f matrix3f = new Matrix3f();
        this.m4View.get(matrix3f);
        Vector3f vector3f = new Vector3f(30.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, 30.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 30.0f);
        matrix3f.transform(vector3f);
        matrix3f.transform(vector3f2);
        matrix3f.transform(vector3f3);
        int n4 = 40;
        int n5 = this.getHeight() - 40;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        this.settings.cX.getRGBColorComponents(fArray);
        this.settings.cY.getRGBColorComponents(fArray2);
        this.settings.cZ.getRGBColorComponents(fArray3);
        SimpleShape simpleShape = SimpleShape.createArrow(9.0f, 3, fArray[0], fArray[1], fArray[2]);
        SimpleShape simpleShape2 = SimpleShape.createArrow(9.0f, 3, fArray2[0], fArray2[1], fArray2[2]);
        SimpleShape simpleShape3 = SimpleShape.createArrow(9.0f, 3, fArray3[0], fArray3[1], fArray3[2]);
        Matrix3f matrix3f2 = new Matrix3f();
        matrix3f2.rotX((float)Math.PI);
        simpleShape3.transform(matrix3f2);
        simpleShape3.translate(new Vector3f(0.0f, 0.0f, 31.0f));
        matrix3f2.rotX(1.5707964f);
        simpleShape2.transform(matrix3f2);
        simpleShape2.translate(new Vector3f(0.0f, 31.0f, 0.0f));
        matrix3f2.rotY(-1.5707964f);
        simpleShape.transform(matrix3f2);
        simpleShape.translate(new Vector3f(31.0f, 0.0f, 0.0f));
        simpleShape.transform(matrix3f);
        simpleShape2.transform(matrix3f);
        simpleShape3.transform(matrix3f);
        simpleShape.translate(new Vector3f(n4, n5, -10000.0f));
        simpleShape2.translate(new Vector3f(n4, n5, -10000.0f));
        simpleShape3.translate(new Vector3f(n4, n5, -10000.0f));
        if (vector3f.z > vector3f2.z && vector3f2.z > vector3f3.z) {
            n3 = 0;
            n2 = 1;
            n = 2;
        } else if (vector3f.z > vector3f3.z && vector3f3.z > vector3f2.z) {
            n3 = 0;
            n = 1;
            n2 = 2;
        } else if (vector3f2.z > vector3f.z && vector3f.z > vector3f3.z) {
            n2 = 0;
            n3 = 1;
            n = 2;
        } else if (vector3f3.z > vector3f.z && vector3f.z > vector3f2.z) {
            n = 0;
            n3 = 1;
            n2 = 2;
        } else if (vector3f2.z > vector3f3.z && vector3f3.z > vector3f.z) {
            n2 = 0;
            n = 1;
            n3 = 2;
        } else {
            n = 0;
            n2 = 1;
            n3 = 2;
        }
        int n6 = 0;
        while (n6 < 3) {
            if (n6 == n3) {
                this.drawable.setColor(this.settings.cX);
                this.drawable.drawLine(n4, n5, n4 + (int)vector3f.x, n5 + (int)vector3f.y);
                vector3f.scale(1.3f);
                this.drawable.drawLine(n4 + (int)vector3f.x - 3, n5 + (int)vector3f.y - 3, n4 + (int)vector3f.x + 3, n5 + (int)vector3f.y + 3);
                this.drawable.drawLine(n4 + (int)vector3f.x - 3, n5 + (int)vector3f.y + 3, n4 + (int)vector3f.x + 3, n5 + (int)vector3f.y - 3);
                this.drawable.drawSimpleShape(simpleShape, null);
            } else if (n6 == n2) {
                this.drawable.setColor(this.settings.cY);
                this.drawable.drawLine(n4, n5, n4 + (int)vector3f2.x, n5 + (int)vector3f2.y);
                vector3f2.scale(1.3f);
                this.drawable.drawLine(n4 + (int)vector3f2.x, n5 + (int)vector3f2.y, n4 + (int)vector3f2.x - 3, n5 + (int)vector3f2.y - 3);
                this.drawable.drawLine(n4 + (int)vector3f2.x, n5 + (int)vector3f2.y, n4 + (int)vector3f2.x + 3, n5 + (int)vector3f2.y - 3);
                this.drawable.drawLine(n4 + (int)vector3f2.x, n5 + (int)vector3f2.y, n4 + (int)vector3f2.x, n5 + (int)vector3f2.y + 3);
                this.drawable.drawSimpleShape(simpleShape2, null);
            } else {
                this.drawable.setColor(this.settings.cZ);
                this.drawable.drawLine(n4, n5, n4 + (int)vector3f3.x, n5 + (int)vector3f3.y);
                vector3f3.scale(1.3f);
                this.drawable.drawLine(n4 + (int)vector3f3.x - 3, n5 + (int)vector3f3.y - 3, n4 + (int)vector3f3.x + 3, n5 + (int)vector3f3.y - 3);
                this.drawable.drawLine(n4 + (int)vector3f3.x - 3, n5 + (int)vector3f3.y + 3, n4 + (int)vector3f3.x + 3, n5 + (int)vector3f3.y + 3);
                this.drawable.drawLine(n4 + (int)vector3f3.x - 3, n5 + (int)vector3f3.y + 3, n4 + (int)vector3f3.x + 3, n5 + (int)vector3f3.y - 3);
                this.drawable.drawSimpleShape(simpleShape3, null);
            }
            ++n6;
        }
    }

    public void drawBezier() {
        this.drawable.setColor(Color.GREEN);
        Patch patch = MainFrame.getInstance().getModel().getFirstPatch();
        while (patch != null) {
            Point3f[][] point3fArray = patch.bicubicPatches();
            int n = 0;
            while (n < point3fArray.length) {
                Point3f[] point3fArray2 = point3fArray[n];
                int n2 = 0;
                while (n2 < 16) {
                    this.m4View.transform(point3fArray2[n2++]);
                }
                this.drawable.drawLine3D(point3fArray2[0], point3fArray2[1]);
                this.drawable.drawLine3D(point3fArray2[1], point3fArray2[2]);
                this.drawable.drawLine3D(point3fArray2[2], point3fArray2[3]);
                this.drawable.drawLine3D(point3fArray2[4], point3fArray2[5]);
                this.drawable.drawLine3D(point3fArray2[5], point3fArray2[6]);
                this.drawable.drawLine3D(point3fArray2[6], point3fArray2[7]);
                this.drawable.drawLine3D(point3fArray2[8], point3fArray2[9]);
                this.drawable.drawLine3D(point3fArray2[9], point3fArray2[10]);
                this.drawable.drawLine3D(point3fArray2[10], point3fArray2[11]);
                this.drawable.drawLine3D(point3fArray2[12], point3fArray2[13]);
                this.drawable.drawLine3D(point3fArray2[13], point3fArray2[14]);
                this.drawable.drawLine3D(point3fArray2[14], point3fArray2[15]);
                this.drawable.drawLine3D(point3fArray2[0], point3fArray2[4]);
                this.drawable.drawLine3D(point3fArray2[1], point3fArray2[5]);
                this.drawable.drawLine3D(point3fArray2[2], point3fArray2[6]);
                this.drawable.drawLine3D(point3fArray2[3], point3fArray2[7]);
                this.drawable.drawLine3D(point3fArray2[4], point3fArray2[8]);
                this.drawable.drawLine3D(point3fArray2[5], point3fArray2[9]);
                this.drawable.drawLine3D(point3fArray2[6], point3fArray2[10]);
                this.drawable.drawLine3D(point3fArray2[7], point3fArray2[11]);
                this.drawable.drawLine3D(point3fArray2[8], point3fArray2[12]);
                this.drawable.drawLine3D(point3fArray2[9], point3fArray2[13]);
                this.drawable.drawLine3D(point3fArray2[10], point3fArray2[14]);
                this.drawable.drawLine3D(point3fArray2[11], point3fArray2[15]);
                ++n;
            }
            patch = patch.getNext();
        }
    }

    public void render() {
        Model model = MainFrame.getInstance().getModel();
        if (this.drawable != null && this.image != null) {
            long l = System.currentTimeMillis();
            if (!this.bZBuffer || this.iMode == 0) {
                this.drawable.clear();
                if (this.viewDefinition.showRotoscope()) {
                    this.drawRotoscope();
                }
                this.drawGrid();
            } else {
                ((ZBufferRenderer)((Object)this.drawable)).reset(this.aiStaticFrameBuffer, this.aiStaticZBuffer);
            }
            if (this.iMode != 1) {
                Object object;
                if (this.viewDefinition.renderCurves()) {
                    this.drawable.setColor(this.settings.cCurve);
                    object = model.getFirstCurve();
                    while (object != null) {
                        if (!((Curve)object).getStart().isStartHook()) {
                            this.drawable.drawJPatchCurve3D((Curve)object, this.m4View);
                        }
                        object = ((Curve)object).getNext();
                    }
                }
                if (this.viewDefinition.renderPoints()) {
                    Object object2;
                    object = (Graphics2D)this.drawable.getGraphics();
                    ((Graphics)object).setColor(this.settings.cText);
                    ((Graphics)object).setFont(this.font);
                    PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
                    Point3f point3f = new Point3f();
                    Object object3 = model.getFirstCurve();
                    while (object3 != null) {
                        object2 = ((Curve)object3).getStart();
                        while (object2 != null) {
                            if (((ControlPoint)object2).isHead()) {
                                point3f.set(((ControlPoint)object2).getPosition());
                                this.m4View.transform(point3f);
                                if (pointSelection != null && pointSelection.contains((ControlPoint)object2)) {
                                    this.drawable.setColor(this.settings.cSelected);
                                    this.drawable.drawPoint3D(point3f, 1);
                                } else if (!((ControlPoint)object2).isHook() && !((ControlPoint)object2).isHidden()) {
                                    if (((ControlPoint)object2).isSingle()) {
                                        this.drawable.setColor(this.settings.cPoint);
                                        this.drawable.drawXPoint3D(point3f);
                                    } else if (!((ControlPoint)object2).isMulti()) {
                                        this.drawable.setColor(this.settings.cHeadPoint);
                                        this.drawable.drawPoint3D(point3f, 1);
                                    } else {
                                        this.drawable.setColor(this.settings.cMultiPoint);
                                        this.drawable.drawPoint3D(point3f, 2);
                                    }
                                }
                            }
                            object2 = ((ControlPoint)object2).getNextCheckNextLoop();
                        }
                        object3 = ((Curve)object3).getNext();
                    }
                    if (pointSelection != null && pointSelection.getHotCp() != null && pointSelection.getHotCp().getCurve() != null && pointSelection.getHotCp().getCurve().getModel() != null) {
                        point3f.set(pointSelection.getHotCp().getPosition());
                        this.m4View.transform(point3f);
                        this.drawable.setColor(this.settings.cHot);
                        this.drawable.drawPoint3D(point3f, 2);
                    }
                    if (pointSelection != null && pointSelection.isCurve()) {
                        object3 = pointSelection.getControlPoint();
                        if (pointSelection.getDirection() && ((ControlPoint)object3).getNext() != null) {
                            object2 = new Point3f(((ControlPoint)object3).getPosition());
                            Point3f point3f2 = new Point3f(((ControlPoint)object3).getOutTangent());
                            Point3f point3f3 = new Point3f(((ControlPoint)object3).getNext().getInTangent());
                            Point3f point3f4 = new Point3f(((ControlPoint)object3).getNext().getPosition());
                            this.m4View.transform((Point3f)object2);
                            this.m4View.transform(point3f2);
                            this.m4View.transform(point3f3);
                            this.m4View.transform(point3f4);
                            this.drawable.setColor(this.settings.cSelected);
                            this.drawable.drawCurveSegment((Point3f)object2, point3f2, point3f3, point3f4);
                        } else if (!pointSelection.getDirection() && ((ControlPoint)object3).getPrev() != null) {
                            object2 = new Point3f(((ControlPoint)object3).getPrev().getPosition());
                            Point3f point3f5 = new Point3f(((ControlPoint)object3).getPrev().getOutTangent());
                            Point3f point3f6 = new Point3f(((ControlPoint)object3).getInTangent());
                            Point3f point3f7 = new Point3f(((ControlPoint)object3).getPosition());
                            this.m4View.transform((Point3f)object2);
                            this.m4View.transform(point3f5);
                            this.m4View.transform(point3f6);
                            this.m4View.transform(point3f7);
                            this.drawable.setColor(this.settings.cSelected);
                            this.drawable.drawCurveSegment((Point3f)object2, point3f5, point3f6, point3f7);
                        }
                    }
                }
                if (this.viewDefinition.renderPatches()) {
                    if (this.bZBuffer) {
                        this.renderHashPatches();
                    } else {
                        this.updateImage();
                        return;
                    }
                }
                if (this.viewDefinition.renderBezierCPs()) {
                    this.drawBezier();
                }
                this.renderBones();
                if (this.tool != null) {
                    this.tool.paint(this, this.drawable);
                }
                boolean bl = false;
                if (MainFrame.getInstance().getJPatchScreen().getActiveViewport() == this) {
                    bl = true;
                }
                this.drawActiveViewportMarker(bl);
                this.paintAxis();
                this.drawOrigin();
                this.drawDisplayName();
                object = (Graphics2D)this.drawable.getGraphics();
                ((Graphics)object).setColor(this.settings.cText);
                ((Graphics)object).setFont(this.font);
                ((Graphics2D)object).drawString(System.currentTimeMillis() - l + "ms", 7, 30);
                this.getGraphics().drawImage(this.image, 0, 0, this);
            }
        }
    }

    private final /* synthetic */ void this() {
        this.iMode = 0;
        this.bZBuffer = false;
        this.grid = new Grid();
        this.bFlat = true;
        this.lighting = Lighting.createDefaultLight();
        this.settings = JPatchSettings.getInstance();
        this.font = new Font("SansSerif", 0, 12);
        this.listTransparentPatches = new ArrayList();
        this.imageLock = new ImageIcon(ClassLoader.getSystemResource("jpatch/images/viewlock.png")).getImage();
    }

    public JPatchCanvas(Model model, ViewDefinition viewDefinition) {
        this.this();
        this.viewDefinition = viewDefinition;
        viewDefinition.setViewport(this);
        this.m4View = viewDefinition.getMatrix();
        this.num = NUM++;
    }
}

