/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchCanvas;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.ViewDefinition;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Grid {
    public static final int NONE = 0;
    public static final int XY = 1;
    public static final int XZ = 2;
    public static final int YZ = 3;
    private int iPlane;
    private float fSpacing;
    private int iSize;
    private boolean bSnap;
    private JPatchSettings settings;

    public void setPlane(int n) {
        this.iPlane = n;
    }

    public boolean snap() {
        return this.bSnap;
    }

    public void snap(boolean bl) {
        this.bSnap = bl;
    }

    public float getSpacing() {
        return this.fSpacing;
    }

    public void setSpacing(float f) {
        this.fSpacing = f;
    }

    public boolean isSnapping() {
        boolean bl = false;
        if (this.bSnap && this.iPlane != 0) {
            bl = true;
        }
        return bl;
    }

    public void paint(JPatchCanvas jPatchCanvas) {
        JPatchDrawable jPatchDrawable = jPatchCanvas.getDrawable();
        ViewDefinition viewDefinition = jPatchCanvas.getViewDefinition();
        Matrix4f matrix4f = viewDefinition.getMatrix();
        if (viewDefinition.getView() != 7) {
            this.drawPlanarGrid(jPatchDrawable, matrix4f, jPatchCanvas.getWidth(), jPatchCanvas.getHeight());
        }
    }

    private final void drawPlanarGrid(JPatchDrawable jPatchDrawable, Matrix4f matrix4f, int n, int n2) {
        float f = this.fSpacing * matrix4f.getScale();
        float f2 = n / 2;
        float f3 = n2 / 2;
        float f4 = matrix4f.m03;
        float f5 = matrix4f.m13;
        if (f >= (float)4) {
            int n3 = Math.round(-f4 / f);
            int n4 = Math.round((2.0f * f2 - f4) / f);
            int n5 = n3;
            while (n5 <= n4) {
                if (n5 % 5 == 0) {
                    jPatchDrawable.setColor(this.settings.iGrid);
                } else {
                    jPatchDrawable.setColor(this.settings.iGridMin);
                }
                jPatchDrawable.drawLine((int)(f4 + (float)n5 * f), 0, (int)(f4 + (float)n5 * f), n2);
                ++n5;
            }
            n3 = Math.round(-f5 / f);
            n4 = Math.round((2.0f * f3 - f5) / f);
            n5 = n3;
            while (n5 <= n4) {
                if (n5 % 5 == 0) {
                    jPatchDrawable.setColor(this.settings.iGrid);
                } else {
                    jPatchDrawable.setColor(this.settings.iGridMin);
                }
                jPatchDrawable.drawLine(0, (int)(f5 + (float)n5 * f), n, (int)(f5 + (float)n5 * f));
                ++n5;
            }
            jPatchDrawable.setColor(this.settings.iGridMin);
            jPatchDrawable.drawLine((int)(f4 + 0.0f * f2 - 1.0f), 0, (int)(f4 + 0.0f * f2 - 1.0f), n2);
            jPatchDrawable.drawLine((int)(f4 + 0.0f * f2 + 1.0f), 0, (int)(f4 + 0.0f * f2 + 1.0f), n2);
            jPatchDrawable.drawLine(0, (int)(f5 + 0.0f * f3 - 1.0f), n, (int)(f5 + 0.0f * f3 - 1.0f));
            jPatchDrawable.drawLine(0, (int)(f5 + 0.0f * f3 + 1.0f), n, (int)(f5 + 0.0f * f3 + 1.0f));
        }
        jPatchDrawable.setColor(this.settings.iGrid);
        jPatchDrawable.drawLine((int)(f4 + 0.0f * f2), 0, (int)(f4 + 0.0f * f2), n2);
        jPatchDrawable.drawLine(0, (int)(f5 + 0.0f * f3), n, (int)(f5 + 0.0f * f3));
    }

    private final void drawBirdsEyeGrid(JPatchDrawable jPatchDrawable, Matrix4f matrix4f) {
        float f = this.fSpacing * (float)this.iSize;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        int n = -this.iSize;
        while (n <= this.iSize) {
            float f2 = this.fSpacing * (float)n;
            if (n % 5 == 0) {
                jPatchDrawable.setColor(this.settings.cGrid);
            } else {
                jPatchDrawable.setColor(this.settings.cGridMin);
            }
            switch (this.iPlane) {
                case 2: {
                    point3f.set(-f, 0.0f, f2);
                    point3f2.set(f, 0.0f, f2);
                    break;
                }
                case 1: {
                    point3f.set(-f, f2, 0.0f);
                    point3f2.set(f, f2, 0.0f);
                    break;
                }
                case 3: {
                    point3f.set(0.0f, -f, f2);
                    point3f2.set(0.0f, f, f2);
                }
            }
            matrix4f.transform(point3f);
            matrix4f.transform(point3f2);
            jPatchDrawable.drawLine3D(point3f, point3f2);
            switch (this.iPlane) {
                case 2: {
                    point3f.set(f2, 0.0f, -f);
                    point3f2.set(f2, 0.0f, f);
                    break;
                }
                case 1: {
                    point3f.set(f2, -f, 0.0f);
                    point3f2.set(f2, f, 0.0f);
                    break;
                }
                case 3: {
                    point3f.set(0.0f, f2, -f);
                    point3f2.set(0.0f, f2, f);
                }
            }
            matrix4f.transform(point3f);
            matrix4f.transform(point3f2);
            jPatchDrawable.drawLine3D(point3f, point3f2);
            ++n;
        }
    }

    public boolean correctPosition(Tuple3f tuple3f, Tuple3f tuple3f2) {
        if (this.bSnap && this.iPlane != 0) {
            tuple3f2.x = this.iPlane == 3 ? tuple3f.x : (float)Math.round(tuple3f2.x / this.fSpacing) * this.fSpacing;
            tuple3f2.y = this.iPlane == 2 ? tuple3f.y : (float)Math.round(tuple3f2.y / this.fSpacing) * this.fSpacing;
            tuple3f2.z = this.iPlane == 1 ? tuple3f.z : (float)Math.round(tuple3f2.z / this.fSpacing) * this.fSpacing;
        }
        return tuple3f.equals(tuple3f2) ^ true;
    }

    public boolean correctZPosition(Tuple3f tuple3f, Tuple3f tuple3f2) {
        if (this.bSnap && this.iPlane != 0) {
            tuple3f2.x = this.iPlane != 3 ? tuple3f.x : (float)Math.round(tuple3f2.x / this.fSpacing) * this.fSpacing;
            tuple3f2.y = this.iPlane != 2 ? tuple3f.y : (float)Math.round(tuple3f2.y / this.fSpacing) * this.fSpacing;
            tuple3f2.z = this.iPlane != 1 ? tuple3f.z : (float)Math.round(tuple3f2.z / this.fSpacing) * this.fSpacing;
        }
        return tuple3f.equals(tuple3f2) ^ true;
    }

    public void correctVector(Tuple3f tuple3f) {
        if (this.bSnap && this.iPlane != 0) {
            tuple3f.x = this.iPlane == 3 ? 0.0f : (float)Math.round(tuple3f.x / this.fSpacing) * this.fSpacing;
            tuple3f.y = this.iPlane == 2 ? 0.0f : (float)Math.round(tuple3f.y / this.fSpacing) * this.fSpacing;
            tuple3f.z = this.iPlane == 1 ? 0.0f : (float)Math.round(tuple3f.z / this.fSpacing) * this.fSpacing;
        }
    }

    public void correctZVector(Tuple3f tuple3f) {
        if (this.bSnap && this.iPlane != 0) {
            tuple3f.x = this.iPlane != 3 ? 0.0f : (float)Math.round(tuple3f.x / this.fSpacing) * this.fSpacing;
            tuple3f.y = this.iPlane != 2 ? 0.0f : (float)Math.round(tuple3f.y / this.fSpacing) * this.fSpacing;
            tuple3f.z = this.iPlane != 1 ? 0.0f : (float)Math.round(tuple3f.z / this.fSpacing) * this.fSpacing;
        }
    }

    public Vector3f getCorrectionVector(Tuple3f tuple3f) {
        Vector3f vector3f = new Vector3f();
        if (this.bSnap && this.iPlane != 0) {
            vector3f.set(tuple3f);
            vector3f.x = this.iPlane == 3 ? vector3f.x : (float)Math.round(vector3f.x / this.fSpacing) * this.fSpacing;
            vector3f.y = this.iPlane == 2 ? vector3f.y : (float)Math.round(vector3f.y / this.fSpacing) * this.fSpacing;
            vector3f.z = this.iPlane == 1 ? vector3f.z : (float)Math.round(vector3f.z / this.fSpacing) * this.fSpacing;
            vector3f.sub(tuple3f);
        }
        return vector3f;
    }

    public Vector3f getZCorrectionVector(Tuple3f tuple3f) {
        Vector3f vector3f = new Vector3f();
        if (this.bSnap && this.iPlane != 0) {
            vector3f.set(tuple3f);
            vector3f.x = this.iPlane != 3 ? vector3f.x : (float)Math.round(vector3f.x / this.fSpacing) * this.fSpacing;
            vector3f.y = this.iPlane != 2 ? vector3f.y : (float)Math.round(vector3f.y / this.fSpacing) * this.fSpacing;
            vector3f.z = this.iPlane != 1 ? vector3f.z : (float)Math.round(vector3f.z / this.fSpacing) * this.fSpacing;
            vector3f.sub(tuple3f);
        }
        return vector3f;
    }

    private final /* synthetic */ void this() {
        this.iPlane = 2;
        this.fSpacing = JPatchSettings.getInstance().fGridSpacing;
        this.iSize = 25;
        this.bSnap = true;
        this.settings = JPatchSettings.getInstance();
    }

    public Grid() {
        this.this();
    }
}

