/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.auxilary.Utils3D;
import jpatch.boundary.SimpleShape;
import jpatch.entity.Bone;
import jpatch.entity.MaterialProperties;

public class BoneShape
extends SimpleShape
implements Comparable {
    static final float R = 0.05f;
    static final float A = 0.2f;
    static final float B = -0.8f;
    static final MaterialProperties[] MATERIAL = new MaterialProperties[]{new MaterialProperties(1.0f, 0.0f, 0.0f), new MaterialProperties(1.0f, 1.0f, 0.0f), new MaterialProperties(0.0f, 1.0f, 0.0f), new MaterialProperties(0.0f, 1.0f, 1.0f), new MaterialProperties(0.0f, 0.0f, 1.0f), new MaterialProperties(1.0f, 0.0f, 1.0f)};
    private final Bone bone;

    public void reset() {
        this.ap3Points[0].set(0.0f, 0.0f, 0.0f);
        this.ap3Points[1].set(-0.05f, 0.2f, -0.05f);
        this.ap3Points[2].set(0.05f, 0.2f, -0.05f);
        this.ap3Points[3].set(0.05f, 0.2f, 0.05f);
        this.ap3Points[4].set(-0.05f, 0.2f, 0.05f);
        this.ap3Points[5].set(0.0f, 1.0f, 0.0f);
        this.av3Normals[0].set(0.0f, -0.05f, -0.2f);
        this.av3Normals[1].set(0.2f, -0.05f, 0.0f);
        this.av3Normals[2].set(0.0f, -0.05f, 0.2f);
        this.av3Normals[3].set(-0.2f, -0.05f, 0.0f);
        this.av3Normals[4].set(0.0f, 0.05f, -0.8f);
        this.av3Normals[5].set(0.8f, 0.05f, 0.0f);
        this.av3Normals[6].set(0.0f, 0.05f, 0.8f);
        this.av3Normals[7].set(-0.8f, 0.05f, 0.0f);
    }

    public void set(Point3f point3f, Point3f point3f2) {
        this.reset();
        Vector3f vector3f = new Vector3f(point3f2);
        vector3f.sub(point3f);
        float f = vector3f.length();
        vector3f.scale(1.0f / f);
        Vector3f vector3f2 = Utils3D.perpendicularVector(vector3f);
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f2, vector3f);
        Matrix4f matrix4f = new Matrix4f(vector3f2.x * f, vector3f.x * f, vector3f3.x * f, point3f.x, vector3f2.y * f, vector3f.y * f, vector3f3.y * f, point3f.y, vector3f2.z * f, vector3f.z * f, vector3f3.z * f, point3f.z, 0.0f, 0.0f, 0.0f, 1.0f);
        this.transform(matrix4f);
    }

    public void set() {
        this.set(this.bone.getStart(), this.bone.getEnd());
    }

    public Bone getBone() {
        return this.bone;
    }

    public MaterialProperties getMaterialProperties() {
        return MATERIAL[this.bone.getNumber() % MATERIAL.length];
    }

    public int compareTo(Object object) {
        BoneShape boneShape = (BoneShape)object;
        Point3f point3f = new Point3f();
        point3f.interpolate(this.ap3Points[0], this.ap3Points[5], 0.5f);
        return -Float.compare(point3f.z, Utils3D.closestPointOnLine((Point3f)boneShape.ap3Points[0], (Point3f)boneShape.ap3Points[5], (Point3f)point3f).z);
    }

    public BoneShape(Bone bone) {
        this.bone = bone;
        this.ap3Points = new Point3f[6];
        this.av3Normals = new Vector3f[8];
        int n = 0;
        while (n < 6) {
            this.ap3Points[n++] = new Point3f();
        }
        n = 0;
        while (n < 8) {
            this.av3Normals[n++] = new Vector3f();
        }
        int[] nArray = new int[24];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[7] = 3;
        nArray[8] = 4;
        nArray[10] = 4;
        nArray[11] = 1;
        nArray[12] = 5;
        nArray[13] = 2;
        nArray[14] = 1;
        nArray[15] = 5;
        nArray[16] = 3;
        nArray[17] = 2;
        nArray[18] = 5;
        nArray[19] = 4;
        nArray[20] = 3;
        nArray[21] = 5;
        nArray[22] = 1;
        nArray[23] = 4;
        this.aiTriangles = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        this.aiNormalIndices = nArray2;
        this.mp = new MaterialProperties();
    }
}

