/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import buoy.widget.AWTWidget;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BProgressBar;
import buoy.widget.BScrollBar;
import buoy.widget.BScrollPane;
import buoy.widget.BSplitPane;
import buoy.widget.BTabbedPane;
import buoy.widget.BTextArea;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.OverlayContainer;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.sound.sampled.Clip;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.vecmath.Point3d;
import jpatch.auxilary.ReadTiff;
import jpatch.auxilary.XMLutils;
import jpatch.boundary.AnimatorMainMenu;
import jpatch.boundary.CameraViewport;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MotionCurveDisplay;
import jpatch.boundary.MotionCurveEditor;
import jpatch.boundary.PoseSliders;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.AnimObject;
import jpatch.entity.Camera;
import jpatch.entity.Model;
import jpatch.entity.Morph;
import jpatch.entity.MotionCurve2;
import jpatch.entity.MotionCurveSet;
import jpatch.entity.MotionKey2;
import jpatch.entity.RenderExtension;
import jpatch.renderer.InyoRenderer2;
import jpatch.renderer.PovrayRenderer3;
import jpatch.renderer.RibRenderer4;
import patterns.TextureParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Animator
extends BFrame {
    private static Animator INSTANCE;
    private ArrayList listObjects;
    private BorderContainer content;
    private Camera camera1;
    private CameraViewport cameraViewport;
    private FormContainer objectBrowser;
    private PoseSliders poseSliders;
    private MotionCurveEditor motionCurveEditor;
    private MotionCurveDisplay motionCurveDisplay;
    private BSplitPane splitPane;
    private String strPrefix;
    private BDialog propertiesDialog;
    private BTextField textStart;
    private BTextField textEnd;
    private BTextField textRate;
    private BTextField textModelDir;
    private BTextField textPrefix;
    private BTextArea textPov;
    private BTextArea textRib;
    private float fStart;
    private float fEnd;
    private float fPosition;
    private float fFramerate;
    private Clip clip;
    private HashMap mapMotionCurves;
    private HashMap mapFilenames;
    private MotionKey2 activeKey;
    private MotionCurve2 activeCurve;
    private RenderExtension re;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;
    static /* synthetic */ Class class$buoy$event$WindowClosingEvent;
    static /* synthetic */ Class class$buoy$event$CommandEvent;

    public final void NEW() {
        this.listObjects.clear();
        this.mapMotionCurves.clear();
        this.fPosition = 0.0f;
        this.fStart = 0.0f;
        this.fEnd = 10.0f * this.fFramerate - 1.0f;
        this.strPrefix = "frame_";
        this.camera1.setOrientation(0.0, 0.0, 0.0);
        this.camera1.setFocalLength(50.0f);
        this.camera1.setPosition(new Point3d(0.0, 0.0, -100.0));
        this.mapMotionCurves.put(this.camera1, new MotionCurveSet.Camera(this.camera1));
        this.listObjects.add(this.camera1);
        this.setActiveObject(this.camera1);
        this.rerenderViewports();
    }

    public final void setClip(Clip clip) {
        if (this.clip != null) {
            this.clip.flush();
        }
        this.clip = clip;
        clip.setMicrosecondPosition((long)(this.fPosition / this.fFramerate * 1000.0f));
    }

    public final Clip getClip() {
        return this.clip;
    }

    public static final Animator getInstance() {
        return INSTANCE == null ? new Animator() : INSTANCE;
    }

    public final ArrayList getObjectList() {
        return this.listObjects;
    }

    public final void enumerateLights() {
        int n = 0;
        Iterator iterator = this.listObjects.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AnimLight)) continue;
            ((AnimLight)e).setNumber(n++);
        }
    }

    public final float getStart() {
        return this.fStart;
    }

    public final float getEnd() {
        return this.fEnd;
    }

    public final float getPosition() {
        return this.fPosition;
    }

    public final float getFramerate() {
        return this.fFramerate;
    }

    public final void stop() {
        this.motionCurveEditor.stop();
    }

    public final MotionKey2 getActiveKey() {
        return this.activeKey;
    }

    public final MotionCurve2 getActiveCurve() {
        return this.activeCurve;
    }

    public final void setActiveKey(MotionKey2 motionKey2) {
        this.activeKey = motionKey2;
    }

    public final void setActiveCurve(MotionCurve2 motionCurve2) {
        this.activeCurve = motionCurve2;
    }

    public final void setPosition(float f) {
        this.fPosition = f;
        Iterator iterator = this.listObjects.iterator();
        while (iterator.hasNext()) {
            ((MotionCurveSet)this.mapMotionCurves.get(iterator.next())).setPosition(f);
        }
        this.motionCurveEditor.setPosition(f);
        this.poseSliders.moveSliders();
        this.poseSliders.repaint();
        this.rerenderViewports();
        if (this.clip != null && !this.clip.isRunning()) {
            this.clip.setMicrosecondPosition((long)(this.fPosition / this.fFramerate * 1000.0f));
        }
    }

    public final void redrawMotionCurveDisplay() {
        this.motionCurveDisplay.repaint();
    }

    public final void reinitMotionCurveDisplay() {
        this.motionCurveDisplay.init();
        this.motionCurveEditor.repaint();
    }

    public final AnimObject getActiveObject() {
        return this.poseSliders.getActiveObject();
    }

    public final void setActiveObject(AnimObject animObject) {
        this.poseSliders.setActiveObject(animObject);
        this.rerenderViewports();
        this.reinitMotionCurveDisplay();
    }

    public final void rerenderViewports() {
        this.cameraViewport.rerender();
    }

    public final void repaintViewports() {
        this.cameraViewport.repaint();
    }

    public final MotionCurveSet getMotionCurveSetFor(AnimObject animObject) {
        return (MotionCurveSet)this.mapMotionCurves.get(animObject);
    }

    public final void setMotionCurveSetFor(AnimObject animObject, MotionCurveSet motionCurveSet) {
        this.mapMotionCurves.put(animObject, motionCurveSet);
    }

    public final void setMorphValue(AnimModel animModel, Morph morph) {
        MotionCurve2.Float float_ = ((MotionCurveSet.Model)this.mapMotionCurves.get(animModel)).morph(morph);
        this.activeCurve = float_;
        this.activeKey = float_.setFloatAt(this.fPosition, morph.getValue());
        this.motionCurveEditor.repaint();
        this.rerenderViewports();
    }

    public final void updateCurvesFor(AnimObject animObject) {
        ((MotionCurveSet)this.mapMotionCurves.get(animObject)).updateCurves(this.fPosition);
        this.motionCurveEditor.repaint();
    }

    public final void addObject(AnimObject animObject) {
        this.addObject(animObject, null);
    }

    public final void addObject(AnimObject animObject, String string) {
        this.addObject(animObject, string, MotionCurveSet.createMotionCurveSetFor(animObject));
    }

    public final void addObject(AnimObject animObject, String string, MotionCurveSet motionCurveSet) {
        this.listObjects.add(animObject);
        this.mapFilenames.put(animObject, string);
        this.mapMotionCurves.put(animObject, motionCurveSet);
        if (animObject instanceof AnimLight) {
            this.enumerateLights();
        }
    }

    public final void removeObject(AnimObject animObject) {
        if (animObject != this.camera1) {
            this.listObjects.remove(animObject);
            this.mapMotionCurves.remove(animObject);
            if (animObject == this.getActiveObject()) {
                this.setActiveObject(this.camera1);
            } else {
                this.poseSliders.init();
                this.rerenderViewports();
            }
            if (animObject instanceof AnimLight) {
                this.enumerateLights();
            }
        }
    }

    public final Camera getActiveCamera() {
        return this.camera1;
    }

    public final void preferences() {
        this.propertiesDialog = new BDialog(this, "Preferences", true);
        this.propertiesDialog.setResizable(false);
        this.textModelDir = new BTextField(JPatchSettings.getInstance().strModelDir, 20);
        FormContainer formContainer = new FormContainer(3, 1);
        BButton bButton = new BButton("browse");
        formContainer.add(new BLabel("Model directory:"), 0, 0);
        formContainer.add(this.textModelDir, 1, 0);
        formContainer.add(bButton, 2, 0);
        RowContainer rowContainer = new RowContainer();
        BButton bButton2 = new BButton("OK");
        BButton bButton3 = new BButton("Cancel");
        rowContainer.add(bButton2);
        rowContainer.add(bButton3);
        Class clazz = class$buoy$event$WindowClosingEvent;
        if (clazz == null) {
            clazz = class$buoy$event$WindowClosingEvent = Animator.class("[Lbuoy.event.WindowClosingEvent;", false);
        }
        this.propertiesDialog.addEventLink(clazz, (Object)this.propertiesDialog, "dispose");
        Class clazz2 = class$buoy$event$CommandEvent;
        if (clazz2 == null) {
            clazz2 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton3.addEventLink(clazz2, (Object)this.propertiesDialog, "dispose");
        Class clazz3 = class$buoy$event$CommandEvent;
        if (clazz3 == null) {
            clazz3 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton2.addEventLink(clazz3, (Object)this, "setPrefs");
        Class clazz4 = class$buoy$event$CommandEvent;
        if (clazz4 == null) {
            clazz4 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton.addEventLink(clazz4, (Object)this, "openFileChooser");
        ColumnContainer columnContainer = new ColumnContainer();
        columnContainer.add(formContainer);
        columnContainer.add(rowContainer);
        this.propertiesDialog.setContent(columnContainer);
        this.propertiesDialog.pack();
        ((Window)this.propertiesDialog.getComponent()).setLocationRelativeTo(this.getComponent());
        this.propertiesDialog.setVisible(true);
    }

    public final void properties() {
        this.propertiesDialog = new BDialog(this, "Sequence properties", true);
        this.propertiesDialog.setResizable(false);
        FormContainer formContainer = new FormContainer(2, 4);
        formContainer.add(new BLabel("Sequence start:"), 0, 0);
        formContainer.add(new BLabel("Sequence end:"), 0, 1);
        formContainer.add(new BLabel("Frame rate:"), 0, 2);
        formContainer.add(new BLabel("File prefix:"), 0, 3);
        this.textStart = new BTextField("" + this.fStart, 20);
        this.textEnd = new BTextField("" + this.fEnd, 20);
        this.textRate = new BTextField("" + this.fFramerate, 20);
        this.textPrefix = new BTextField(this.strPrefix, 20);
        this.textPov = new BTextArea(this.re.getRenderString("povray", ""), 10, 50);
        this.textRib = new BTextArea(this.re.getRenderString("renderman", ""), 10, 50);
        formContainer.add(this.textStart, 1, 0);
        formContainer.add(this.textEnd, 1, 1);
        formContainer.add(this.textRate, 1, 2);
        formContainer.add(this.textPrefix, 1, 3);
        RowContainer rowContainer = new RowContainer();
        BButton bButton = new BButton("OK");
        BButton bButton2 = new BButton("Cancel");
        rowContainer.add(bButton);
        rowContainer.add(bButton2);
        BTabbedPane bTabbedPane = new BTabbedPane();
        bTabbedPane.add(new BScrollPane(this.textPov), "POV-Ray");
        bTabbedPane.add(new BScrollPane(this.textRib), "RenderMan");
        ColumnContainer columnContainer = new ColumnContainer();
        columnContainer.add(formContainer);
        columnContainer.add(bTabbedPane);
        columnContainer.add(rowContainer);
        Class clazz = class$buoy$event$WindowClosingEvent;
        if (clazz == null) {
            clazz = class$buoy$event$WindowClosingEvent = Animator.class("[Lbuoy.event.WindowClosingEvent;", false);
        }
        this.propertiesDialog.addEventLink(clazz, (Object)this.propertiesDialog, "dispose");
        Class clazz2 = class$buoy$event$CommandEvent;
        if (clazz2 == null) {
            clazz2 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton2.addEventLink(clazz2, (Object)this.propertiesDialog, "dispose");
        Class clazz3 = class$buoy$event$CommandEvent;
        if (clazz3 == null) {
            clazz3 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton.addEventLink(clazz3, (Object)this, "setProperties");
        this.propertiesDialog.setContent(columnContainer);
        this.propertiesDialog.pack();
        ((Window)this.propertiesDialog.getComponent()).setLocationRelativeTo(this.getComponent());
        this.propertiesDialog.setVisible(true);
    }

    public final void setRenderString(String string, String string2, String string3) {
        this.re.setRenderString(string, string2, string3);
    }

    public final String getRenderString(String string, String string2) {
        return this.re.getRenderString(string, string2);
    }

    public final StringBuffer renderStrings(int n) {
        return this.re.xml(n);
    }

    private final void openFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(this.textModelDir.getText()));
        if (jFileChooser.showDialog(this.getComponent(), "Select") == 0) {
            this.textModelDir.setText(jFileChooser.getSelectedFile().getPath());
        }
    }

    private final void setProperties() {
        try {
            this.fStart = Float.parseFloat(this.textStart.getText());
            this.fEnd = Float.parseFloat(this.textEnd.getText());
            this.fFramerate = Math.round(Float.parseFloat(this.textRate.getText()));
            this.re.setRenderString("povray", "", this.textPov.getText());
            this.re.setRenderString("renderman", "", this.textRib.getText());
            this.strPrefix = this.textPrefix.getText();
            this.propertiesDialog.dispose();
            this.reinitMotionCurveDisplay();
            this.motionCurveEditor.setPosition(this.fPosition);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void setPrefs() {
        JPatchSettings.getInstance().strModelDir = this.textModelDir.getText();
        JPatchSettings.getInstance().saveSettings();
        this.propertiesDialog.dispose();
    }

    public final void setPrefix(String string) {
        this.strPrefix = string;
    }

    public final String getPrefix() {
        return this.strPrefix;
    }

    final void parseTimesheet(String string) {
        try {
            AnimObject animObject = this.getActiveObject();
            if (animObject instanceof AnimModel) {
                String string2;
                MotionCurveSet.Model model = (MotionCurveSet.Model)this.mapMotionCurves.get(animObject);
                Model model2 = ((AnimModel)animObject).getModel();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    String string3 = string2.substring(0, 5);
                    String string4 = string2.substring(6, 18);
                    String string5 = string2.substring(21, 22);
                    String string6 = string2.substring(25, string2.length() >= 38 ? 38 : string2.length());
                    if (string3.equals("Frame")) continue;
                    int n = Integer.parseInt(string3.replaceAll("^\\s*", "").replaceAll("\\s*$", ""));
                    Morph morph = model2.getMorphFor(string6.replaceAll("^\\s*", "").replaceAll("\\s*$", ""));
                    if (morph == null) continue;
                    Iterator iterator = model2.getPhonemeMorphSet().iterator();
                    while (iterator.hasNext()) {
                        Morph morph2 = (Morph)iterator.next();
                        MotionCurve2.Float float_ = model.morph(morph2);
                        float f = n - 1;
                        boolean bl = false;
                        if (morph2 == morph) {
                            bl = true;
                        }
                        float_.setFloatAt(f, (float)bl);
                    }
                }
                this.motionCurveEditor.repaint();
                this.rerenderViewports();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void quit() {
        if (JOptionPane.showConfirmDialog(Animator.getInstance().getComponent(), "Are you sure?", "Quit JPatch", 0) == 0) {
            this.dispose();
            System.exit(0);
        }
    }

    public final void renderCurrentFrame() {
        ProgressDisplay progressDisplay = new ProgressDisplay(Math.round(this.fPosition + 1.0f), Math.round(this.fPosition + 1.0f));
    }

    public final void renderFrame(String string, ProgressDisplay progressDisplay) {
        Object object;
        JPatchSettings jPatchSettings = JPatchSettings.getInstance();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object object2 = Animator.getInstance().getObjectList().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (object instanceof AnimModel) {
                arrayList.add(object);
            }
            if (!(object instanceof AnimLight)) continue;
            arrayList2.add(object);
        }
        switch (jPatchSettings.iRenderer) {
            case 0: {
                progressDisplay.clearText();
                progressDisplay.addText("Working directory is: " + jPatchSettings.strWorkingDir + '\n');
                progressDisplay.addText("Invoking Inyo...");
                TextureParser.setTexturePath(jPatchSettings.inyoSettings.strTexturePath);
                object2 = new InyoRenderer2(arrayList, Animator.getInstance().getActiveCamera(), arrayList2);
                object = ((InyoRenderer2)object2).render();
                if (object == null) break;
                File file = new File(jPatchSettings.strWorkingDir, string + ".png");
                try {
                    ImageIO.write((RenderedImage)((BufferedImage)object), "png", file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                progressDisplay.loadImage(file);
                break;
            }
            case 2: {
                String[] stringArray;
                object2 = new RibRenderer4();
                object = new File(jPatchSettings.strWorkingDir, string + ".rib");
                progressDisplay.clearText();
                progressDisplay.addText("Working directory is: " + jPatchSettings.strWorkingDir + '\n');
                progressDisplay.addText("Generating geometry...");
                try {
                    stringArray = new BufferedWriter(new FileWriter((File)object));
                    ((RibRenderer4)object2).writeToFile(arrayList, Animator.getInstance().getActiveCamera(), arrayList2, (BufferedWriter)stringArray, string + ".tif");
                    stringArray.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                stringArray = new String[]{jPatchSettings.ribSettings.strExecutable, string + ".rib"};
                String[] stringArray2 = JPatchSettings.getEnv(jPatchSettings.ribSettings.strEnv);
                File file = new File(jPatchSettings.strWorkingDir, string + ".tif");
                if (file.exists()) {
                    file.delete();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Starting RenderMAN renderer using:\n");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n++]).append(" ");
                }
                stringBuffer.append("\n");
                if (stringArray2 != null) {
                    stringBuffer.append("Environment variables:\n");
                    n = 0;
                    while (n < stringArray2.length) {
                        stringBuffer.append(stringArray2[n++]).append("\n");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append("--------------------------------------------------------------------------------\n");
                progressDisplay.addText(stringBuffer.toString());
                try {
                    Process process = Runtime.getRuntime().exec(stringArray, stringArray2, new File(jPatchSettings.strWorkingDir));
                    ProcessMonitor processMonitor = new ProcessMonitor(process, progressDisplay);
                    process.waitFor();
                    if (jPatchSettings.bDeleteSources) {
                        ((File)object).delete();
                    }
                    progressDisplay.loadImage(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1: {
                String[] stringArray;
                progressDisplay.clearText();
                progressDisplay.addText("Working directory is: " + jPatchSettings.strWorkingDir + '\n');
                progressDisplay.addText("Generating geometry...");
                object2 = new File(jPatchSettings.strWorkingDir, string + ".pov");
                try {
                    object = new PovrayRenderer3();
                    stringArray = new BufferedWriter(new FileWriter((File)object2));
                    ((PovrayRenderer3)object).writeFrame(arrayList, this.camera1, arrayList2, this.re.getRenderString("povray", ""), (BufferedWriter)stringArray);
                    stringArray.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                object = new ArrayList();
                ((ArrayList)object).add((String)jPatchSettings.povraySettings.strExecutable);
                if (jPatchSettings.povraySettings.iVersion == 0) {
                    ((ArrayList)object).add("+I" + string + ".pov");
                } else {
                    ((ArrayList)object).add("/RENDER");
                    ((ArrayList)object).add(string + ".pov");
                    ((ArrayList)object).add("/EXIT");
                }
                ((ArrayList)object).add("+O" + string + ".png");
                ((ArrayList)object).add("+W" + jPatchSettings.iRenderWidth);
                ((ArrayList)object).add("+H" + jPatchSettings.iRenderHeight);
                ((ArrayList)object).add("-D");
                ((ArrayList)object).add("-P");
                ((ArrayList)object).add("+FN8");
                if (jPatchSettings.povraySettings.iAaMethod != 0) {
                    ((ArrayList)object).add("+A" + jPatchSettings.povraySettings.fAaThreshold);
                    ((ArrayList)object).add("+AM" + jPatchSettings.povraySettings.iAaMethod);
                    ((ArrayList)object).add("+R" + jPatchSettings.povraySettings.iAaLevel);
                } else {
                    ((ArrayList)object).add("-A");
                }
                if (jPatchSettings.povraySettings.fAaJitter != 0.0f) {
                    ((ArrayList)object).add("+J" + jPatchSettings.povraySettings.fAaJitter);
                } else {
                    ((ArrayList)object).add("-J");
                }
                stringArray = ((ArrayList)object).toArray(new String[0]);
                String[] stringArray3 = JPatchSettings.getEnv(jPatchSettings.povraySettings.strEnv);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Starting POV-Ray renderer using:\n");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n++]).append(" ");
                }
                stringBuffer.append("\n");
                if (stringArray3 != null) {
                    stringBuffer.append("Environment variables:\n");
                    n = 0;
                    while (n < stringArray3.length) {
                        stringBuffer.append(stringArray3[n++]).append("\n");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append("--------------------------------------------------------------------------------\n");
                progressDisplay.addText(stringBuffer.toString());
                File file = new File(jPatchSettings.strWorkingDir, string + ".png");
                if (file.exists()) {
                    file.delete();
                }
                try {
                    Process process = Runtime.getRuntime().exec(stringArray, stringArray3, new File(jPatchSettings.strWorkingDir));
                    progressDisplay.setRendererProcess(process);
                    ProcessMonitor processMonitor = new ProcessMonitor(process, progressDisplay);
                    process.waitFor();
                    if (jPatchSettings.bDeleteSources) {
                        ((File)object2).delete();
                    }
                    progressDisplay.loadImage(file);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public final void renderingDone(Image image) {
    }

    public final void renderAnimation() {
        final BDialog bDialog = new BDialog(this, "Render animation", true);
        bDialog.setResizable(false);
        final BTextField bTextField = new BTextField("1", 20);
        final BTextField bTextField2 = new BTextField("" + (Math.round(this.fEnd - this.fStart) + 1), 20);
        FormContainer formContainer = new FormContainer(2, 2);
        formContainer.add(new BLabel("First frame:"), 0, 0);
        formContainer.add(new BLabel("Last frame:"), 0, 1);
        formContainer.add(bTextField, 1, 0);
        formContainer.add(bTextField2, 1, 1);
        RowContainer rowContainer = new RowContainer();
        BButton bButton = new BButton("OK");
        BButton bButton2 = new BButton("Cancel");
        rowContainer.add(bButton);
        rowContainer.add(bButton2);
        Class clazz = class$buoy$event$WindowClosingEvent;
        if (clazz == null) {
            clazz = class$buoy$event$WindowClosingEvent = Animator.class("[Lbuoy.event.WindowClosingEvent;", false);
        }
        bDialog.addEventLink(clazz, (Object)bDialog, "dispose");
        Class clazz2 = class$buoy$event$CommandEvent;
        if (clazz2 == null) {
            clazz2 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton2.addEventLink(clazz2, (Object)bDialog, "dispose");
        Class clazz3 = class$buoy$event$CommandEvent;
        if (clazz3 == null) {
            clazz3 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
        }
        bButton.addEventLink(clazz3, new Object(){

            private final void processEvent() {
                try {
                    int n = Integer.parseInt(bTextField.getText());
                    int n2 = Integer.parseInt(bTextField2.getText());
                    bDialog.dispose();
                    ProgressDisplay progressDisplay = new ProgressDisplay(Math.round(Animator.this.fStart + (float)n), Math.round(Animator.this.fStart + (float)n2));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        ColumnContainer columnContainer = new ColumnContainer();
        columnContainer.add(formContainer);
        columnContainer.add(rowContainer);
        bDialog.setContent(columnContainer);
        bDialog.pack();
        ((Window)bDialog.getComponent()).setLocationRelativeTo(this.getComponent());
        bDialog.setVisible(true);
    }

    public final StringBuffer xml() {
        AnimObject animObject;
        Object e;
        StringBuffer stringBuffer = XMLutils.indent(1);
        StringBuffer stringBuffer2 = XMLutils.indent(2);
        StringBuffer stringBuffer3 = XMLutils.lineBreak();
        StringBuffer stringBuffer4 = new StringBuffer();
        stringBuffer4.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(stringBuffer3);
        stringBuffer4.append("<sequence>").append(stringBuffer3);
        stringBuffer4.append(stringBuffer).append("<name>New Sequence</name>").append(stringBuffer3);
        stringBuffer4.append(stringBuffer).append("<start>" + this.fStart + "</start>").append(stringBuffer3);
        stringBuffer4.append(stringBuffer).append("<end>" + this.fEnd + "</end>").append(stringBuffer3);
        stringBuffer4.append(stringBuffer).append("<framerate>" + this.fFramerate + "</framerate>").append(stringBuffer3);
        stringBuffer4.append(stringBuffer).append("<prefix>" + this.strPrefix + "</prefix>").append(stringBuffer3);
        stringBuffer4.append(this.renderStrings(1));
        Iterator iterator = this.listObjects.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof Camera)) continue;
            animObject = (Camera)e;
            stringBuffer4.append(stringBuffer).append("<camera>").append(stringBuffer3);
            stringBuffer4.append(stringBuffer2).append("<name>" + animObject.getName() + "</name>").append(stringBuffer3);
            this.getMotionCurveSetFor(animObject).xml(stringBuffer4, 2);
            stringBuffer4.append(stringBuffer).append("</camera>").append(stringBuffer3);
        }
        iterator = this.listObjects.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof AnimLight)) continue;
            animObject = (AnimLight)e;
            stringBuffer4.append(stringBuffer).append("<lightsource>").append(stringBuffer3);
            stringBuffer4.append(stringBuffer2).append("<name>" + animObject.getName() + "</name>").append(stringBuffer3);
            if (!((AnimLight)animObject).isActive()) {
                stringBuffer4.append(stringBuffer2).append("<inactive/>").append(stringBuffer3);
            }
            stringBuffer4.append(((AnimLight)animObject).renderStrings(2));
            this.getMotionCurveSetFor(animObject).xml(stringBuffer4, 2);
            stringBuffer4.append(stringBuffer).append("</lightsource>").append(stringBuffer3);
        }
        iterator = this.listObjects.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof AnimModel)) continue;
            animObject = (AnimModel)e;
            Model model = ((AnimModel)animObject).getModel();
            String string = (String)this.mapFilenames.get(animObject);
            stringBuffer4.append(stringBuffer).append("<model>").append(stringBuffer3);
            stringBuffer4.append(stringBuffer2).append("<name>" + animObject.getName() + "</name>").append(stringBuffer3);
            stringBuffer4.append(stringBuffer2).append("<filename>" + string + "</filename>").append(stringBuffer3);
            int n = ((AnimModel)animObject).getSubdivisionOffset();
            if (n != 0) {
                stringBuffer4.append(stringBuffer2).append("<subdivisionoffset>" + n + "</subdivisionoffset>").append(stringBuffer3);
            }
            stringBuffer4.append(((AnimModel)animObject).renderStrings(2));
            this.getMotionCurveSetFor(animObject).xml(stringBuffer4, 2);
            stringBuffer4.append(stringBuffer).append("</model>").append(stringBuffer3);
        }
        stringBuffer4.append("</sequence>").append(stringBuffer3);
        return stringBuffer4;
    }

    public final void setFramerate(float f) {
        this.fFramerate = f;
    }

    public final void setStart(float f) {
        this.fStart = f;
    }

    public final void setEnd(float f) {
        this.fEnd = f;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listObjects = new ArrayList();
        this.content = new BorderContainer();
        this.camera1 = new Camera("Camera 1");
        this.cameraViewport = new CameraViewport(this.camera1, this.listObjects);
        this.objectBrowser = new FormContainer(3, 1);
        this.strPrefix = "frame_";
        this.fFramerate = 24.0f;
        this.mapMotionCurves = new HashMap();
        this.mapFilenames = new HashMap();
        this.re = new RenderExtension(new String[]{"povray", "", "renderman", ""});
    }

    private Animator() {
        this.this();
        this.setTitle("JPatch Animator 0.4 PREVIEW 1");
        INSTANCE = this;
        try {
            UIManager.setLookAndFeel(JPatchSettings.getInstance().strPlafClassName);
        }
        catch (Exception exception) {}
        this.fPosition = 0.0f;
        this.fStart = 0.0f;
        this.fEnd = 10.0f * this.fFramerate - 1.0f;
        this.camera1.setPosition(new Point3d(0.0, 0.0, -100.0));
        this.mapMotionCurves.put(this.camera1, new MotionCurveSet.Camera(this.camera1));
        this.listObjects.add(this.camera1);
        this.poseSliders = new PoseSliders();
        this.motionCurveEditor = new MotionCurveEditor();
        this.motionCurveDisplay = this.motionCurveEditor.getMotionCurveDisplay();
        this.splitPane = new BSplitPane(BSplitPane.VERTICAL, this.cameraViewport.getWidget(), this.motionCurveEditor);
        Class clazz = class$buoy$event$ValueChangedEvent;
        if (clazz == null) {
            clazz = class$buoy$event$ValueChangedEvent = Animator.class("[Lbuoy.event.ValueChangedEvent;", false);
        }
        this.splitPane.addEventLink(clazz, (Object)this, "rerenderViewports");
        this.content.add(this.splitPane, BorderContainer.CENTER);
        this.content.add(this.poseSliders.getContent(), BorderContainer.EAST);
        this.setContent(this.content);
        this.setMenuBar(new AnimatorMainMenu());
        this.pack();
        Class clazz2 = class$buoy$event$WindowClosingEvent;
        if (clazz2 == null) {
            clazz2 = class$buoy$event$WindowClosingEvent = Animator.class("[Lbuoy.event.WindowClosingEvent;", false);
        }
        this.addEventLink(clazz2, (Object)this, "quit");
        this.setBounds(new Rectangle(0, 0, 1000, 700));
        this.setVisible(true);
        this.poseSliders.init();
        this.rerenderViewports();
        this.setActiveObject(this.camera1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ProgressDisplay
    extends BDialog {
        private ColumnContainer columnContainer;
        private ImagePanel imagePanel;
        private BProgressBar progressBar;
        private BButton buttonAbort;
        private BButton buttonClose;
        private BTextArea textArea;
        private BScrollBar scrollBar;
        private OverlayContainer overlayContainer;
        private final int frame;
        private final int frames;
        private volatile StopableThread rendererThread;
        private volatile Process rendererProcess;

        void setImage(Image image) {
            this.imagePanel.setImage(image);
        }

        void loadImage(File file) {
            if (this.rendererThread != null && this.rendererThread.running) {
                if (file.exists()) {
                    try {
                        Image image;
                        if (file.getPath().endsWith(".tif") && !ImageIO.getImageReadersByFormatName("tiff").hasNext()) {
                            this.addText("");
                            this.addText("********************************************************************************");
                            this.addText("The renderer generated a tiff image, but no ImageIO tiff-reader is available.");
                            this.addText("Plase install the Java Advanced Imagige (JAI) IO Tools package available from Sun Microsystems at http://java.sun.com/products/java-media/jai/current.html");
                            this.addText("********************************************************************************");
                            this.addText("");
                            this.addText("Attempting to load the tiff image with JPatch's builtin tiff-reader (which can't handle compressed files)...");
                            this.addText("");
                            image = new ReadTiff().loadImage(file);
                        } else {
                            image = ImageIO.read(file);
                        }
                        Graphics graphics = ((Image)image).getGraphics();
                        graphics.setColor(Color.BLACK);
                        graphics.drawString(file.getParent() + File.separator, 8, 16);
                        graphics.drawString(file.getName(), 8, 32);
                        graphics.setColor(Color.WHITE);
                        graphics.drawString(file.getParent() + File.separator, 7, 15);
                        graphics.drawString(file.getName(), 7, 31);
                        this.imagePanel.setImage(image);
                    }
                    catch (Exception exception) {
                        JPatchSettings jPatchSettings = JPatchSettings.getInstance();
                        BufferedImage bufferedImage = new BufferedImage(jPatchSettings.iRenderWidth, jPatchSettings.iRenderHeight, 1);
                        Graphics graphics = ((Image)bufferedImage).getGraphics();
                        graphics.setColor(Color.RED);
                        graphics.drawString("Can't display image - error reading file", 8, 16);
                        this.imagePanel.setImage(bufferedImage);
                    }
                } else {
                    JPatchSettings jPatchSettings = JPatchSettings.getInstance();
                    BufferedImage bufferedImage = new BufferedImage(jPatchSettings.iRenderWidth, jPatchSettings.iRenderHeight, 1);
                    Graphics graphics = ((Image)bufferedImage).getGraphics();
                    graphics.setColor(Color.RED);
                    graphics.drawString("Can't display image - file not found", 8, 16);
                    this.imagePanel.setImage(bufferedImage);
                }
            }
        }

        void setRendererProcess(Process process) {
            this.rendererProcess = process;
        }

        private final void abort() {
            if (this.rendererThread != null) {
                this.rendererThread.running = false;
                this.rendererThread.stop();
            }
            if (this.rendererProcess != null) {
                this.rendererProcess.destroy();
            }
            this.setTitle("Rendering aborted");
            this.done();
        }

        private final void close() {
            if (this.rendererThread != null && this.rendererThread.running) {
                if (JOptionPane.showConfirmDialog(this.getComponent(), "Do you want to stop the rendering process?", "Confirm", 0) == 0) {
                    this.rendererThread.running = false;
                    if (this.rendererProcess != null) {
                        this.rendererProcess.destroy();
                    }
                    this.dispose();
                }
            } else {
                this.dispose();
            }
        }

        void done() {
            this.buttonAbort.setVisible(false);
            this.buttonClose.setVisible(true);
            this.progressBar.setValue(this.progressBar.getMaximum());
        }

        synchronized void clearText() {
            this.textArea.setText("");
        }

        synchronized void addText(String string) {
            this.textArea.append(string);
            this.textArea.append("\n");
            this.scrollBar.setValue(this.scrollBar.getMaximum());
            this.textArea.repaint();
        }

        static /* synthetic */ StopableThread access$2(ProgressDisplay progressDisplay) {
            return progressDisplay.rendererThread;
        }

        static /* synthetic */ Process access$4(ProgressDisplay progressDisplay) {
            return progressDisplay.rendererProcess;
        }

        private final /* synthetic */ void this() {
            this.columnContainer = new ColumnContainer();
            this.progressBar = new BProgressBar();
            this.buttonAbort = new BButton("Abort");
            this.buttonClose = new BButton("Close");
            this.textArea = new BTextArea(10, 80);
            this.overlayContainer = new OverlayContainer();
        }

        ProgressDisplay(final int n, int n2) {
            super(Animator.getInstance(), true);
            this.this();
            this.frame = n;
            this.frames = n2 - n + 1;
            this.imagePanel = new ImagePanel();
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.frames);
            this.textArea.setWrapStyle(BTextArea.WRAP_WORD);
            this.textArea.setFont(new Font("Monospaced", 0, 12));
            this.textArea.setFont(new Font("Monospaced", 0, 12));
            this.textArea.setEditable(false);
            this.textArea.setBackground(Color.BLACK);
            this.textArea.getComponent().setForeground(Color.GREEN);
            BScrollPane bScrollPane = new BScrollPane(this.textArea, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_ALWAYS);
            this.scrollBar = bScrollPane.getVerticalScrollBar();
            LayoutInfo layoutInfo = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL);
            this.overlayContainer.add(this.buttonAbort);
            this.overlayContainer.add(this.buttonClose);
            this.buttonClose.setVisible(false);
            this.columnContainer.add(this.progressBar, layoutInfo);
            this.columnContainer.add(new AWTWidget(this.imagePanel));
            this.columnContainer.add(bScrollPane, layoutInfo);
            this.columnContainer.add(this.overlayContainer);
            Class clazz = class$buoy$event$CommandEvent;
            if (clazz == null) {
                clazz = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
            }
            this.buttonAbort.addEventLink(clazz, (Object)this, "abort");
            Class clazz2 = class$buoy$event$CommandEvent;
            if (clazz2 == null) {
                clazz2 = class$buoy$event$CommandEvent = Animator.class("[Lbuoy.event.CommandEvent;", false);
            }
            this.buttonClose.addEventLink(clazz2, (Object)this, "dispose");
            Class clazz3 = class$buoy$event$WindowClosingEvent;
            if (clazz3 == null) {
                clazz3 = class$buoy$event$WindowClosingEvent = Animator.class("[Lbuoy.event.WindowClosingEvent;", false);
            }
            this.addEventLink(clazz3, (Object)this, "close");
            this.setContent(this.columnContainer);
            this.pack();
            this.setResizable(false);
            this.rendererThread = new StopableThread(this){

                public final void run() {
                    this.running = true;
                    int n3 = 0;
                    while (n3 < ProgressDisplay.this.frames && this.running) {
                        int n2 = n + n3 - Math.round(Animator.this.fStart);
                        ProgressDisplay.this.setTitle("Rendering frame " + n2 + " (" + (n3 + 1) + " of " + ProgressDisplay.this.frames + ')');
                        ProgressDisplay.this.progressBar.setValue(n3);
                        Animator.this.setPosition(n + n3 - 1);
                        String string = Animator.this.strPrefix + (n2 < 10 ? "00000" + n2 : (n2 < 100 ? "0000" + n2 : (n2 < 1000 ? "000" + n2 : (n2 < 10000 ? "00" + n2 : (n2 < 100000 ? "0" + n2 : "" + n2)))));
                        Animator.this.renderFrame(string, ProgressDisplay.this);
                        ++n3;
                    }
                    this.running = false;
                    ProgressDisplay.this.rendererThread = null;
                    ProgressDisplay.this.rendererProcess = null;
                    ProgressDisplay.this.done();
                    ProgressDisplay.this.setTitle("Done. " + ProgressDisplay.this.frames + " frames rendered.");
                }
            };
            this.rendererThread.start();
            this.setVisible(true);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class StopableThread
        extends Thread {
            volatile boolean running;

            StopableThread() {
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ProcessMonitor {
        ProcessMonitor(final Process process, final ProgressDisplay progressDisplay) {
            new Thread(){

                public final void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            progressDisplay.addText(string);
                        }
                    }
                    catch (IOException iOException) {
                        progressDisplay.addText("*** ABORTED ***");
                    }
                }
            }.start();
            new Thread(){

                public final void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            progressDisplay.addText(string);
                        }
                    }
                    catch (IOException iOException) {
                        progressDisplay.addText("*** ABORTED ***");
                    }
                }
            }.start();
        }
    }

    static class ImagePanel
    extends JPanel {
        private Image image;

        void setImage(Image image) {
            this.image = image;
            this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this);
            }
        }

        ImagePanel() {
            this.setImage(new BufferedImage(JPatchSettings.getInstance().iRenderWidth, JPatchSettings.getInstance().iRenderHeight, 1));
        }
    }
}

