/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtMaterial;
import inyo.RtTriangle;
import inyo.RtWorld;
import javax.vecmath.Point3d;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class RtZBuffer {
    boolean[] edgeFlag;
    double[] edgeStartX;
    double[] edgeStartZ;
    double[] edgeEndX;
    double[] edgeEndZ;
    double[][] depthBuffer;
    RtTriangle[][] triangleBuffer;
    int top;
    int bottom;
    int left;
    int right;
    int high;
    int wide;
    double dTop;
    double dBottom;
    double dLeft;
    double dRight;
    double fov;
    double dClipping;

    void freeSpans() {
        this.edgeFlag = null;
        this.edgeStartX = null;
        this.edgeStartZ = null;
        this.edgeEndX = null;
        this.edgeEndZ = null;
    }

    public final void setHitPoint(RtWorld rtWorld, int n, int n2, Point3d point3d) {
        int n3 = -this.left + n;
        int n4 = this.top - n2;
        double d = 1.0 / this.depthBuffer[n3][n4];
        double d2 = (double)n / this.fov * d;
        double d3 = (double)n2 / this.fov * d;
        point3d.set(d2, d3, d);
    }

    public final RtTriangle getTriangle(int n, int n2) {
        int n3 = -this.left + n;
        int n4 = this.top - n2;
        return this.triangleBuffer[n3][n4];
    }

    public final RtMaterial getMaterial(int n, int n2) {
        int n3 = -this.left + n;
        int n4 = this.top - n2;
        RtTriangle rtTriangle = this.triangleBuffer[n3][n4];
        if (rtTriangle == null) {
            return null;
        }
        return rtTriangle.material;
    }

    public final double getDepth(int n, int n2) {
        int n3 = -this.left + n;
        int n4 = this.top - n2;
        return 1.0 / this.depthBuffer[n3][n4];
    }

    public final void calculateClip(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = point3d2.z - point3d.z;
        double d2 = this.dClipping - point3d.z;
        double d3 = (point3d2.x - point3d.x) / d;
        double d4 = (point3d2.y - point3d.y) / d;
        double d5 = (point3d2.z - point3d.z) / d;
        point3d3.x = point3d.x + d2 * d3;
        point3d3.y = point3d.y + d2 * d4;
        point3d3.z = point3d.z + d2 * d5;
    }

    public final void renderClippedTriangle(RtWorld rtWorld, RtTriangle rtTriangle) {
        Point3d point3d = rtTriangle.v1.point;
        Point3d point3d2 = rtTriangle.v2.point;
        Point3d point3d3 = rtTriangle.v3.point;
        if (point3d.z >= this.dClipping && point3d2.z >= this.dClipping && point3d3.z >= this.dClipping) {
            this.renderTriangle(rtWorld, rtTriangle, point3d, point3d2, point3d3);
        } else if (!(point3d.z < this.dClipping && point3d2.z < this.dClipping && point3d3.z < this.dClipping)) {
            if (point3d.z < this.dClipping && point3d2.z < this.dClipping) {
                Point3d point3d4 = new Point3d();
                Point3d point3d5 = new Point3d();
                this.calculateClip(point3d, point3d3, point3d4);
                this.calculateClip(point3d2, point3d3, point3d5);
                this.renderTriangle(rtWorld, rtTriangle, point3d4, point3d5, point3d3);
            } else if (point3d2.z < this.dClipping && point3d3.z < this.dClipping) {
                Point3d point3d6 = new Point3d();
                Point3d point3d7 = new Point3d();
                this.calculateClip(point3d, point3d2, point3d6);
                this.calculateClip(point3d, point3d3, point3d7);
                this.renderTriangle(rtWorld, rtTriangle, point3d, point3d6, point3d7);
            } else if (point3d.z < this.dClipping && point3d3.z < this.dClipping) {
                Point3d point3d8 = new Point3d();
                Point3d point3d9 = new Point3d();
                this.calculateClip(point3d, point3d2, point3d8);
                this.calculateClip(point3d2, point3d3, point3d9);
                this.renderTriangle(rtWorld, rtTriangle, point3d8, point3d2, point3d9);
            } else if (point3d.z < this.dClipping) {
                Point3d point3d10 = new Point3d();
                Point3d point3d11 = new Point3d();
                this.calculateClip(point3d, point3d2, point3d10);
                this.calculateClip(point3d, point3d3, point3d11);
                this.renderTriangle(rtWorld, rtTriangle, point3d11, point3d10, point3d2);
                this.renderTriangle(rtWorld, rtTriangle, point3d11, point3d2, point3d3);
            } else if (point3d2.z < this.dClipping) {
                Point3d point3d12 = new Point3d();
                Point3d point3d13 = new Point3d();
                this.calculateClip(point3d, point3d2, point3d12);
                this.calculateClip(point3d2, point3d3, point3d13);
                this.renderTriangle(rtWorld, rtTriangle, point3d, point3d12, point3d3);
                this.renderTriangle(rtWorld, rtTriangle, point3d12, point3d13, point3d3);
            } else {
                Point3d point3d14 = new Point3d();
                Point3d point3d15 = new Point3d();
                this.calculateClip(point3d, point3d3, point3d14);
                this.calculateClip(point3d2, point3d3, point3d15);
                this.renderTriangle(rtWorld, rtTriangle, point3d, point3d14, point3d2);
                this.renderTriangle(rtWorld, rtTriangle, point3d14, point3d15, point3d2);
            }
        }
    }

    final void renderTriangle(RtWorld rtWorld, RtTriangle rtTriangle, Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = point3d.x / point3d.z * this.fov;
        double d2 = point3d.y / point3d.z * this.fov;
        double d3 = 1.0 / point3d.z;
        double d4 = point3d2.x / point3d2.z * this.fov;
        double d5 = point3d2.y / point3d2.z * this.fov;
        double d6 = 1.0 / point3d2.z;
        double d7 = point3d3.x / point3d3.z * this.fov;
        double d8 = point3d3.y / point3d3.z * this.fov;
        double d9 = 1.0 / point3d3.z;
        if (d < (double)this.left && d4 < (double)this.left && d7 < (double)this.left || d > (double)this.right && d4 > (double)this.right && d7 > (double)this.right || d2 > (double)this.top && d5 > (double)this.top && d8 > (double)this.top || d2 < (double)this.bottom && d5 < (double)this.bottom && d8 < (double)this.bottom) {
            return;
        }
        int n = 0;
        while (n < this.high) {
            this.edgeFlag[n] = false;
            ++n;
        }
        this.renderSegment(d, d2, d3, d4, d5, d6);
        this.renderSegment(d4, d5, d6, d7, d8, d9);
        this.renderSegment(d, d2, d3, d7, d8, d9);
        n = 0;
        while (n < this.high) {
            int n2 = this.top - n;
            if (this.edgeFlag[n]) {
                this.renderSpan(rtTriangle, n2, n);
            }
            ++n;
        }
    }

    final void renderSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (d2 > d5) {
            d7 = d;
            d = d4;
            d4 = d7;
            d7 = d2;
            d2 = d5;
            d5 = d7;
            d7 = d3;
            d3 = d6;
            d6 = d7;
        }
        if ((d7 = d5 - d2) <= 1.0) {
            this.addEdge(d, d2, d3);
            this.addEdge(d4, d5, d6);
            return;
        }
        double d8 = (d4 - d) / d7;
        double d9 = (d6 - d3) / d7;
        double d10 = d2;
        while (d10 <= d5) {
            this.addEdge(d, d10, d3);
            d += d8;
            d3 += d9;
            d10 += 1.0;
        }
    }

    final void addEdge(double d, double d2, double d3) {
        int n;
        if (d2 >= (double)this.bottom && d2 <= (double)this.top && (n = this.top - (int)Math.floor(d2)) > 0 && n < this.high) {
            if (!this.edgeFlag[n]) {
                this.edgeFlag[n] = true;
                this.edgeStartX[n] = d;
                this.edgeStartZ[n] = d3;
                this.edgeEndX[n] = d;
                this.edgeEndZ[n] = d3;
            } else if (d < this.edgeStartX[n]) {
                this.edgeStartX[n] = d;
                this.edgeStartZ[n] = d3;
            } else {
                this.edgeEndX[n] = d;
                this.edgeEndZ[n] = d3;
            }
        }
    }

    final void renderSpan(RtTriangle rtTriangle, int n, int n2) {
        double d;
        double d2 = this.edgeStartX[n2];
        double d3 = this.edgeStartZ[n2];
        double d4 = this.edgeEndX[n2];
        double d5 = this.edgeEndZ[n2];
        if (d2 > d4) {
            d = d2;
            d2 = d4;
            d4 = d;
            d = d3;
            d3 = d5;
            d5 = d;
        }
        d = (d5 - d3) / (d4 - d2);
        double d6 = d2;
        while (d6 <= d4) {
            if (d6 >= (double)this.left && d6 <= (double)this.right && n <= this.top && n >= this.bottom) {
                int n3 = -this.left + (int)Math.floor(d6);
                int n4 = this.top - (int)Math.floor(n);
                if (n3 > 0 && n3 < this.wide && n4 > 0 && n4 < this.high && d3 >= this.depthBuffer[n3][n4]) {
                    this.depthBuffer[n3][n4] = d3;
                    this.triangleBuffer[n3][n4] = rtTriangle;
                }
            }
            d3 += d;
            d6 += 1.0;
        }
    }

    private final /* synthetic */ void this() {
        this.dClipping = 1.0;
    }

    public RtZBuffer(int n, int n2, int n3, int n4, int n5) {
        this.this();
        this.left = n;
        this.right = n3;
        this.top = n2;
        this.bottom = n4;
        this.dTop = this.top;
        this.dBottom = this.bottom;
        this.dLeft = this.left;
        this.dRight = this.right;
        this.fov = n5;
        this.high = Math.abs(this.top - this.bottom) + 1;
        this.wide = Math.abs(this.right - this.left) + 1;
        this.edgeFlag = new boolean[this.high];
        this.edgeStartX = new double[this.high];
        this.edgeStartZ = new double[this.high];
        this.edgeEndX = new double[this.high];
        this.edgeEndZ = new double[this.high];
        this.depthBuffer = new double[this.wide][this.high];
        this.triangleBuffer = new RtTriangle[this.wide][this.high];
        int n6 = 0;
        while (n6 < this.high) {
            int n7 = 0;
            while (n7 < this.wide) {
                this.depthBuffer[n7][n6] = -1.0;
                this.triangleBuffer[n7][n6] = null;
                ++n7;
            }
            ++n6;
        }
    }
}

