/*
 * Decompiled with CFR 0.152.
 */
package inyo;

class RtVector3 {
    double x;
    double y;
    double z;

    public RtVector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public RtVector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    RtVector3(RtVector3 p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    final RtVector3 cross(RtVector3 p) {
        return new RtVector3(this.y * p.z - this.z * p.y, this.z * p.x - this.x * p.z, this.x * p.y - this.y * p.x);
    }

    final RtVector3 cross(double x, double y, double z) {
        return new RtVector3(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    final void add(RtVector3 p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
    }

    final void add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    final void add(RtVector3 p1, RtVector3 p2) {
        this.x = p1.x + p2.x;
        this.y = p1.y + p2.y;
        this.z = p1.z + p2.z;
    }

    final void sub(RtVector3 p) {
        this.x -= p.x;
        this.y -= p.y;
        this.z -= p.z;
    }

    final void sub(RtVector3 p1, RtVector3 p2) {
        this.x = p1.x - p2.x;
        this.y = p1.y - p2.y;
        this.z = p1.z - p2.z;
    }

    final void mul(RtVector3 p) {
        this.x *= p.x;
        this.y *= p.y;
        this.z *= p.z;
    }

    final void mul(RtVector3 p1, RtVector3 p2) {
        this.x = p1.x * p2.x;
        this.y = p1.y * p2.y;
        this.z = p1.z * p2.z;
    }

    final void div(RtVector3 p) {
        this.x /= p.x;
        this.y /= p.y;
        this.z /= p.z;
    }

    final void div(RtVector3 p1, RtVector3 p2) {
        this.x = p1.x / p2.x;
        this.y = p1.y / p2.y;
        this.z = p1.z / p2.z;
    }

    final void scale(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    final void scale(double factor, RtVector3 p) {
        this.x = p.x * factor;
        this.y = p.y * factor;
        this.z = p.z * factor;
    }

    final double length(RtVector3 p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        double dz = this.z - p.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    final double length(double x, double y, double z) {
        return Math.sqrt((x -= this.x) * x + (y -= this.y) * y + (z -= this.z) * z);
    }

    final void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    final void set(RtVector3 p) {
        if (p != null) {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }
    }

    final void clamp(double min, double max) {
        if (this.x < min) {
            this.x = min;
        }
        if (this.x > max) {
            this.x = max;
        }
        if (this.y < min) {
            this.y = min;
        }
        if (this.y > max) {
            this.y = max;
        }
        if (this.z < min) {
            this.z = min;
        }
        if (this.z > max) {
            this.z = max;
        }
    }

    final void interpolate(RtVector3 p1, RtVector3 p2, double alpha) {
        this.x = (1.0 - alpha) * p1.x + alpha * p2.x;
        this.y = (1.0 - alpha) * p1.y + alpha * p2.y;
        this.z = (1.0 - alpha) * p1.z + alpha * p2.z;
    }

    final void normalize() {
        double len = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (len > 0.0) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    final double dot(RtVector3 p) {
        return this.x * p.x + this.y * p.y + this.z * p.z;
    }

    final double dot(double a, double b, double c) {
        return this.x * a + this.y * b + this.z * c;
    }

    final RtVector3 rotate(double angleX, double angleY, double angleZ) {
        double ry1 = this.y * Math.cos(angleX) - this.z * Math.sin(angleX);
        double rz1 = this.z * Math.cos(angleX) + this.y * Math.sin(angleX);
        double rz2 = rz1 * Math.cos(angleY) - this.x * Math.sin(angleY);
        double rx2 = this.x * Math.cos(angleY) + rz1 * Math.sin(angleY);
        double rx3 = rx2 * Math.cos(angleZ) - ry1 * Math.sin(angleZ);
        double ry3 = ry1 * Math.cos(angleZ) + rx2 * Math.sin(angleZ);
        return new RtVector3(rx3, ry3, rz2);
    }

    final RtVector3 sampleRandomly() {
        double theta = Math.random() * Math.PI * 2.0;
        double phi = Math.random() * Math.PI;
        double x = Math.cos(phi) * Math.sin(theta);
        double y = Math.sin(phi) * Math.sin(theta);
        double z = Math.cos(theta);
        RtVector3 sample = new RtVector3(x, y, z);
        sample.add(this);
        sample.normalize();
        if (this.dot(sample) <= 0.0) {
            sample.negate();
        }
        return sample;
    }

    final RtVector3 sampleHemisphere_(double randomTheta, double randomPhi) {
        double b;
        double a;
        RtVector3 u = Math.abs(this.x) < 0.5 ? new RtVector3(1.0, 0.0, 0.0) : this.cross(0.0, 1.0, 0.0);
        u.normalize();
        RtVector3 v = u.cross(this);
        while (!((a = Math.random() * 2.0 - 1.0) * a + (b = Math.random() * 2.0 - 1.0) * b < 1.0)) {
        }
        double c = Math.sqrt(1.0 - (a * a + b * b));
        return new RtVector3(a * u.x + b * v.x + c * this.x, a * u.y + b * v.y + c * this.y, a * u.z + b * v.z + c * this.z);
    }

    final RtVector3 sampleHemisphere(double theta, double phi) {
        double x = Math.cos(phi) * Math.sin(theta);
        double y = Math.sin(phi) * Math.sin(theta);
        double z = Math.cos(theta);
        RtVector3 sample = new RtVector3(x, y, z);
        sample.add(this);
        sample.normalize();
        if (this.dot(sample) < 0.0) {
            sample.negate();
        }
        return sample;
    }

    final RtVector3 sampleUsingCosine() {
        double y;
        double thetaNormal = Math.atan2(this.y, this.x);
        double phiNormal = Math.acos(this.z);
        double theta = Math.PI * Math.acos(Math.sqrt(Math.random()));
        double phi = Math.PI * 2 * Math.random();
        theta += thetaNormal;
        double z = Math.cos(phi += phiNormal);
        double x = Math.sin(phi) * Math.cos(theta);
        RtVector3 sample = new RtVector3(x, y = Math.sin(phi) * Math.sin(theta), z);
        if (this.dot(sample) < 0.0) {
            sample.negate();
        }
        return sample;
    }

    final RtVector3 importanceSample(RtVector3 normal) {
        RtVector3 jittered;
        RtVector3 D = new RtVector3(this);
        D.negate();
        RtVector3 reflection = new RtVector3(normal);
        reflection.scale(2.0 * normal.dot(D));
        reflection.sub(D);
        while (!(this.dot(jittered = this.sampleUsingCosine()) >= 0.0)) {
        }
        return jittered;
    }
}

