/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtImageMap;
import javax.vecmath.Color3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class RtShader {
    static Vector3d reflect(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(vector3d2);
        vector3d3.scale((double)2 * vector3d.dot(vector3d2));
        vector3d3.negate();
        vector3d3.add(vector3d);
        return vector3d3;
    }

    static Vector3d refract(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = vector3d.dot(vector3d2);
        double d3 = 1.0 - d * d * (1.0 - d2 * d2);
        if (d3 < 0.0) {
            return new Vector3d();
        }
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.scale(d);
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.scale(d * d2 + Math.sqrt(d3));
        vector3d3.sub(vector3d4);
        return vector3d3;
    }

    public static double fresnel(double d, double d2) {
        double d3 = Math.cos(d);
        double d4 = Math.sqrt(d2 * d2 + d3 * d3 - 1.0);
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        double d5 = 0.5;
        d5 *= (d4 - d3) * (d4 - d3) / ((d4 + d3) * (d4 + d3));
        double d6 = (d3 * (d4 + d3) - 1.0) / (d3 * (d4 - d3) + 1.0);
        d6 *= d6;
        return d5 *= (d6 += 1.0);
    }

    static final Vector3d faceForward(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(vector3d);
        if (vector3d.dot(vector3d2) >= 0.0) {
            vector3d3.negate();
        }
        return vector3d3;
    }

    static double fresnel(Vector3d vector3d, Vector3d vector3d2, double d, Vector3d vector3d3, Vector3d vector3d4) {
        vector3d4.set(RtShader.refract(vector3d, vector3d2, d));
        vector3d3.set(RtShader.reflect(vector3d, vector3d2));
        double d2 = -vector3d.dot(vector3d2);
        double d3 = 1.0 - d * d * (1.0 - d2 * d2);
        boolean bl = false;
        if (d3 >= 0.0) {
            bl = true;
        }
        double d4 = (double)bl;
        double d5 = -vector3d2.dot(vector3d4);
        double d6 = d5 / d2;
        double d7 = d2 / d5;
        double d8 = (d6 - d) / (d6 + d);
        d8 *= d8;
        double d9 = (d7 - d) / (d7 + d);
        d9 *= d9;
        double d10 = 0.5 * (d8 + d9);
        double d11 = d4 * d10 + (1.0 - d4);
        return d11;
    }

    static Color3f imageBasedShader(Vector3d vector3d, Vector3d vector3d2, RtImageMap rtImageMap) {
        Vector2d vector2d = new Vector2d(vector3d.x, vector3d.z);
        vector2d.normalize();
        Vector2d vector2d2 = new Vector2d(-vector3d2.x, -vector3d2.z);
        vector2d2.normalize();
        double d = vector2d.dot(vector2d2);
        vector2d = new Vector2d(vector3d.y, vector3d.z);
        vector2d.normalize();
        vector2d2 = new Vector2d(-vector3d2.y, -vector3d2.z);
        vector2d2.normalize();
        double d2 = vector2d.dot(vector2d2);
        boolean bl = false;
        if (-vector3d2.x < vector3d.x) {
            bl = true;
        }
        boolean bl2 = false;
        if (-vector3d2.y < vector3d.y) {
            bl2 = true;
        }
        return rtImageMap.getMapColor(d, bl, d2, bl2);
    }

    static double lambertDiffuse(Vector3d vector3d, Vector3d vector3d2) {
        return Math.max(0.0, vector3d.dot(vector3d2));
    }

    static double wrappedLambertDiffuse(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = vector3d.dot(vector3d2);
        return 1.0 - Math.acos(d2) / d;
    }

    static double povDiffuse(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d, double d2, double d3) {
        double d4 = d * vector3d2.dot(vector3d);
        if (d4 > 0.0) {
            d4 = Math.pow(d4, d3) * d;
        }
        return d4;
    }

    static double orenNayarDiffuse(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.add(vector3d3);
        vector3d4.normalize();
        double d6 = vector3d.dot(vector3d4);
        if (d6 < 0.0) {
            d6 = 0.0;
        }
        if ((d5 = vector3d.dot(vector3d3)) <= 0.0) {
            d5 = 0.0;
        }
        if ((d4 = vector3d.dot(vector3d2)) <= 0.0) {
            return 0.0;
        }
        double d7 = vector3d3.dot(vector3d4);
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        double d8 = Math.acos(d4);
        double d9 = Math.acos(d5);
        Vector3d vector3d5 = new Vector3d(vector3d2.x - d4 * vector3d.x, vector3d2.y - d4 * vector3d.y, vector3d2.z - d4 * vector3d.z);
        vector3d5.normalize();
        Vector3d vector3d6 = new Vector3d(vector3d3.x - d5 * vector3d.x, vector3d3.y - d5 * vector3d.y, vector3d3.z - d5 * vector3d.z);
        vector3d6.normalize();
        double d10 = vector3d5.dot(vector3d6);
        if (d10 < 0.0) {
            d10 = 0.0;
        }
        if (d8 > d9) {
            d3 = d8;
            d2 = d9;
        } else {
            d3 = d9;
            d2 = d8;
        }
        double d11 = 1.0 - 0.5 * (d * d / (d * d + 0.33));
        double d12 = 0.45 * (d * d / (d * d + 0.09));
        return d4 * (d11 + d12 * d10 * Math.sin(d3) * Math.tan(d2 *= 0.95));
    }

    static double minnaertDiffuse(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        double d2 = vector3d.dot(vector3d2);
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = vector3d.dot(vector3d3);
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        double d4 = d2 * Math.pow(Math.max(d3 * d2, 0.1), d);
        if (d < 0.0) {
            d4 /= Math.pow(0.1, d);
        }
        return d4;
    }

    static double povSpecular(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d, double d2) {
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.sub(vector3d3);
        vector3d4.scale(1.0 / Math.sqrt(vector3d4.dot(vector3d4)));
        vector3d4.normalize();
        double d3 = vector3d4.dot(vector3d);
        d3 = d3 > 0.0 ? (d3 *= Math.pow(d3, 1.0 / d2) * d) : 0.0;
        return d3;
    }

    static double phongSpecular(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.add(vector3d3);
        vector3d4.normalize();
        double d2 = vector3d.dot(vector3d4);
        if (d2 <= 0.0) {
            return 0.0;
        }
        return Math.pow(d2, 1.0 / d);
    }

    static double blinnSpecular(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d, double d2) {
        double d3;
        if (d < 1.0) {
            return 0.0;
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        d2 = d2 < 100.0 ? Math.sqrt(1.0 / d2) : 10.0 / d2;
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.add(vector3d3);
        vector3d4.normalize();
        double d4 = vector3d.dot(vector3d4);
        if (d4 < 0.0) {
            return 0.0;
        }
        double d5 = vector3d.dot(vector3d3);
        if (d5 <= 0.0) {
            d5 = 0.01;
        }
        if ((d3 = vector3d.dot(vector3d2)) <= 0.0) {
            return 0.0;
        }
        double d6 = vector3d3.dot(vector3d4);
        if (d6 <= 0.0) {
            d6 = 0.01;
        }
        double d7 = 0.0;
        double d8 = 1.0;
        double d9 = (double)2 * d4 * d5 / d6;
        double d10 = (double)2 * d4 * d3 / d6;
        if (d8 < d9 && d8 < d10) {
            d7 = d8;
        } else if (d9 < d8 && d9 < d10) {
            d7 = d9;
        } else if (d10 < d8 && d10 < d9) {
            d7 = d10;
        }
        double d11 = Math.sqrt(d * d + d6 * d6 - 1.0);
        double d12 = (d11 - d6) * (d11 - d6) / ((d11 + d6) * (d11 + d6)) * (1.0 + (d6 * (d11 + d6) - 1.0) * (d6 * (d11 + d6) - 1.0) / ((d6 * (d11 - d6) + 1.0) * (d6 * (d11 - d6) + 1.0)));
        double d13 = Math.acos(d4);
        return d12 * d7 * Math.exp(-(d13 * d13) / ((double)2 * d2 * d2));
    }

    static double cookTorrenceSpecular(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d, double d2) {
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.add(vector3d3);
        vector3d4.normalize();
        double d3 = vector3d.dot(vector3d3);
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = vector3d.dot(vector3d4);
        if (d4 <= 0.0) {
            return 0.0;
        }
        double d5 = vector3d.dot(vector3d2);
        double d6 = vector3d4.dot(vector3d2);
        double d7 = Math.acos(d5);
        double d8 = Math.acos(d4);
        double d9 = Math.tan(d8) / d;
        d9 *= d9;
        double d10 = 1.0 / Math.cos(d8);
        d10 *= d10;
        d10 *= d10;
        d10 /= (double)4 * d * d;
        d10 *= Math.exp(-d9);
        double d11 = 1.0;
        double d12 = (double)2 * d4 * d5 / d6;
        double d13 = (double)2 * d4 * d3 / d6;
        if (d12 < d11) {
            d11 = d12;
        }
        if (d13 < d11) {
            d11 = d13;
        }
        d9 = d10 * d11 / (d5 * d3);
        return RtShader.fresnel(d7, d2) / Math.PI * d9;
    }

    static double reducedCookTorranceSpecular(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.add(vector3d3);
        vector3d4.normalize();
        double d2 = vector3d.dot(vector3d4);
        if (d2 < 0.0) {
            return 0.0;
        }
        double d3 = vector3d.dot(vector3d3);
        if (d3 <= 0.0) {
            return 0.0;
        }
        return Math.pow(d3, 1.0 / d) / (0.1 + d3);
    }

    static double wardIsotropicSpecular(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        double d2;
        double d3;
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.add(vector3d3);
        vector3d4.normalize();
        double d4 = vector3d4.dot(vector3d);
        if (d4 <= 0.0) {
            d4 = 0.001;
        }
        if ((d3 = vector3d.dot(vector3d3)) <= 0.0) {
            d3 = 0.001;
        }
        if ((d2 = vector3d.dot(vector3d2)) <= 0.0) {
            d2 = 0.001;
        }
        double d5 = Math.tan(Math.acos(d4));
        double d6 = Math.max(d, 0.001);
        return 1.0 / (Math.PI * 4 * d6 * d6) * (Math.exp(-(d5 * d5) / (d6 * d6)) / Math.sqrt(d3 * d2));
    }

    static double phase(Vector3d vector3d, Vector3d vector3d2, double d) {
        double d2 = -vector3d.dot(vector3d2);
        return (1.0 - d * d) / Math.pow(1.0 + d * d - (double)2 * d * d2, 1.5);
    }

    static double singleScatter(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d, double d2, double d3) {
        double d4 = Math.abs(vector3d.dot(vector3d3));
        double d5 = Math.abs(vector3d2.dot(vector3d3));
        return d2 * RtShader.phase(vector3d, vector3d2, d) / (d4 + d5) * (1.0 - Math.exp(-(1.0 / d4 + 1.0 / d5) * d3));
    }

    static double smoothstep(double d, double d2, double d3) {
        if (d3 < d) {
            return 0.0;
        }
        if (d3 > d2) {
            return 1.0;
        }
        double d4 = (d3 - d) / (d2 - d);
        return d4 * d4 * ((double)3 - (double)2 * d4);
    }

    static double pharrSkinScatter(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        double d2 = 0.7142857142857143;
        Vector3d vector3d4 = new Vector3d(vector3d);
        vector3d4.negate();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        double d3 = RtShader.fresnel(vector3d4, vector3d2, d2, vector3d5, vector3d6);
        d3 = RtShader.smoothstep(0.0, 0.5, d3);
        double d4 = 1.0 - d3;
        vector3d6.normalize();
        vector3d4 = new Vector3d(vector3d2);
        vector3d4.negate();
        Vector3d vector3d7 = new Vector3d();
        Vector3d vector3d8 = new Vector3d();
        double d5 = RtShader.fresnel(vector3d4, vector3d2, d2, vector3d7, vector3d8);
        vector3d8.normalize();
        d5 = RtShader.smoothstep(0.0, 0.5, d5);
        double d6 = 1.0 - d5;
        return d4 * d6 * (RtShader.singleScatter(vector3d6, vector3d8, vector3d2, 0.8, 0.8, d) + RtShader.singleScatter(vector3d6, vector3d8, vector3d2, 0.3, 0.5, d) + RtShader.singleScatter(vector3d6, vector3d8, vector3d2, 0.0, 0.4, d));
    }

    public static double pharrSkin(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        Vector3d vector3d4 = RtShader.faceForward(vector3d, vector3d3);
        Vector3d vector3d5 = new Vector3d(vector3d3);
        vector3d5.negate();
        return RtShader.pharrSkinScatter(vector3d5, vector3d4, vector3d2, d);
    }
}

