/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtLight;
import inyo.RtMaterial;
import inyo.RtPathNode;
import inyo.RtScatteringSample;
import inyo.RtShader;
import inyo.RtTriangle;
import inyo.RtWorld;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RtScattering {
    ArrayList samples;

    final void addTriangle(RtTriangle rtTriangle) {
        if (rtTriangle.material.specular == 0.0) {
            RtScatteringSample rtScatteringSample = new RtScatteringSample(rtTriangle);
            this.samples.add(rtScatteringSample);
        }
    }

    final Vector3d multipleScattering(RtWorld rtWorld, RtPathNode rtPathNode, RtMaterial rtMaterial) {
        double d = rtMaterial.scatteringMaxRedDistance;
        d = Math.max(d, rtMaterial.scatteringMaxGreenDistance);
        d = Math.max(d, rtMaterial.scatteringMaxBlueDistance);
        boolean bl = false;
        if (rtMaterial.scatteringMaxRedDistance == rtMaterial.scatteringMaxGreenDistance && rtMaterial.scatteringMaxRedDistance == rtMaterial.scatteringMaxBlueDistance) {
            bl = true;
        }
        double d2 = rtMaterial.scatteringMultipleScale;
        double d3 = d * d;
        Point3d point3d = rtPathNode.hitPoint;
        Vector3d vector3d = new Vector3d();
        int n = 0;
        while (n < this.samples.size()) {
            RtScatteringSample rtScatteringSample = (RtScatteringSample)this.samples.get(n);
            double d4 = point3d.distanceSquared(rtScatteringSample.position);
            if (d4 < d3 && d4 > 0.1) {
                Vector3d vector3d2 = rtScatteringSample.getIllumination(rtWorld);
                double d5 = Math.sqrt(d4);
                double d6 = d2 / d5;
                if (bl) {
                    vector3d.x += vector3d2.x * d6;
                    vector3d.y += vector3d2.y * d6;
                    vector3d.z += vector3d2.z * d6;
                } else {
                    if (d4 < rtMaterial.scatteringMaxRedDistance) {
                        vector3d.x += vector3d2.x * d6;
                    }
                    if (d4 < rtMaterial.scatteringMaxGreenDistance) {
                        vector3d.y += vector3d2.y * d6;
                    }
                    if (d4 < rtMaterial.scatteringMaxBlueDistance) {
                        vector3d.z += vector3d2.z * d6;
                    }
                }
            }
            ++n;
        }
        return vector3d;
    }

    final Vector3d singleScattering(RtWorld rtWorld, RtPathNode rtPathNode, RtMaterial rtMaterial) {
        double d;
        double d2 = rtMaterial.scatteringSingleScale;
        double d3 = rtMaterial.scatteringSingleMaxDistance;
        double d4 = rtMaterial.scatteringSingleBias;
        Vector3d vector3d = new Vector3d();
        RtPathNode rtPathNode2 = rtWorld.getPathNode();
        rtPathNode2.origin = rtPathNode.hitPoint;
        rtPathNode2.ignoreTriangle = rtPathNode.hitTriangle;
        rtPathNode2.direction = new Vector3d(rtPathNode.direction);
        rtPathNode2.hitTest(rtWorld);
        if (rtPathNode2.hit && (d = rtPathNode.hitPoint.distance(rtPathNode2.hitPoint)) < d3) {
            if (d4 != 0.0) {
                rtPathNode2.calcHitFromOrigin(rtPathNode2.distance + d4);
            }
            int n = 0;
            while (n < rtWorld.lightList.size()) {
                RtLight rtLight = (RtLight)rtWorld.lightList.get(n);
                RtPathNode rtPathNode3 = rtLight.getShadowRay(rtWorld, rtPathNode2.hitPoint, rtPathNode2.hitTriangle, false);
                rtPathNode3.hitTest(rtWorld);
                if (!rtPathNode3.hit) {
                    double d5 = RtShader.smoothstep(0.0, d3, d3 - d);
                    double d6 = rtLight.calcIntensity(rtWorld, rtPathNode3.hitPoint);
                    double d7 = d2 * d6 * d5;
                    vector3d.x += d7 * (double)rtLight.color.x;
                    vector3d.y += d7 * (double)rtLight.color.y;
                    vector3d.z += d7 * (double)rtLight.color.z;
                }
                rtPathNode3.inUse = false;
                ++n;
            }
        }
        rtPathNode2.inUse = false;
        return vector3d;
    }

    final double fakeSingleScattering(RtWorld rtWorld, RtPathNode rtPathNode, RtMaterial rtMaterial) {
        double d;
        double d2 = rtMaterial.scatteringSingleScale;
        double d3 = rtMaterial.scatteringSingleMaxDistance;
        double d4 = 0.0;
        RtPathNode rtPathNode2 = rtWorld.getPathNode();
        rtPathNode2.origin = rtPathNode.hitPoint;
        rtPathNode2.ignoreTriangle = rtPathNode.hitTriangle;
        rtPathNode2.direction = new Vector3d(rtPathNode.direction);
        rtPathNode2.hitTest(rtWorld);
        if (rtPathNode2.hit && (d = rtPathNode.hitPoint.distance(rtPathNode2.hitPoint)) < d3) {
            double d5 = RtShader.smoothstep(0.0, d3, d3 - d);
            d4 = d2 * d5;
        }
        rtPathNode2.inUse = false;
        return d4;
    }

    private final /* synthetic */ void this() {
        this.samples = new ArrayList();
    }

    RtScattering() {
        this.this();
    }
}

