/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtMaterial;
import inyo.RtPathNode;
import inyo.RtTriangle;
import inyo.RtWorld;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class RtLight {
    public static final int FALLOFF_NONE = 0;
    public static final int FALLOFF_LINEAR = 1;
    public static final int FALLOFF_QUADRATIC = 2;
    double radius;
    double power;
    Color3f color;
    Point3d position;
    boolean castsShadow;
    boolean hasSpecular;
    boolean hasDiffuse;
    int falloffType;
    double falloffScale;
    Vector3d direction;
    double falloffAngle;
    RtTriangle lastOccludedBy;
    boolean lensFlare;

    public final Point3d sampleOnSurface() {
        double d = Math.random() * Math.PI * (double)2;
        double d2 = Math.random() * Math.PI * (double)2;
        double d3 = Math.sin(d) * this.radius;
        double d4 = Math.sin(d) * this.radius;
        double d5 = Math.cos(d2) * d3 * this.radius;
        return new Point3d(this.position.x + d3, this.position.y + d4, this.position.z + d5);
    }

    final boolean facesLight(Vector3d vector3d, Point3d point3d) {
        Vector3d vector3d2 = new Vector3d(point3d.x - this.position.x, point3d.y - this.position.y, point3d.z - this.position.z);
        double d = vector3d.dot(vector3d2);
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
        }
        return bl;
    }

    final RtPathNode getShadowRay(RtWorld rtWorld, Point3d point3d, RtTriangle rtTriangle, boolean bl) {
        RtPathNode rtPathNode = rtWorld.getPathNode();
        rtPathNode.ignoreTriangle = rtTriangle;
        rtPathNode.origin.set(point3d);
        if (bl && rtWorld.useSoftShadows && this.radius > 0.0) {
            Point3d point3d2 = this.sampleOnSurface();
            rtPathNode.lookAt(point3d2);
            rtPathNode.maxDistance = point3d.distance(point3d2);
        } else {
            rtPathNode.origin.set(point3d);
            rtPathNode.lookAt(this.position);
            rtPathNode.maxDistance = point3d.distance(this.position);
        }
        return rtPathNode;
    }

    final double calcIntensity(RtWorld rtWorld, Point3d point3d) {
        double d = this.power;
        double d2 = 1.0;
        switch (this.falloffType) {
            case 0: {
                break;
            }
            case 1: {
                d2 = this.falloffScale / point3d.distance(this.position);
                break;
            }
            case 2: {
                d2 *= this.falloffScale / point3d.distanceSquared(this.position);
                break;
            }
        }
        return d * d2;
    }

    final RtPathNode calcLightColor(RtWorld rtWorld, Point3d point3d, RtTriangle rtTriangle) {
        boolean bl = false;
        if (rtTriangle.material.transmit == 0.0) {
            bl = true;
        }
        RtPathNode rtPathNode = this.getShadowRay(rtWorld, point3d, rtTriangle, true);
        rtPathNode.stopAtFirstHit = rtWorld.useBlackShadows;
        rtPathNode.hitTest(rtWorld);
        if (rtPathNode.hit) {
            if (rtWorld.useBlackShadows) {
                rtPathNode.red = 0.0;
                rtPathNode.green = 0.0;
                rtPathNode.blue = 0.0;
            } else {
                RtMaterial rtMaterial = rtPathNode.hitTriangle.material;
                if (rtMaterial.filter > 0.0 || rtMaterial.transmit > 0.0) {
                    RtPathNode rtPathNode2 = this.calcLightColor(rtWorld, rtPathNode.hitPoint, rtPathNode.hitTriangle);
                    double d = rtMaterial.transmit;
                    double d2 = rtMaterial.filter;
                    if (rtMaterial.conserveEnergy) {
                        double d3 = 1.0 + rtPathNode2.direction.dot(rtPathNode.hitTriangle.normal);
                        double d4 = rtMaterial.reflectionMin + Math.pow(d3, rtMaterial.reflectionFalloff) * (rtMaterial.reflectionMax - rtMaterial.reflectionMin);
                        d *= 1.0 - d4;
                        d2 *= 1.0 - d4;
                    }
                    rtPathNode.red += rtMaterial.red * rtPathNode2.red * d2 + rtPathNode2.red * d;
                    rtPathNode.green += rtMaterial.green * rtPathNode2.green * d2 + rtPathNode2.green * d;
                    rtPathNode.blue += rtMaterial.blue * rtPathNode2.blue * d2 + rtPathNode2.blue * d;
                    rtPathNode2.inUse = false;
                }
            }
        } else {
            rtPathNode.red = this.color.x;
            rtPathNode.green = this.color.y;
            rtPathNode.blue = this.color.z;
        }
        return rtPathNode;
    }

    private final /* synthetic */ void this() {
        this.radius = 0.0;
        this.power = 1.0;
        this.color = new Color3f(1.0f, 1.0f, 1.0f);
        this.position = null;
        this.castsShadow = true;
        this.hasSpecular = true;
        this.hasDiffuse = true;
        this.falloffType = 0;
        this.falloffScale = 1.0;
        this.direction = null;
        this.falloffAngle = 0.0;
        this.lastOccludedBy = null;
        this.lensFlare = false;
    }

    public RtLight(double d, double d2, double d3, double d4, double d5) {
        this.this();
        this.position = new Point3d(d, d2, d3);
        this.power = d4;
        this.radius = d5;
    }

    public RtLight(Vector3d vector3d) {
        this.this();
        this.position = new Point3d(vector3d);
    }
}

