/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtCanvas;
import inyo.RtShader;

public class RtLensFlare {
    static int clip(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 > n2) {
            return n2;
        }
        return n3;
    }

    static void drawFlare(RtCanvas rtCanvas, int n, int n2, int n3) {
        if (n < -rtCanvas.halfWide || n > rtCanvas.halfWide || n2 < -rtCanvas.halfHigh || n2 > rtCanvas.halfHigh) {
            return;
        }
        RtLensFlare.drawSunburst(rtCanvas, n, n2, n3, 12);
        RtLensFlare.drawHalo(rtCanvas, n / 2, n2 / 2, n3 / 2, 1, 100, 100, 100);
        RtLensFlare.drawHalo(rtCanvas, n / 3, n2 / 3, n3 / 4, 0, 100, 100, 100);
        RtLensFlare.drawHalo(rtCanvas, n / 8, n2 / 8, n3, 1, 100, 100, 100);
        RtLensFlare.drawHalo(rtCanvas, -n / 2, -n2 / 2, n3 / 2, 0, 100, 100, 100);
        RtLensFlare.drawHalo(rtCanvas, -n / 4, -n2 / 4, n3 / 4, 1, 100, 100, 100);
        RtLensFlare.drawHalo(rtCanvas, (int)((double)(-n) / 5.5), (int)((double)(-n2) / 5.5), n3 / 4, 0, 100, 100, 100);
    }

    static void drawParticle(RtCanvas rtCanvas, int n, int n2, int n3) {
        int n4 = -n3;
        while (n4 <= n3) {
            int n5 = -n3;
            while (n5 <= n3) {
                float f = n5 * n5 + n4 * n4;
                float f2 = 1.0f - f / (float)(n3 * n3);
                f2 *= f2;
                f2 *= f2;
                int n6 = n5 + n;
                int n7 = n4 + n2;
                int n8 = (int)(f2 * 10.0f);
                rtCanvas.addPixel(0, n6, n7, n8, n8, n8);
                ++n5;
            }
            ++n4;
        }
    }

    static void drawSunburst(RtCanvas rtCanvas, int n, int n2, int n3, int n4) {
        double d = 0.0;
        double d2 = Math.PI * 2 / (double)n4;
        int n5 = 0;
        while (n5 < n4) {
            double d3 = Math.cos(d);
            double d4 = Math.sin(d);
            float f = n;
            float f2 = n2;
            int n6 = 0;
            while (n6 < n3) {
                RtLensFlare.drawParticle(rtCanvas, (int)f, (int)f2, 6);
                f = (float)((double)f + d3);
                f2 = (float)((double)f2 + d4);
                ++n6;
            }
            d += d2;
            ++n5;
        }
    }

    static void drawHalo(RtCanvas rtCanvas, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f = 0.0f;
        int n8 = -n3;
        while (n8 <= n3) {
            int n9 = n8 + n2;
            int n10 = -n3;
            while (n10 <= n3) {
                int n11 = n10 + n;
                if (n11 < -rtCanvas.halfWide || n9 < -rtCanvas.halfHigh || n11 >= rtCanvas.halfWide || n9 >= rtCanvas.halfHigh) break;
                float f2 = (float)(Math.sqrt(n10 * n10 + n8 * n8) / (double)n3);
                switch (n4) {
                    case 0: {
                        f = 1.0f - f2;
                        f *= f;
                        break;
                    }
                    case 1: {
                        f = f2 * f2;
                        f *= f;
                        f = f * f * f;
                        break;
                    }
                    case 2: {
                        f = f2;
                        break;
                    }
                    case 3: {
                        f = 1.0f - Math.abs(f2 - 0.9f) / 0.1f;
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        f *= f;
                        f *= f;
                        break;
                    }
                }
                f = (float)((double)f * (1.0 - RtShader.smoothstep(0.99f, 1.01f, f2)));
                rtCanvas.addPixel(0, n11, n9, (int)((float)n5 * f), (int)((float)n6 * f), (int)((float)n7 * f));
                ++n10;
            }
            ++n8;
        }
    }
}

