/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtBoundingBox;
import inyo.RtWorld;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class RtIrradianceCache {
    double minDistance;
    double maxDistance;
    double tolerance;
    double invTolerance;
    int maxTreeDepth;
    RtIrrOctTree root;

    void add(Point3d point3d, Vector3d vector3d, double d, Color3f color3f) {
        RtIrrOctTree rtIrrOctTree = this.root;
        int n = 0;
        if (this.root.isInside(point3d)) {
            while (n < this.maxTreeDepth && rtIrrOctTree.size >= (double)4 * this.tolerance) {
                int n2 = 0;
                int n3 = 0;
                if (point3d.x > rtIrrOctTree.center.x) {
                    n3 = 1;
                }
                n2 |= n3;
                n2 |= point3d.y > rtIrrOctTree.center.y ? 2 : 0;
                if (rtIrrOctTree.child[n2 |= point3d.z > rtIrrOctTree.center.z ? 4 : 0] == null) {
                    Point3d point3d2 = new Point3d(rtIrrOctTree.center);
                    point3d2.x = point3d2.x + ((n2 & 1) == 0 ? -rtIrrOctTree.quarterSize : rtIrrOctTree.quarterSize);
                    point3d2.y = point3d2.y + ((n2 & 2) == 0 ? -rtIrrOctTree.quarterSize : rtIrrOctTree.quarterSize);
                    point3d2.z = point3d2.z + ((n2 & 4) == 0 ? -rtIrrOctTree.quarterSize : rtIrrOctTree.quarterSize);
                    rtIrrOctTree.child[n2] = new RtIrrOctTree(point3d2, rtIrrOctTree.halfSize);
                }
                rtIrrOctTree = rtIrrOctTree.child[n2];
            }
        }
        RtSample rtSample = new RtSample(point3d, vector3d, d, color3f);
        rtSample.next = rtIrrOctTree.first;
        rtIrrOctTree.first = rtSample;
    }

    Color3f estimateIrradiance(Point3d point3d, Vector3d vector3d) {
        Color3f color3f = new Color3f();
        float f = this.root.getEstimate(point3d, vector3d, color3f);
        if ((double)f == 0.0) {
            color3f = null;
        } else {
            color3f.scale((float)(1.0 / (double)f));
        }
        return color3f;
    }

    public RtIrradianceCache(RtWorld rtWorld) {
        this.tolerance = rtWorld.irradianceCacheTolerance;
        this.invTolerance = 1.0 / this.tolerance;
        this.minDistance = rtWorld.irradianceCacheMinDistance;
        this.maxDistance = 100.0 * this.minDistance;
        RtBoundingBox rtBoundingBox = new RtBoundingBox();
        int n = 1;
        while (n < rtWorld.modelList.size()) {
            RtBoundingBox rtBoundingBox2 = (RtBoundingBox)rtWorld.modelList.get(n);
            rtBoundingBox.add(rtBoundingBox2);
            ++n;
        }
        double d = rtBoundingBox.maxX - rtBoundingBox.minX;
        d = Math.max(d, rtBoundingBox.maxY - rtBoundingBox.minY);
        d = Math.max(d, rtBoundingBox.maxZ - rtBoundingBox.minZ);
        this.root = new RtIrrOctTree(rtBoundingBox.getCenter(), 1.0001 * d);
        this.maxTreeDepth = rtWorld.irradianceMaxTreeDepth;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RtIrrOctTree {
        RtIrrOctTree[] child = new RtIrrOctTree[8];
        RtSample first;
        Point3d center;
        double size;
        double halfSize;
        double quarterSize;

        final boolean isInside(Point3d point3d) {
            boolean bl = false;
            if (Math.abs(point3d.x - this.center.x) < this.halfSize && Math.abs(point3d.y - this.center.y) < this.halfSize && Math.abs(point3d.z - this.center.z) < this.halfSize) {
                bl = true;
            }
            return bl;
        }

        final float getEstimate(Point3d point3d, Vector3d vector3d, Color3f color3f) {
            float f = 0.0f;
            RtSample rtSample = this.first;
            while (rtSample != null) {
                float f2 = (float)Math.min(1.0E10, rtSample.weight(point3d, vector3d));
                if ((double)f2 > RtIrradianceCache.this.invTolerance) {
                    rtSample.irradiance.scale(f2);
                    color3f.add(rtSample.irradiance);
                    f += f2;
                }
                rtSample = rtSample.next;
            }
            int n = 0;
            while (n < 8) {
                if (this.child[n] != null && Math.abs(this.child[n].center.x - point3d.x) <= this.halfSize && Math.abs(this.child[n].center.y - point3d.y) <= this.halfSize && Math.abs(this.child[n].center.z - point3d.z) <= this.halfSize) {
                    f += this.child[n].getEstimate(point3d, vector3d, color3f);
                }
                ++n;
            }
            return f;
        }

        RtIrrOctTree(Point3d point3d, double d) {
            int n = 0;
            while (n < 8) {
                this.child[n] = null;
                ++n;
            }
            this.center = new Point3d(point3d);
            this.size = d;
            this.halfSize = d / (double)2;
            this.quarterSize = d / (double)4;
            this.first = null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RtSample {
        Point3d position;
        Vector3d normal;
        Color3f irradiance;
        double R0;
        RtSample next;

        double weight(Point3d point3d, Vector3d vector3d) {
            double d = this.position.distance(point3d);
            if (this.R0 > 0.0) {
                d *= this.R0;
            }
            double d2 = Math.sqrt(1.0 - Math.min(1.0, this.normal.dot(vector3d)));
            return 1.0 / (d + d2);
        }

        public RtSample(Point3d point3d, Vector3d vector3d, double d, Color3f color3f) {
            this.position = new Point3d(point3d);
            this.normal = new Vector3d(vector3d);
            this.R0 = d;
            this.irradiance = new Color3f(color3f);
            this.next = null;
        }
    }
}

