/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import javax.vecmath.Color3f;

public class RtImageMap {
    Image image;
    int width;
    int height;
    int[] pixels;

    private final Color3f getPixelColor(int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.width) {
            n = this.width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        int n3 = this.pixels[n + this.width * n2];
        int n4 = n3 >> 24 & 0xFF;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        return new Color3f((float)n5 / 255.0f, (float)n6 / 255.0f, (float)n7 / 255.0f);
    }

    final Color3f getMapColor(double d, boolean bl, double d2, boolean bl2) {
        int n = this.width / 2;
        int n2 = this.height / 2;
        d -= 1.0;
        d2 -= 1.0;
        d *= (double)n;
        d2 *= (double)n2;
        d = !bl ? (d += (double)n) : (double)n - d;
        d2 = bl2 ? (d2 += (double)n2) : (double)n - d2;
        return this.getPixelColor((int)d, (int)d2);
    }

    RtImageMap(String string) {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        ImageIcon imageIcon = new ImageIcon(image);
        this.height = imageIcon.getIconHeight();
        this.width = imageIcon.getIconWidth();
        this.pixels = new int[this.width * this.height];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
    }
}

