/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;

public abstract class WindowWidget
extends WidgetContainer {
    private static ThreadLocal encodingInProgress = new ThreadLocal();
    protected Widget content;
    protected Dimension lastSetSize;
    private Boolean mockVisible;

    public void setBounds(Rectangle rectangle) {
        if (encodingInProgress.get() != Boolean.TRUE && !this.component.isDisplayable()) {
            this.component.addNotify();
        }
        this.lastSetSize = new Dimension(rectangle.width, rectangle.height);
        this.component.setBounds(rectangle);
        this.layoutChildren();
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget widget) {
        if (this.content != null) {
            this.remove(this.content);
        }
        this.content = widget;
        if (this.content != null) {
            if (this.content.getParent() != null) {
                this.content.getParent().remove(this.content);
            }
            JComponent jComponent = (JComponent)((RootPaneContainer)((Object)this.component)).getContentPane();
            jComponent.add(this.content.component);
            this.setAsParent(this.content);
        }
    }

    public void pack() {
        if (!this.component.isDisplayable()) {
            this.component.addNotify();
        }
        JComponent jComponent = (JComponent)((RootPaneContainer)((Object)this.component)).getContentPane();
        if (this.content == null) {
            jComponent.setPreferredSize(new Dimension(0, 0));
        } else {
            jComponent.setPreferredSize(this.content.getPreferredSize());
        }
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle = this.getBounds();
        this.setBounds(new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height));
    }

    public void layoutChildren() {
        if (this.content != null) {
            this.component.validate();
            Dimension dimension = this.content.getMaximumSize();
            Dimension dimension2 = ((RootPaneContainer)((Object)this.component)).getContentPane().getSize();
            this.content.component.setBounds(0, 0, Math.min(dimension.width, dimension2.width), Math.min(dimension.height, dimension2.height));
            if (this.content instanceof WidgetContainer) {
                ((WidgetContainer)this.content).layoutChildren();
            }
        }
    }

    public void dispose() {
        ((Window)this.component).dispose();
    }

    public void toFront() {
        ((Window)this.getComponent()).toFront();
    }

    public void toBack() {
        ((Window)this.getComponent()).toBack();
    }

    public boolean isVisible() {
        if (this.mockVisible != null) {
            return this.mockVisible;
        }
        return this.component.isVisible();
    }

    public void setVisible(boolean bl) {
        if (encodingInProgress.get() == Boolean.TRUE) {
            this.mockVisible = bl ? Boolean.TRUE : Boolean.FALSE;
            return;
        }
        super.setVisible(bl);
    }
}

