/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.ToolTipEvent;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class BToolTip
extends Widget {
    private static BToolTip currentTip;
    private static Popup tipWindow;

    protected JToolTip createComponent() {
        return new JToolTip();
    }

    public String getText() {
        return ((JToolTip)this.component).getTipText();
    }

    public void setText(String string) {
        ((JToolTip)this.component).setTipText(string);
        this.invalidateSize();
    }

    public void show(Widget widget, Point point) {
        BToolTip.hide();
        Point point2 = widget.getComponent().getLocationOnScreen();
        tipWindow = PopupFactory.getSharedInstance().getPopup(widget.component, this.component, point2.x + point.x, point2.y + point.y);
        tipWindow.show();
        currentTip = this;
    }

    public void processEvent(ToolTipEvent toolTipEvent) {
        Widget widget = toolTipEvent.getWidget();
        Point point = toolTipEvent.getToolTipLocation();
        Window window = SwingUtilities.getWindowAncestor(widget.getComponent());
        if (window != null) {
            point = SwingUtilities.convertPoint(widget.getComponent(), point, window);
            Dimension dimension = window.getSize();
            Dimension dimension2 = this.getPreferredSize();
            if (point.x + dimension2.width > dimension.width) {
                point.x = Math.max(0, dimension.width - dimension2.width);
            }
            if (point.y + dimension2.height > dimension.height) {
                point.y = Math.max(0, dimension.height - dimension2.height);
            }
            point = SwingUtilities.convertPoint(window, point, widget.getComponent());
        }
        this.show(widget, point);
    }

    public static BToolTip getShowingToolTip() {
        return currentTip;
    }

    public static void hide() {
        if (tipWindow != null) {
            tipWindow.hide();
        }
        tipWindow = null;
        currentTip = null;
    }

    public BToolTip() {
        this.component = this.createComponent();
    }

    public BToolTip(String string) {
        this();
        this.setText(string);
    }
}

