/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadPrimitiveAction;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class LoadObjectHandler
extends RequestHandler {
    public static final String command = "load_object";
    private final List<PrimitiveId> ps = new LinkedList<PrimitiveId>();

    public String[] getMandatoryParams() {
        return new String[]{"objects"};
    }

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
            System.out.println("RemoteControl: download forbidden by preferences");
        }
        if (!this.ps.isEmpty()) {
            final boolean bl = this.isLoadInNewLayer();
            final boolean bl2 = Boolean.parseBoolean((String)this.args.get("relation_members"));
            GuiHelper.runInEDTAndWait(new Runnable(){

                public void run() {
                    DownloadPrimitiveAction.processItems(bl, LoadObjectHandler.this.ps, true, bl2);
                }
            });
            GuiHelper.executeByMainWorkerInEDT(new Runnable(){

                public void run() {
                    Main.main.getCurrentDataSet().setSelected(LoadObjectHandler.this.ps);
                    AddTagsDialog.addTags(LoadObjectHandler.this.args, LoadObjectHandler.this.sender);
                    LoadObjectHandler.this.ps.clear();
                }
            });
        }
    }

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load objects (specified by their id) from the API.", new Object[0]);
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_DATA;
    }

    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.ps.clear();
        for (String string : ((String)this.args.get("objects")).split(",\\s*")) {
            try {
                this.ps.add(SimplePrimitiveId.fromString(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("RemoteControl: invalid selection '" + string + "' ignored");
            }
        }
    }
}

