/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmServerReadPostprocessor;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class OsmReader
extends AbstractReader {
    protected XMLStreamReader parser;
    protected boolean cancel;
    public static ArrayList<OsmServerReadPostprocessor> postprocessors;

    public static void registerPostprocessor(OsmServerReadPostprocessor osmServerReadPostprocessor) {
        if (postprocessors == null) {
            postprocessors = new ArrayList();
        }
        postprocessors.add(osmServerReadPostprocessor);
    }

    public static void deregisterPostprocessor(OsmServerReadPostprocessor osmServerReadPostprocessor) {
        if (postprocessors != null) {
            postprocessors.remove(osmServerReadPostprocessor);
        }
    }

    protected OsmReader() {
    }

    protected void setParser(XMLStreamReader xMLStreamReader) {
        this.parser = xMLStreamReader;
    }

    protected void throwException(String string) throws XMLStreamException {
        throw new OsmParsingException(string, this.parser.getLocation());
    }

    protected void parse() throws XMLStreamException {
        int n = this.parser.getEventType();
        while (true) {
            if (n == 1) {
                this.parseRoot();
            } else if (n == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            n = this.parser.next();
        }
        this.parser.close();
    }

    protected void parseRoot() throws XMLStreamException {
        if (this.parser.getLocalName().equals("osm")) {
            this.parseOsm();
        } else {
            this.parseUnknown();
        }
    }

    private void parseOsm() throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "version");
        if (string == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
        }
        if (!string.equals("0.5") && !string.equals("0.6")) {
            this.throwException(I18n.tr("Unsupported version: {0}", string));
        }
        this.ds.setVersion(string);
        String string2 = this.parser.getAttributeValue(null, "upload");
        if (string2 != null) {
            this.ds.setUploadDiscouraged(!Boolean.parseBoolean(string2));
        }
        String string3 = this.parser.getAttributeValue(null, "generator");
        Long l = null;
        if (this.parser.getAttributeValue(null, "upload-changeset") != null) {
            l = this.getLong("upload-changeset");
        }
        while (true) {
            int n = this.parser.next();
            if (this.cancel) {
                this.cancel = false;
                this.throwException(I18n.tr("Reading was canceled", new Object[0]));
            }
            if (n == 1) {
                if (this.parser.getLocalName().equals("bounds")) {
                    this.parseBounds(string3);
                    continue;
                }
                if (this.parser.getLocalName().equals("node")) {
                    this.parseNode();
                    continue;
                }
                if (this.parser.getLocalName().equals("way")) {
                    this.parseWay();
                    continue;
                }
                if (this.parser.getLocalName().equals("relation")) {
                    this.parseRelation();
                    continue;
                }
                if (this.parser.getLocalName().equals("changeset")) {
                    this.parseChangeset(l);
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (n == 2) break;
        }
    }

    private void parseBounds(String string) throws XMLStreamException {
        String string2 = this.parser.getAttributeValue(null, "minlon");
        String string3 = this.parser.getAttributeValue(null, "minlat");
        String string4 = this.parser.getAttributeValue(null, "maxlon");
        String string5 = this.parser.getAttributeValue(null, "maxlat");
        String string6 = this.parser.getAttributeValue(null, "origin");
        if (string2 != null && string4 != null && string3 != null && string5 != null) {
            Object object;
            Bounds bounds;
            if (string6 == null) {
                string6 = string;
            }
            if ((bounds = new Bounds(Double.parseDouble(string3), Double.parseDouble(string2), Double.parseDouble(string5), Double.parseDouble(string4))).isOutOfTheWorld()) {
                object = new Bounds(bounds);
                bounds.normalize();
                System.out.println("Bbox " + object + " is out of the world, normalized to " + bounds);
            }
            object = new DataSource(bounds, string6);
            this.ds.dataSources.add((DataSource)object);
        } else {
            this.throwException(I18n.tr("Missing mandatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{3}'',maxlat=''{4}'', origin=''{5}''.", string2, string3, string4, string5, string6));
        }
        this.jumpToEnd();
    }

    protected Node parseNode() throws XMLStreamException {
        NodeData nodeData = new NodeData();
        String string = this.parser.getAttributeValue(null, "lat");
        String string2 = this.parser.getAttributeValue(null, "lon");
        if (string != null && string2 != null) {
            nodeData.setCoor(new LatLon(Double.parseDouble(string), Double.parseDouble(string2)));
        }
        this.readCommon(nodeData);
        Node node = new Node(nodeData.getId(), nodeData.getVersion());
        node.setVisible(nodeData.isVisible());
        node.load(nodeData);
        this.externalIdMap.put(nodeData.getPrimitiveId(), node);
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("tag")) {
                    this.parseTag(node);
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (n == 2) break;
        }
        return node;
    }

    protected Way parseWay() throws XMLStreamException {
        WayData wayData = new WayData();
        this.readCommon(wayData);
        Way way = new Way(wayData.getId(), wayData.getVersion());
        way.setVisible(wayData.isVisible());
        way.load(wayData);
        this.externalIdMap.put(wayData.getPrimitiveId(), way);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("nd")) {
                    arrayList.add(this.parseWayNode(way));
                    continue;
                }
                if (this.parser.getLocalName().equals("tag")) {
                    this.parseTag(way);
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (n == 2) break;
        }
        if (way.isDeleted() && arrayList.size() > 0) {
            System.out.println(I18n.tr("Deleted way {0} contains nodes", way.getUniqueId()));
            arrayList = new ArrayList();
        }
        this.ways.put(wayData.getUniqueId(), arrayList);
        return way;
    }

    private long parseWayNode(Way way) throws XMLStreamException {
        long l;
        if (this.parser.getAttributeValue(null, "ref") == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", way.getUniqueId()));
        }
        if ((l = this.getLong("ref")) == 0L) {
            this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", l));
        }
        this.jumpToEnd();
        return l;
    }

    protected Relation parseRelation() throws XMLStreamException {
        RelationData relationData = new RelationData();
        this.readCommon(relationData);
        Relation relation = new Relation(relationData.getId(), relationData.getVersion());
        relation.setVisible(relationData.isVisible());
        relation.load(relationData);
        this.externalIdMap.put(relationData.getPrimitiveId(), relation);
        ArrayList<RelationMemberData> arrayList = new ArrayList<RelationMemberData>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("member")) {
                    arrayList.add(this.parseRelationMember(relation));
                    continue;
                }
                if (this.parser.getLocalName().equals("tag")) {
                    this.parseTag(relation);
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (n == 2) break;
        }
        if (relation.isDeleted() && arrayList.size() > 0) {
            System.out.println(I18n.tr("Deleted relation {0} contains members", relation.getUniqueId()));
            arrayList = new ArrayList();
        }
        this.relations.put(relationData.getUniqueId(), arrayList);
        return relation;
    }

    private RelationMemberData parseRelationMember(Relation relation) throws XMLStreamException {
        String string = null;
        OsmPrimitiveType osmPrimitiveType = null;
        long l = 0L;
        String string2 = this.parser.getAttributeValue(null, "ref");
        if (string2 == null) {
            this.throwException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", relation.getUniqueId()));
        }
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(relation.getUniqueId()), string2));
        }
        string2 = this.parser.getAttributeValue(null, "type");
        if (string2 == null) {
            this.throwException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(l), Long.toString(relation.getUniqueId())));
        }
        try {
            osmPrimitiveType = OsmPrimitiveType.fromApiTypeName(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(l), Long.toString(relation.getUniqueId()), string2));
        }
        string = string2 = this.parser.getAttributeValue(null, "role");
        if (l == 0L) {
            this.throwException(I18n.tr("Incomplete <member> specification with ref=0", new Object[0]));
        }
        this.jumpToEnd();
        return new RelationMemberData(string, osmPrimitiveType, l);
    }

    private void parseChangeset(Long l) throws XMLStreamException {
        long l2 = this.getLong("id");
        if (l2 == l) {
            this.uploadChangeset = new Changeset((int)this.getLong("id"));
            while (true) {
                int n;
                if ((n = this.parser.next()) == 1) {
                    if (this.parser.getLocalName().equals("tag")) {
                        this.parseTag(this.uploadChangeset);
                        continue;
                    }
                    this.parseUnknown();
                    continue;
                }
                if (n == 2) break;
            }
            return;
        }
        this.jumpToEnd(false);
    }

    private void parseTag(Tagged tagged) throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "k");
        String string2 = this.parser.getAttributeValue(null, "v");
        if (string == null || string2 == null) {
            this.throwException(I18n.tr("Missing key or value attribute in tag.", new Object[0]));
        }
        tagged.put(string.intern(), string2.intern());
        this.jumpToEnd();
    }

    protected void parseUnknown(boolean bl) throws XMLStreamException {
        if (bl) {
            System.out.println(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", this.parser.getLocalName()));
        }
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                this.parseUnknown(false);
                continue;
            }
            if (n == 2) break;
        }
    }

    protected void parseUnknown() throws XMLStreamException {
        this.parseUnknown(true);
    }

    private void jumpToEnd(boolean bl) throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                this.parseUnknown(bl);
                continue;
            }
            if (n == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        this.jumpToEnd(true);
    }

    private User createUser(String string, String string2) throws XMLStreamException {
        if (string == null) {
            if (string2 == null) {
                return null;
            }
            return User.createLocalUser(string2);
        }
        try {
            long l = Long.parseLong(string);
            return User.createOsmUser(l, string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", string));
            return null;
        }
    }

    private void readCommon(PrimitiveData primitiveData) throws XMLStreamException {
        String string;
        String string2;
        primitiveData.setId(this.getLong("id"));
        if (primitiveData.getUniqueId() == 0L) {
            this.throwException(I18n.tr("Illegal object with ID=0.", new Object[0]));
        }
        if ((string2 = this.parser.getAttributeValue(null, "timestamp")) != null && string2.length() != 0) {
            primitiveData.setTimestamp(DateUtils.fromString(string2));
        }
        String string3 = this.parser.getAttributeValue(null, "user");
        String string4 = this.parser.getAttributeValue(null, "uid");
        primitiveData.setUser(this.createUser(string4, string3));
        String string5 = this.parser.getAttributeValue(null, "visible");
        if (string5 != null) {
            primitiveData.setVisible(Boolean.parseBoolean(string5));
        }
        String string6 = this.parser.getAttributeValue(null, "version");
        int n = 0;
        if (string6 != null) {
            try {
                n = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(primitiveData.getUniqueId()), string6));
            }
            if (this.ds.getVersion().equals("0.6")) {
                if (n <= 0 && primitiveData.getUniqueId() > 0L) {
                    this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(primitiveData.getUniqueId()), string6));
                } else if (n < 0 && primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 0, "0.6"));
                    n = 0;
                }
            } else if (this.ds.getVersion().equals("0.5")) {
                if (n <= 0 && primitiveData.getUniqueId() > 0L) {
                    System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 1, "0.5"));
                    n = 1;
                } else if (n < 0 && primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 0, "0.5"));
                    n = 0;
                }
            } else {
                this.throwException(I18n.tr("Unknown or unsupported API version. Got {0}.", this.ds.getVersion()));
            }
        } else if (primitiveData.getUniqueId() > 0L && this.ds.getVersion() != null && this.ds.getVersion().equals("0.6")) {
            this.throwException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(primitiveData.getUniqueId())));
        } else if (primitiveData.getUniqueId() > 0L && this.ds.getVersion() != null && this.ds.getVersion().equals("0.5")) {
            System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 1, "0.5"));
            n = 1;
        } else if (primitiveData.getUniqueId() <= 0L && this.ds.getVersion() != null && this.ds.getVersion().equals("0.5")) {
            n = 0;
        }
        primitiveData.setVersion(n);
        String string7 = this.parser.getAttributeValue(null, "action");
        if (string7 != null) {
            if (string7.equals("delete")) {
                primitiveData.setDeleted(true);
                primitiveData.setModified(primitiveData.isVisible());
            } else if (string7.equals("modify")) {
                primitiveData.setModified(true);
            }
        }
        if ((string = this.parser.getAttributeValue(null, "changeset")) == null) {
            primitiveData.setChangesetId(0);
        } else {
            try {
                primitiveData.setChangesetId(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                if (primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", string, primitiveData.getUniqueId()));
                    primitiveData.setChangesetId(0);
                }
                this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", string));
            }
            if (primitiveData.getChangesetId() <= 0) {
                if (primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", string, primitiveData.getUniqueId()));
                    primitiveData.setChangesetId(0);
                } else {
                    this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", string));
                }
            }
        }
    }

    private long getLong(String string) throws XMLStreamException {
        String string2 = this.parser.getAttributeValue(null, string);
        if (string2 == null) {
            this.throwException(I18n.tr("Missing required attribute ''{0}''.", string));
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", string, string2));
            return 0L;
        }
    }

    protected DataSet doParseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        ProgressMonitor.CancelListener cancelListener = new ProgressMonitor.CancelListener(){

            public void operationCanceled() {
                OsmReader.this.cancel = true;
            }
        };
        progressMonitor.addCancelListener(cancelListener);
        CheckParameterUtil.ensureParameterNotNull(inputStream, "source");
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", 2));
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing OSM data...", new Object[0]));
            UTFInputStreamReader uTFInputStreamReader = UTFInputStreamReader.create(inputStream, "UTF-8");
            XMLStreamReader xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(uTFInputStreamReader);
            this.setParser(xMLStreamReader);
            this.parse();
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Preparing data set...", new Object[0]));
            this.prepareDataSet();
            progressMonitor.worked(1);
            if (postprocessors != null) {
                for (OsmServerReadPostprocessor osmServerReadPostprocessor : postprocessors) {
                    osmServerReadPostprocessor.postprocessDataSet(this.getDataSet(), progressMonitor);
                }
            }
            DataSet dataSet = this.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException illegalDataException) {
            throw illegalDataException;
        }
        catch (OsmParsingException osmParsingException) {
            throw new IllegalDataException(osmParsingException.getMessage(), osmParsingException);
        }
        catch (XMLStreamException xMLStreamException) {
            String string = xMLStreamException.getMessage();
            Pattern pattern = Pattern.compile("Message: (.+)");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                string = matcher.group(1);
            }
            if (xMLStreamException.getLocation() != null) {
                throw new IllegalDataException(I18n.tr("Line {0} column {1}: ", xMLStreamException.getLocation().getLineNumber(), xMLStreamException.getLocation().getColumnNumber()) + string, xMLStreamException);
            }
            throw new IllegalDataException(string, xMLStreamException);
        }
        catch (Exception exception) {
            throw new IllegalDataException(exception);
        }
        finally {
            progressMonitor.finishTask();
            progressMonitor.removeCancelListener(cancelListener);
        }
    }

    public static DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        return new OsmReader().doParseDataSet(inputStream, progressMonitor);
    }

    private static class OsmParsingException
    extends XMLStreamException {
        public OsmParsingException() {
        }

        public OsmParsingException(String string) {
            super(string);
        }

        public OsmParsingException(String string, Location location) {
            super(string);
            this.location = location;
        }

        public OsmParsingException(String string, Location location, Throwable throwable) {
            super(string, throwable);
            this.location = location;
        }

        public OsmParsingException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public OsmParsingException(Throwable throwable) {
            super(throwable);
        }

        public String getMessage() {
            String string = super.getMessage();
            if (string == null) {
                string = this.getClass().getName();
            }
            if (this.getLocation() == null) {
                return string;
            }
            string = string + " " + I18n.tr("(at line {0}, column {1})", this.getLocation().getLineNumber(), this.getLocation().getColumnNumber());
            return string;
        }
    }
}

