/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmHistoryReader {
    private final InputStream in;
    private final HistoryDataSet data;

    public OsmHistoryReader(InputStream inputStream) {
        this.in = inputStream;
        this.data = new HistoryDataSet();
    }

    public HistoryDataSet parse(ProgressMonitor progressMonitor) throws SAXException, IOException {
        InputSource inputSource = new InputSource(new InputStreamReader(this.in, "UTF-8"));
        progressMonitor.beginTask(I18n.tr("Parsing OSM history data ...", new Object[0]));
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new Parser());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    private class Parser
    extends DefaultHandler {
        private HistoryOsmPrimitive current;
        private Locator locator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected String getCurrentPosition() {
            if (this.locator == null) {
                return "";
            }
            return "(" + this.locator.getLineNumber() + "," + this.locator.getColumnNumber() + ")";
        }

        protected void throwException(String string) throws SAXException {
            throw new SAXException(this.getCurrentPosition() + string);
        }

        protected long getMandatoryAttributeLong(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
            }
            Long l = 0L;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", string, string2));
            }
            if (l < 0L) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", string, string2));
            }
            return l;
        }

        protected Long getAttributeLong(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                return null;
            }
            Long l = null;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", string, string2));
            }
            if (l < 0L) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", string, string2));
            }
            return l;
        }

        protected Double getAttributeDouble(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                return null;
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for attribute ''{0}'' of type double. Got ''{1}''.", string, string2));
            }
            return d;
        }

        protected String getMandatoryAttributeString(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
            }
            return string2;
        }

        protected boolean getMandatoryAttributeBoolean(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
            }
            if ("true".equals(string2)) {
                return true;
            }
            if ("false".equals(string2)) {
                return false;
            }
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type boolean. Got ''{1}''.", string, string2));
            return false;
        }

        protected HistoryOsmPrimitive createPrimitive(Attributes attributes, OsmPrimitiveType osmPrimitiveType) throws SAXException {
            long l = this.getMandatoryAttributeLong(attributes, "id");
            long l2 = this.getMandatoryAttributeLong(attributes, "version");
            long l3 = this.getMandatoryAttributeLong(attributes, "changeset");
            boolean bl = this.getMandatoryAttributeBoolean(attributes, "visible");
            Long l4 = this.getAttributeLong(attributes, "uid");
            String string = attributes.getValue("user");
            User user = string != null ? (l4 != null ? User.createOsmUser(l4, string) : User.createLocalUser(string)) : User.getAnonymous();
            String string2 = this.getMandatoryAttributeString(attributes, "timestamp");
            Date date = DateUtils.fromString(string2);
            HistoryOsmPrimitive historyOsmPrimitive = null;
            if (osmPrimitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                Double d = this.getAttributeDouble(attributes, "lat");
                Double d2 = this.getAttributeDouble(attributes, "lon");
                LatLon latLon = d != null && d2 != null ? new LatLon(d, d2) : null;
                historyOsmPrimitive = new HistoryNode(l, l2, bl, user, l3, date, latLon);
            } else if (osmPrimitiveType.equals((Object)OsmPrimitiveType.WAY)) {
                historyOsmPrimitive = new HistoryWay(l, l2, bl, user, l3, date);
            }
            if (osmPrimitiveType.equals((Object)OsmPrimitiveType.RELATION)) {
                historyOsmPrimitive = new HistoryRelation(l, l2, bl, user, l3, date);
            }
            return historyOsmPrimitive;
        }

        protected void startNode(Attributes attributes) throws SAXException {
            this.current = this.createPrimitive(attributes, OsmPrimitiveType.NODE);
        }

        protected void startWay(Attributes attributes) throws SAXException {
            this.current = this.createPrimitive(attributes, OsmPrimitiveType.WAY);
        }

        protected void startRelation(Attributes attributes) throws SAXException {
            this.current = this.createPrimitive(attributes, OsmPrimitiveType.RELATION);
        }

        protected void handleTag(Attributes attributes) throws SAXException {
            String string = this.getMandatoryAttributeString(attributes, "k");
            String string2 = this.getMandatoryAttributeString(attributes, "v");
            this.current.put(string, string2);
        }

        protected void handleNodeReference(Attributes attributes) throws SAXException {
            long l = this.getMandatoryAttributeLong(attributes, "ref");
            ((HistoryWay)this.current).addNode(l);
        }

        protected void handleMember(Attributes attributes) throws SAXException {
            long l = this.getMandatoryAttributeLong(attributes, "ref");
            String string = this.getMandatoryAttributeString(attributes, "type");
            OsmPrimitiveType osmPrimitiveType = null;
            try {
                osmPrimitiveType = OsmPrimitiveType.fromApiTypeName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type OsmPrimitiveType. Got ''{1}''.", "type", string));
            }
            String string2 = this.getMandatoryAttributeString(attributes, "role");
            RelationMemberData relationMemberData = new RelationMemberData(string2, osmPrimitiveType, l);
            ((HistoryRelation)this.current).addMember(relationMemberData);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("node")) {
                this.startNode(attributes);
            } else if (string3.equals("way")) {
                this.startWay(attributes);
            } else if (string3.equals("relation")) {
                this.startRelation(attributes);
            } else if (string3.equals("tag")) {
                this.handleTag(attributes);
            } else if (string3.equals("nd")) {
                this.handleNodeReference(attributes);
            } else if (string3.equals("member")) {
                this.handleMember(attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("node") || string3.equals("way") || string3.equals("relation")) {
                OsmHistoryReader.this.data.put(this.current);
            }
        }
    }
}

