/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.InvalidXmlCharacterFilter;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxReader
implements GpxConstants {
    private String version;
    private GpxData gpxData;
    private InputSource inputSource;

    public GpxReader(InputStream inputStream) throws IOException {
        InvalidXmlCharacterFilter invalidXmlCharacterFilter = new InvalidXmlCharacterFilter(inputStream);
        this.inputSource = new InputSource(UTFInputStreamReader.create(invalidXmlCharacterFilter, "UTF-8"));
    }

    public boolean parse(boolean bl) throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.newSAXParser().parse(this.inputSource, (DefaultHandler)parser);
            return true;
        }
        catch (SAXException sAXException) {
            if (bl) {
                parser.tryToFinish();
                if (parser.data.isEmpty()) {
                    throw sAXException;
                }
                return false;
            }
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        private GpxData data;
        private Collection<Collection<WayPoint>> currentTrack;
        private Map<String, Object> currentTrackAttr;
        private Collection<WayPoint> currentTrackSeg;
        private GpxRoute currentRoute;
        private WayPoint currentWayPoint;
        private State currentState = State.init;
        private GpxLink currentLink;
        private Extensions currentExtensions;
        private Stack<State> states;
        private final Stack<String> elements = new Stack();
        private StringBuffer accumulator = new StringBuffer();
        private boolean nokiaSportsTrackerBug = false;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.states = new Stack();
            this.data = new GpxData();
        }

        private double parseCoord(String string) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }

        private LatLon parseLatLon(Attributes attributes) {
            return new LatLon(this.parseCoord(attributes.getValue("lat")), this.parseCoord(attributes.getValue("lon")));
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string2);
            switch (this.currentState) {
                case init: {
                    this.states.push(this.currentState);
                    this.currentState = State.gpx;
                    this.data.creator = attributes.getValue("creator");
                    GpxReader.this.version = attributes.getValue("version");
                    if (GpxReader.this.version != null && GpxReader.this.version.startsWith("1.0")) {
                        GpxReader.this.version = "1.0";
                        break;
                    }
                    if ("1.1".equals(GpxReader.this.version)) break;
                    GpxReader.this.version = "1.1";
                    break;
                }
                case gpx: {
                    if (string2.equals("metadata")) {
                        this.states.push(this.currentState);
                        this.currentState = State.metadata;
                        break;
                    }
                    if (string2.equals("wpt")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (string2.equals("rte")) {
                        this.states.push(this.currentState);
                        this.currentState = State.rte;
                        this.currentRoute = new GpxRoute();
                        break;
                    }
                    if (string2.equals("trk")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trk;
                        this.currentTrack = new ArrayList<Collection<WayPoint>>();
                        this.currentTrackAttr = new HashMap<String, Object>();
                        break;
                    }
                    if (string2.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        this.currentExtensions = new Extensions();
                        break;
                    }
                    if (!string2.equals("gpx") || attributes.getValue("creator") == null || !attributes.getValue("creator").startsWith("Nokia Sports Tracker")) break;
                    this.nokiaSportsTrackerBug = true;
                    break;
                }
                case metadata: {
                    if (string2.equals("author")) {
                        this.states.push(this.currentState);
                        this.currentState = State.author;
                        break;
                    }
                    if (string2.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        this.currentExtensions = new Extensions();
                        break;
                    }
                    if (string2.equals("copyright")) {
                        this.states.push(this.currentState);
                        this.currentState = State.copyright;
                        this.data.attr.put("meta.copyright.author", attributes.getValue("author"));
                        break;
                    }
                    if (!string2.equals("link")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.link;
                    this.currentLink = new GpxLink(attributes.getValue("href"));
                    break;
                }
                case author: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("email")) break;
                    this.data.attr.put("meta.author.email", attributes.getValue("id") + "@" + attributes.getValue("domain"));
                    break;
                }
                case trk: {
                    if (string2.equals("trkseg")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trkseg;
                        this.currentTrackSeg = new ArrayList<WayPoint>();
                        break;
                    }
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    this.currentExtensions = new Extensions();
                    break;
                }
                case trkseg: {
                    if (!string2.equals("trkpt")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.wpt;
                    this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                    break;
                }
                case wpt: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    this.currentExtensions = new Extensions();
                    break;
                }
                case rte: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (string2.equals("rtept")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    this.currentExtensions = new Extensions();
                }
            }
            this.accumulator.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.nokiaSportsTrackerBug) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != '\u0001') continue;
                    cArray[i] = 32;
                }
                this.nokiaSportsTrackerBug = false;
            }
            this.accumulator.append(cArray, n, n2);
        }

        private Map<String, Object> getAttr() {
            switch (this.currentState) {
                case rte: {
                    return this.currentRoute.attr;
                }
                case metadata: {
                    return this.data.attr;
                }
                case wpt: {
                    return this.currentWayPoint.attr;
                }
                case trk: {
                    return this.currentTrackAttr;
                }
            }
            return null;
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.elements.pop();
            switch (this.currentState) {
                case gpx: 
                case metadata: {
                    if (string2.equals("name")) {
                        this.data.attr.put("meta.name", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("desc")) {
                        this.data.attr.put("meta.desc", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("time")) {
                        this.data.attr.put("meta.time", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("keywords")) {
                        this.data.attr.put("meta.keywords", this.accumulator.toString());
                        break;
                    }
                    if (GpxReader.this.version.equals("1.0") && string2.equals("author")) {
                        this.data.attr.put("meta.author.name", this.accumulator.toString());
                        break;
                    }
                    if (GpxReader.this.version.equals("1.0") && string2.equals("email")) {
                        this.data.attr.put("meta.author.email", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("url") || string2.equals("urlname")) {
                        this.data.attr.put(string2, this.accumulator.toString());
                        break;
                    }
                    if ((this.currentState != State.metadata || !string2.equals("metadata")) && (this.currentState != State.gpx || !string2.equals("gpx"))) break;
                    this.convertUrlToLink(this.data.attr);
                    if (this.currentExtensions != null && !this.currentExtensions.isEmpty()) {
                        this.data.attr.put("meta.extensions", this.currentExtensions);
                    }
                    this.currentState = this.states.pop();
                    break;
                }
                case author: {
                    if (string2.equals("author")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (string2.equals("name")) {
                        this.data.attr.put("meta.author.name", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("email") || !string2.equals("link")) break;
                    this.data.attr.put("meta.author.link", this.currentLink);
                    break;
                }
                case copyright: {
                    if (string2.equals("copyright")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (string2.equals("year")) {
                        this.data.attr.put("meta.copyright.year", this.accumulator.toString());
                        break;
                    }
                    if (!string2.equals("license")) break;
                    this.data.attr.put("meta.copyright.license", this.accumulator.toString());
                    break;
                }
                case link: {
                    if (string2.equals("text")) {
                        this.currentLink.text = this.accumulator.toString();
                    } else if (string2.equals("type")) {
                        this.currentLink.type = this.accumulator.toString();
                    } else if (string2.equals("link")) {
                        if (this.currentLink.uri == null && this.accumulator != null && this.accumulator.toString().length() != 0) {
                            this.currentLink = new GpxLink(this.accumulator.toString());
                        }
                        this.currentState = this.states.pop();
                    }
                    if (this.currentState == State.author) {
                        this.data.attr.put("meta.author.link", this.currentLink);
                        break;
                    }
                    if (this.currentState == State.link) break;
                    Map<String, Object> map = this.getAttr();
                    if (!map.containsKey("meta.links")) {
                        map.put("meta.links", new LinkedList());
                    }
                    ((Collection)map.get("meta.links")).add(this.currentLink);
                    break;
                }
                case wpt: {
                    if (string2.equals("ele") || string2.equals("magvar") || string2.equals("name") || string2.equals("src") || string2.equals("geoidheight") || string2.equals("type") || string2.equals("sym") || string2.equals("url") || string2.equals("urlname")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("hdop") || string2.equals("vdop") || string2.equals("pdop")) {
                        try {
                            this.currentWayPoint.attr.put(string2, Float.valueOf(Float.parseFloat(this.accumulator.toString())));
                        }
                        catch (Exception exception) {
                            this.currentWayPoint.attr.put(string2, new Float(0.0f));
                        }
                        break;
                    }
                    if (string2.equals("time")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (string2.equals("cmt") || string2.equals("desc")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (string2.equals("rtept")) {
                        this.currentState = this.states.pop();
                        this.convertUrlToLink(this.currentWayPoint.attr);
                        this.currentRoute.routePoints.add(this.currentWayPoint);
                        break;
                    }
                    if (string2.equals("trkpt")) {
                        this.currentState = this.states.pop();
                        this.convertUrlToLink(this.currentWayPoint.attr);
                        this.currentTrackSeg.add(this.currentWayPoint);
                        break;
                    }
                    if (!string2.equals("wpt")) break;
                    this.currentState = this.states.pop();
                    this.convertUrlToLink(this.currentWayPoint.attr);
                    if (this.currentExtensions != null && !this.currentExtensions.isEmpty()) {
                        this.currentWayPoint.attr.put("meta.extensions", this.currentExtensions);
                    }
                    this.data.waypoints.add(this.currentWayPoint);
                    break;
                }
                case trkseg: {
                    if (!string2.equals("trkseg")) break;
                    this.currentState = this.states.pop();
                    this.currentTrack.add(this.currentTrackSeg);
                    break;
                }
                case trk: {
                    if (string2.equals("trk")) {
                        this.currentState = this.states.pop();
                        this.convertUrlToLink(this.currentTrackAttr);
                        this.data.tracks.add(new ImmutableGpxTrack(this.currentTrack, this.currentTrackAttr));
                        break;
                    }
                    if (!string2.equals("name") && !string2.equals("cmt") && !string2.equals("desc") && !string2.equals("src") && !string2.equals("type") && !string2.equals("number") && !string2.equals("url") && !string2.equals("urlname")) break;
                    this.currentTrackAttr.put(string2, this.accumulator.toString());
                    break;
                }
                case ext: {
                    if (string2.equals("extensions")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!"http://josm.openstreetmap.de/gpx-extensions-1.0".equals(string)) break;
                    this.currentExtensions.put(string2, this.accumulator.toString());
                    break;
                }
                default: {
                    if (string2.equals("wpt")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!string2.equals("rte")) break;
                    this.currentState = this.states.pop();
                    this.convertUrlToLink(this.currentRoute.attr);
                    this.data.routes.add(this.currentRoute);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.states.empty()) {
                throw new SAXException(I18n.tr("Parse error: invalid document structure for GPX document.", new Object[0]));
            }
            Extensions extensions = (Extensions)this.data.attr.get("meta.extensions");
            if (extensions != null && "true".equals(extensions.get("from-server"))) {
                this.data.fromServer = true;
            }
            GpxReader.this.gpxData = this.data;
        }

        private void convertUrlToLink(Map<String, Object> map) {
            String string = (String)map.get("url");
            String string2 = (String)map.get("urlname");
            if (string != null) {
                if (!map.containsKey("meta.links")) {
                    map.put("meta.links", new LinkedList());
                }
                GpxLink gpxLink = new GpxLink(string);
                gpxLink.text = string2;
                Collection collection = (Collection)map.get("meta.links");
                collection.add(gpxLink);
            }
        }

        public void tryToFinish() throws SAXException {
            ArrayList<String> arrayList = new ArrayList<String>(this.elements);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.endElement(null, (String)arrayList.get(i), (String)arrayList.get(i));
            }
            this.endDocument();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        init,
        gpx,
        metadata,
        wpt,
        rte,
        trk,
        ext,
        author,
        link,
        trkseg,
        copyright;

    }
}

